set more off

set linesize 120
log using "/home/projects/sehs/replication/logs/appendix_table5_overall.log", replace

*******************************************************************************
*
* DATE:    June 15, 2019
*
* PROGRAM: appendix_table5_overall.do
*
* DATA:    "/home/projects/sehs/replication/data/fullestsample_max.dta"
* NOTES:   1. rdrobust by tierXschoolXcohort to get the right sample for
*             including covariates.
*          2. rdrobust using tierXschoolXcohort FEs and save the right
*             bandwidths for local linear estimates.
*          3. Local linear estimates including all tiers. 
*          4. Write estimates out to table and calculate means at the left limit
*             using the margins command.
*   KERNEL: uniform
*   POLYNOMIAL: p(1)

* OUTPUT: apptable5_overall.xml
*
*******************************************************************************
#delimit;
tempfile temp1 temp2;

****** Define the estimation program ******;
capture program drop rdrobustoverall;
program def rdrobustoverall;
use "/home/projects/sehs/replication/data/fullestsample_max.dta", clear;
* Keep only schools with relatively similar cutoffs across tiers.;
drop if inlist(schoice,"Brooks","Jones","Lane","Northside","Payton","Young");
drop if schoice=="Lindblom" & inlist(cohort9,2011,2012);
drop if schoice=="Westinghouse" & inlist(cohort9,2011,2012);

di "$var";
/*Step 1*/;
postfile dataNon tierschcoh N_l N_r h_bw coeff se_coeff tiernum using 
"/home/projects/sehs/replication/data/NonParResults_overall.dta", replace;

forvalues i = 1/148 {;
capture rdrobust $var centered if tierschcoh==`i', kernel(uniform) p(1); 
capture local tierschcoh = `i';
capture local N_l = e(N_h_l);
capture local N_r = e(N_h_r);
capture local h_bw = e(h_l);
capture local coeff = e(tau_cl);
capture local se_coeff = e(se_tau_cl);
capture sum tier if tierschcoh == `i';
capture local tiernum = r(mean);
capture post dataNon (`tierschcoh') (`N_l') (`N_r') (`h_bw') (`coeff') 
     (`se_coeff') (`tiernum');
ereturn clear;
};

postclose dataNon;
/* Step 2*/;
merge m:1 tierschcoh using "/home/projects/sehs/replication/data/NonParResults_overall.dta";
drop if N_l == .;
quietly tab tierschcoh, gen(tsc);
gen x=1;
quietly rdrobust $var centered, covs($tsc1 $tsc2 $tsc3 $tsc4) p(1) kernel(uniform);
replace x=0 if (centered<-e(h_l) | centered>e(h_l));

/*Step 3*/;
reg $var i.admit centered centeredXadmit $tsc1 $tsc2 $tsc3 $tsc4 if x==1, cluster(schoice_n);
/* Step 4*/;
outreg2 i1.admit using "/home/projects/sehs/replication/tables/appendixtable5_overall.xml", 
  nocons keep(i.admit) excel se dec(3);
margins admit, at(centered=0 centeredXadmit=0);

rm "/home/projects/sehs/replication/data/NonParResults_overall.dta";
end;

* Variable = stdcomp;
global var "stdcomp";
global tsc1 "tsc1-tsc8";
global tsc2 "tsc10-tsc17";
global tsc3 "tsc19-tsc26";
global tsc4 "tsc28-tsc35";
rdrobustoverall;

* Variable = stdactcomp;
global var "stdactcomp";
global tsc1 "tsc1-tsc8";
global tsc2 "tsc10-tsc17";
global tsc3 "tsc19-tsc26";
global tsc4 "tsc28-tsc35";
rdrobustoverall;

* Variable = latent8pct;
global var "latent8pct";
global tsc1 "tsc1-tsc8";
global tsc2 "tsc10-tsc17";
global tsc3 "tsc19-tsc26";
global tsc4 "tsc28-tsc35";
rdrobustoverall;

* Variable = gpa_unwt2;
global var "gpa_unwt2";
global tsc1 "tsc1-tsc8";
global tsc2 "tsc10-tsc17";
global tsc3 "tsc19-tsc26";
global tsc4 "tsc28-tsc35";
rdrobustoverall;
* Variable = gpa_unwt2_gr11;
global var "gpa_unwt2_gr11";
global tsc1 "tsc1-tsc8";
global tsc2 "tsc10-tsc17";
global tsc3 "tsc19-tsc26";
global tsc4 "tsc28-tsc35";
rdrobustoverall;

* Variable = grad4yr;
global var "grad4yr";
global tsc1 "tsc1-tsc8";
global tsc2 "tsc10-tsc17";
global tsc3 "tsc19-tsc26";
global tsc4 "tsc28-tsc34";
rdrobustoverall;

* Variable = firstfall;
global var "firstfall";
global tsc1 "tsc1-tsc4";
global tsc2 "tsc6-tsc9";
global tsc3 "tsc11-tsc14";
global tsc4 "tsc16-tsc19";
rdrobustoverall;

* Variable = verycompetitiveplus;
global var "verycompetitiveplus";
global tsc1 "tsc1-tsc4";
global tsc2 "tsc6-tsc9";
global tsc3 "tsc11-tsc14";
global tsc4 "tsc16-tsc19";
rdrobustoverall;

* Variable = anyhonors;
global var "anyhonors";
global tsc1 "tsc1-tsc8";
global tsc2 "tsc10-tsc17";
global tsc3 "tsc19-tsc26";
global tsc4 "tsc28-tsc35";
rdrobustoverall;

* Variable = hrsstdy10;
global var "hrsstdy10";
global tsc1 "tsc1-tsc8";
global tsc2 "tsc10-tsc17";
global tsc3 "tsc19-tsc26";
global tsc4 "tsc28-tsc35";
rdrobustoverall;

* Variable = stdoscie;
global var "stdoscie";
global tsc1 "tsc1-tsc8";
global tsc2 "tsc10-tsc17";
global tsc3 "tsc19-tsc26";
global tsc4 "tsc28-tsc35";
rdrobustoverall;

* Variable = stdossaf;
global var "stdossaf";
global tsc1 "tsc1-tsc8";
global tsc2 "tsc10-tsc17";
global tsc3 "tsc19-tsc26";
global tsc4 "tsc28-tsc34";
rdrobustoverall;

* Variable = stdopeer;
global var "stdopeer";
global tsc1 "tsc1-tsc8";
global tsc2 "tsc10-tsc17";
global tsc3 "tsc19-tsc26";
global tsc4 "tsc28-tsc35";
rdrobustoverall;

* Variable = stdotrts;
global var "stdotrts";
global tsc1 "tsc1-tsc8";
global tsc2 "tsc10-tsc17";
global tsc3 "tsc19-tsc26";
global tsc4 "tsc28-tsc35";
rdrobustoverall;
*/;
* Variable = stdopssm;
global var "stdopssm";
global tsc1 "tsc1-tsc8";
global tsc2 "tsc10-tsc17";
global tsc3 "tsc19-tsc26";
global tsc4 "tsc28-tsc35";
rdrobustoverall;

* Variable = distance;
global var "distance";
global tsc1 "tsc1-tsc8";
global tsc2 "tsc10-tsc17";
global tsc3 "tsc19-tsc26";
global tsc4 "tsc28-tsc35";
rdrobustoverall;

