* REGRESSIONS, MAIN ANALYSIS AND ROBUSTNESS
* PRESCHOOL FOR EVER IMPLEMENTERS, INTERACTIONS WITH NURSE PROGRAM
* first generation

do "D:\Data\workdata\704665\daycare\dofiles\first.do"


use "$work\analysis_daycare_muni_ever_yrapproval.dta", clear
set seed 1234
set matsize 10000

label var operating "Any Approved Preschool at Age 3"

****************** REGRESSIONS ***************************TA
capture drop decade
gen decade=.
replace decade=1 if year<1940
replace decade=2 if year>=1940 & year<1950
replace decade=3 if year>=1950 

gen countyurbrur=county*rural
* educational reform interaction 
gen fyear=year-3
gen edu=(fyear>=1946 & rural==1)

************************************************************************************************
* MAINOUTCOMES AND ROBUSTNESS
************************************************************************************************

estimates clear
*mainouts
foreach vars of varlist $mainout $otherinc  index_hc $nights $diag60  married {
	
	
	 areg `vars' operating  $style1 , abs(muni) cl(muni)

	display as text "trends:" 
	display as text "Coefficient: " _b[operating] as text ", SE: " _se[operating] as text ", t-test: " _b[operating]/_se[operating] _newline
	estimates store `vars'2
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)'
	
	areg `vars' operating  $style2 , abs(muni) cl(muni)
			
	display as text " Muni Controls:"
	display as text "Coefficient: " _b[operating] as text ", SE: " _se[operating] as text ", t-test: " _b[operating]/_se[operating] _newline
	estimates store `vars'3
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)'

}

/*Creates the table  */
************************************************************************************************
* table 3
************************************************************************************************

file open myfile using "$results\mainout.tex", write replace
file write myfile "\begin{tabular}{p{2in} cc}" _n "\toprule" _n ///
" Outcome   &         (1)   &         (2)  	 			 		\\" _n 
file close myfile
foreach vars of global mainout  {
	estout `vars'* using "$results\mainout.tex", type ///
		append  cells(b(star fmt(%9.3f))  se(par([ ]))) starlevels(* 0.10 ** 0.05 *** 0.01)   ///
		stats(dv N, fmt(%9.3f %9.0f) labels("Control Mean, dep. var." "No. of obs.")) style(tex)  ///
		mlabels(,none) collabels(,none) ///
		keep(operating ) varlabels(operating "\multirow{2}{2in}{${title_`vars'}}" ) ///
		prefoot("[.5em]") posthead("\midrule")
}
file open myfile using "$results\mainout.tex", write append
do $dofiles\tabbottom.do



/*Creates the table  */
file open myfile using "$results\indexhc.tex", write replace
file write myfile "\begin{tabular}{p{2in} cc}" _n "\toprule" _n ///
" Outcome   &         (1)   &         (2)  		 		\\" _n 
file close myfile
foreach vars of varlist index_hc  surv65 {
	estout `vars'* using "$results\indexhc.tex", type ///
		append  cells(b(star fmt(%9.3f)) se(par([ ]))) starlevels(* 0.10 ** 0.05 *** 0.01) ///
		stats(dv N, fmt(%9.3f %9.0f) labels("Control Mean, dep. var." "No. of obs.")) style(tex)  ///
		mlabels(,none) collabels(,none) ///
		keep(operating ) varlabels(operating "\multirow{2}{2in}{${title_`vars'}}" ) ///
		prefoot("[.5em]") posthead("\midrule")
}
file open myfile using "$results\indexhc.tex", write append
do $dofiles\tabbottom.do

************************************************************************************************
*Appendix Table A3
************************************************************************************************
/*Creates the table  nights and diag */
file open myfile using "$results\nightsdiag.tex", write replace
file write myfile "\begin{tabular}{p{2in} cc}" _n "\toprule" _n ///
" Outcome   &         (1)   &         (2)  		 		\\" _n 
file close myfile
foreach vars of varlist $nights $diag60 {
	estout `vars'* using "$results\nightsdiag.tex", type ///
		append  cells(b(star fmt(%9.3f)) se(par([ ]))) starlevels(* 0.10 ** 0.05 *** 0.01) ///
		stats(dv N, fmt(%9.3f %9.0f) labels("Control Mean, dep. var." "No. of obs.")) style(tex)  ///
		mlabels(,none) collabels(,none) ///
		keep(operating ) varlabels(operating "\multirow{2}{2in}{${title_`vars'}}" ) ///
		prefoot("[.5em]") posthead("\midrule")
}
file open myfile using "$results\nightsdiag.tex", write append
do $dofiles\tabbottom.do

************************************************************************************************
* Appendix Table A.2
************************************************************************************************
*other income outcomes
/*Creates the table  */
file open myfile using "$results\otherinc.tex", write replace
file write myfile "\begin{tabular}{p{2in} cc}" _n "\toprule" _n ///
" Outcome   &         (1)   &         (2)  	 	 		 		\\" _n 
file close myfile
foreach vars of global otherinc  {
	estout `vars'* using "$results\otherinc.tex", type ///
		append  cells(b(star fmt(%9.3f)) se(par([ ]))) starlevels(* 0.10 ** 0.05 *** 0.01) ///
		stats(dv N, fmt(%9.3f %9.0f) labels("Control Mean, dep. var." "No. of obs.")) style(tex)  ///
		mlabels(,none) collabels(,none) ///
		keep(operating ) varlabels(operating "\multirow{2}{2in}{${title_`vars'}}") ///
		prefoot("[.5em]") posthead("\midrule")
}
file open myfile using "$results\otherinc.tex", write append
do $dofiles\tabbottom.do

************************************************************************************************
* for referee: married
************************************************************************************************
************************************************************************************************
file open myfile using "$results\married.tex", write replace
file write myfile "\begin{tabular}{p{2in} cc}" _n "\toprule" _n ///
" Outcome   &         (1)   &         (2)  		 		\\" _n 
file close myfile
foreach vars of varlist married {
	estout `vars'* using "$results\married.tex", type ///
		append  cells(b(star fmt(%9.3f)) se(par([ ]))) starlevels(* 0.10 ** 0.05 *** 0.01) ///
		stats(dv N, fmt(%9.3f %9.0f) labels("Control mean, dep. var." "No. of obs.")) style(tex)  ///
		mlabels(,none) collabels(,none) ///
		keep(operating ) varlabels(operating "\multirow{2}{2in}{${title_`vars'}}" ) ///
		prefoot("[.5em]") posthead("\midrule")
}
file open myfile using "$results\married.tex", write append
do $dofiles\tabbottom.do
estimates clear



***************************************************************
* robustness - focus on trends (Table A7) and sample (Table A8)
***************************************************************
drop frac_operating
gen frac_operating=1 if age_atopen<=3
replace frac_operating=0.75 if age_atopen==4
replace frac_operating=0.5 if age_atopen==5
replace frac_operating=0.25 if age_atopen==6
replace frac_operating=0 if age_atopen>=7
label var frac_operating "Frac Yrs"

label var edu "Post 1946 $\times$ Rural"

estimates clear 
foreach vars of varlist $mainout surv65 {

	
	areg `vars' operating  i.year  $contrvars i.rural#c.year  [aweight=N]  , abs(muni) cl(muni)
	estimates store `vars'2
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)'
	
	 areg `vars' operating edu  $style1, abs(muni) cl(muni)	
	estimates store `vars'3
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)'
	
	areg `vars' operating  i.rural#i.decade $style1, abs(muni) cl(muni)
	estimates store `vars'4
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)' 

	
	eststo: areg `vars' frac_operating    $style2, abs(muni) cl(muni)
	estimates store `vars'5
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)'
	
	
	}



/*Creates the tables  */
file open myfile using "$results\mainout_robust.tex", write replace
file write myfile "\begin{tabular}{p{1.5in} cccc}" _n "\toprule" _n ///
" Outcome   &         (1)   &         (2)  	& (3) 	& (4) 	 		\\" _n ///
"   		&              (Rural trends)  & (Edu. Ref.) & (Rural*Decade)  &(Frac Yrs) 	\\" _n 
file close myfile
foreach vars of global mainout  {
	estout `vars'* using "$results\mainout_robust.tex", type ///
		rename(frac_operating operating) append  cells(b(star fmt(%9.3f)) se(par([ ]))) starlevels(* 0.10 ** 0.05 *** 0.01) ///
		stats(dv N, fmt(%9.3f %9.0f) labels("Control Mean, dep. var." "No. of obs.")) style(tex)  ///
		mlabels(,none) collabels(,none) ///
		keep(operating) varlabels(operating "\multirow{2}{2in}{${title_`vars'}}") ///
		prefoot("[.5em]") posthead("\midrule")
}
file open myfile using "$results\mainout_robust.tex", write append
file write myfile "\midrule" _n ///
"Cohort FE 									&    Yes   &         Yes  & 		Yes  	&  Yes   	\\" _n ///
"Municipality FE 							&    Yes   &         Yes  & 		Yes  	&  Yes    	 \\" _n ///
"Muni Controls 							&    Yes   &         Yes  & 		Yes  	&  Yes  	\\" _n ///
"County Trends		  &        No 	& No 	      	& No &         Yes  \\" _n ///
"\bottomrule" _n "\end{tabular}"
file close myfile


/*Creates the table  */
************************************************************************************************
* Appendix Table A7 (first gen outcomes)
************************************************************************************************

file open myfile using "$results\indexhc_robust.tex", write replace
file write myfile "\begin{tabular}{p{1.5in} cccc}" _n "\toprule" _n ///
" Outcome   &         (1)   &         (2)  	& (3) 	& (4) 	 		\\" _n ///
"   		&              (Rural trends)  & (Edu. Ref.) & (Rural*Decade)  &(Frac Yrs) 	\\" _n 
file close myfile
foreach vars of varlist index_hc surv65  {
	estout `vars'* using "$results\indexhc_robust.tex", type ///
		rename(frac_operating operating) append  cells(b(star fmt(%9.3f)) se(par([ ]))) starlevels(* 0.10 ** 0.05 *** 0.01) ///
		stats(dv N, fmt(%9.3f %9.0f) labels("Control Mean, dep. var." "No. of obs.")) style(tex)  ///
		mlabels(,none) collabels(,none) ///
		keep(operating) varlabels(operating "\multirow{2}{2in}{${title_`vars'}}") ///
		prefoot("[.5em]") posthead("\midrule")
}
file open myfile using "$results\indexhc_robust.tex", write append
file write myfile "\midrule" _n ///
"Cohort FE 									&    Yes   &         Yes  & 		Yes  	&  Yes  	\\" _n ///
"Municipality FE 							&    Yes   &         Yes  & 		Yes  	&  Yes    	 \\" _n ///
"Muni Controls  							&    Yes   &         Yes  & 		Yes  	 	&    Yes \\" _n ///
"County Trends		  &        No 	& No 	      	& No &         Yes  \\" _n ///
"\bottomrule" _n "\end{tabular}"
file close myfile

************************************************************************************************
* robustness to change in sample, Appendix Table A8
************************************************************************************************
estimates clear 
foreach vars of varlist $mainout  surv65{
	
	areg `vars' operating $style1  if  rural==0 , abs(muni) cl(muni)
	
	estimates store `vars'1
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)' 

	quietly: areg `vars' operating $style1 if  rural==1 , abs(muni) cl(muni)
	estimates store `vars'2
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)' 

	areg `vars' operating   $style2   if   fstyear>=1934 & fstyear!=. , abs(muni) cl(muni)
	
	estimates store `vars'3
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)' 
	

	quietly: areg `vars' operating  $style2  if ever_nurse==1 , abs(muni) cl(muni)
	
	estimates store `vars'5
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)'  
	
	
	}


/*Creates the table  */
file open myfile using "$results\mainout_robust1.tex", write replace
file write myfile "\begin{tabular}{p{1.5in} cccc}" _n "\toprule" _n ///
" Outcome   &         (1)   &         (2)  	& (3) 	& (4) 	  		\\" _n ///
"   		&         (Rural areas) &        (Towns)  & (No always impl.) &  (Ever nurse) 	\\" _n 
file close myfile
foreach vars of global mainout  {
	estout `vars'* using "$results\mainout_robust1.tex", type ///
		 append  cells(b(star fmt(%9.3f)) se(par([ ]))) starlevels(* 0.10 ** 0.05 *** 0.01) ///
		stats(dv N, fmt(%9.3f %9.0f) labels("Control Mean, dep. var." "No. of obs.")) style(tex)  ///
		mlabels(,none) collabels(,none) ///
		keep(operating) varlabels(operating "\multirow{2}{2in}{${title_`vars'}}") ///
		prefoot("[.5em]") posthead("\midrule")
}
file open myfile using "$results\mainout_robust1.tex", write append
file write myfile "\midrule" _n ///
"Cohort FE 									&    Yes   &         Yes  & 		Yes  	&  Yes  	  \\" _n ///
"Municipality FE 							&    Yes   &         Yes  & 		Yes  	&  Yes  	    	 \\" _n ///
"Muni Controls  							&    Yes   &         Yes  & 		Yes  	&  Yes   	\\" _n ///
"\textit{Trends} \\" _n ///
"County 		  &        No 	& No 	      	& Yes &         Yes  \\" _n ///
"\bottomrule" _n "\end{tabular}"
file close myfile

/*Creates the table  */
file open myfile using "$results\indexhc_robust1.tex", write replace
file write myfile "\begin{tabular}{p{1.5in} cccc}" _n "\toprule" _n ///
" Outcome   &         (1)   &         (2)  	& (3) 	& (4) 	 		\\" _n ///
"   		&         (Rural areas) &        (Towns)  & (No always impl.) &  (Ever nurse) 	\\" _n 
file close myfile
foreach vars of varlist index_hc surv65  {
	estout `vars'* using "$results\indexhc_robust1.tex", type ///
		 append  cells(b(star fmt(%9.3f)) se(par([ ]))) starlevels(* 0.10 ** 0.05 *** 0.01) ///
		stats(dv N, fmt(%9.3f %9.0f) labels("Control Mean, dep. var." "No. of obs.")) style(tex)  ///
		mlabels(,none) collabels(,none) ///
		keep(operating) varlabels(operating "\multirow{2}{2in}{${title_`vars'}}") ///
		prefoot("[.5em]") posthead("\midrule")
}
file open myfile using "$results\indexhc_robust1.tex", write append
file write myfile "\midrule" _n ///
"Cohort FE 									&    Yes   &         Yes  & 		Yes  	&  Yes 	  \\" _n ///
"Municipality FE 							&    Yes   &         Yes  & 		Yes  	&  Yes 	   	 \\" _n ///
"Muni Controls  							&    Yes   &         Yes  & 		Yes  	&  Yes 	\\" _n ///
"\textit{Trends} \\" _n ///
"County		  &        No 	& No 	      	& Yes &         Yes 	\\" _n ///
"\bottomrule" _n "\end{tabular}"
file close myfile






**************************************************************************
***************************MAIN NURSE PROGRAM	 *****************
**************************************************************************

estimates clear
* nurse program on daycare sample 

* survival

foreach vars of global surv  {


	quietly: areg `vars' nurse_treat $style1 , abs(muni) cl(muni)

	estimates store `vars'2
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)'
	
	quietly: areg `vars' nurse_treat  $style2 , abs(muni) cl(muni)
	estimates store `vars'3
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)'
	 

}

/*Creates the table  */
************************************************************************************************
* Appendix Table B. 1
************************************************************************************************

file open myfile using "$results\deathout_nurse.tex", write replace
file write myfile "\begin{tabular}{p{2in} cc}" _n "\toprule" _n ///
" Outcome   &         (1)   &         (2)  	 			 		\\" _n 
file close myfile
foreach vars of global surv  {
	estout `vars'* using "$results\deathout_nurse.tex", type ///
		append  cells(b(star fmt(%9.3f)) se(par)) starlevels(* 0.10 ** 0.05 *** 0.01) ///
		stats(dv N, fmt(%9.3f %9.0f) labels("Control Mean, dep. var." "No. of obs.")) style(tex)  ///
		mlabels(,none) collabels(,none) ///
		keep(nurse_treat) varlabels(nurse_treat "\multirow{2}{2in}{${title_`vars'}}") ///
		prefoot("[.5em]") posthead("\midrule")
}
file open myfile using "$results\deathout_nurse.tex", write append
do $dofiles\tabbottom.do

estimates clear

************************************************************************************************
*diags and hosp nights
* Appendix table B.2
************************************************************************************************

foreach vars of global diagnights60   {


	quietly: areg `vars' nurse_treat $style1 , abs(muni) cl(muni)
	estimates store `vars'2
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)'
	
	quietly: areg `vars' nurse_treat  $style2 , abs(muni) cl(muni)
	estimates store `vars'3
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)' 
	
	

}

/*Creates the table  */
file open myfile using "$results\diagout_nurse.tex", write replace
file write myfile "\begin{tabular}{p{2in} cc}" _n "\toprule" _n ///
" Outcome   &         (1)   &         (2)  				 		\\" _n 
file close myfile
foreach vars of global diagnights60  {
	estout `vars'* using "$results\diagout_nurse.tex", type ///
		append  cells(b(star fmt(%9.3f)) se(par)) starlevels(* 0.10 ** 0.05 *** 0.01) ///
		stats(dv N, fmt(%9.3f %9.0f) labels("Control Mean, dep. var." "No. of obs.")) style(tex)  ///
		mlabels(,none) collabels(,none) ///
		keep(nurse_treat) varlabels(nurse_treat "\multirow{2}{2in}{${title_`vars'}}") ///
		prefoot("[.5em]") posthead("\midrule")
}
file open myfile using "$results\diagout_nurse.tex", write append
do $dofiles\tabbottom.do

estimates clear


**********************************************************************************************
* both nurse and preschool - main effects only
* Appendix Tables  B3 and B4
**********************************************************************************************

estimates clear
foreach vars of varlist $surv $mainout $diagnights60 {


	quietly: areg `vars' operating nurse_treat  $style1 , abs(muni) cl(muni)
	estimates store `vars'2
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)'
	
	quietly: areg `vars' operating nurse_treat  $style2 , abs(muni) cl(muni)
	estimates store `vars'3
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)'
	

}



/*Creates the table  */
file open myfile using "$results\mainout_nursechildcare.tex", write replace
file write myfile "\begin{tabular}{p{2.5in} cc}" _n "\toprule" _n ///
" Outcome/Program  &         (1)   &         (2)   	 		 		\\" _n 
file close myfile
foreach vars of global mainout  {
	estout `vars'* using "$results\mainout_nursechildcare.tex", type ///
		append  cells(b(star fmt(%9.3f)) se(par)) starlevels(* 0.10 ** 0.05 *** 0.01) ///
		stats(dv N, fmt(%9.3f %9.0f) labels("Control Mean, dep. var." "No. of obs.")) style(tex)  ///
		mlabels(,none) collabels(,none) ///
		keep(operating nurse_treat ) varlabels(nurse_treat "{${title_`vars'}: NHV}" operating "{${title_`vars'}: Preschool}" ) ///
		prefoot("[.5em]") posthead("\midrule")
}
file open myfile using "$results\mainout_nursechildcare.tex", write append
do $dofiles\tabbottom.do


/*Creates the table  */
file open myfile using "$results\diagout_nursechildcare.tex", write replace
file write myfile "\begin{tabular}{p{2.5in} cc}" _n "\toprule" _n ///
" Outcome/Program   &         (1)   &         (2)  	 		 		\\" _n 
file close myfile
foreach vars of global diagnights60  {
	estout `vars'* using "$results\diagout_nursechildcare.tex", type ///
		append  cells(b(star fmt(%9.3f)) se(par)) starlevels(* 0.10 ** 0.05 *** 0.01) ///
		stats(dv N, fmt(%9.3f %9.0f) labels("Control Mean, dep. var." "No. of obs.")) style(tex)  ///
		mlabels(,none) collabels(,none) ///
		keep(operating nurse_treat ) varlabels(nurse_treat "{${title_`vars'}: NHV}" operating "{${title_`vars'}: Preschool}" ) ///
		prefoot("[.5em]") posthead("\midrule")
}
file open myfile using "$results\diagout_nursechildcare.tex", write append
do $dofiles\tabbottom.do


/*Creates the table  */
file open myfile using "$results\indexhc_nursechildcare.tex", write replace
file write myfile "\begin{tabular}{p{2.5in} cc}" _n "\toprule" _n ///
" Outcome/Program   &         (1)   &         (2)  	 		 		\\" _n 
file close myfile
foreach vars of varlist index_hc surv65 {
	estout `vars'* using "$results\indexhc_nursechildcare.tex", type ///
		append  cells(b(star fmt(%9.3f)) se(par)) starlevels(* 0.10 ** 0.05 *** 0.01) ///
		stats(dv N, fmt(%9.3f %9.0f) labels("Control mean, dep. var." "No. of obs.")) style(tex)  ///
		mlabels(,none) collabels(,none) ///
		keep(operating nurse_treat ) varlabels(nurse_treat "{${title_`vars'}: NHV}" operating "{${title_`vars'}: Preschool}" ) ///
		prefoot("[.5em]") posthead("\midrule")
}
file open myfile using "$results\indexhc_nursechildcare.tex", write append
do $dofiles\tabbottom.do

estimates clear




********************************************************************************
******************************* MAIN TABLE FOR INTERACTION WITH NURSE PROGRAM***
********************************************************************************

****  Table 6
eststo clear
foreach var of varlist index_hc surv65  {
eststo: areg `var' operating nurse_treat daycare_nurse  $style2, abs(muni) cl(muni)
qui sum `var'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
estadd scalar dv=`r(mean)'
}
#delimit ;
esttab using  "$results\index_DAY_NURSE_everD_yrapproval.tex", keep(operating nurse_treat daycare_nurse) star(* .1 ** .05 *** .01) 
wrap label varwidth(18) collabels(,none)
replace booktabs fragment  cells(b(star fmt(%9.3f)) se(par([ ])))  stats(dv N, fmt(%9.3f %9.0f) label("Control mean, dep. var." "Observations (cells)"))
mtitles ("Human capital index" "Survival beyond age 65" ) ;
#delimit cr



******************* INTERACTION ROBUSTNESS
* Appendix Table A.12
*** "help nurse" sample (drop cohorts born after 1949 in the 28 municipalities with worse nurse program data)

gen helpnurse=1 if imputenurse==0
replace helpnurse=1 if imputenurse==1 & year<=1952



eststo clear
foreach var in $mainout {
eststo: areg `var' operating nurse_treat daycare_nurse    $style2 if helpnurse==1 , abs(muni) cl(muni)
qui sum `var'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
estadd scalar dv=`r(mean)'
}
#delimit ;
esttab using  "$results\mainout_DAY_NURSE_contr_helpnurse.tex", keep(operating nurse_treat daycare_nurse ) star(* .1 ** .05 *** .01) se brackets
wrap label varwidth(18) collabels(,none)
replace booktabs fragment  cells(b(star fmt(%9.3f)) se(par([ ])))  stats(dv N, fmt(%9.3f %9.0f) label("Control mean, dep. var." "Observations (cells)"))
mtitles ("Yrs. School" "More than Comp" "Log Wage Inc" "Survival beyond age 65" ) ;
#delimit cr


eststo clear
foreach var of varlist index_hc surv65{
eststo: areg `var' operating nurse_treat daycare_nurse    $style2 if helpnurse==1 , abs(muni) cl(muni)
qui sum `var'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
estadd scalar dv=`r(mean)'
}
#delimit ;
esttab using  "$results\index_DAY_NURSE_contr_helpnurse.tex", keep(operating nurse_treat daycare_nurse ) star(* .1 ** .05 *** .01) se brackets
wrap label varwidth(18) collabels(,none)
replace booktabs fragment  cells(b(star fmt(%9.3f)) se(par([ ])))  stats(dv N, fmt(%9.3f %9.0f) label("Control mean, dep. var." "Observations (cells)"))
mtitles ("Human Capital Index" "Survival beyond age 65" ) ;
#delimit cr


