****************** Intergenerational Analysis on 2nd Generation's Education
* all kids sample rather than first kids sample


do "D:\Data\workdata\704665\daycare\dofiles\first.do"

capture log close
set scheme s1mono

* the data for this analysis is created in 3_cr_edu_kids (omit the constraint that only keeps first kids)

**************************************************************************
*********************** COLLAPSED DATA ANALYSIS***************************
* Appendix Table A6
**************************************************************************
use "$work\analysis_daycare_intergen_everopen_allkids.dta", clear


foreach vars of global kidedu25  {

	quietly: areg `vars' operating  $style1 , abs(muni) cl(muni)

	estimates store `vars'2
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)'
	
	 areg `vars' operating  $style2 , abs(muni) cl(muni)
			
	estimates store `vars'3
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)'
	
	

}

/*Creates the table  */
file open myfile using "$results\kidedu25all.tex", write replace
file write myfile "\begin{tabular}{p{2in} cc}" _n "\toprule" _n ///
" Outcome   &         (1)   &         (2)  			 		\\" _n 
file close myfile
foreach vars of global kidedu25  {
	estout `vars'* using "$results\kidedu25all.tex", type ///
		append  cells(b(star fmt(%9.3f)) se(par([ ]))) starlevels(* 0.10 ** 0.05 *** 0.01) ///
		stats(dv N, fmt(%9.3f %9.0f) labels("Control Mean, dep. var." "No. of obs.")) style(tex)  ///
		mlabels(,none) collabels(,none) ///
		keep(operating) varlabels(operating "\multirow{2}{2in}{${title_`vars'}}") ///
		prefoot("[.5em]") posthead("\midrule")
}
file open myfile using "$results\kidedu25all.tex", write append
do $dofiles\tabbottom.do

estimates clear





