* appendix figure a5 

capture program drop permut
program define permut, rclass
	version 12	
	syntax varlist [if], [weight(string) graph ] reps(string) 

preserve
	
	* set nbr of permutations
	local P=`reps'			
	gen p_num=_n
	replace p_num=. if p_num>`P'

	*create variable to later save p
	gen p=.
	  
	*start loop for permutations
	forval i=1/`P'{
	* create empty variable to save permutated treated
	gen treated_perm=0
	egen group=group(muni)
	*tab group
	
	gen helpyear=fstyear
	replace helpyear=1921 if fstyear==.
	
	*start loop counter	- all munics should end up with a new treat date
	foreach num of numlist 1 (1) 138 {
	* select year 
	sum helpyear if `varlist'!=. 
	
	local delta=r(max)-r(min)+1
	
	local ayear=round(runiform()*`delta'+r(min)-0.5)
	dis `ayear'

	
	*create treatment variable 
	replace treated_perm=1 if group==`num' & year>=`ayear'  
	
	dis `ayear'
	dis `num'
	dis `i'
	tab treated_perm
	}
	tab treated_perm
	*estimate and save
	qui: areg `varlist' treated_perm  $style2 , abs(muni) cl(muni)
	replace p=_b[treated_perm] if p_num==`i'
	
	*drop created vars
	drop treated_perm group helpyear
	
	}

		
	*estimate actual reg
	
	qui: areg `varlist' operating  $style2 , abs(muni) cl(muni)
	
	*make graph
	
	if "`graph'"!=""{
	*CDF
	cumul p, gen(cdf)
	sum p, d
	local c=_b[operating]
	local low=r(p1)*0.9
	local lowest=min(`low', `c')
	local high=r(p99)*1.1
	local highest=max(`high', `c')
	twoway(line cdf p if p>=`lowest' & p<=`highest', sort lcolor(black)), xsc(range(`lowest' `highest')) xline(`c', lcolor(gs6)) ///
	xtitle("Estimates") graphregion(fcolor(white) lcolor(white)) ///
	plotregion(fcolor(white)  lcolor(black)) xlabel(#10, noticks) ///
	ylabel(#10, noticks) legend(off) ytitle(Fraction) saving("$graphs\graphs_jan2018\permut`varlist'.gph", replace)
	
	graph export "$graphs\graphs_jan2018\permut`varlist'.png",replace
	

	twoway(kdensity p if p>=`lowest' & p<=`highest',  sort lcolor(black)), xsc(range(`lowest' `highest')) xline(`c', lcolor(gs6)) ///
	xtitle("Estimates") graphregion(fcolor(white) lcolor(white)) ///
	plotregion(fcolor(white)  lcolor(black)) xlabel(#10, noticks) ///
	legend(off) ytitle(Density) saving("$graphs\graphs_jan2018\permut`varlist'kdens.gph", replace)
	
	graph export "$graphs\graphs_jan2018\permut`varlist'_kdens.png",replace
	
	
	twoway(hist p if p>=`lowest' & p<=`highest',  dens bin(20) sort lcolor(black)), xsc(range(`lowest' `highest')) xline(`c', lcolor(gs6)) ///
	xtitle("Estimates") graphregion(fcolor(white) lcolor(white)) ///
	plotregion(fcolor(white)  lcolor(black)) xlabel(#10, noticks) ///
	legend(off) ytitle(Density) saving("$graphs\graphs_jan2018\permut`varlist'_hist.gph", replace)
	
	graph export "$graphs\graphs_jan2018\permut`varlist'_hist.png",replace
	
	}
	
	
	restore 
	end
	
	
	
	
