
run "D:\Data\workdata\704665\daycare\dofiles\first.do"

*************************************************************
* Health outcomes: mortality/survival
*************************************************************

********************************************
* mortality 
********************************************

use "$raw\DOD2013.dta", clear

merge 1:1 pnr using "$work\pop_daycare_pnrlist.dta"
keep if _merge==3
drop _merge

rename DOEDSAARS1 dodsars1
rename DOEDSAARS2 dodsars2

gen sks=substr(dodsars1,1,3)

gen gruppe23=. 
replace gruppe23=1 if sks>="A00" & sks<="B99"
replace gruppe23=2 if sks>="C00" & sks<="C97"
replace gruppe23=3 if sks>="D00" & sks<="D48"
replace gruppe23=4 if sks>="D50" & sks<="D89"
replace gruppe23=5 if sks>="E00" & sks<="E90"
replace gruppe23=6 if sks>="F03" & sks<="F99"
replace gruppe23=7 if sks>="G00" & sks<="G31"
replace gruppe23=7 if sks>="G35" & sks<="H95"
replace gruppe23=8 if sks>="I00" & sks<="I25"
replace gruppe23=8 if sks=="I27"
replace gruppe23=8 if sks>="I30" & sks<="I51"
replace gruppe23=9 if sks=="I26"
replace gruppe23=9 if sks=="I28"
replace gruppe23=9 if sks>="I60" & sks<="I99"
replace gruppe23=10 if sks>="J00" & sks<="J99"
replace gruppe23=11 if sks>="K00" & sks<="K92"
replace gruppe23=12 if sks>="L00" & sks<="L99" /*grupper 12 og 13 kan ikke skelnes i ICD8 derfor laver jeg kun en gruppe af de to grupper*/
replace gruppe23=12 if sks>="M00" & sks<="M99"
replace gruppe23=14 if sks>="N00" & sks<="N98"
replace gruppe23=15 if sks>="O00" & sks<="O99"
replace gruppe23=16 if sks>="P00" & sks<="P96"
replace gruppe23=17 if sks>="Q00" & sks<="Q99"
replace gruppe23=18 if sks>="R00" & sks<="R98"
replace gruppe23=18 if sks=="R99"
replace gruppe23=19 if sks>="V01" & sks<="X59"
replace gruppe23=19 if sks>="Y40" & sks<="Y86"
replace gruppe23=19 if sks=="Y88"
replace gruppe23=20 if sks>="X60" & sks<="X84" /*drab, selvmord osv slår jeg også sammen*/
replace gruppe23=20 if sks=="Y87"
replace gruppe23=20 if sks>="X85" & sks<="X99"
replace gruppe23=20 if sks>="Y00" & sks<="Y09"
replace gruppe23=20 if sks=="Y89" 
replace gruppe23=20 if sks>="Y10" & sks<="Y34"
replace gruppe23=20 if sks>="Y35" & sks<="Y36"
replace gruppe23=. if sks=="R99"

* cause 2
drop sks
gen sks=substr(dodsars2,1,3)

gen gruppe23a=. 
replace gruppe23a=1 if sks>="A00" & sks<="B99"
replace gruppe23a=2 if sks>="C00" & sks<="C97"
replace gruppe23a=3 if sks>="D00" & sks<="D48"
replace gruppe23a=4 if sks>="D50" & sks<="D89"
replace gruppe23a=5 if sks>="E00" & sks<="E90"
replace gruppe23a=6 if sks>="F03" & sks<="F99"
replace gruppe23a=7 if sks>="G00" & sks<="G31"
replace gruppe23a=7 if sks>="G35" & sks<="H95"
replace gruppe23a=8 if sks>="I00" & sks<="I25"
replace gruppe23a=8 if sks=="I27"
replace gruppe23a=8 if sks>="I30" & sks<="I51"
replace gruppe23a=9 if sks=="I26"
replace gruppe23a=9 if sks=="I28"
replace gruppe23a=9 if sks>="I60" & sks<="I99"
replace gruppe23a=10 if sks>="J00" & sks<="J99"
replace gruppe23a=11 if sks>="K00" & sks<="K92"
replace gruppe23a=12 if sks>="L00" & sks<="L99" /*grupper 12 og 13 kan ikke skelnes i ICD8 derfor laver jeg kun en gruppe af de to grupper*/
replace gruppe23a=12 if sks>="M00" & sks<="M99"
replace gruppe23a=14 if sks>="N00" & sks<="N98"
replace gruppe23a=15 if sks>="O00" & sks<="O99"
replace gruppe23a=16 if sks>="P00" & sks<="P96"
replace gruppe23a=17 if sks>="Q00" & sks<="Q99"
replace gruppe23a=18 if sks>="R00" & sks<="R98"
replace gruppe23a=18 if sks=="R99"
replace gruppe23a=19 if sks>="V01" & sks<="X59"
replace gruppe23a=19 if sks>="Y40" & sks<="Y86"
replace gruppe23a=19 if sks=="Y88"
replace gruppe23a=20 if sks>="X60" & sks<="X84" /*drab, selvmord osv slår jeg også sammen*/
replace gruppe23a=20 if sks=="Y87"
replace gruppe23a=20 if sks>="X85" & sks<="X99"
replace gruppe23a=20 if sks>="Y00" & sks<="Y09"
replace gruppe23a=20 if sks=="Y89" 
replace gruppe23a=20 if sks>="Y10" & sks<="Y34"
replace gruppe23a=20 if sks>="Y35" & sks<="Y36"
replace gruppe23a=. if sks=="R99"


* ICD 8 codes
drop sks
gen sks=substr(dodsars1,1,3)

replace gruppe23=1 if sks>="000" & sks<="009"
replace gruppe23=1 if sks>="010" & sks<="136"
replace gruppe23=2 if sks>="140" & sks<="199"
replace gruppe23=2 if sks>="200" & sks<="209"
replace gruppe23=3 if sks>="210" & sks<="239"
replace gruppe23=4 if sks>="280" & sks<="289"
replace gruppe23=5 if sks>="240" & sks<="246"
replace gruppe23=5 if sks>="250" & sks<="279"
replace gruppe23=6 if sks>="290" & sks<="315"
replace gruppe23=7 if sks>="320" & sks<="389"
replace gruppe23=8 if sks>="390" & sks<="398"
replace gruppe23=8 if sks>="400" & sks<="404"
replace gruppe23=8 if sks>="410" & sks<="414"
replace gruppe23=8 if sks>="420" & sks<="429"
replace gruppe23=9 if sks>="430" & sks<="438"
replace gruppe23=9 if sks>="440" & sks<="448"
replace gruppe23=9 if sks>="450" & sks<="458"
replace gruppe23=10 if sks>="460" & sks<="474"
replace gruppe23=10 if sks>="480" & sks<="486"
replace gruppe23=10 if sks>="490" & sks<="493"
replace gruppe23=10 if sks>="500" & sks<="519"
replace gruppe23=11 if sks>="520" & sks<="577"
replace gruppe23=12 if sks>="680" & sks<="738"
replace gruppe23=14 if sks>="580" & sks<="629"
replace gruppe23=15 if sks>="630" & sks<="678"
replace gruppe23=16 if sks>="760" & sks<="779"
replace gruppe23=17 if sks>="746" & sks<="759"
replace gruppe23=18 if sks>="780" & sks<="793"
replace gruppe23=18 if sks>="795" & sks<="796"
replace gruppe23=19 if sks>="E80" & sks<="E94"
replace gruppe23=20 if sks>="E95" & sks<="E99"

* cause 2
drop sks
gen sks=substr(dodsars2,1,3)

replace gruppe23a=1 if sks>="000" & sks<="009"
replace gruppe23a=1 if sks>="010" & sks<="136"
replace gruppe23a=2 if sks>="140" & sks<="199"
replace gruppe23a=2 if sks>="200" & sks<="209"
replace gruppe23a=3 if sks>="210" & sks<="239"
replace gruppe23a=4 if sks>="280" & sks<="289"
replace gruppe23a=5 if sks>="240" & sks<="246"
replace gruppe23a=5 if sks>="250" & sks<="279"
replace gruppe23a=6 if sks>="290" & sks<="315"
replace gruppe23a=7 if sks>="320" & sks<="389"
replace gruppe23a=8 if sks>="390" & sks<="398"
replace gruppe23a=8 if sks>="400" & sks<="404"
replace gruppe23a=8 if sks>="410" & sks<="414"
replace gruppe23a=8 if sks>="420" & sks<="429"
replace gruppe23a=9 if sks>="430" & sks<="438"
replace gruppe23a=9 if sks>="440" & sks<="448"
replace gruppe23a=9 if sks>="450" & sks<="458"
replace gruppe23a=10 if sks>="460" & sks<="474"
replace gruppe23a=10 if sks>="480" & sks<="486"
replace gruppe23a=10 if sks>="490" & sks<="493"
replace gruppe23a=10 if sks>="500" & sks<="519"
replace gruppe23a=11 if sks>="520" & sks<="577"
replace gruppe23a=12 if sks>="680" & sks<="738"
replace gruppe23a=14 if sks>="580" & sks<="629"
replace gruppe23a=15 if sks>="630" & sks<="678"
replace gruppe23a=16 if sks>="760" & sks<="779"
replace gruppe23a=17 if sks>="746" & sks<="759"
replace gruppe23a=18 if sks>="780" & sks<="793"
replace gruppe23a=18 if sks>="795" & sks<="796"
replace gruppe23a=19 if sks>="E80" & sks<="E94"
replace gruppe23a=20 if sks>="E95" & sks<="E99"

label variable gruppe23 "ICD groups for causes of deaths(23)"
label variable gruppe23a "ICD groups for causes of deaths, second cause of death"

#delimit ;
label define gruppe 1"Infection" 
2"Cancer"
3"Other cancer"
4"Blood and bloodforming organs"
5"Endocrine, metabolic disease"
6"Mental disorders"
7"Nervous system"
8"Heart disease"
9"Other cardiovascular disease"
10"Respiratory system"
11"Digestive system"
12"Skin, musculosceletal system, connecting tissue"
14"Genitourinary system"
15"Pregnancy and childbirth"
16"Perinatal period"
17"Congential disease"
18"Symtoms not elsewhere classified"
19"Accidents"
20"Suicide, murder, legal interventions";

#delimit cr

label values gruppe23 gruppe
label values gruppe23a gruppe

gen deathyear=year(doddato)
label var deathyear "Year of death"

drop dodsars1 dodsars2 DOEDSAARS3 sks
compress
save "$work\death19812013.dta" , replace


use "$work\death19812013.dta" , clear

gen age_death=deathyear-fodyear


preserve
gen death30=1 if age_death<=30
gen death35=1 if age_death<=35
gen death40=1 if age_death<=40
gen death45=1 if age_death<=45
gen death50=1 if age_death<=50
foreach var of varlist death30-death50{
replace `var'=0 if `var'==.
}
save "$work\death19812013_pre45.dta" , replace
restore

drop if age_death<50
gen death55=1 if age_death<=55
gen death60=1 if age_death<=60
gen death65=1 if age_death<=65

foreach var of varlist death55-death65{
replace `var'=0 if `var'==.
}

* sample that has same chance of entering risk period
save "$work\death19812013.dta" , replace


