
run "D:\Data\workdata\704665\daycare\dofiles\first.do"

set max_memory 6g

******************************************************************************
*  udd
******************************************************************************
 foreach num of numlist 1980/2012{
use pnr pstill hfaudd using "$raw\GRUND`num'.dta",clear
bysort pnr: gen byte copies=_n
drop if copies>1
drop copies
drop if pnr==""
merge 1:1 pnr using pop_daycare_pnrlist.dta
keep if _merge==3
drop _merge

gen outyear=`num'
 
* gen age var
gen age=outyear-fodyear

*education
gen audd= hfaudd
gen audd1=string(audd)
drop audd
rename audd1 audd
merge m:1 audd using "$work\uddan_2008_audd.dta"
drop if _merge==2
destring h1, replace

gen university=(h1>=60 & h1<71)
replace university=. if h1==.
gen higheredu=(h1>=40 & h1<60)
replace higheredu=. if h1==.
gen edu_unknown=(h1>70)
gen basic_edu=(h1==10)
replace basic_edu=. if h1==.

gen month=pria

drop pstill audd atext pria fsp1e apubl1 u1 u1tekst m1 m1tekst _merge
compress

save "$work\edu_`num'.dta",replace
}

clear
set max_memory 10g

use "$work\edu_1980.dta",clear
 foreach num of numlist 1981/2012{
append  using  "$work\edu_`num'.dta"
 }

sort pnr outyear 

save "$work\edu_panel.dta", replace

clear
use "$work\edu_panel.dta"


 
* the education vars
keep pnr university higheredu edu_unknown basic_edu early_ret  month age

sort pnr
foreach var of varlist university higheredu edu_unknown basic_edu early_ret  month {
 foreach nums of numlist 30(5)65{
gen `var'`nums'=`var' if age==`nums'
compress
}
}

drop university higheredu edu_unknown basic_edu early_ret  month 

collapse (min) university30-early_ret65 (max) month30-month65, by(pnr)

save "$work\edu_3065.dta", replace


use "$work\edu_3065.dta", clear

foreach num of numlist 30(5)65{
gen year`num'=month`num'/12
}

foreach num of numlist 30(5)65{
label var university`num' "University education age `num'"
label var higheredu`num' "Higher education age `num'"
label var edu_unknown`num' "Missing education age `num'"
label var basic_edu`num' "Basic education age `num'"
label var early_ret`num' "early retirement by age `num'"
label var month`num' "Months of education age `num'"
label var year`num' "Years of education age `num'"
}

compress
save "$work\edu_3065.dta", replace

