clear all
close all

global al la la1 dd ga zmax L rr rr1 pi bt pp_Pz pp_Pz_1 pp_Pa pp_Pa_1 pp_Pa1 pp_Pa1_1 KK nu pp_PT pp_PT_1 Tax w_hist r_hist la_hist T t w0 r0 Tax0 kk AA BB AA_W p0 pini zlow0

% benchmark calibration
ga = .9^(1/4);
al =  1/3;
dd = 1-(1-0.07)^(1/4);
la=1/(1-.69); % bmk calibration
bt= 0.98645; % B/(4*Y)=0.62, th=0.69
L  = 1;
nu = 0; % share of income devoted to cash goods. For the case of the 
% counterfactual where M is held fixed we consider the cashless limit
pw=0.25; % fraction of workers in the population

N=40;
zmax=10;
sd=3.36;
mu=0;
% z(:,1)=[0;logspace(log(.01)/log(10),log(zmax)/log(10),N-1)'];
z(:,1)=linspace(0,zmax,N)';
Pz=logncdf(z,mu,sd)/logncdf(zmax,mu,sd);
pp_Pz = pchip(z,Pz);
Mder = diag(3:-1:1,1);
pp_Pz_1 = pp_Pz;
pp_Pz_1.coefs = pp_Pz.coefs*Mder;

load lognormal_B0_nu0_201609
load la_hist_cal_201902

g=.00;

% Initialize the policy function for workers

T=150


% transtion part starts. We first calculate the case with indexed bonds


% initializing the history of wages and interest rate

% if we do not have a better guess saves use the following

w_hist=[w0*ones(T+1,1)];
r_hist=[r0*ones(T+1,1)];p2(1,1)=p0;
Tax=ones(T+1,1)*Tax0;

% initializing the government debt
B1(1,1)=B0;
B2(1,1)=B0;

% we calculate the policy function for workers solve using the endogenous
% grid method (Carroll, 2005)

kk=[0 logspace(log(.001)/log(10),log(100)/log(10),40)]';

c0=(1+r0)*kk+w0-pw*Tax0;

% initializing the policy function of workers in the steady state (notice
% that the new steady state is endogenous, as it depends on the sequence of
% policies during the ZLB
for i=1:100
    
    B=(1+r0)*bt*c0.^(-1);
    cc=B.^(-1);
    mm=nu/(1-nu)*c0/(1+r0);
    kk2=(cc+kk+mm-w0+pw*Tax0)/(1+r0);
    kk2_low=(cc(1)+kk(1)+mm(1)-w0+pw*Tax0)/(1+r0);
    c1=interp1([0;kk2(kk2>=kk2_low)],[(1-nu)/(1-nu*(1-bt))*(w0-pw*Tax0);cc(kk2>=kk2_low)],kk,'linear');
    
    if max(max(abs(c1-c0)))<.0001
        break
    end
    c0=c1;
    
end

% sequence of prices, exogenous given that the government follows an
% inflation target
p1(1,1)=p0;for t=1:T, p1(t+1,1)=(1+g)*p1(t,1); end

% % [M2_W a2_W]=feval('out_workers_Tax',[w1(1:100)' r1(1:100)'  zeros(100,1)
% % pw*Tax0*ones(100,1)],p2,M0_W/(1+g),T);

[a2_W M2_W c1_W c2_W]=feval('out_workers_simple3',[w_hist r_hist],p1,M0_W/(1+g),pw*Tax,c0);

p_nozlb(1)=p0;
pu(1,1)=p0;
M1(1,1)=M0_nu; % M0_nu is the initial cash supply relative to nu,
    %which is a strictly positive and bounded value in the cashless limit


K1(1,1)=K0;
Z1(1,1)=Z0;
zlow1(1)=zlow0;
r1(1,1)=r0;
rr=r1(1);
w1(1,1)=(1-al)*Z1(1)*K1(1)^al*L^(-al);

T1=100;

for iT=1:40
    
    Pa1(:,1)=Pa0;
    pp_Pa = pchip(z,Pa1(:,1));
    pp_Pa_1 = pp_Pa;
    pp_Pa_1.coefs = pp_Pa.coefs*Mder;
    
    PT2=(1-pw)*Pz;
    pp_PT = pchip(z,PT2);
    pp_PT_1 = pp_PT;
    pp_PT_1.coefs = pp_PT.coefs*Mder;
    
    pi = al*((1-al)/(w1(1)))^((1-al)/al);
    pp_Pa = pchip(z,Pa1(:,1));
    Y1(1,1)=Z1(1)*K1(1)^al*L^(1-al);
    
    rr=r1(1,1);
    M1(1,1)=M0_nu/(1+g); % M0_nu is the initial cash supply relative to nu,
    %which is a strictly positive and bounded value in the cashless limit

    for t=1:T
        
        la=la_hist(t);
        la1=la_hist(t+1);
        
        if t==1
            C1(t,1)=C10;
        end
        
        sum_Tax_temp_all_2=quad('eq_sum_Tax_2',z(1),z(end));
        sum_Tax_temp_all=quad('eq_sum_Tax',z(1),z(end));
        C2(t,1)=(1-nu)*(1-bt)/(1-nu*(1-bt))*(quad('eqR',z(1),z(end))-sum_Tax_temp_all_2);
        C1(t+1,1)=p1(t)/p1(t+1)*bt*nu*(1-bt)/(1-nu*(1-bt))*(quad('eqR',z(1),z(end))-sum_Tax_temp_all_2);
        
        
        R0z2(2)=quad('eqR',z(1),z(2));
        T_sum_temp(2)=quad('eq_sum_Tax',z(1),z(2));
        
        for i=3:N
            R0z2(i)=R0z2(i-1)+quad('eqR',z(i-1),z(i));
            T_sum_temp(i)=T_sum_temp(i-1)+quad('eq_sum_Tax',z(i-1),z(i));
        end
        
        
        A1(t+1,1)=bt*(R0z2(end)-(1-pw)*Tax(t))...
            +(1-bt)*sum_Tax_temp_all;
        
        B1(t+1,1)=B1(t,1);
        
        Taxnew(t,1)=r1(t)*B1(t,1);
        
        Pa1(1,t+1)=0; Pa1(N,t+1)=A1(t+1,1);
        
        T_temp=quad('eq_Tax',z(1),z(2));
        Pa1(2,t+1) = ga*(bt*(R0z2(2)-T_temp)+(1-bt)*T_sum_temp(2))...
            +(1-ga)*ppval(pp_Pz,z(2))*A1(t+1,1)...
            +(1-ga)*nu*(1-bt)*(T_sum_temp(2)...
            -ppval(pp_Pz,z(2))*sum_Tax_temp_all);
        
        for i=3:N-1
            T_temp=T_temp+quad('eq_Tax',z(i-1),z(i));
            Pa1(i,t+1) = ga*(bt*(R0z2(i)-T_temp)+(1-bt)*T_sum_temp(i))...
                +(1-ga)*ppval(pp_Pz,z(i))*A1(t+1,1)...
                +(1-ga)*nu*(1-bt)*(T_sum_temp(i)...
                -ppval(pp_Pz,z(i))*sum_Tax_temp_all);
        end
        
        pp_Pa1 = pchip(z,Pa1(:,t+1));
        pp_Pa1_1 = pp_Pa1;
        pp_Pa1_1.coefs = pp_Pa1.coefs*Mder;
        
        AA=A1(t+1,1);
        BB=B1(t+1,1);
        AA_W=a2_W(t+1);
        
        zlow1(t+1)=fminbnd('eqzhat_unc_B',z(1),z(end));
        K1(t+1,1)=la1*(AA-ppval(pp_Pa1,zlow1(t+1)));
        KK=K1(t+1,1);
        Ztemp=quad('eqZ',zlow1(t+1),z(end));
        Z1(t+1,1)=Ztemp^al;
        
        w1(t+1,1)=(1-al)*Z1(t+1)*K1(t+1)^al*L^(-al);
        Y1(t+1,1)=Z1(t+1,1)*K1(t+1,1)^al*L^(1-al);
        pi = al*((1-al)/(w1(t+1,1)))^((1-al)/al);
        r1(t+1,1)=pi*zlow1(t+1)-dd;
        
        
        rr=r1(t+1,1);
        zlb(t+1)=0;
        
        pp_Pa = pchip(z,Pa1(:,t+1));
        pp_Pa_1 = pp_Pa;
        pp_Pa_1.coefs = pp_Pa.coefs*Mder;
        
        M1(t+1,1)=(1+g)*M1(t);
        
        % calculate the unconstrained price level sequence
        pu(t,1)=M1(t+1)/(bt*(1-bt)*(quad('eqR',z(1),z(end))-sum_Tax_temp_all_2)...
            +bt*c2_W(t));
        
        
    end
    
    Taxnew(t+1,1)=Taxnew(t,1);
    
    
    clear rnu
    
    rnu(1,1)=r1(1);
    for t=2:T1
        rnu(t,1)=(1+r1(t))*pu(t)/pu(t-1)-1;
    end
    
    tmax=max(find(rnu<0));
    tmin=min(find(rnu<0));
    
    clear pc
    
    pc(tmax,1)=pu(tmax);
    for t=tmax-1:-1:1
        pc(t,1)=(1+r1(t+1))*pc(t+1);
    end
    
    if pc(1)>1
        break
    else
        p1(1:tmax,1)=pc;
        p1(tmax+1:length(pu),1)=pu(tmax+1:end,1);
    end
    
    
    [iT min(Tax-Taxnew) max(Tax-Taxnew) min(Tax) max(Tax) max(r1) p1(1)]
    
    if (max(abs(Tax-Taxnew))<0.0001)
        break
    end
    
    %         Tax_acum(:,iT)=Tax;
    %         K_acum(:,iT)=K2;
    %         B_acum(:,iT)=B2;
    
    update_T=1;
    update_price=1;
    
    
    Tax= (1-update_T)*Tax+update_T*Taxnew;
    w_hist=(1-update_price)*w_hist+update_price*w1;
    r_hist=(1-update_price)*r_hist+update_price*r1;
    
    if bt*(1+r0)<1
        
        for i=1:100
            
            B=(1+r1(end))*bt*c0.^(-1);
            cc=B.^(-1);
            mm=nu/(1-nu)*c0/(1+r1(end));
            kk2=(cc+kk+mm-w1(end)+pw*Tax(end))/(1+r1(end));
            kk2_low=(cc(1)+kk(1)+mm(1)-w1(end)+pw*Tax(end))/(1+r1(end));
            c1=interp1([0;kk2(kk2>=kk2_low)],[(1-nu)/(1-nu*(1-bt))*(w1(end)-pw*Tax(end));cc(kk2>=kk2_low)],kk,'linear');
            
            if max(max(abs(c1-c0)))<.0001
                break
            end
            c0=c1;
            
        end
        
        % [M2_W a2_W]=feval('out_workers_Tax',[w2(1:100) r2(1:100)  zlb(1:100)' pw*Tax],p2,M0_W/(1+g),T);
        
                [a2_W M2_W c1_W c2_W]=feval('out_workers_simple3',[w_hist r_hist ],p1,M0_W/(1+g),pw*Tax,c0);
        
    end
    
    [Y1(1:5)-(K1(2:6)-(1-dd)*K1(1:5)) C1(1:5)+C2(1:5)+c1_W(1:5)+c2_W(1:5)]
    
end

Tax1=Tax;


figure(1)
tt=1:100;
subplot(2,2,1),plot(tt,Y1(tt)/Y1(1))
axis([0 max(tt) .85 1.05])
title('output')
subplot(2,2,2),plot(tt,Z1(tt)/Z1(1))
axis([0 max(tt) .85 1.05])
title('TFP')
w1=(1-al)*Z1.*K1.^al;
subplot(2,2,3),plot(tt,w1(tt)/w1(1))
axis([0 max(tt) .85 1.05])
title('real wage')
subplot(2,2,4),plot(tt,p1(tt))
axis([0 max(tt) .85 1.05])
title('price level')


% we now calculate the case with nominal bonds. The main difference from
% the previous case is that we now use the function eqR3, which takes into
% account the effect of the initial deflation/inflation on the real value
% of initial nominal liabilities/assets

% initializing the history of wages and interest rate

% if we do not have a better guess saves use the following

w_hist=w1;
r_hist=r1;
Tax=Tax1;

% initializing the government debt
B2(1,1)=B0;

% we calculate the policy function for workers solve using the endogenous
% grid method (Carroll, 2005)

kk=[0 logspace(log(.001)/log(10),log(100)/log(10),40)]';

c0=(1+r0)*kk+w0-pw*Tax0;

% initializing the policy function of workers in the steady state (notice
% that the new steady state is endogenous, as it depends on the sequence of
% policies during the ZLB
for i=1:100
    
    B=(1+r0)*bt*c0.^(-1);
    cc=B.^(-1);
    mm=nu/(1-nu)*c0/(1+r0);
    kk2=(cc+kk+mm-w0+pw*Tax0)/(1+r0);
    kk2_low=(cc(1)+kk(1)+mm(1)-w0+pw*Tax0)/(1+r0);
    c1=interp1([0;kk2(kk2>=kk2_low)],[(1-nu)/(1-nu*(1-bt))*(w0-pw*Tax0);cc(kk2>=kk2_low)],kk,'linear');
    
    if max(max(abs(c1-c0)))<.0001
        break
    end
    c0=c1;
    
end

p2=p1;
pini=p2(1);

% % [M2_W a2_W]=feval('out_workers_Tax',[w1(1:100)' r1(1:100)'  zeros(100,1)
% % pw*Tax0*ones(100,1)],p2,M0_W/(1+g),T);

[a2_W M2_W c1_W c2_W]=feval('out_workers_simple3',[w_hist r_hist],p2,M0_W/(1+g),pw*Tax,c0);



p_nozlb(1)=p0;
pu(1,1)=p0;
M2(1,1)=M0_nu;

K2(1,1)=K0;
Z2(1,1)=Z0;
zlow2(1)=zlow0;
r2(1,1)=r0;
rr=r2(1);

w2=w1;
            
for iT=1:40
    
    Pa2(:,1)=Pa0;
    pp_Pa = pchip(z,Pa2(:,1));
    pp_Pa_1 = pp_Pa;
    pp_Pa_1.coefs = pp_Pa.coefs*Mder;
    
    PT2=(1-pw)*Pz;
    pp_PT = pchip(z,PT2);
    pp_PT_1 = pp_PT;
    pp_PT_1.coefs = pp_PT.coefs*Mder;
    
    pi = al*((1-al)/(w2(1)))^((1-al)/al);
    pp_Pa = pchip(z,Pa2(:,1));
    Y2(1,1)=Z2(1)*K2(1)^al*L^(1-al);
    
    rr=r2(1,1);
    M2(1,1)=M0_nu/(1+g);
    
    for t=1:T
        
        la=la_hist(t);
        la1=la_hist(t+1);
        
        if t==1
            C1(t,1)=C10;
        end
        
                    if t==1
                
                
                Taxnew(t,1)=((1+r2(t))*p0/pini-1)*B2(t,1);
                Tax(t,1)=Taxnew(t,1);
                
                sum_Tax_temp_all_2=quad('eq_sum_Tax_2',z(1),z(end));
                sum_Tax_temp_all=quad('eq_sum_Tax',z(1),z(end));
                C2(t,1)=(1-nu)*(1-bt)/(1-nu*(1-bt))*(quad('eqR3',z(1),z(end))-sum_Tax_temp_all_2);
                C1(t+1,1)=p2(t)/p2(t+1)*bt*nu*(1-bt)/(1-nu*(1-bt))*(quad('eqR3',z(1),z(end))-sum_Tax_temp_all_2);
                
                
                R0z2(2)=quad('eqR3',z(1),z(2));
                T_sum_temp(2)=quad('eq_sum_Tax',z(1),z(2));
                
                for i=3:N
                    R0z2(i)=R0z2(i-1)+quad('eqR3',z(i-1),z(i));
                    T_sum_temp(i)=T_sum_temp(i-1)+quad('eq_sum_Tax',z(i-1),z(i));
                end
                
            else
                
                Taxnew(t,1)=r2(t)*B2(t,1);
                
                sum_Tax_temp_all_2=quad('eq_sum_Tax_2',z(1),z(end));
                sum_Tax_temp_all=quad('eq_sum_Tax',z(1),z(end));
                C2(t,1)=(1-nu)*(1-bt)/(1-nu*(1-bt))*(quad('eqR',z(1),z(end))-sum_Tax_temp_all_2);
                C1(t+1,1)=p2(t)/p2(t+1)*bt*nu*(1-bt)/(1-nu*(1-bt))*(quad('eqR',z(1),z(end))-sum_Tax_temp_all_2);
                
                
                R0z2(2)=quad('eqR',z(1),z(2));
                T_sum_temp(2)=quad('eq_sum_Tax',z(1),z(2));
                
                for i=3:N
                    R0z2(i)=R0z2(i-1)+quad('eqR',z(i-1),z(i));
                    T_sum_temp(i)=T_sum_temp(i-1)+quad('eq_sum_Tax',z(i-1),z(i));
                end
                
            end
        
        A2(t+1,1)=bt*(R0z2(end)-(1-pw)*Tax(t))...
            +(1-bt)*sum_Tax_temp_all;
        
        B2(t+1,1)=B2(t,1);
        
        
        Pa2(1,t+1)=0; Pa2(N,t+1)=A2(t+1,1);
        
        T_temp=quad('eq_Tax',z(1),z(2));
        Pa2(2,t+1) = ga*(bt*(R0z2(2)-T_temp)+(1-bt)*T_sum_temp(2))...
            +(1-ga)*ppval(pp_Pz,z(2))*A2(t+1,1)...
            +(1-ga)*nu*(1-bt)*(T_sum_temp(2)...
            -ppval(pp_Pz,z(2))*sum_Tax_temp_all);
        
        for i=3:N-1
            T_temp=T_temp+quad('eq_Tax',z(i-1),z(i));
            Pa2(i,t+1) = ga*(bt*(R0z2(i)-T_temp)+(1-bt)*T_sum_temp(i))...
                +(1-ga)*ppval(pp_Pz,z(i))*A2(t+1,1)...
                +(1-ga)*nu*(1-bt)*(T_sum_temp(i)...
                -ppval(pp_Pz,z(i))*sum_Tax_temp_all);
        end
        
        pp_Pa1 = pchip(z,Pa2(:,t+1));
        pp_Pa1_1 = pp_Pa1;
        pp_Pa1_1.coefs = pp_Pa1.coefs*Mder;
        
        AA=A2(t+1,1);
        BB=B2(t+1,1);
        AA_W=a2_W(t+1);
        
        zlow2(t+1)=fminbnd('eqzhat_unc_B',z(1),z(end));
        K2(t+1,1)=la1*(AA-ppval(pp_Pa1,zlow2(t+1)));
        KK=K2(t+1,1);
        Ztemp=quad('eqZ',zlow2(t+1),z(end));
        Z2(t+1,1)=Ztemp^al;
        
        w2(t+1,1)=(1-al)*Z2(t+1)*K2(t+1)^al*L^(-al);
        Y2(t+1,1)=Z2(t+1,1)*K2(t+1,1)^al*L^(1-al);
        pi = al*((1-al)/(w2(t+1,1)))^((1-al)/al);
        r2(t+1,1)=pi*zlow2(t+1)-dd;
                
        rr=r2(t+1,1);
        zlb(t+1)=0;
        
        pp_Pa = pchip(z,Pa2(:,t+1));
        pp_Pa_1 = pp_Pa;
        pp_Pa_1.coefs = pp_Pa.coefs*Mder;
        
        M2(t+1,1)=(1+g)*M2(t);
        
        % calculate the unconstrained price level sequence
        pu(t,1)=M2(t+1)/(bt*(1-bt)*(quad('eqR',z(1),z(end))-sum_Tax_temp_all_2)...
            +bt*c2_W(t));
        
        
    end
    
    Taxnew(t+1,1)=Taxnew(t,1);
    
    
    clear rnu
    
    rnu(1,1)=r2(1);
    for t=2:T1
        rnu(t,1)=(1+r2(t))*pu(t)/pu(t-1)-1;
    end
    
    tmax=max(find(rnu<0));
    tmin=min(find(rnu<0));
    
    clear pc
    
    pc(tmax,1)=pu(tmax);
    for t=tmax-1:-1:1
        pc(t,1)=(1+r2(t+1))*pc(t+1);
    end
    
    if pc(1)>1
        break
    else
        p2N(1:tmax,1)=pc;
        p2N(tmax+1:length(pu),1)=pu(tmax+1:end,1);
    end
    
    p2N(length(pu)+1,1)=p2(end);

    [iT min(Tax-Taxnew) max(Tax-Taxnew) min(Tax) max(Tax) max(r2) p2(1) p2N(1)]
    
    if (max(abs(Tax-Taxnew))<0.0001)
        break
    end
    
    %         Tax_acum(:,iT)=Tax;
    %         K_acum(:,iT)=K2;
    %         B_acum(:,iT)=B2;
    
    update_T=1;
    updatep=.2;
    update_price=1;
    
    p2=updatep*p2N+(1-updatep)*p2;
    
    pini=p2(1);
    
    Tax= (1-update_T)*Tax+update_T*Taxnew;
    w_hist=(1-update_price)*w_hist+update_price*w2;
    r_hist=(1-update_price)*r_hist+update_price*r2;
    
    if bt*(1+r2(end))<1
        
        for i=1:100
            
            B=(1+r2(end))*bt*c0.^(-1);
            cc=B.^(-1);
            mm=nu/(1-nu)*c0/(1+r2(end));
            kk2=(cc+kk+mm-w2(end)+pw*Tax(end))/(1+r2(end));
            kk2_low=(cc(1)+kk(1)+mm(1)-w2(end)+pw*Tax(end))/(1+r2(end));
            c1=interp1([0;kk2(kk2>=kk2_low)],[(1-nu)/(1-nu*(1-bt))*(w2(end)-pw*Tax(end));cc(kk2>=kk2_low)],kk,'linear');
            
            if max(max(abs(c1-c0)))<.0001
                break
            end
            c0=c1;
            
        end
        
        % [M2_W a2_W]=feval('out_workers_Tax',[w2(1:100) r2(1:100)  zlb(1:100)' pw*Tax],p2,M0_W/(1+g),T);
        
        % for the cashless limit we replace M0_W/(1+g)=0, as we are using M for M/nu
                [a2_W M2_W c1_W c2_W]=feval('out_workers_simple3',[w_hist r_hist ],p2,M0_W/(1+g),pw*Tax,c0);
        
    end
    
    [Y2(1:5)-(K2(2:6)-(1-dd)*K2(1:5)) C1(1:5)+C2(1:5)+c1_W(1:5)+c2_W(1:5)]
    
end

Tax2=Tax;

save  lognormal_B_fixed_M_nominal_smooth_201902 Y2 Z2 K2 w2 p2 B2 Tax2 r2 Pa2 zlow2 Y1 Z1 K1 w1 p1 B1 Tax1 r1 Pa1 zlow1

figure(2)
tt=1:100;
subplot(2,2,1),plot(tt,Y1(tt)/Y1(1),tt,Y2(tt)./Y2(end))
axis([0 max(tt) .85 1.05])
title('output')
legend('indexed debt','nominal debt','Location','SouthEast')
subplot(2,2,2),plot(tt,Z1(tt)/Z1(1),tt,Z2(tt)/Z2(1))
axis([0 max(tt) .85 1.05])
title('TFP')
% w1=(1-al)*Z1.*K1.^al;
subplot(2,2,3),plot(tt,K1(tt)/K0,tt,K2(tt)/K0)
axis([0 max(tt) .85 1.05])
title('capital')
subplot(2,2,4),plot(tt,p1(tt),tt,p2(tt))
axis([0 max(tt) .8 1.05])
title('price index')

