clear all
close all

global al la la1 dd ga zmax L rr rr1 pi bt pp_Pz pp_Pz_1 pp_Pa pp_Pa_1 pp_Pa1 pp_Pa1_1 KK nu pp_PT pp_PT_1 Tax w_hist r_hist la_hist T t w0 r0 Tax0 kk AA BB AA_W p0 pini zlow0

% benchmark calibration
ga = .9^(1/4);
al =  1/3;
dd = 1-(1-0.07)^(1/4);
% la = 1/(1-.77);
% bt=0.99259;
% la = 2.85;
la=1/(1-.69); % bmk calibration
% la=1/(1-.59); % value for the sensitivity exercise
% la=1/(1-.79); % value for the sensitivity exercise
bt= 0.9865; % B/(4*Y)=0.62, th=0.69
% bt= 0.9826; % B/(4*Y)=0.62, th=0.59
% bt= 0.9898; % B/(4*Y)=0.62, th=0.79
L  = 1;
nu = 0; % share of income devoted to cash goods
pw=0.25; % fraction of workers in the population

N=40;
zmax=10;
sd=3.36;
mu=0;
% z(:,1)=[0;logspace(log(.01)/log(10),log(zmax)/log(10),N-1)'];
z(:,1)=linspace(0,zmax,N)';
Pz=logncdf(z,mu,sd)/logncdf(zmax,mu,sd);
pp_Pz = pchip(z,Pz);
Mder = diag(3:-1:1,1);
pp_Pz_1 = pp_Pz;
pp_Pz_1.coefs = pp_Pz.coefs*Mder;

% initializing the initial wealth
zlow=ppval(pp_Pz,1-1/la);
la1=la;
pp_Pa = pchip(z,Pz);
pp_Pa1 = pchip(z,Pz);
pp_Pa_1 = pp_Pa;
pp_Pa_1.coefs = pp_Pa.coefs*Mder;
pp_Pa1_1 = pp_Pa1;
pp_Pa1_1.coefs = pp_Pa1.coefs*Mder;
KK=1;
Ztemp=quad('eqZ',zlow,z(end));
Z=(Ztemp)^al;

K(1)=(al*Z*L^(1-al)/(1/bt-1+dd))^(1/(1-al));

w0=(1-al)*Z*K^al*L^(-al);
pi0 = al*((1-al)/w0)^((1-al)/al);
r0=pi0*zlow-dd;
K0=K;

rr=r0;
pi=pi0;

B0=24.5; % B/(4*Y)=0.62 (value on 2007Q2), th=0.69
% B0=22.8; % B/(4*Y)=0.62 (value on 2007Q2), th=0.59
% B0=26.3; % B/(4*Y)=0.62 (value on 2007Q2), th=0.79
Tax0=0;%0.005*B0;

% initializing wealth measures for the iteration that calculates the initial
% st st
pp_Pa = pchip(z,Pz*K0); % spline for today's wealth measure
pp_Pa1 = pchip(z,Pz*K0); % spline for tomorrow's wealth measure
pp_PT = pchip(z,(1-pw)*Pz); % spline for the cdf of tax shares

pp_Pa_1 = pp_Pa;
pp_Pa_1.coefs = pp_Pa.coefs*Mder;

pp_Pa1_1 = pp_Pa1;
pp_Pa1_1.coefs = pp_Pa1.coefs*Mder;

pp_PT_1 = pp_PT;
pp_PT_1.coefs = pp_PT.coefs*Mder;


T0=50; % number of periods for the simulation of the st st
T=100; % number of periods for the simulations of the transitions

% calculating initial steady state (the final steady state will be solved
% with the transition
la1=la;

% Solving for the st st. We assume that in the st st the ZLB is not
% binding.

for ir=1:800
    
    R0z(2)=quad('eqR',z(1),z(2));
    Tax_temp(2)=quad('eq_Tax_0',z(1),z(2));
    sum_Tax_temp(2)=quad('eq_sum_Tax_0',z(1),z(2));
    sum_Tax_temp0=quad('eq_sum_Tax_02',z(1),z(2));

    for i=3:N
        R0z(i)=R0z(i-1)+quad('eqR',z(i-1),z(i));
        Tax_temp(i)=Tax_temp(i-1)+quad('eq_Tax_0',z(i-1),z(i));
        sum_Tax_temp(i)=sum_Tax_temp(i-1)+quad('eq_sum_Tax_0',z(i-1),z(i));
        sum_Tax_temp0=sum_Tax_temp0+quad('eq_sum_Tax_02',z(i-1),z(i));
    end
    
    A(ir)=bt*(R0z(end)-Tax_temp(end))...
        +(1-bt)*sum_Tax_temp(end);
    
    for t=1:T0
        
        
        %         A(t+1)=bt*(quad('eqR',z(1),z(end))-quad('eq_Tax_0',z(1),z(end)))...
        %             +(1-bt)*quad('eq_sum_Tax_0',z(1),z(end));
        
        Pa(1,t+1)=0; Pa(N,t+1)=A(ir);
        
        
        Pa(2,t+1) = ga*(bt*(R0z(2)-Tax_temp(2))...
            +(1-bt)*sum_Tax_temp(2))...
            +(1-ga)*ppval(pp_Pz,z(2))*A(ir);
        
        for i=3:N-1
            
            Pa(i,t+1) = ga*(bt*(R0z(i)-Tax_temp(i))...
                +(1-bt)*sum_Tax_temp(i))...
                +(1-ga)*ppval(pp_Pz,z(i))*A(ir);
            
        end
        
        
        pp_Pa1 = pchip(z,Pa(:,t+1));
        pp_Pa1_1 = pp_Pa1;
        pp_Pa1_1.coefs = pp_Pa1.coefs*Mder;
        
        pp_Pa = pp_Pa1;
        pp_Pa_1 = pp_Pa;
        pp_Pa_1.coefs = pp_Pa.coefs*Mder;
        
    end
    
    AA_W=0;
    AA = A(ir);
    BB = B0;
    
    zlow=fminbnd('eqzhat_unc_B',z(1),z(end));
    %         zlow=fminunc('eqzhat_unc_B',zlow,options);
    K(ir)=la1*(AA-ppval(pp_Pa1,zlow));
    KK = K(ir);
    Ztemp=quad('eqZ',zlow,z(end));
    Z=(Ztemp)^al;
    Y=Z*K(ir)^al*L^(1-al);
    w=(1-al)*Z*K(ir)^al*L^(-al);
    r=(al*((1-al)/w)^((1-al)/al))*zlow-dd;
    
    %   pp_PT = pchip(z,Pa(:,end)/K(end));
    
    
    [ir Tax0 B0 w0 r0 w r K(end) A(end) B0/(4*Y)]
    
    %     C20=(1-bt)*(quad('eqR',z(1),z(end))-quad('eq_sum_Tax_02',z(1),z(end)));
    % checking that market clearing holds in the steady state
    % [Y0-dd*K0 C20+(w0-pw*Tax0)]
    
    % if max(abs(r-r0),abs(w-w0))<.00001 & ir>10
    if max([abs(r-r0) abs(w-w0) abs((K0-K(end))/K0)])<.00001 & ir>10
        break
    end
    
    K0=K(end);
    Z0=Z;
    Y0=Y;
    
    update=1;
    
    w0=update*w+(1-update)*w0;
    pi = al*((1-al)/w0)^((1-al)/al);
    r0=max(0.001,update*r+(1-update)*r0);
    rr=max(0.001,update*r+(1-update)*rr);
    
    p0=1;
    M0_W=p0*bt*nu/(1-nu*(1-bt))*(w(end)-pw*Tax0);
    M0_E=p0*nu*(1-bt)...
    *bt/(1-nu*(1-bt))*(R0z(end)...
    -sum_Tax_temp0);
M0=M0_E+M0_W;

    if ir<400
        Tax_1=.005*B0-.005*M0/p0;
    else
        Tax_1=r0*B0-.005*M0/p0;
    end
    
    Tax0=update*Tax_1+(1-update)*Tax0;
    
end

Tax0=.005*B0;

zlow0=zlow(end);
K0=K(end);
Y0=Y(end);
Z0=Z(end);

Pa0=Pa(:,end);

sum_Tax_temp0=quad('eq_sum_Tax_02',z(1),z(2));
for i=3:N
    sum_Tax_temp0=sum_Tax_temp0+quad('eq_sum_Tax_02',z(i-1),z(i));
end

% rate of growth of money
% g=0.00;
% g=0.0025;
g=0.005;

C20=(1-nu)*(1-bt)/(1-nu*(1-bt))*(R0z(end)-sum_Tax_temp0);
C10=1/(1+g)*bt*nu/(1-nu)*C20;
% checking that market clearing holds in the steady state
[Y0-dd*K0 C10+C20+(w0-pw*Tax0)]


p0=1;
M0_W=p0*bt*nu/(1-nu*(1-bt))*(w(end)-pw*Tax0);
M0_E=p0*nu*(1-bt)...
    *bt/(1-nu*(1-bt))*(R0z(end)...
    -sum_Tax_temp0);
M0=M0_E+M0_W;

M0_W_nu=p0*bt*(w(end)-pw*Tax0);
M0_E_nu=p0*(1-bt)...
    *bt*(R0z(end)...
    -sum_Tax_temp0);
M0_nu=M0_E_nu+M0_W_nu;


save lognormal_B0_nu0_201609.mat zlow0 K0 Y0 Z0 w0 r0 Tax0 B0 Pa0 p0 M0 M0_W M0_E C10 C20 pi rr Pa0 M0_nu M0_W_nu M0_E_nu
