/*

This file produces Table A5 in the Appendix.

*/

use "W:\Data\final_data.dta", clear
 set matsize 2999
 
* defines treatment status
gen tr2=1 if ownership>0.30&ownership<=0.50&no_firms==1
replace tr2=0 if ownership>0.50&ownership<=0.8&no_firms==1

foreach var of varlist palkkakulu konekalu tvlarvopaperi kuluera1 kokotulo lpalkat osinko male ika liikevaihto varatyht velkayht opoyht henklkm_r {
replace `var'=0 if `var'==. & (tr2==0|tr2==1)
}

* log wage sum
gen lpalkkakulu=log(palkkakulu)
* log variable costs
gen lkuluera1=log(kuluera1)
* log number of employees
gen lhenklkm_r=log(henklkm_r)

* Post period
gen post=1 if vuosi>2010
replace post=0 if vuosi>2005&vuosi<2011

* round ownershipshare 
 gen wnrsp=round(ownership, 0.01)
 by ID, sort: egen min_ownrsp=min(wnrsp)

* log investments 
 gen lkonekalu=log(konekalu)

 foreach var of varlist llv lkuluera1 lpalkkakulu lnettoeltulos lkokotulo llpalkat ltvlyht ltvlarvopaperi lkonekalu lopoyht lhenklkm_r{
 gen miss_d_`var'=1 if `var'==0 | `var'==.
 replace miss_d_`var'=0 if miss_d_`var'==.
 replace `var'=0 if `var'==.
 }

 * Municipality code
 gen KUNTANRO=kuntanro
 destring KUNTANRO, replace force
 by ID, sort: egen KuntaNro=min(KUNTANRO)
 
* industry codes
 gen eka_tala=substr(talakoodi, 1,1)
 destring eka_tala, replace
 by ID, sort: egen Eka_tala=min(eka_tala)
 
* Heterogeneity by age of the firm -- by young (5 years) vs old
by yritys_id, sort: egen minimi_vuosi=min(vuosi)
gen age_firm=vuosi-minimi_vuosi
by yritys_id, sort: egen AGE=max(age_firm)
gen young=1 if tr2!=. & AGE<=5
by yritys_id, sort: egen Young=min(young)
gen old=1 if tr2!=. & AGE>5
by yritys_id, sort: egen Old=min(old)
replace Young=0 if tr2!=. & Old==1
replace Young=2 if tr2!=. & Young==.
replace young=0 if tr2!=. & AGE>5

*****
****
***
**
*
* Table A5 - all - robust with larger control group 51-80% ownership share
* no controls
xi: reg lvvakmaksut i.vuosi i.post*i.tr2, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_control_group_51_80.xls", replace
xi: reg llv i.vuosi i.post*i.tr2, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_control_group_51_80.xls", append
xi: reg lpalkkakulu i.vuosi i.post*i.tr2, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_control_group_51_80.xls", append
xi: reg lkonekalu i.vuosi i.post*i.tr2, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_control_group_51_80.xls", append
xi: reg ltvlarvopaperi i.vuosi i.post*i.tr2, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_control_group_51_80.xls", append
xi: reg lkuluera1 i.vuosi i.post*i.tr2, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_control_group_51_80.xls", append
xi: reg lhenklkm_r i.vuosi i.post*i.tr2, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_control_group_51_80.xls", append


* Table A5 - Young
* no controls
xi: reg lvvakmaksut i.vuosi i.post*i.tr2 if Young==1, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_young_control_group_51_80.xls", replace
xi: reg llv i.vuosi i.post*i.tr2 if Young==1, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_young_control_group_51_80.xls", append
xi: reg lpalkkakulu i.vuosi i.post*i.tr2 if Young==1, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_young_control_group_51_80.xls", append
xi: reg lkonekalu i.vuosi i.post*i.tr2 if Young==1, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_young_control_group_51_80.xls", append
xi: reg ltvlarvopaperi i.vuosi i.post*i.tr2 if Young==1, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_young_control_group_51_80.xls", append
xi: reg lkuluera1 i.vuosi i.post*i.tr2 if Young==1, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_young_control_group_51_80.xls", append
xi: reg lhenklkm_r i.vuosi i.post*i.tr2 if Young==1, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_young_control_group_51_80.xls", append


* Table A5 - Old
* no controls
xi: reg lvvakmaksut i.vuosi i.post*i.tr2 if Young==0, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_old_control_group_51_80.xls", replace
xi: reg llv i.vuosi i.post*i.tr2 if Young==0, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_old_control_group_51_80.xls", append
xi: reg lpalkkakulu i.vuosi i.post*i.tr2 if Young==0, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_old_control_group_51_80.xls", append
xi: reg lkonekalu i.vuosi i.post*i.tr2 if Young==0, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_old_control_group_51_80.xls", append
xi: reg ltvlarvopaperi i.vuosi i.post*i.tr2 if Young==0, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_old_control_group_51_80.xls", append
xi: reg lkuluera1 i.vuosi i.post*i.tr2 if Young==0, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_old_control_group_51_80.xls", append
xi: reg lhenklkm_r i.vuosi i.post*i.tr2 if Young==0, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_old_control_group_51_80.xls", append


