/*

This file plots Figure A6 in the Appendix.

*/

use "W:\Data\final_data.dta", clear
set matsize 2999
 
* define treatment status
gen tr2=1 if ownership>0.30&ownership<=0.50&no_firms==1
replace tr2=0 if ownership>0.50&ownership<=0.7&no_firms==1

foreach var of varlist palkkakulu konekalu tvlarvopaperi kuluera1 kokotulo lpalkat osinko male ika liikevaihto varatyht velkayht opoyht henklkm_r {
replace `var'=0 if `var'==. & (tr2==0|tr2==1)
}

* log wage sum
gen lpalkkakulu=log(palkkakulu)
* log variable costs
gen lkuluera1=log(kuluera1)
* log number of employees
gen lhenklkm_r=log(henklkm_r)

* Post period
gen post=1 if vuosi>2010
replace post=0 if vuosi>2005&vuosi<2011

* round ownershipshare 
 gen wnrsp=round(ownership, 0.01)
 by ID, sort: egen min_ownrsp=min(wnrsp)

* log investments 
 gen lkonekalu=log(konekalu)

 foreach var of varlist llv lkuluera1 lpalkkakulu lnettoeltulos lkokotulo llpalkat ltvlyht ltvlarvopaperi lkonekalu lopoyht lhenklkm_r{
 gen miss_d_`var'=1 if `var'==0 | `var'==.
 replace miss_d_`var'=0 if miss_d_`var'==.
 replace `var'=0 if `var'==.
 }
 
by yritys_id, sort: egen minimi_vuosi=min(vuosi)
gen age_firm=vuosi-minimi_vuosi
by yritys_id, sort: egen AGE=max(age_firm)

*********************
***************
********
* Heterogeneity by firm age
gen age_groups=1 if tr2!=. & AGE<3
replace age_groups=2 if tr2!=. & AGE>2&AGE<6
replace age_groups=3 if tr2!=. & AGE>5&AGE<9
replace age_groups=4 if tr2!=. & AGE>8&AGE<=10
replace age_groups=5 if tr2!=. & AGE>10
gen dd=post*tr2
* testing
xi: reg llv i.dd*i.age_groups i.post*i.age_groups i.tr2*i.age_groups 

gen eff=.
gen effu=.
gen effl=.
gen nro=_n
label define NRO 1 "0-2" 2 "3-5" 3 "6-8" 4 "9-10" 5 ">10", replace
label val nro NRO
gen nolla=0

* sales
xi: reg llv i.dd*i.age_groups i.post*i.age_groups i.tr2*i.age_groups 
lincom _Idd_1 
replace eff=r(estimate) in 1
replace effu=r(estimate)+1.96*r(se) in 1
replace effl=r(estimate)-1.96*r(se) in 1
forvalues i = 2(1)5{
qui{
local c=`i'
lincom _Idd_1  + _IddXage_1_`i'
replace eff=r(estimate) in `c'
replace effu=r(estimate)+1.96*r(se) in `c'
replace effl=r(estimate)-1.96*r(se) in `c'
}
}
scatter eff nro if nro<6 || rcap effl effu nro if nro<6 || line nolla nro if nro<6, lp(solid) lc(black) graphr(c(white)) scheme(s2mono)/*
*/ note("") xlabel(1(1)6) xtitle("") ytitle("") legend(off) subtitle(Sales) xlabel(none) xtick(1(1)5) ylabel(-.2(0.2)0.4) name(dd_sales, replace)

* variable costs
xi: reg lpalkkakulu i.dd*i.age_groups i.post*i.age_groups i.tr2*i.age_groups 
lincom _Idd_1 
replace eff=r(estimate) in 1
replace effu=r(estimate)+1.96*r(se) in 1
replace effl=r(estimate)-1.96*r(se) in 1
forvalues i = 2(1)5{
qui{
local c=`i'
lincom _Idd_1  + _IddXage_1_`i'
replace eff=r(estimate) in `c'
replace effu=r(estimate)+1.96*r(se) in `c'
replace effl=r(estimate)-1.96*r(se) in `c'
}
}
scatter eff nro if nro<6 || rcap effl effu nro if nro<6 || line nolla nro if nro<6, lp(solid) lc(black) graphr(c(white)) scheme(s2mono)/*
*/ note("") xlabel(1(1)6) xtitle("") ytitle("") legend(off) subtitle("Labor costs") xlabel(none) xtick(1(1)5) ylabel(-.2(0.2)0.4) name(dd_labcosts, replace)

* investments in machines etc.
xi: reg lkonekalu i.dd*i.age_groups i.post*i.age_groups i.tr2*i.age_groups 
lincom _Idd_1 
replace eff=r(estimate) in 1
replace effu=r(estimate)+1.96*r(se) in 1
replace effl=r(estimate)-1.96*r(se) in 1
forvalues i = 2(1)5{
qui{
local c=`i'
lincom _Idd_1  + _IddXage_1_`i'
replace eff=r(estimate) in `c'
replace effu=r(estimate)+1.96*r(se) in `c'
replace effl=r(estimate)-1.96*r(se) in `c'
}
}
scatter eff nro if nro<6 || rcap effl effu nro if nro<6 || line nolla nro if nro<6, lp(solid) lc(black) graphr(c(white)) scheme(s2mono)/*
*/ note("") xlabel(1(1)6) xtitle("Firm age groups in years") ytitle("") legend(off) subtitle("Investments in machines and equipment") xlabel(1(1)5, valuelabel) ylabel(-.2(0.2)0.4) name(dd_machines, replace)

* stock holdings
xi: reg ltvlarvopaperi i.dd*i.age_groups i.post*i.age_groups i.tr2*i.age_groups 
lincom _Idd_1 
replace eff=r(estimate) in 1
replace effu=r(estimate)+1.96*r(se) in 1
replace effl=r(estimate)-1.96*r(se) in 1
forvalues i = 2(1)5{
qui{
local c=`i'
lincom _Idd_1  + _IddXage_1_`i'
replace eff=r(estimate) in `c'
replace effu=r(estimate)+1.96*r(se) in `c'
replace effl=r(estimate)-1.96*r(se) in `c'
}
}
scatter eff nro if nro<6 || rcap effl effu nro if nro<6 || line nolla nro if nro<6, lp(solid) lc(black) graphr(c(white)) scheme(s2mono)/*
*/ note("") xlabel(1(1)5) xtitle("Firm age groups in years") ytitle("") legend(off) subtitle("Stock holdings") xlabel(1(1)5, valuelabel) ylabel(-.2(0.2)0.4) name(dd_stock, replace)

graph combine dd_sales dd_labcosts dd_machines dd_stock, graphr(c(white)) scheme(s2mono) subtitle(Responses by firm age groups)
graph export "W:\Kuvat\Final\responses_firm_age_groups.png", replace width(1600) height(1200)
graph export "W:\Kuvat\Final\responses_firm_age_groups.eps", replace

