******************************************************
******************************************************

*	This program generates the main figures and
*	tables. It takes the data generated in SAS. 

******************************************************
******************************************************

set more off
set memory 500m
set matsize 2000

log using LOG_FILE_PATH\FINAL_DATA_PROGRAM.log, replace
import delimited DATA_FILE_PATH\FINAL_PROGRAM.csv

keep	e 		wages 		capital2	contracts_paid 	el_increase 	rate 		tot_revs	elpre        	///
	tot_ass 	tot_liabilities mne 		royalty_cost	tyear 		firmid 		ty_lag  	naics5		///
	ki_mean_med 	ki_mean 	keep_firmid 	physicali 	dtax3 		tao1 		ditc

sort  firmid tyear
xtset firmid tyear		
								
gen tot = 1
egen int_obs = total(tot), by(firmid)
									
drop if ty_lag == . | rate == . | tot_revs == . | tot_ass == . | tot_liabilities == . | mne == . | royalty_cost == .
keep if 1 < keep_firmid

gen naics541	= (54100 <= naics5 & naics5 < 54200)

******************************************************

gen pp = (2004 <= tyear)
gen eligiblenow	= el_increase
gen treatednow	= eligiblenow*pp

*	Outcome variables
replace e				= 0 if e == .
replace capital2		= 0 if capital2 == .
replace wages			= 0 if wages == .
replace contracts_paid	= 0 if contracts_paid == .
replace physicali = 0 if physicali == .

******************************************************
******************************************************
*	Exogenous variables

*	Express these variables in millions of dollars
*	for the summary statistics

gen tot_revs2 			= tot_revs / 1000000
gen tot_ass2  			= tot_ass / 1000000 
gen tot_liabilities2 	= tot_liabilities / 1000000

*	Log RHS variables

replace	rate			= log(max(.01,rate))
replace tot_revs 		= log(max(1,tot_revs))
replace tot_ass			= log(max(1,tot_ass))
replace tot_liabilities	= log(max(1,tot_liabilities))
replace mne				= log(max(1,mne))
replace royalty_cost	= log(max(1,royalty_cost))

******************************************************
******************************************************
*	Create 3-digit NAICS-year FE

gen _2000 = (tyear == 2000)
gen _2001 = (tyear == 2001)
gen _2002 = (tyear == 2002)
gen _2003 = (tyear == 2003)
gen _2004 = (tyear == 2004)
gen _2005 = (tyear == 2005)
gen _2006 = (tyear == 2006)
gen _2007 = (tyear == 2007)

gen naics1 = floor(naics5 / 100)

*	Aggregate 3-digit naics to allow XTPQML
*	algorithm to converge. Need to make categories
*	thicker.

replace naics1 = 113 if naics1 == 114
replace naics1 = 213 if naics1 == 211
replace naics1 = 213 if naics1 == 212
replace naics1 = 312 if naics1 == 316
replace naics1 = 322 if naics1 == 324
replace naics1 = 415 if naics1 == 411
replace naics1 = 415 if naics1 == 412
replace naics1 = 448 if naics1 == 441
replace naics1 = 448 if naics1 == 442
replace naics1 = 448 if naics1 == 445
replace naics1 = 448 if naics1 == 446
replace naics1 = 454 if naics1 == 451
replace naics1 = 454 if naics1 == 452
replace naics1 = 488 if naics1 == 481
replace naics1 = 488 if naics1 == 484
replace naics1 = 488 if naics1 == 492
replace naics1 = 488 if naics1 == 493
replace naics1 = 519 if naics1 == 515
replace naics1 = 519 if naics1 == 516
replace naics1 = 522 if naics1 == 524
replace naics1 = 532 if naics1 == 531
replace naics1 = 532 if naics1 == 533
replace naics1 = 621 if naics1 == 623
replace naics1 = 621 if naics1 == 624
replace naics1 = 713 if naics1 == 711
replace naics1 = 722 if naics1 == 721
replace naics1 = 813 if naics1 == 812
replace naics1 = 0   if naics1 == 911
replace naics1 = 0   if naics1 == 221

******************************************************
******************************************************
*	Figure 2: UNBALANCED sample
******************************************************
******************************************************

preserve

gen h = eligiblenow * (2003 < tyear)
xi: xtpqml e h eligiblenow rate tot_revs tot_ass tot_liabilities mne royalty_cost i.tyear, fe
gen esample = e(sample)
drop h
keep if esample == 1

replace ty_lag	= ty_lag / 1000
replace e	= e / 1000

*	Figures with R&D residuals

xi: areg e i.tyear, absorb(firmid)
predict resid, resid

sort ty_lag

*	Deg(3) BW(50)

lpoly resid ty_lag if tyear <= 2003 & ty_lag <= 1500, deg(3) bw(50)	at(ty_lag) gen(prebw50d3) se(presebw50d3) nograph
lpoly resid ty_lag if 2004 <= tyear & ty_lag <= 1500, deg(3) bw(50)	at(ty_lag) gen(postbw50d3) se(postsebw50d3) nograph

gen prepos = prebw50d3 + 1.96*presebw50d3
gen preneg = prebw50d3 - 1.96*presebw50d3

gen postpos = postbw50d3 + 1.96*postsebw50d3
gen postneg = postbw50d3 - 1.96*postsebw50d3

twoway																																												///
(line prebw50d3 ty_lag, lpattern(solid) lcolor(black) ylabel(,nogrid) xtitle(" " "Lagged Taxable Income ($1,000)") ytitle("Mean Residual R&D ($1,000)") graphregion(fcolor(white))) ///
(line prepos ty_lag, lpattern(shortdash) lcolor(gray) alwidth(thin)) 																												///
(line preneg ty_lag, lpattern(shortdash) lcolor(gray) alwidth(thin)) 																												///
(line postbw50d3 ty_lag, lpattern(longdash) lcolor(black)) 																															///
(line postpos ty_lag, lpattern(shortdash) lcolor(gray) alwidth(thin)) 																												///
(line postneg ty_lag, lpattern(shortdash) lcolor(gray) alwidth(thin)) if ty_lag <= 400, legend(order(1 "Pre-policy" 4 "Post-policy"))
graph export     "FIGURE_FILE_PATH\FINAL_RESULTS_PROGRAM_Fig2.png", replace
graph export     "FIGURE_FILE_PATH\FINAL_RESULTS_PROGRAM_Fig2.ps",  replace
graph export     "FIGURE_FILE_PATH\FINAL_RESULTS_PROGRAM_Fig2.eps", replace
graph save Graph "FIGURE_FILE_PATH\FINAL_RESULTS_PROGRAM_Fig2.gph"

restore

******************************************************
******************************************************
*	TABLE 1: UNBALANCED sample
******************************************************
******************************************************
preserve

xi: xtpqml e eligiblenow treatednow rate tot_revs tot_ass tot_liabilities mne royalty_cost i.tyear, fe
gen _sample = e(sample)
keep if _sample == 1

gen e_id = (e != . & 0 < e)
gen dtax3_id  = (dtax3 <= 0)
gen tao1_id	  = (tao1 <= 0)
gen ez		  = eligiblenow * dtax3_id
gen pre_capital2 = .
replace pre_capital2 = capital2 if tyear <= 2003
gen ditc2 = max(0,ditc)

tabstat e_id e wages contracts_paid capital2 physicali eligiblenow treatednow ditc ditc2 dtax3 tao1 dtax3_id tao1_id ez tot_revs2 pre_capital2 tot_ass2 tot_liabilities2, stat(mean sd min max)

restore

******************************************************
******************************************************
*	TABLE 2: UNBALANCED sample
******************************************************
******************************************************

*	Total R&D: Column 1
xtpqml e eligiblenow treatednow pp, fe
predict y2, xb
replace y2 = y2^2
gen exb			= exp(y2^0.5)
egen meany		= mean(e) if y2 !=., by(firmid)
egen meanexb	= mean(exb), by(firmid)
gen efe			= meany/meanexb
gen yhat 		= (efe*exb)
qui cor e yhat
di as txt " R-squared   "  (`r(rho)')^2
gen e2 			= (e-yhat)^2
gen lyhat 		= ln(efe*exb)
gen _sample 	= e(sample)

tabstat e if _sample == 1, stat(mean sd min max n)
drop y2 exb meany meanexb efe yhat e2 lyhat _sample


*	Total R&D: Column 2
xi: xtpqml e              eligiblenow treatednow                                                        i.naics1*i._2000 i.naics1*i._2001 i.naics1*i._2002 i.naics1*i._2003 i.naics1*i._2004 i.naics1*i._2005 i.naics1*i._2006 i.naics1*i._2007, fe
predict y2, xb
replace y2 = y2^2
gen exb			= exp(y2^0.5)
egen meany		= mean(e) if y2 !=., by(firmid)
egen meanexb	= mean(exb), by(firmid)
gen efe			= meany/meanexb
gen yhat 		= (efe*exb)
qui cor e yhat
di as txt " R-squared   "  (`r(rho)')^2
gen e2 			= (e-yhat)^2
gen lyhat 		= ln(efe*exb)
gen _sample 	= e(sample)

tabstat e if _sample == 1, stat(mean sd min max n)
drop y2 exb meany meanexb efe yhat e2 lyhat _sample

*	Columns 3-6
local depvar_set "e wages contracts_paid physicali"
foreach depvar in `depvar_set' {

xi: xtpqml `depvar'	eligiblenow treatednow rate tot_revs tot_ass tot_liabilities mne royalty_cost i.naics1*i._2000 i.naics1*i._2001 i.naics1*i._2002 i.naics1*i._2003 i.naics1*i._2004 i.naics1*i._2005 i.naics1*i._2006 i.naics1*i._2007, fe
predict y2, xb
replace y2 = y2^2
gen exb			= exp(y2^0.5)
egen meany		= mean(e) if y2 !=., by(firmid)
egen meanexb	= mean(exb), by(firmid)
gen efe			= meany/meanexb
gen yhat 		= (efe*exb)
qui cor e yhat
di as txt " R-squared   "  (`r(rho)')^2
gen e2 			= (e-yhat)^2
gen lyhat 		= ln(efe*exb)
gen _sample 	= e(sample)

tabstat `depvar' if _sample == 1, stat(mean sd min max n)
drop y2 exb meany meanexb efe yhat e2 lyhat _sample

}

******************************************************
******************************************************
*	TABLE 3: UNBALANCED sample
******************************************************
******************************************************

*	Create leads and lags

gen t_2000 = eligiblenow * (tyear == 2000)
gen t_2001 = eligiblenow * (tyear == 2001)
gen t_2002 = eligiblenow * (tyear == 2002)
gen t_2003 = eligiblenow * (tyear == 2003)
gen t_2004 = eligiblenow * (tyear == 2004)
gen t_2005 = eligiblenow * (tyear == 2005)
gen t_2006 = eligiblenow * (tyear == 2006)
gen t_2007 = eligiblenow * (tyear == 2007)

*	Columns 1-3

local depvar_set "e wages contracts_paid"
foreach depvar in `depvar_set' {

xi: xtpqml `depvar' t_2000 t_2001 t_2002 t_2003 t_2004 t_2005 t_2006 t_2007 rate tot_revs tot_ass tot_liabilities mne royalty_cost i.naics1*i._2000 i.naics1*i._2001 i.naics1*i._2002 i.naics1*i._2003 i.naics1*i._2004 i.naics1*i._2005 i.naics1*i._2006 i.naics1*i._2007, fe
predict y2, xb
test (t_2000 = 0)  (t_2001 = 0)  (t_2002 = 0)  (t_2003 = 0) 
replace y2 = y2^2
gen exb			= exp(y2^0.5)
egen meany		= mean(e) if y2 !=., by(firmid)
egen meanexb	= mean(exb), by(firmid)
gen efe			= meany/meanexb
gen yhat 		= (efe*exb)
qui cor e yhat
di as txt " R-squared   "  (`r(rho)')^2
gen e2 			= (e-yhat)^2
gen lyhat 		= ln(efe*exb)
gen _sample 	= e(sample)

tabstat `depvar' if _sample == 1, stat(mean sd min max n)
drop y2 exb meany meanexb efe yhat e2 lyhat _sample

}

drop t_2000 t_2001 t_2002 t_2003 t_2004 t_2005 t_2006 t_2007

******************************************************
******************************************************
*	TABLE 4: UNBALANCED sample
******************************************************
******************************************************

*	Create tax exhaustion and triple-diff variables.
*	Then estimate related regressions: Columns 1-3

gen h  = (dtax3 <= 0)
gen f1 = eligiblenow * pp * h
gen f2 = pp * h
gen f3 = eligiblenow * h
gen f4 = eligiblenow * pp
gen f5 = eligiblenow
gen f6 = h

local depvar_set "e wages contracts_paid"
foreach depvar in `depvar_set' {

xi: xtpqml `depvar' f1 f2 f3 f4 f5 f6 rate tot_revs tot_ass tot_liabilities mne royalty_cost i.naics1*i._2000 i.naics1*i._2001 i.naics1*i._2002 i.naics1*i._2003 i.naics1*i._2004 i.naics1*i._2005 i.naics1*i._2006 i.naics1*i._2007, fe
predict y2, xb
replace y2 = y2^2
gen exb			= exp(y2^0.5)
egen meany		= mean(e) if y2 !=., by(firmid)
egen meanexb	= mean(exb), by(firmid)
gen efe			= meany/meanexb
gen yhat 		= (efe*exb)
qui cor e yhat
di as txt " R-squared   "  (`r(rho)')^2
gen e2 			= (e-yhat)^2
gen lyhat 		= ln(efe*exb)
gen _sample 	= e(sample)

tabstat `depvar' if _sample == 1, stat(mean sd min max n)
drop y2 exb meany meanexb efe yhat e2 lyhat _sample

}

drop h f1-f6

*	Create pre-2004 R&D capital purchase and triple-diff variables.
*	Then estimate related regressions: Columns 4-6

gen h = (ki_mean_med < ki_mean)
gen f1 = eligiblenow * pp * h
gen f2 = pp * h
gen f3 = eligiblenow * h
gen f4 = eligiblenow * pp
gen f5 = eligiblenow
gen f6 = h

local depvar_set "e wages contracts_paid"
foreach depvar in `depvar_set' {

xi: xtpqml `depvar' f1 f2 f3 f4 f5 f6 rate tot_revs tot_ass tot_liabilities mne royalty_cost i.naics1*i._2000 i.naics1*i._2001 i.naics1*i._2002 i.naics1*i._2003 i.naics1*i._2004 i.naics1*i._2005 i.naics1*i._2006 i.naics1*i._2007 if naics541 == 0, fe
predict y2, xb
replace y2 = y2^2
gen exb			= exp(y2^0.5)
egen meany		= mean(e) if y2 !=., by(firmid)
egen meanexb	= mean(exb), by(firmid)
gen efe			= meany/meanexb
gen yhat 		= (efe*exb)
qui cor e yhat
di as txt " R-squared   "  (`r(rho)')^2
gen e2 			= (e-yhat)^2
gen lyhat 		= ln(efe*exb)
gen _sample 	= e(sample)

tabstat `depvar' if _sample == 1, stat(mean sd min max n)
drop y2 exb meany meanexb efe yhat e2 lyhat _sample

}

drop h f1-f6

******************************************************
******************************************************
*	TABLE 5
******************************************************
******************************************************

*	No empirical work with STATA needed.

******************************************************
******************************************************
*	TABLE B-1: UNBALANCED sample
******************************************************
******************************************************

*	No empirical work with STATA needed.

******************************************************
******************************************************
*	TABLE B-2: UNBALANCED sample
******************************************************
******************************************************

preserve

keep if int_obs == 8

*	Total R&D: Column 1
xtpqml e eligiblenow treatednow pp, fe
predict y2, xb
replace y2 = y2^2
gen exb			= exp(y2^0.5)
egen meany		= mean(e) if y2 !=., by(firmid)
egen meanexb	= mean(exb), by(firmid)
gen efe			= meany/meanexb
gen yhat 		= (efe*exb)
qui cor e yhat
di as txt " R-squared   "  (`r(rho)')^2
gen e2 			= (e-yhat)^2
gen lyhat 		= ln(efe*exb)
gen _sample 	= e(sample)

tabstat e if _sample == 1, stat(mean sd min max n)
drop y2 exb meany meanexb efe yhat e2 lyhat _sample

*	Total R&D: Column 2
xi: xtpqml e              eligiblenow treatednow                                                        i.tyear, fe
predict y2, xb
replace y2 = y2^2
gen exb			= exp(y2^0.5)
egen meany		= mean(e) if y2 !=., by(firmid)
egen meanexb	= mean(exb), by(firmid)
gen efe			= meany/meanexb
gen yhat 		= (efe*exb)
qui cor e yhat
di as txt " R-squared   "  (`r(rho)')^2
gen e2 			= (e-yhat)^2
gen lyhat 		= ln(efe*exb)
gen _sample 	= e(sample)

tabstat e if _sample == 1, stat(mean sd min max n)
drop y2 exb meany meanexb efe yhat e2 lyhat _sample

*	Columns 3-6
local depvar_set "e wages contracts_paid physicali"
foreach depvar in `depvar_set' {

xi: xtpqml `depvar'		eligiblenow treatednow rate tot_revs tot_ass tot_liabilities mne royalty_cost i.tyear, fe
predict y2, xb
replace y2 = y2^2
gen exb			= exp(y2^0.5)
egen meany		= mean(e) if y2 !=., by(firmid)
egen meanexb	= mean(exb), by(firmid)
gen efe			= meany/meanexb
gen yhat 		= (efe*exb)
qui cor e yhat
di as txt " R-squared   "  (`r(rho)')^2
gen e2 			= (e-yhat)^2
gen lyhat 		= ln(efe*exb)
gen _sample 	= e(sample)

tabstat `depvar' if _sample == 1, stat(mean sd min max n)
drop y2 exb meany meanexb efe yhat e2 lyhat _sample

}

restore

******************************************************
******************************************************
*	TABLE B-3: BALANCED sample
******************************************************
******************************************************

preserve

drop if elpre < e

*	Column 1
xi: xtpqml e eligiblenow treatednow                                                               i.naics1*i._2000 i.naics1*i._2001 i.naics1*i._2002 i.naics1*i._2003 i.naics1*i._2004 i.naics1*i._2005 i.naics1*i._2006 i.naics1*i._2007, fe
predict y2, xb
replace y2 = y2^2
gen exb			= exp(y2^0.5)
egen meany		= mean(e) if y2 !=., by(firmid)
egen meanexb	= mean(exb), by(firmid)
gen efe			= meany/meanexb
gen yhat 		= (efe*exb)
qui cor e yhat
di as txt " R-squared   "  (`r(rho)')^2
gen e2 			= (e-yhat)^2
gen lyhat 		= ln(efe*exb)
gen _sample 	= e(sample)

tabstat e if _sample == 1, stat(mean sd min max n)
drop y2 exb meany meanexb efe yhat e2 lyhat _sample

*	Columns 2-4
local depvar_set "e wages contracts_paid"
foreach depvar in `depvar_set' {

xi: xtpqml `depvar'	eligiblenow treatednow rate tot_revs tot_ass tot_liabilities mne royalty_cost i.naics1*i._2000 i.naics1*i._2001 i.naics1*i._2002 i.naics1*i._2003 i.naics1*i._2004 i.naics1*i._2005 i.naics1*i._2006 i.naics1*i._2007, fe
predict y2, xb
replace y2 = y2^2
gen exb			= exp(y2^0.5)
egen meany		= mean(e) if y2 !=., by(firmid)
egen meanexb	= mean(exb), by(firmid)
gen efe			= meany/meanexb
gen yhat 		= (efe*exb)
qui cor e yhat
di as txt " R-squared   "  (`r(rho)')^2
gen e2 			= (e-yhat)^2
gen lyhat 		= ln(efe*exb)
gen _sample 	= e(sample)

tabstat `depvar' if _sample == 1, stat(mean sd min max n)
drop y2 exb meany meanexb efe yhat e2 lyhat _sample

}

restore

******************************************************
******************************************************
*	TABLE B-4: UNBALANCED sample
******************************************************
******************************************************

preserve

keep if int_obs == 8

*	Create tax exhaustion and triple-diff variable 

gen h  = (dtax3 <= 0)
gen f1 = eligiblenow * pp * h
gen f2 = pp * h
gen f3 = eligiblenow * h
gen f4 = eligiblenow * pp
gen f5 = eligiblenow
gen f6 = h

*	Column 1-3
local depvar_set "e wages contracts_paid"
foreach depvar in `depvar_set' {

xi: xtpqml `depvar' f1 f2 f3 f4 f5 f6 rate tot_revs tot_ass tot_liabilities mne royalty_cost i.tyear, fe
predict y2, xb
replace y2 = y2^2
gen exb			= exp(y2^0.5)
egen meany		= mean(e) if y2 !=., by(firmid)
egen meanexb	= mean(exb), by(firmid)
gen efe			= meany/meanexb
gen yhat 		= (efe*exb)
qui cor e yhat
di as txt " R-squared   "  (`r(rho)')^2
gen e2 			= (e-yhat)^2
gen lyhat 		= ln(efe*exb)
gen _sample 	= e(sample)

tabstat `depvar' if _sample == 1, stat(mean sd min max n)
drop y2 exb meany meanexb efe yhat e2 lyhat _sample

}
drop h f1-f6


*	Create pre-2004 R&D capital purchase and other triple-diff variables

gen h = (ki_mean_med < ki_mean)
gen f1 = eligiblenow * pp * h
gen f2 = pp * h
gen f3 = eligiblenow * h
gen f4 = eligiblenow * pp
gen f5 = eligiblenow
gen f6 = h

*	Columns 4-6
local depvar_set "e wages contracts_paid"
foreach depvar in `depvar_set' {

xi: xtpqml `depvar' f1 f2 f3 f4 f5 f6 rate tot_revs tot_ass tot_liabilities mne royalty_cost i.tyear if naics541 == 0, fe
predict y2, xb
replace y2 = y2^2
gen exb			= exp(y2^0.5)
egen meany		= mean(e) if y2 !=., by(firmid)
egen meanexb	= mean(exb), by(firmid)
gen efe			= meany/meanexb
gen yhat 		= (efe*exb)
qui cor e yhat
di as txt " R-squared   "  (`r(rho)')^2
gen e2 			= (e-yhat)^2
gen lyhat 		= ln(efe*exb)
gen _sample 	= e(sample)

tabstat `depvar' if _sample == 1, stat(mean sd min max n)
drop y2 exb meany meanexb efe yhat e2 lyhat _sample

}

restore

******************************************************
******************************************************
*	TABLE B-5: UNBALANCED sample
******************************************************
******************************************************

*	All years
xi: xtpqml e eligiblenow treatednow rate tot_revs tot_ass tot_liabilities mne royalty_cost i.tyear, fe

*	Drop 2003
preserve
drop if tyear == 2003
xi: xtpqml e eligiblenow treatednow rate tot_revs tot_ass tot_liabilities mne royalty_cost i.tyear, fe
restore

*	Drop 2004
preserve
drop if tyear == 2004
xi: xtpqml e eligiblenow treatednow rate tot_revs tot_ass tot_liabilities mne royalty_cost i.tyear, fe
restore

*	Drop 2003 and 2004
preserve
drop if tyear == 2003 | tyear == 2004
xi: xtpqml e eligiblenow treatednow rate tot_revs tot_ass tot_liabilities mne royalty_cost i.tyear, fe
restore

*	Drop 2003, 2004, 2005
preserve
drop if tyear == 2003 | tyear == 2004 | tyear == 2005
xi: xtpqml e eligiblenow treatednow rate tot_revs tot_ass tot_liabilities mne royalty_cost i.tyear, fe
restore


******************************************************
******************************************************
*	TABLE B-6: UNBALANCED sample
******************************************************
******************************************************

preserve

gen ee				= e
replace e			= max(1,e)
gen le				= log(e)

gen lee			= log(ee)
gen lee10000 	= log(max(10000,ee))
gen lee25000 	= log(max(25000,ee))
gen lee50000 	= log(max(50000,ee))

egen _sd = sd(e), by(firmid)
keep if _sd != 0
drop  _sd

*	Column 1
xi: areg lee eligiblenow treatednow rate tot_revs tot_ass tot_liabilities mne royalty_cost i.tyear if 0 < ee, absorb(firmid) r 

*	Column 2-4
local depvar_set "lee10000 lee25000 lee50000"
foreach depvar in `depvar_set' {

xi: areg `depvar' eligiblenow treatednow rate tot_revs tot_ass tot_liabilities mne royalty_cost i.tyear, absorb(firmid) r 

}

restore

******************************************************
******************************************************
*	TABLE B-7: UNBALANCED sample
******************************************************
******************************************************

preserve

*	Create tax exhaustion and triple-diff variable 

gen h  = (tao1 <= 0)
gen f1 = eligiblenow * pp * h
gen f2 = pp * h
gen f3 = eligiblenow * h
gen f4 = eligiblenow * pp
gen f5 = eligiblenow
gen f6 = h

*	Column 1-3
local depvar_set "e wages contracts_paid"
foreach depvar in `depvar_set' {

xi: xtpqml `depvar' f1 f2 f3 f4 f5 f6 rate tot_revs tot_ass tot_liabilities mne royalty_cost i.tyear, fe
predict y2, xb
replace y2 = y2^2
gen exb			= exp(y2^0.5)
egen meany		= mean(e) if y2 !=., by(firmid)
egen meanexb	= mean(exb), by(firmid)
gen efe			= meany/meanexb
gen yhat 		= (efe*exb)
qui cor e yhat
di as txt " R-squared   "  (`r(rho)')^2
gen e2 			= (e-yhat)^2
gen lyhat 		= ln(efe*exb)
gen _sample 	= e(sample)

tabstat `depvar' if _sample == 1, stat(mean sd min max n)
drop y2 exb meany meanexb efe yhat e2 lyhat _sample

}

restore

******************************************************
******************************************************
*	TABLE B-8: UNBALANCED sample
******************************************************
******************************************************
preserve
xi: xtpqml e eligiblenow treatednow rate tot_revs tot_ass tot_liabilities mne royalty_cost i.tyear, fe
gen _sample = e(sample)

keep if _sample == 1

tabstat e wages contracts_paid if tyear < 2004 & eligiblenow == 1, stat(mean)
tabstat e wages contracts_paid if tyear < 2004 & eligiblenow == 1 & 0 < dtax3, stat(mean)
tabstat e wages contracts_paid if tyear < 2004 & eligiblenow == 1 & dtax3 <= 0, stat(mean)

tabstat e wages contracts_paid if 2003 < tyear & eligiblenow == 1, stat(n)
tabstat e wages contracts_paid if 2003 < tyear & eligiblenow == 1 & 0 < dtax3, stat(n)
tabstat e wages contracts_paid if 2003 < tyear & eligiblenow == 1 & dtax3 <= 0, stat(n)

restore

clear
log close
