function [config_binary_new, config_full_new, ...
    config_considered_updated, oem_profit_fc, d_profit]...
    = one_product_swap_BR(...
    config_binary_start, binary_prod, config_full_start, full_prod, ...
    oem_profit_fc_start, prod_profit_fc_binary_start, ...
    prod_profit_fc_full_start, config_considered, n_OEM, sim_pcoeff, sim_qcoeff, ...
    sim_rand, mc_param_q, fixed_prod, n_carrier, n_top_gap, nfc, x_rand, setup)

    % PURPOSE: find one product swap best response to config_init
    % n_iter: the firm to take the action
    % config_new: new configuration
    % profit_new: new profit 
    % d_profit: deviating profit % deviating total surplus

    n_iter = n_OEM;

    if setup.merge && ismember(n_iter, setup.merge_id)
        n_iter = setup.merge_id;
    end

    % total moves
    ttmoves = 0;
    for n_count = 1 : length(n_iter)
        no = n_iter(n_count);
        ttmoves = ttmoves + length(config_binary_start{no}) + ...
            length(config_full_start{no})*(n_carrier+1);
    end

    dev_config = cell(ttmoves, 1);
    dev_profit = nan(ttmoves, 1);
    
    oem_profit_no = nan(ttmoves, 1);

    config_considered_updated = config_considered;

    k = 0;
    for n_count = 1 : length(n_iter);
        no = n_iter(n_count);

        % binary moves
        n_binary = length(config_binary_start{no});
        if n_binary==0; error('unknown OEM in firm seq'); end

        for ii = 1 : n_binary % loop over potential products on this OEM
            ind = k + 1;
            config_binary_ii = config_binary_start;
            config_binary_ii{no}(ii) = 1 - config_binary_ii{no}(ii);

            config_ii.binary = config_binary_ii;
            config_ii.full = config_full_start;
            
            if isnan(binary_prod{no}{ii}.q0)
                config_considered_updated = [config_considered_updated, config_ii];
            end

            if ismember_struct(config_ii, config_considered_updated)
                dev_profit(ind) = -1;
            else
                dev_config{ind} = config_ii;
                config_considered_updated = [config_considered_updated, config_ii];
                
                [oem_varprofit_ii, ~, ~, ~, ~, ~, ~,...
                    cons_surplus_ii, ~, ~, carrier_profit_ii, ~, ...
                    ~, ~, prod_profit_binary_ii]...
                    = equi_ind(config_binary_ii, binary_prod, ...
                    config_full_start, full_prod, fixed_prod, ...
                    setup, n_top_gap, n_carrier, setup.n_draws, x_rand, ...
                    sim_pcoeff, sim_qcoeff, sim_rand, mc_param_q);

                [fc_ii, prod_fc_binary_ii]...
                    = compute_fc(config_binary_ii, binary_prod, ...
                    config_full_start, full_prod, n_top_gap, nfc);

                if ismember(setup.counterfactual, {'merge_2_firms_seq1','merge_2_firms_seq2', 'merge_2_firms_simultaneous'})
                    dev_profit(ind) = sum(oem_varprofit_ii(n_iter)) - sum(fc_ii(n_iter));
                elseif ismember(setup.counterfactual, {'no_cannibalization', 'no_cannibalization_simultaneous'})
                    if config_binary_ii{no}(ii)==0 
                        dev_profit(ind) = -prod_profit_fc_binary_start{no}(ii);
                    else
                        dev_profit(ind) = prod_profit_binary_ii{no}(ii)-...
                            prod_fc_binary_ii{no}(ii);
                    end
                    
                    oem_profit_no(ind) = sum(oem_varprofit_ii(n_iter)) - sum(fc_ii(n_iter));
                else
                    error('unknown counterfactual');
                end
            end
            k = ind;
        end

        % full moves
        for ntg = 1 : n_top_gap
            for ic = 0 : n_carrier
                ind = k + 1;

                config_full_ii = config_full_start;
                if ~isempty(config_full_ii{no})
                    config_full_ii{no}(ntg) = ic;
                end

                config_ii.binary = config_binary_start;
                config_ii.full = config_full_ii;
                
                if ic>0 && (~isempty(full_prod{no}) && isnan(full_prod{no}{ic, ntg}.q0))
                    config_considered_updated = [config_considered_updated, config_ii];
                end
                
                if ismember_struct(config_ii, config_considered_updated)
                    dev_profit(ind) = -1;
                else
                    dev_config{ind} = config_ii;
                    config_considered_updated = [config_considered_updated, config_ii];
                    
                    [oem_varprofit_ii, ~, ~, ~, ~, ~, ~,...
                        cons_surplus_ii, ~, ~, carrier_profit_ii, ~, ...
                        ~, ~,  ~, prod_profit_full_ii]...
                        = equi_ind(config_binary_start, binary_prod, ...
                        config_full_ii, full_prod, fixed_prod, ...
                        setup, n_top_gap, n_carrier, setup.n_draws, x_rand, ...
                        sim_pcoeff, ...
                        sim_qcoeff, sim_rand, mc_param_q);
                    
                    [fc_ii, ~, prod_fc_full_ii]...
                        = compute_fc(config_binary_start, binary_prod, ...
                        config_full_ii, full_prod, n_top_gap, nfc);
                    
                    if ismember(setup.counterfactual, {'merge_2_firms_seq1','merge_2_firms_seq2', 'merge_2_firms_simultaneous'})
                        dev_profit(ind) = sum(oem_varprofit_ii(n_iter)) - sum(fc_ii(n_iter));
                    elseif ismember(setup.counterfactual, {'no_cannibalization', 'no_cannibalization_simultaneous'})
                        if config_full_ii{no}(ntg)==0
                            dev_profit(ind) = -prod_profit_fc_full_start{no}(ntg);
                        else
                            dev_profit(ind) = prod_profit_full_ii{no}(ntg)-...
                                prod_fc_full_ii{no}(ntg);
                        end
                        
                        oem_profit_no(ind) = sum(oem_varprofit_ii(n_iter)) - sum(fc_ii(n_iter));
                    else
                        error('unknown counterfactual');
                    end
                    
                end

                k = ind;
            end
        end

    end

    if (ismember(setup.counterfactual, {'merge_2_firms_seq1','merge_2_firms_seq2', 'merge_2_firms_simultaneous'})...
            && max(dev_profit)<=oem_profit_fc_start) ||...
            (ismember(setup.counterfactual, {'no_cannibalization', 'no_cannibalization_simultaneous'}) && max(dev_profit)<=0)

        config_binary_new = config_binary_start;
        config_full_new = config_full_start;
        oem_profit_fc = oem_profit_fc_start;
        d_profit = -1;
    else
        [~, maxind] = max(dev_profit);
        config_binary_new = dev_config{maxind}.binary;
        config_full_new = dev_config{maxind}.full;
        if ismember(setup.counterfactual, {'merge_2_firms_seq1','merge_2_firms_seq2', 'merge_2_firms_simultaneous'})
            oem_profit_fc = dev_profit(maxind);
            d_profit = oem_profit_fc - oem_profit_fc_start;       
        elseif ismember(setup.counterfactual, {'no_cannibalization', 'no_cannibalization_simultaneous'})
            oem_profit_fc = oem_profit_no(maxind);
            d_profit = dev_profit(maxind);
        else
            error('unknown counterfactual');
        end
    end

end

%% subfunction
function tf = ismember_struct(A, B)
    nB = length(B);
    tf = false;
    for nb = 1 : nB
        tf = tf | isequal(A, B{nb});
    end
end



