function [b, se_2sls] = gmm_iv(y, x, z)

Pz = z*((z'*z)\z'); % IV*inv(IV'*IV)*IV'

b = (x'*Pz*x)\(x'*Pz*y);


resid = y-x*b;
S = repmat(resid, [1, size(z, 2)]).*z;
S = S' * S;
INV = inv(z'*z);
se_2sls = inv(x'*Pz*x)*(x'*z*INV*S*INV*z'*x)*inv(x'*Pz*x);
se_2sls = sqrt(diag(se_2sls));

