function [mean_demand, mean_mc] = gen_mean(t, oem_ind_j, carrier_ind_j, ...
    flag_j, para_linear_est, mc_param, dim_demand_brandtime, ...
    dim_demand_flagship, dim_demand_carriertime, dim_demand_const, ...
    dim_demand_time, dim_mc_carriertime, dim_mc_brand, dim_mc_const, ...
    key_oem_ind)
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
% IMPORTANT: make sure that this code is consistent with how brand_dummies, brandtime_dummies and carriertime_dummies are deefined in master_est_smartphone.m 
%!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

para_linear_est = para_linear_est';
mc_param = mc_param';
% brand effect 
mc_brand_coeff = mc_param(dim_mc_brand);
if ismember(oem_ind_j, key_oem_ind)
    mean_mc_brand = mc_brand_coeff(ismember(key_oem_ind, oem_ind_j));
else
    mean_mc_brand = 0;
end

% current carrier_time dummy
demand_time_coeff = [0, para_linear_est(dim_demand_time)];

n_quarter = floor((t-1)/3)+1;
n_quarter_year = n_quarter-floor((n_quarter-1)/4)*4;

mean_demand_time = demand_time_coeff(n_quarter_year);

demand_carriertime_coeff = [0, para_linear_est(dim_demand_carriertime)];
mc_carriertime_coeff = [0, mc_param(dim_mc_carriertime)];

n_year = floor((t-1)/12)+1;

mean_demand_carriertime = demand_carriertime_coeff(n_year+5*(carrier_ind_j-1));
mean_mc_carriertime = mc_carriertime_coeff(n_year+5*(carrier_ind_j-1));

demand_brand_coeff = para_linear_est(dim_demand_brandtime);
if ismember(oem_ind_j, key_oem_ind)
    mean_demand_brandtime = demand_brand_coeff(ismember(key_oem_ind, oem_ind_j));
else
    mean_demand_brandtime = 0;
end

mean_demand = mean_demand_brandtime + flag_j*para_linear_est(dim_demand_flagship)...
    +mean_demand_time+mean_demand_carriertime...
    +para_linear_est(dim_demand_const);

mean_mc = mc_param(dim_mc_const)+mean_mc_brand+mean_mc_carriertime;

end