function [XCMATu, XPMAT, dum_med, dum_big, PrevInc] = PrepData(DataInputs)

global INSIDER_switch DIROFF_Switch Switchdummies Switchmergers;

%%%%%%%%%%%%%%%%%
%% Import data %%
%%%%%%%%%%%%%%%%%

%% First Firm-level data.
% Initialize variables.

filename = DataInputs{1};

delimiter = ',';
startRow = 2;

formatSpec = '%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%[^\n\r]';

% Open the text file.
fileID = fopen(filename,'r');

dataArray = textscan(fileID, formatSpec, 'Delimiter', delimiter, 'EmptyValue' ,NaN,'HeaderLines' ,startRow-1, 'ReturnOnError', false);

% Close the text file.
fclose(fileID);

% Allocate imported array to column variable names
firm_id = dataArray{:, 1};
time_id = dataArray{:, 2};
inc_id = dataArray{:, 3};
hdq_id = dataArray{:, 4};

Managers_dum15 = dataArray{:, 5};
Director_dum15 = dataArray{:, 6};
Officer_dum15 = dataArray{:, 7};

takeover_prem = dataArray{:, 8};

InstOwn_perc = dataArray{:, 9}; 

at0_100 = dataArray{:, 10};
at100_1000 = dataArray{:, 11};
at1000 = dataArray{:, 12};

ControlFct_resid = dataArray{:, 13};

SP500 = dataArray{:, 14};

PrevInc = dataArray{:, 15};

if  strcmp(DataInputs{5},'takeover_prem') == 1 
    mergervar = takeover_prem;
end

if strcmp(DataInputs{6},'InstOwn_perc') == 1
ownershipvar = InstOwn_perc;
end

% Clear temporary variables
clearvars filename delimiter startRow formatSpec fileID dataArray ans;

% Assemble XCMATu
% CHOOSE MERGER VARIABLE
if Switchmergers == 0 && Switchdummies == 3;
  
    XCMATu = [firm_id time_id inc_id hdq_id ownershipvar at0_100 at100_1000]; % leaves out TempHdq for now

elseif Switchmergers == 1 && Switchdummies == 3;
  
    XCMATu = [firm_id time_id inc_id hdq_id ownershipvar at0_100 at100_1000 mergervar]; % leaves out TempHdq for now

end


% now add insiders
if INSIDER_switch == 1 && strcmp(DataInputs{7},'dum15') == 1 
    XCMATu = [XCMATu,Managers_dum15]; 
elseif INSIDER_switch == 2 && strcmp(DataInputs{7},'dum15') == 1 && DIROFF_Switch == 2;
    XCMATu = [XCMATu,Managers_dum15,Director_dum15]; 
elseif INSIDER_switch == 2 && strcmp(DataInputs{7},'dum15') == 1 && DIROFF_Switch == 1;
    XCMATu = [XCMATu,Managers_dum15,Director_dum15,Officer_dum15]; 
end

%% Now State-level data.
% Initialize variables.
filename  = DataInputs{2};
delimiter = ',';
startRow = 2;

formatSpec = '%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%[^\n\r]';

fileID = fopen(filename,'r');
dataArray = textscan(fileID, formatSpec, 'Delimiter', delimiter, 'HeaderLines' ,startRow-1, 'ReturnOnError', false);
fclose(fileID);

% Allocate imported array to column variable names
time_id = dataArray{:, 1};
state_option = dataArray{:, 2};
ATS = dataArray{:, 3};
DIR = dataArray{:, 4};
OFF = dataArray{:, 5};
DIROFF = dataArray{:, 6};

ExtremeS = dataArray{:, 7};
DeadH = dataArray{:, 8};
PillStat = dataArray{:, 9};

%%%%%

clearvars filename delimiter startRow formatSpec fileID dataArray ans;

if strcmp(DataInputs{3},'ATS') == 1 
atsvar = ATS;
elseif strcmp(DataInputs{3},'ExtremeS') == 1
atsvar = ExtremeS;
elseif strcmp(DataInputs{3},'DeadH') == 1
atsvar = DeadH;
elseif strcmp(DataInputs{3},'PillStat') == 1
atsvar = PillStat;
end

if strcmp(DataInputs{4},'DIR') == 1 
XPMAT = [state_option time_id atsvar DIR OFF]; %
elseif strcmp(DataInputs{4},'DIROFF') == 1
XPMAT = [state_option time_id atsvar DIROFF]; 
elseif strcmp(DataInputs{4},'DeadH') == 1
XPMAT = [state_option time_id atsvar DeadH DIR OFF]; 
elseif strcmp(DataInputs{4},'ExtremeS') == 1
XPMAT = [state_option time_id atsvar ExtremeS DIR OFF]; 

end

if Switchdummies ==3
dum_med=at100_1000;
dum_big=(at0_100==0).*(dum_med==0);

end

end
