function [L, g] = LogLikG_mh_Cf(Params)


% This function takes in a column vector of parameters of the likelihood function
% and DATA ( as well as other parameters of the problem) as globals, and
% returns as arguments -Loglikelihood, and gradient of -Loglikelihood.

global NT NALT Cvarn
global XCMATu XXP T PInc CFcn % bulk of DATA

L = 0;
g = 0;

    for t = 1:NT
    
    Pt = (XCMATu(:,2)==t);
    
    % xs for trying deltastar; take for all consumers in a given year.
    % recall: 1. dmid, 2. timeid, 3.choice index, 4.dm-level char
    XC = XCMATu(Pt,5:4+Cvarn);
    HomeSt = XCMATu(Pt,4);
    CFcn_t = CFcn(Pt);
    
    Choices = XCMATu(Pt,3);
    Pinct = PInc(Pt,1);

    % recall: XPMAT = [prodid timeid2 XProd]; % Prod-T level matrix with:
    XP = XXP([(t-1)*NALT+Choices],:);
    % this is matrix of chars of the prod that each DM chooses!
    
    % at time t, products chosen will be indexed by (t-1)*NALT + prod index
    XPp = XXP([(t-1)*NALT+Pinct],:);
    % xs at time t of past choice!
    
    XPd = XXP((1:NALT)+NALT*(t-1),:);
    % ALL Xs of the period, in NALT*Pvarn form
    
    % stuff for LigLikt
    Tt = T(Pt,:);

    Lt = LogLikt_mh_Cf(Params,XP,XPp,XPd,XC,CFcn_t,Choices,Pinct,HomeSt,Tt);
    L = L + Lt;
    
    % gradients:
    gt = [gradtB_mh_Cf(Params,XP,XPp,XPd,XC,CFcn_t,Choices,Pinct,HomeSt,Tt) ...
         gradtHbi_mh_Cf(Params,XP,XPp,XPd,XC,CFcn_t,Choices,Pinct,HomeSt,Tt) ...
         gradtFE_mh_Cf(Params,XP,XPp,XPd,XC,CFcn_t,Choices,Pinct,HomeSt,Tt) ...
         gradtFE_CFcn_mh_Cf(Params,XP,XPp,XPd,XC,CFcn_t,Choices,Pinct,HomeSt,Tt) ...
         gradtH_mh_Cf(Params,XP,XPp,XPd,XC,CFcn_t,Choices,Pinct,HomeSt,Tt) ...
         gradtmu_mh_Cf(Params,XP,XPp,XPd,XC,CFcn_t,Choices,Pinct,HomeSt,Tt) ...
         gradtsigma_mh_Cf(Params,XP,XPp,XPd,XC,CFcn_t,Choices,Pinct,HomeSt,Tt)];
    % the gradt terms should be of dimension NCSt*# of vars
    
    g = g + gt;
    
    clear XC XP XPd Pt Choices Pinct Tt t Lt CFcn_t

    end
    
    L = -L;
    g = -g;

end
