function gh = gradtH_mh_Cf(Params,XP,XPp,XPd,XC,CFcn_t,Choices,Pinct,HomeSt,Tt)

global  NALT Pvarn Int3 NhomebInt

Tt1 = Tt(:,1);
Tt2 = Tt(:,2);
Tt3 = Tt(:,3);
Cs = size(XC,1);

hchosen = (Choices==HomeSt); % vector that indicates whether current choice is home.
Phchosen = (Pinct == HomeSt); % vector that indicates whether past choice is home
hmat = (repmat([1:NALT],Cs,1) == repmat(HomeSt,1,NALT)); % Cs*NALT matrix that says, for each i, whether j is home

pp = plogit_mh_Cf(XC,CFcn_t,XPd,HomeSt,Params)';  % this is CsxNALT of exp(deltaj)/sum(exp(deltah))
pph =  pdelta_mh_Cf(XC,CFcn_t,XPd,HomeSt,Params)'; % this is CsxNALT of exp(deltaj)

sigma = Params(Pvarn+Int3+2*NALT+1+NhomebInt);

ppi = pinatt_mh_Cf(Params,XPp,XPd,XC,CFcn_t,Pinct,HomeSt);

gth = hchosen .* (Tt1+Tt2) + ... // this is indicator of whether choice==ALT
       (((1 - ppi)/sigma).* (Tt2) .* (pp(hmat') - Phchosen))   - ... //  this is ((1-pi)/sigma)*(e(deltaj)/sum(exp) - Indicator(pastchoice==j))
       pp(hmat') + ... //  this is e(home)/sum(exp)
       ( (1 - ppi) .* (pph(hmat')) + ... // (1-pi)*exp(delta(home))
          (ppi.* edeltastar_mh_Cf(XC,CFcn_t,XP,Pinct,HomeSt,Params) .* hchosen) + ...
          ((ppi.*(1 - ppi)/sigma) .* (edeltastar_mh_Cf(XC,CFcn_t,XP,Pinct,HomeSt,Params) - deltaexp_mh_Cf(XC,CFcn_t,XPd,HomeSt,Params)) .* (pp(hmat') - Phchosen))) ...
          ./ ... // denominator of whole expression; same expression as in the likelihood, see LogLikt
          ( (1-ppi) .* deltaexp_mh_Cf(XC,CFcn_t,XPd,HomeSt,Params) + ppi .* edeltastar_mh_Cf(XC,CFcn_t,XP,Choices,HomeSt,Params)) .* ...
          Tt3 ;
          
gh = sum(gth,1);

clear hchosen Phchosen hmat pp pph gth

end
