function gfe = gradtFE_oh(Params,XP,XPp,XPd,XC,Choices,Pinct,HomeSt,Tt)


global  NALT Pvarn Int3 NhomebInt

Tt1 = Tt(:,1);
Tt2 = Tt(:,2);
Tt3 = Tt(:,3);
Cs = size(XC,1);

Altk = (repmat([2:NALT],Cs,1) == repmat(Choices,1,NALT-1)); % matrix CsxNALT that gives for every i,j whether choice corresponds to alt
Altkp = (repmat([2:NALT],Cs,1) == repmat(Pinct,1,NALT-1)); % matrix CsxNALT that gives for every i,j whether PAST choice corresponds to alt

plogitAlt = plogit_mh(XC,XPd,HomeSt,Params);    % CsxNALT matrix that gives exp(deltaj)/sum(exp(deltah)) for every i,j
plogitAlt = plogitAlt(:,2:NALT);    % CsxNALT matrix that gives exp(deltaj)/sum(exp(deltah)) for every i,j

pdeltaAlt = pdelta_mh(XC,XPd,HomeSt,Params); % CsxNALT matrix that gives exp(deltaj) for every i,j
pdeltaAlt = pdeltaAlt(:,2:NALT); % CsxNALT matrix that gives exp(deltaj) for every i,j

sigma = Params(Pvarn+Int3+NALT+2+NhomebInt);
ppi = pinatt_mh(Params,XPp,XPd,XC,Pinct,HomeSt);

gtfe = Altk .* repmat((Tt1+Tt2),1,NALT-1) + ... // this is indicator of whether choice==ALT
       (repmat(((1 - ppi)/sigma).* (Tt2),1,NALT-1) .* (plogitAlt - Altkp))   - ... //  this is ((1-pi)/sigma)*(e(deltaj)/sum(exp) - Indicator(pastchoice==j))
       plogitAlt + ... //  this is e(home)/sum(exp)
       ( repmat((1 - ppi),1,NALT-1) .* pdeltaAlt + ... // (1-pi)*exp(delta(home))
          (repmat(ppi.* exp(deltastar_mh(XC,XP,Pinct,HomeSt,Params)),1,NALT-1) .* Altk) + ...
          (repmat((ppi.*(1 - ppi)/sigma) .* (exp(deltastar_mh(XC,XP,Pinct,HomeSt,Params)) - deltaexp_mh(XC,XPd,HomeSt,Params)) ,1,NALT-1).* (plogitAlt - Altkp))) ...
          ./ ... // denominator of whole expression; same expression as in the likelihood, see LogLikt
          (repmat( (1-ppi) .* deltaexp_mh(XC,XPd,HomeSt,Params) + ppi .* exp(deltastar_mh(XC,XP,Choices,HomeSt,Params)),1,NALT-1)) .* ...
          repmat(Tt3,1,NALT-1) ;
          
gfe = gtfe;

clear Altk Altkp plogitAlt pdeltaAlt gtfe

end

