/*********************************************************************
Figure 1 Panel A: (before the score posting period)
Relationship between (continuous) restaurant hygiene scores and
	 restaurant leads
*********************************************************************/

use leads_score_posting, clear

keep if month == -1
// Plot using data before the posting of hygiene scores

* Removed a few (less than 1%) top coded restaurants with the largest number of 
* 	leads when graphing to improve scaling of the figure.


*** Fig1, Panel A, Left Figure ***
* Scatter plot: leads and hygiene scores
* NOTE: the variable "leads" is removed from the data due to the data agreement with Yelp
#delimit ;
twoway (qfitci leads score if month==-1, acolor(gs14) clcolor(gs2))
	(scatter leads score if month==-1, msymbol(+) mcolor(navy) msize(tiny)),
	xtitle("Hygiene Score") ytitle("Leads")
	xlabel(50(10)100, labsize(medsmall)) ylabel(none)
	xscale(lw(medium)) yscale(lw(medium))
	legend(order(1 "95% CI" 2 "Quadratic Fitted Line" ) 
		size(medsmall) rows(1))
	graphregion(fcolor(white));
#delimit cr
graph export Fig1_A_1.eps, replace


*** Fig1, Panel A, Right Figure ***
* Compare distribution of leads between restaurants with scores>70 vs. <=70
* NOTE: the variable "leads" is removed from the data due to the data agreement with Yelp
#delimit ;
graph twoway (hist leads if below70==0 & month==-1, width(100) color(gs10) frac)
             (hist leads if below70==1 & month==-1, width(100) fcolor(none) lcolor(gs1) frac),
	xtitle("Leads") ytitle("Fraction")
	xlabel("", notick nogrid)
	xscale(lw(medium)) yscale(lw(medium))
	legend(order(1 "Score>70" 2 "Score<=70"))
	graphregion(fcolor(white));
#delimit cr
graph export Fig1_A_2.eps, replace



/*********************************************************************
Figure 2 Panel A: (before the score posting period)
Relationship between (continuous) restaurant hygiene scores and
	 restaurant characteristics 
*********************************************************************/

use leads_score_posting, clear

* plot using data before the posting of hygiene scores
keep if month == -1

*** Fig2, Panel A, Left Figure: 
*	hygiene score and review ratings
#delimit ;
twoway (qfitci score rating, acolor(gs14) clcolor(gs2))
	(scatter score rating, msymbol(+) mcolor(gs2) msize(small)),
	ytitle("Hygiene Score") xtitle("Review Rating")
	ylabel(50(10)100, labsize(medsmall))
	xlabel(1(1)5, labsize(medsmall))
	xscale(lw(medium)) yscale(lw(medium))
	legend(order(1 "95% CI" 2 "Quadratic Fitted Line" ) 
			size(medsmall) rows(1))
	graphregion(fcolor(white));
#delimit cr
graph export Fig2_A_1.eps, replace


*** Fig2, Panel A, Right Figure:
*	hygiene score and restaurant price categories
tab price, missing
#delimit ;
twoway (qfitci score price, acolor(gs14) clcolor(gs2))
		(scatter score price, msymbol(+) mcolor(gs2) msize(small)),
	ytitle("Hygiene Score") xtitle("Price Category")
	ylabel(50(10)100, labsize(medsmall))
	xlabel(1 "$" 2 "$$" 3 "$$$" 4 "$$$$", labsize(medsmall))
	xscale(lw(medium)) yscale(lw(medium))
	legend(order(1 "95% CI" 2 "Quadratic Fitted Line")
			size(medsmall) rows(1))
	graphregion(fcolor(white));
#delimit cr
graph export Fig2_A_2.eps, replace



/*********************************************************************
Figure 1 Panel B: (before the hygiene alert period)
Relationship between (continuous) restaurant hygiene scores and
	 restaurant leads
*********************************************************************/

use leads_hygiene_alert, clear

keep if month == -1
// using data before the alert intervention
count if leads>2000
// 8 out of 4510 restaurants have leads>2000,
//	did not plot them due to scaling


*** Figure 1, Pnale B, Left Figure ***
* 	Scatter plot: leads and hygiene scores
* NOTE: the variable "leads" is removed from the data due to the data agreement with Yelp
#delimit ;
twoway (qfitci leads score if leads<=2000, acolor(gs14) clcolor(gs2))
	(scatter leads score if leads<=2000, msymbol(+) mcolor(navy) msize(tiny)),
	xtitle("Hygiene Score") ytitle("Leads")
	xlabel(50(10)100, labsize(medsmall)) ylabel(none)
	xscale(lw(medium)) yscale(lw(medium))
	legend(order(1 "95% CI" 2 "Quadratic Fitted Line" ) 
		size(medsmall) rows(1))
	graphregion(fcolor(white));
#delimit cr
graph export Fig1_B_1.eps, replace


*** Figure 1, Pnale B, Right Figure ***
* 	Distribution of leads by alert status
* NOTE: the variable "leads" is removed from the data due to the data agreement with Yelp
#delimit ;
graph twoway (hist leads if alert==0, width(100) color(gs10) frac)
             (hist leads if alert==1, width(100) fcolor(none) lcolor(gs1) frac),
	xtitle("Leads") ytitle("Fraction")
	xlabel("", notick nogrid)
	xscale(lw(medium)) yscale(lw(medium))
	legend(order(1 "Score>70" 2 "Score<=70"))
	graphregion(fcolor(white));
#delimit cr
graph export Fig1_B_2.eps, replace


/*********************************************************************
Figure 2 Panel B: (before the hygiene alert period)
Relationship between (continuous) restaurant hygiene scores and
	 restaurant leads
*********************************************************************/

use leads_hygiene_alert, clear

keep if month == -1
// using data before the alert intervention

*** Fig2, Panel B, Left Figure ***
* 	Rating distribution by alert status

gen rating2 = rating
replace rating2 = rating + 0.1
replace rating2 = rating + 0.15 if rating >=2
replace rating2 = rating + 0.2 if rating >=4

#delimit ;
graph twoway (histogram rating if alert==0, width(0.1) color(gs10) frac)
             (histogram rating2 if alert==1, width(0.1) color(gs4) frac),
	xtitle("Posted Rating") ytitle("Fraction")
  xlabel(1.1 "1" 1.6 "1.5" 2.1 "2" 2.6 "2.5" 3.1 "3" 3.6 "3.5" 
	4.1 "4" 4.6 "4.5" 5.1 "5",noticks nogrid)
  xscale(lw(medium)) yscale(lw(medium))
  legend(order(1 "Score>70" 2 "Score<=70"))
  graphregion(fcolor(white));
#delimit cr
graph export Fig2_B_1.eps, replace


*** Panel B Right Figure ***
*	Price category by alert status

gen price2 = price + 0.3
replace price2 = price+0.3 if price == 3
replace price2 = price+0.6 if price == 4

#delimit ;
graph twoway (histogram price if alert==0 & month==-1, width(0.1) color(gs10) frac)
             (histogram price2 if alert==1 & month==-1, width(0.1) color(gs4) frac),
  xtitle("Price Category") ytitle("Fraction")
  xlabel(1.15 "$" 2.15 "$$" 3.15 "$$$" 4.15 "$$$$",noticks nogrid)
  xscale(lw(medium)) yscale(lw(medium))
  legend(order(1 "Score>70" 2 "Score<=70"))
  graphregion(fcolor(white));
#delimit cr
graph export Fig2_B_2.eps, replace


