clear 
clc

load Data
% Data contains the Nominal GDP, Cpi in levels and CPI Inflation

%%

year=1990:2015;
mo={'Jan','Apr','Jul','Oct'};
Ind=0;

for i=1:length(year)
    
    for s=1:4
        Ind=Ind+1;
    Obs(Ind,1)=strcat('01-',mo(s),'-', num2str(year(i)));
    end
end
observation_date=datenum(Obs(1:end-1));
%% Real GDP
Outn= Out./trucpi(2:end);
Nodetr= (Out - Out(75))/Out(75) *100;




%% Detrending with HP-Filter for GDP

 [Trend,Cyclical] = hpfilter(Outn,1600);
 Detr = Cyclical./Trend*100;
 figure(1)
 %recessionplot
hold on
 plot( observation_date,Detr )
 datetick('x')
%recessionplot
hold off
 xlabel('Quarters')
ylabel('Output Gap')




%% Detrending with HP-Filter for Inflation

 figure(2)
 title('Cpi','Interpreter','Latex')
 %recessionplot
 plot( observation_date,Cpi )
 datetick('x')
xlabel('Quarters')
ylabel('CPI Inflation')

