function [F_1 F_2 V_1 V_2 M_tilde H_shock g_shock]= Time_Matrices (A_tilde,B_tilde, NZ,NC,NE,...
    M,time_M,S,h_x,h_z,g_x,g_z,Time_Mat,M_z)
%% Inputs:
%         NZ = #s of exogenous state
%         NC = #s of controls
%         NE = #s of endogenous state
%         NY = NC+NE+NX
%
%         A_tilde = 2-dimension matrices, first two dimension : Matrix of constraints
%          and derivatives at t+1
%
%         B_tilde =3-dimension matrices, first two dimension :Matrix of constraints
%          and derivatives at t
%         3rd dimension represents in which case we are 1 zlb, 2 nzlb or 1
%         both zlb, 2 one in zlb , 3 none in zlb
%
%         Time_mat = Vector with different time at which the system of
%         equation change. Fist element should be always 0 and last 
%          the last time period. In the middle you should put the time
%         at which the economy change the structure. To be precise:
%         Immagine that at T_1 economy is out of zlb then in the Time_mat
%         you will have [0 T_1-1 S]; 
%
%         M = Matrix of exogenous shock process
%         time_M = Vector of time when the exogenous shock ends
%
%         S = time
%     
%         Processes for the states and controls are defined as:
%
%         y_{t}=F_1^t * x_{t-1} + F_2^t * z_{t-1} + h_{shock}^t * shock
%
%         x_{t}=V_1^t * x_{t-1} + V_2^t * z_{t-1} + g_{shock}^t * shock
%
%         z_{t}= M_z^t * z_{t-1} + M_{shock}^t * shock
%
%         where shock are 1 or zero while the coefficient in M_{shock}
%         embedded the shocks level
%
%         h_x= F_1^s , g_x=V_1^s , g_z=V_2^s
%           , h_z=F_2^s are the coefficients from s=Time_mat(end-1)+1
%         on, the ones that comes from reds and solds.
%% Output :
%          M_tilde = Matrices of exogenous shock coefficients for exogenous
%          states
%          H_shock =Matrices of exogenous shock coefficients for controls
%          g_shock =Matrices of exogenous shock coefficients for end. states
% Since we should
% These matrices are 3-dimensions: 
% First dimension is the #s of states or controls
% Second dimension is the time
% Third dimension the shock
% Since we change the 
%
%          F_1,F_2,V_1 and V_2 are defined above. They are 3-dimensions
%          matrices, first 2 dimensions are the one need for the
%          coefficient while the 3rd is the one for time.

%% We build the matrices s.t.:

% [ A_1^t A_2^t] y_{t+1} = [B_1^t B_2^t B_3^t] [y_{t} x_{t-1} z_{t}]'
%            x_{t}

A_1= A_tilde (:,1:NC);
if NE>0
A_2 = A_tilde(:,NC+1:end); 
end


B_1 = NaN(NC+NE, NC,S);
if NE>0
B_2 = NaN(NC+NE , NE, S);
end
B_3 = NaN(NC+NE , NZ,S);



%% Coefficients:
if NE>0
F_1 = NaN(NC , NE, S);
V_1 = NaN(NE , NE, S);
V_2 = NaN(NE , NZ, S);
end

F_2 = NaN(NC,NZ,S);

%% Fullfill the matrices:
%T_1_tilde = T_1 - 1;
for i=1:length(Time_Mat)-1

    if NE>0
    B_2(:,:,Time_Mat(i)+1:Time_Mat(i+1))= repmat(B_tilde(:,NC+1:NC+NE,i) ,[1 1 Time_Mat(i+1)-Time_Mat(i)]);
    end
    B_1(:,:,Time_Mat(i)+1:Time_Mat(i+1))= repmat(B_tilde(:,1:NC,i) ,[1 1 Time_Mat(i+1)-Time_Mat(i)]);
    B_3(:,:,Time_Mat(i)+1:Time_Mat(i+1))= repmat(B_tilde(:,NC+NE+1 :end,i) ,[1 1 Time_Mat(i+1)-Time_Mat(i)]);

end

if NE>0
F_1 (:,:,end)= h_x;
V_1 (:,:,end)= g_x;
V_2 (:,:,end)= g_z;
end

F_2 (:,:,end)= h_z;


%% Process for the coefficients of the exogenous and endogenous state
%% variables
% We have to write the loop for V_1^t,F_1^t, V_2^t and F_2^t
% We know that:
%       [ V_1^t   =   [A_1*F_1^{t+1}+A_2   -B_1^t]^{-1} *B_2^z
%         F_1^t]
%
% and 
%

%       [ V_2^t   =   [A_1*F_1^{t+1}+A_2   -B_1^t]^{-1} *R(t+1)
%         F_2^t]
% where
%     R(t+1)=%(B_3^t*M_1 - A_1*F_2^{t+1}*M_1
for s=1:S-1
    %% Check
   if rank( [(A_1*F_1(:,:,S-s+1)+A_2)   -B_1(:,:,S-s)]) < size( [(A_1*F_1(:,:,S-s+1)+A_2)   -B_1(:,:,S-s)],1)
       error('Matrix is not invertible');
   end
   
    
   Matrix_1 = [(A_1*F_1(:,:,S-s+1)+A_2)   -B_1(:,:,S-s)]^(-1)* B_2(:,:,S-s);
   Matrix_2 = [(A_1*F_1(:,:,S-s+1)+A_2)   -B_1(:,:,S-s)]^(-1)*(B_3(:,:,S-s)*M_z -A_1*F_2(:,:,S-s+1)*M_z);
   
   if NE>0
   V_1(:,:,S-s)=Matrix_1(1:NE,:);
   V_2(:,:,S-s)=Matrix_2(1:NE,:);
   end
   F_1(:,:,S-s)=Matrix_1(NE+1:end,:);
   F_2(:,:,S-s)=Matrix_2(NE+1:end,:);
   
end


    
%% Initialize shock matrices 
% These matrices are 3-dimensions: 
% First dimension is the #s of states or controls
% Second dimension is the time
% Third dimension the shock

M_tilde= NaN(NZ,S,size(M,2)); % Exogenous shock for ex state
H_shock = NaN(NC,S,size(M,2)); % Shocks coefficients for end controls
g_shock = NaN(NE,S,size(M,2)); % Shock coefficients for end states


%% Initialize the process
% At the last period shocks are 0 for end state and controls
for i = 1:size(M,2)
    H_shock (:,end,i)=0;
    g_shock (:,end,i)=0;
end
    

% We build the matrices of  coefficients for exogenous shock
for i=1:size(M,2)
    if time_M(i,2)<1
     M_tilde (:,1:time_M(i,1),i)=repmat(M(:,i),[ 1 time_M(i,1)]);
     M_tilde (:,time_M(i,1)+1:end,i)=0;
    else
   M_tilde (:,1:time_M(i,1),i)=0;
   M_tilde (:,time_M(i,1)+1:time_M(i,2),i)=repmat(M(:,i),[ 1 time_M(i,2)-time_M(i,1)]);
   M_tilde (:,time_M(i,2)+1:end,i)=0;
    end
end
  
%% Process for the coefficients of the shocks:
% Since the process to define the shock coefficients are the same,
% independently if the shock is on epsilon, v or \pi we define only once
% the process and we index as i=[epsilon, v, pi].
%
%       [ g_i^t   =   [A_1*F_1^{t+1}+A_2   -B_1^z]^{-1} *N(t,t+1)
%         h_i^t]
%
% where:
%    
%         N(t,t+1)=(- A_1 * h_i^{t+1} + B_3z* m_i^t - A_1 *F_2^{t+1}*m_i^t)

for i=1:size(M,2)
    for s=1:S-1
        
     
        Matrix =[(A_1*F_1(:,:,S-s+1)+A_2)   -B_1(:,:,S-s)]\(B_3(:,:,S-s) * M_tilde(:,S-s,i) - A_1 * F_2(:,:,S-s+1) * M_tilde(:,S-s,i) -A_1 * H_shock(:,S-s+1,i));
    
        g_shock (:,S-s,i)=Matrix(1:NE,:);
        H_shock (:,S-s,i)=Matrix(NE+1:end,:);
    end
end

