
function[Irf] = Irf_fede(H_shock ,g_shock, M_tilde, NC,NE,NX,F_1,F_2,V_1,V_2,M_z,S,x0,z0)
%% Pass from 3-dimensions to 2:

H_shock_new = sum (H_shock,3);
g_shock_new = sum (g_shock,3);
M_shock = sum (M_tilde,3);

%% Initialize
y=NaN(NC,S);
x=NaN(NE,S);
z=NaN(NX,S);

y(:,1)= H_shock_new(:,1)+F_1(:,:,1)*x0+F_2(:,:,1)*z0;
x(:,1)= g_shock_new(:,1)+V_1(:,:,1)*x0+V_2(:,:,1)*z0;
z(:,1)= M_shock(:,1);

for s=2:S
    y(:,s)= F_1(:,:,s) * x(:,s-1) + F_2(:,:,s) * z(:,s-1) + H_shock_new(:,s);
    x(:,s)= V_1(:,:,s) * x(:,s-1) + V_2(:,:,s) * z(:,s-1) + g_shock_new(:,s);
    z(:,s)= M_z * z(:,s-1) + M_shock(:,s);
end

Irf = [y;x;z];
    