clear
clc
addpath(strcat(pwd,'/joe_00m'))
load debt3
load obs
year=1952:2015;
mo={'Jan','Apr','Jul','Oct'};
Ind=0;


for i=1:length(year)
    
    for s=1:4
        Ind=Ind+1;
    Obs(Ind,1)=strcat('01-',mo(s),'-', num2str(year(i)));
    end
end
Obs=datenum(Obs);

%% Perform Chow test:
A1= detrend(debt(1:50));
A2= detrend(debt(51:130));
A3= detrend(debt(141:196));


a=debt(141)-A3(1);
b= (debt(142)-A3(2))-(debt(141)-A3(1));

Series= a+ b*(0:length(debt)-141 +(year(end)-2015)*4);

figure(1)
hold on

SP1=Obs(50);
SP2=Obs(141);
SP3=Obs(131);

fig=figure(1)
fig.Position = [1, 1, 1500, 700];

plot(Obs(1:end-(1 +(year(end)-2015)*4)),debt,'Color',[0 0 0.8],'LineStyle','-','LineWidth',1.5)
plot(Obs(141:end-(1 +(year(end)-2015)*4)),Series,'Color',[1 0 0.4],'LineStyle','--','LineWidth',1.5)
plot(Obs(1:50),debt(1:50)-A1,'Color',[0.6 0 0.4],'LineStyle','--','LineWidth',1.5)
plot(Obs(51:130),debt(51:130)-A2,'Color',[0.8 0 0.4],'LineStyle','--','LineWidth',1.5)
%plot(Obs(79:79+EA+K-1),yfit,'g--')

y1=get(gca,'ylim');
plot([SP1 SP1],y1,'Color',[0. 0.6 0.6],'LineStyle','-.','LineWidth',1.5)
y1=get(gca,'ylim');
plot([SP3 SP3],y1,'Color',[0. 0.6 0.6],'LineStyle','-.','LineWidth',1.5)
y1=get(gca,'ylim');
plot([SP2 SP2],y1,'Color',[0. 0.6 0.6],'LineStyle','-.','LineWidth',1.5)



% line([SP SP],get(hax,'XLim'))
hold off
datetick('x')
ylabel(' Private Debt over GDP $\%$','Interpreter','Latex','FontSize',16)
xlabel('Quarters','Interpreter','Latex','FontSize',16)




