clear;
clc;
%% MASTER CODE:
% to use together with:
% reds and solds from Woodford website;
% 1. Steady_State;
% 2. Matrix_build_Inflation;
% 3. Time_Matrices_b
% 4. Irf_fede
%% NAME and add path
addpath(strcat(pwd,'/REProgram')); 
addpath(strcat(pwd,'/Myfile')); 


%% Exogenous Parameters

Tirf=30;% 


%% Exogenous Parameters
var.Target=[1.0773*4;.88*4]; % Debt over GDP
var.eta=1.; % Labor Disutility
var.rho= 1.5; % Relative Risk Aversion
var.sigma=1/var.rho; % Inverse of Relative Risk Aversion
var.k=.02;
var.chi= 0.61; % Portion of Borrowers
var.Pi_bar = 1 + 0.02/4; % Inflation
var.beta=(1/(1 + .015/4)); % Discount Factor

var.i_bar= var.Pi_bar/var.beta; % Nominal Interest Rate
var.theta= 7.88; % Elasticity
Sim_d=['i' 'o'];
Span=1000;

%% TIME FOR THE SIMULATION IN THE GRAPH



%% TIME 
% T is the time in which the shock on the safe level of the debt, d_t, hit
% the economy
% T_1+1 is the time in which the economy enter in zlb, T_2+1 is the time in which
% economy exit from zlb
var.T=1;
var.T_1=0;%% TIME IN WHICH ECONOMY ENTER IN ZLB


%% STEADY STATE
[var] = Steady_State(var);
%% LEAVE AFTER
var.b= var.D_b(1)/var.Y_bar;

var.nu=.159*var.b^(-1);%1.*var.phi;
var.phi=0.055*var.b^(-1);
for ii=1:length(Sim_d)
    Sim=Sim_d(ii);
%% Intermediate Parameters
%% SHOCK

var.v= (var.D_b(2)-var.D_b(1))/(var.Y_bar);



if var.T<1
var.v= 0;
end
if strcmp('o',Sim)
C_b_r=  (var.C_b(2) -var.C_b(1))/var.Y_bar;
C_s_r=  (var.C_s(2) -var.C_s(1))/var.Y_bar;
var.epsilonc= C_b_r - C_s_r;% Shock on consumption
end
%% Derived Parameters
var.lb= var.Y_bar/var.L_b(1);
var.ls= var.Y_bar/var.L_s(1);


%% BUILD THE MATRIX AND THE INDEX
if strcmp('o',Sim)
[A B C NY NK NX A_nzlb B_nzlb B_zlb Indicator_Variables]= Matrix_Build_optimal(var);
var.T_2=18; %% TIME IN WHICH ECONOMY EXIT (INCLUDED)
l{ii}='Optimal Policy';

else
[A B C A_nzlb B_nzlb B_zlb Indicator_Variables NY NX NK ]= Matrix_build_Inflation(var);
var.T_2=12; %% TIME IN WHICH ECONOMY EXIT (INCLUDED)
l{ii}='IT';
end
%% Indicator
% You find the meaning inside Matrix_Build_Inflation
   
for i=0:length(Indicator_Variables)/3-1
eval(['ind_' Indicator_Variables(3*i+1:3*(i+1)) '=' num2str(i+1) ';']);

end      

%% WOODFORD      
reds;
solds;


%% Drop the imaginary part

if abs( max(max(imag(D)))) < 10^(-13)
    D=real(D);
end

if abs(max(max(imag(G)))) < 10^(-13)
    G=real(G);
end


%% Build exogenous process

NC= NY - NK; % # of controls
NE = NK - NX; % # of endogenous state;
NZ = NX; % # of exogenous state


%% Built the matrices:
M_z= round(G(NE+1:end,NE+1:end));
%% 2. Exogenous State shock
NS = 3; % #s of shocks NS<=NZ


for i = 1:NS

eval(['M_' num2str(i) '=  zeros(NZ,1);' ]);
end

M_1(ind_d_t - NC -NE,1)= var.v; % for z

M_2(ind_iss - NC -NE,1)= - log(var.i_bar); % for i_bar
if strcmp('o',Sim)
M_3(ind_c_r - NC -NE,1)=var.epsilonc; % for i_bar
end    

M_4 (ind_d_t - NC -NE,1)= var.v*0;
M_5 (ind_d_t - NC -NE,1)= var.v*0; 
M_6 (ind_d_t - NC -NE,1)= var.v*0; 
M = [M_1 M_2 M_3 M_4 M_5 M_6];
% NB:
% It is important that shock and end of the shock are in the same position:
% If the process for the shock of deleverage is defined in column 1 in
% matrix M THEN time at which the process end should be in position 1 in
% vector time_M
time_M= zeros(size(M,2),2);
time_M(1,1)= 0; % Time at which shock for deleverage ends (included)
time_M(1,2)=1; % Time at which shock for deleverage ends (included)

time_M(2,1)= var.T_1;% Time at which shock for zlb starts (included)
time_M(2,2)= var.T_2;% Time at which shock for zlb ends (included)
if strcmp('o',Sim)
 time_M(3,1)= 1;% Time at which shock for zlb ends (included)
end
time_M(4,1)=1;
time_M(4,2)=2;
time_M(5,1)=2;
time_M(5,2)=3;
time_M(6,1)=3;
time_M(6,2)=4;

%% Build the endogenous process:
% Since we define the matrix for ex. state we should re-write matrix A and
% B. Notice that contrained and unconstrained economy have the same A
% matrix while they have different B matrices. Then we should define
% B_tilde matrix as a 3-dimensional matrix. The first matrix (:,:,1) is the
% B matrix from zlb where we leave the equations for the ex. state, hence B
% has dimension NC+NE*NY the second  matrix (:,:,2) is the B outside the
% zlb, again this matrix has dimesion NC+NE * NY.

%% A
A_tilde = A_nzlb (1 : end-NZ ,1 : end-NZ);
%% B
B_tilde = NaN(NC+NE,NY,2);
B_tilde(:,:,1) = B_nzlb ( 1:end -NZ,:);
B_tilde(:,:,2) = B_zlb ( 1:end -NZ,:);
B_tilde(:,:,3) = B_nzlb ( 1:end -NZ,:);

%% Coefficients:
% Outside zlb we KNOW the coefficients for the end. variables processes.
% They are the output of reds and solds and also the basis to build the new
% coefficients. Hence we store them

D_tilde = D(1:NC, :);
G_tilde = G(1:NE , :);

g_x = G_tilde(: , 1:NE);
g_z = G_tilde(: , NE+1:end) * M_z;

h_x = D_tilde(: , 1:NE);
h_z = D_tilde(: , NE+1:end) * M_z;

%% Time_mat
% Imagine to have 1 break in the system of equation, this means that a
% certain time T* the economy pass from a system of equation to another.
% Then Time_Matrix should be defined as 1st position 0 (time1-1), 2nd
% position T*-1 (because you have to write the moment when the old system is still active)
% 3rd position S where S is the time in which simulation end. If you have
% more than one break (imagine T_1* and T_2*) and you know that T_1*<=T_2*
% then Time_mat=[0,T_1*,T_2*,S].

S = 1000; % Last period


Time_Mat= NaN(size(B_tilde,3)+1,1);
Time_Mat(1)= 0;
Time_Mat(2)= var.T_1;
Time_Mat(3)= var.T_2;
Time_Mat(4)= S;

%% Time_Matrices and Irf_fede 
% Description are inside the code, i compare the code with WOODFORD toolbox
% in case of 1 period shock
[F_1 F_2 V_1 V_2 M_tilde H_shock g_shock]= Time_Matrices(A_tilde,B_tilde, NZ,NC,NE,...
    M,time_M,S,h_x,h_z,g_x,g_z,Time_Mat,M_z);
y0=zeros(NC,1);
z0=zeros(NZ,1);
x0=zeros(NE,1);

Irf_db= Irf_fede(H_shock ,g_shock, M_tilde, NC,NE,NX,F_1,F_2,V_1,V_2,M_z,S,x0,z0);
Dummy=NaN(size(Irf_db,1),size(Irf_db,2)+1);
Dummy(:,2:end)=Irf_db(:,1:end);
Dummy(:,1)=[y0;x0;z0];
Irf_db=Dummy;
Irf_d=Irf_db.*(abs((Irf_db))>10.^(-8)) + 0.*(abs((Irf_db))<10.^(-8));
Irf_d(ind_c_b,:)=Irf_d(ind_c_b,:).*var.Y_bar*var.C_b(1)^(-1);
Irf_d(ind_c_s,:)=Irf_d(ind_c_s,:).*var.Y_bar*var.C_s(1)^(-1);

%% CHANGE THE VARIABLES 
% We need to have the debt level
New_irf_lev_d=NaN(2,size(Irf_d,2));
New_irf_lev_d(1,:)=(Irf_d(ind_bgd,:)+ var.Target(1))*100/4;
New_irf_lev_d(2,:) = (Irf_d(ind_b_b,:)+1)*var.D_b(1);
Infi = Irf_d(ind_pi_,:)+ var.Pi_bar-1;
price_d=NaN(1,size(Infi,2));
price_d(1)=exp(Infi(1));
for s= 1:size(Infi,2)-1
    price_d(s+1)= exp(Infi(s+1)+ log(price_d(s)));
end

%% New Variables:
% We want to have the inflation and interest rate target
log_Steady_state=zeros(NY,1);
log_Steady_state(ind_i_b,1)= log(var.i_bar);
log_Steady_state(ind_i_s,1)= log(var.i_bar);
log_Steady_state(ind_pi_,1)= log(var.Pi_bar);
log_Steady_state(ind_r_n,1)= log(1/var.beta);
log_Steady_State_new = log_Steady_state * ones(1,S+1);


New_Irf_d = (exp(Irf_d + log_Steady_State_new)-1)*400.*(abs((exp(Irf_d + log_Steady_State_new)-1)*400)>10.^(-10))...
    + 0.*(abs((exp(Irf_d + log_Steady_State_new)-1)*400)<10.^(-10)) ;

%% Definition
Irf(:,:,ii)= Irf_d(1:ind_l_s,:);
New_Irf(1:ind_r_n,:,ii)= New_Irf_d(1:ind_r_n,:);
price(:,:,ii)= price_d;
New_Irf_lev(:,:,ii)= New_irf_lev_d(:,:);

%% For the natural real rate i apply Woodford definition chapt. 4 pg 248
% hat{r}_t^n = log(1 + r_t^n) + log(beta)

RN(:,ii)=(exp(Irf_d(ind_r_n,:)- log(var.beta))-1)*400;  

end
col=[0. 0.4 0.2; 1 0.4 .2];
s={'-' '--' '-*'};
col=lines(20);
%% GRAPH
Variables_label= { '$Y$' '$\pi$' '$r^n$' '$i^b$' '$i$' '$b^{gdp}$' '$C^b$' '$C^s$'  };
Variables = [ind_y__  ind_pi_ ind_r_n  ind_i_b ind_i_s ind_bgd ind_c_b ind_c_s   ];
fig=figure(1)
fig.Position = [1, 1, 1500, 700];

for i = 1:length(Variables_label)
    subplot(3,3,i)
    hold on
    if i==4 || i==5
         plot(0:Tirf,(exp( log_Steady_State_new(Variables(i),1:Tirf+1))-1)*400,'r','LineWidth',1.5)
       
        for ii=1:size(New_Irf,3)
        
            plot( 0:Tirf,New_Irf(Variables(i),1:Tirf+1,ii),s{ii},'Color',col(ii,:),'LineWidth',1.5)
        
        ylabel('$\%$','Interpreter','LaTex','FontSize',16)
        end
        
        
    elseif i==7 || i==8 
         plot(0:Tirf,zeros(Tirf+1,1),'r','LineWidth',1.5)
   
        for ii=1:size(Irf,3)
         plot( 0:Tirf,Irf(Variables(i),1:Tirf+1,ii)*100,s{ii},'Color',col(ii,:),'LineWidth',1.5)
       
         ylabel('$\%$ ','Interpreter','LaTex','FontSize',16)
         end
        
    elseif i==2
         plot(0:Tirf,(exp( log_Steady_State_new(Variables(i),1:Tirf+1))-1)*400,'r','LineWidth',1.5)
         for ii=1:size(New_Irf,3)
        plot( 0:Tirf,New_Irf(Variables(i),1:Tirf+1,ii),s{ii},'Color',col(ii,:),'LineWidth',1.5)
       
        ylabel('$\%$ ','Interpreter','LaTex','FontSize',16)

         end
       
    ylim([-0.5 3])
    elseif i==3
         for ii=1:size(New_Irf,3)
        plot( 0:Tirf,RN(1:Tirf+1,ii),s{ii},'Color',col(ii,:),'LineWidth',1.5)
        plot(0:Tirf,((var.beta^(-1) -1)*400*ones(Tirf+1,1)),'r','LineWidth',1.5)
        ylabel('$\%$ ','Interpreter','LaTex','FontSize',16)
         end
        %plot(0:Tirf,(exp( log_Steady_State_new(Variables(i),1:Tirf+1))-1)*400,'r')
    elseif i==1
         plot(0:Tirf,zeros(Tirf+1,1),'r','LineWidth',1.5)
       
        for ii=1:size(Irf,3)
       ph1(ii,:)=  plot( 0:Tirf,Irf(Variables(i),1:Tirf+1,ii)*100,s{ii},'Color',col(ii,:),'LineWidth',1.5)
         ylabel('$\%$ ','Interpreter','LaTex','FontSize',16)
        end
        ylim([-8 2])
    elseif i==6
        for ii=1:size(Irf,3)
           
            plot( 0:Tirf,New_Irf_lev(1,1:Tirf+1,ii),s{ii},'Color',col(ii,:),'LineWidth',1.5)
          if ii==2
         plot(0:Tirf,88*ones(Tirf+1,1),'r','LineWidth',1.)
            end
         ylabel('$\%$','Interpreter','LaTex','FontSize',16)
        end
       
    
     
    end      
         
         
        
  
     if i==7 ||  i==8
         
  xlabel('Quarters','Interpreter','LaTex','FontSize',16)
     end
    hold off
     title(Variables_label(i),'Interpreter','LaTex','FontSize',16)
      %if i==8
       %   legend(l,'Location','NorthEastOutside','Interpreter','LaTex','FontSize',10)
%legend boxoff
      %end
end

        
sh=subplot(3,3,9);
p=get(sh,'position');
     lh=legend(sh,[ph1(1,:) ph1(2,:)],{'Inflation Targeting ' 'Optimal Policy'},'Interpreter','LaTex','FontSize',16);
     set(lh,'position',p);
     axis(sh,'off'); 
