clear;
clc;
%% MASTER CODE:
% to use together with:
% reds and solds from Woodford website;
% 1. Steady_State;
% 2. Matrix_build_Inflation;
% 3. Time_Matrices_b
% 4. Irf_fede
%% NAME and add path
addpath(strcat(pwd,'/REProgram')); 
addpath(strcat(pwd,'/Myfile')); 
%% Exogenous Parameters

Tirf=30;% 


%% Exogenous Parameters
                                              % Debt over GDP
var.eta=1.; % Labor Disutility
var.rho= 1.5; % Relative Risk Aversion
var.sigma=1/var.rho; % Inverse of Relative Risk Aversion
var.k=.02;
var.chi= 0.61; % Portion of Borrowers
var.Pi_bar = 1 + 0.02/4; % Inflation
var.beta=(1/(1 + .015/4)); % Discount Factor

var.i_bar= var.Pi_bar/var.beta; % Nominal Interest Rate
var.theta= 7.88; % Elasticity
Sim_d=['i' ];
Span=1000;

%% TIME FOR THE SIMULATION IN THE GRAPH



%% TIME 
% T is the time in which the shock on the safe level of the debt, d_t, hit
% the economy
% T_1+1 is the time in which the economy enter in zlb, T_2+1 is the time in which
% economy exit from zlb
var.T=1;
var.T_1=0;%% TIME IN WHICH ECONOMY ENTER IN ZLB



lambda_o=0;
ep=0;
epsi=1;
%load('l')
% 
% lambdaha=[.145:0.001:.165];
% phis=[.04:.005:.07];
phis =[.006:.0002:.008];
nuha =[.02:.0005:.025];
First=[1.0773];


for kk=1:length(phis)   
for jj=1:length(First)
for ii=1:length(nuha)
    
   var.Target=[First(jj)*4;.88*4]; 
   %% STEADY STATE
[var] = Steady_State(var);
%% LEAVE AFTER
var.b= var.D_b(1)/var.Y_bar;

    Sim='i';
    epsi=1;
    t1=0;
%% Intermediate Parameters
%% SHOCK
while epsi>10^(-5)
var.v= (var.D_b(2)-var.D_b(1))/(var.Y_bar);



%var.phi = .0474/(4*abs(var.v));
var.phi = phis(kk);

var.nu=nuha(ii);


if var.T<1
var.v= 0;
end

if strcmp('o',Sim)
C_b_r=  (var.C_b(2) -var.C_b(1))/var.Y_bar;
C_s_r=  (var.C_s(2) -var.C_s(1))/var.Y_bar;
var.epsilonc= C_b_r - C_s_r;% Shock on consumption
end
%% Derived Parameters
var.lb= var.Y_bar/var.L_b(1);
var.ls= var.Y_bar/var.L_s(1);


%% BUILD THE MATRIX AND THE INDEX
if strcmp('o',Sim)
[A B C NY NK NX A_nzlb B_nzlb B_zlb Indicator_Variables]= Matrix_Build_optimal(var);
var.T_2=t1; %% TIME IN WHICH ECONOMY EXIT (INCLUDED)
l{ii}='Optimal Policy';

else
[A B C A_nzlb B_nzlb B_zlb Indicator_Variables NY NX NK ]= Matrix_build_Inflation(var);
var.T_2=t1; %% TIME IN WHICH ECONOMY EXIT (INCLUDED)
l{ii}='IT';
if var.T_2<1 
    OutputTar=0;
end
end
%% Indicator
% You find the meaning inside Matrix_Build_Inflation
   
for i=0:length(Indicator_Variables)/3-1
eval(['ind_' Indicator_Variables(3*i+1:3*(i+1)) '=' num2str(i+1) ';']);

end      

%% WOODFORD      
reds;
solds;


%% Drop the imaginary part

if abs( max(max(imag(D)))) < 10^(-13)
    D=real(D);
end

if abs(max(max(imag(G)))) < 10^(-13)
    G=real(G);
end


%% Build exogenous process

NC= NY - NK; % # of controls
NE = NK - NX; % # of endogenous state;
NZ = NX; % # of exogenous state


%% Built the matrices:
M_z= round(G(NE+1:end,NE+1:end));
%% 2. Exogenous State shock
NS = 3; % #s of shocks NS<=NZ


for i = 1:NS

eval(['M_' num2str(i) '=  zeros(NZ,1);' ]);
end

M_1(ind_d_t - NC -NE,1)= var.v; % for z
M_2(ind_iss - NC -NE,1)= - log(var.i_bar); % for i_bar
if strcmp('o',Sim)
M_3(ind_c_r - NC -NE,1)=var.epsilonc; % for i_bar
end    

M_4 (ind_d_t - NC -NE,1)= var.v*0;
M_5 (ind_d_t - NC -NE,1)= var.v*0; 
M_6 (ind_d_t - NC -NE,1)= var.v*0; 
M = [M_1 M_2 M_3 M_4 M_5 M_6];
 

%M = [M_1 M_2 M_3];
% NB:
% It is important that shock and end of the shock are in the same position:
% If the process for the shock of deleverage is defined in column 1 in
% matrix M THEN time at which the process end should be in position 1 in
% vector time_M
time_M= zeros(size(M,2),2);
time_M(1,1)= 0; 
time_M(1,2)= var.T; % Time at which shock for deleverage ends (included)
time_M(2,1)= var.T_1;% Time at which shock for zlb starts (included)
time_M(2,2)= var.T_2;% Time at which shock for zlb ends (included)
if strcmp('o',Sim)
 time_M(3,1)= 1;% Time at which shock for zlb ends (included)
end
time_M(4,1)=1;
time_M(4,2)=2;
time_M(5,1)=2;
time_M(5,2)=3;
time_M(6,1)=3;
time_M(6,2)=4;
%% Build the endogenous process:
% Since we define the matrix for ex. state we should re-write matrix A and
% B. Notice that contrained and unconstrained economy have the same A
% matrix while they have different B matrices. Then we should define
% B_tilde matrix as a 3-dimensional matrix. The first matrix (:,:,1) is the
% B matrix from zlb where we leave the equations for the ex. state, hence B
% has dimension NC+NE*NY the second  matrix (:,:,2) is the B outside the
% zlb, again this matrix has dimesion NC+NE * NY.

%% A
A_tilde = A_nzlb (1 : end-NZ ,1 : end-NZ);
%% B
B_tilde = NaN(NC+NE,NY,2);
B_tilde(:,:,1) = B_nzlb ( 1:end -NZ,:);
B_tilde(:,:,2) = B_zlb ( 1:end -NZ,:);
B_tilde(:,:,3) = B_nzlb ( 1:end -NZ,:);

%% Coefficients:
% Outside zlb we KNOW the coefficients for the end. variables processes.
% They are the output of reds and solds and also the basis to build the new
% coefficients. Hence we store them

D_tilde = D(1:NC, :);
G_tilde = G(1:NE , :);

g_x = G_tilde(: , 1:NE);
g_z = G_tilde(: , NE+1:end) * M_z;

h_x = D_tilde(: , 1:NE);
h_z = D_tilde(: , NE+1:end) * M_z;

%% Time_mat
% Imagine to have 1 break in the system of equation, this means that a
% certain time T* the economy pass from a system of equation to another.
% Then Time_Matrix should be defined as 1st position 0 (time1-1), 2nd
% position T*-1 (because you have to write the moment when the old system is still active)
% 3rd position S where S is the time in which simulation end. If you have
% more than one break (imagine T_1* and T_2*) and you know that T_1*<=T_2*
% then Time_mat=[0,T_1*,T_2*,S].

S = 1000; % Last period


Time_Mat= NaN(size(B_tilde,3)+1,1);
Time_Mat(1)= 0;
Time_Mat(2)= var.T_1;
Time_Mat(3)= var.T_2;
Time_Mat(4)= S;

%% Time_Matrices and Irf_fede 
% Description are inside the code, i compare the code with WOODFORD toolbox
% in case of 1 period shock
[F_1 F_2 V_1 V_2 M_tilde H_shock g_shock]= Time_Matrices(A_tilde,B_tilde, NZ,NC,NE,...
    M,time_M,S,h_x,h_z,g_x,g_z,Time_Mat,M_z);
y0=zeros(NC,1);
z0=zeros(NZ,1);
x0=zeros(NE,1);

Irf_db= Irf_fede(H_shock ,g_shock, M_tilde, NC,NE,NX,F_1,F_2,V_1,V_2,M_z,S,x0,z0);
Dummy=NaN(size(Irf_db,1),size(Irf_db,2)+1);
Dummy(:,2:end)=Irf_db(:,1:end);
Dummy(:,1)=[y0;x0;z0];
Irf_db=Dummy;
Irf_d=Irf_db.*(abs((Irf_db))>10.^(-8)) + 0.*(abs((Irf_db))<10.^(-8));
Irf_d(ind_c_b,:)=Irf_d(ind_c_b,:).*var.Y_bar*var.C_b(1)^(-1);
Irf_d(ind_c_s,:)=Irf_d(ind_c_s,:).*var.Y_bar*var.C_s(1)^(-1);

%% CHANGE THE VARIABLES 
% We need to have the debt level
New_irf_lev_d=NaN(2,size(Irf_d,2));
New_irf_lev_d(1,:)=(Irf_d(ind_bgd,:)+var.Target(1))*100/4;
New_irf_lev_d(2,:) = (Irf_d(ind_b_b,:)+1)*var.D_b(1);
Infi = Irf_d(ind_pi_,:)+ var.Pi_bar-1;
price_d=NaN(1,size(Infi,2));
price_d(1)=exp(Infi(1));
for s= 1:size(Infi,2)-1
    price_d(s+1)= exp(Infi(s+1)+ log(price_d(s)));
end

%% New Variables:
% We want to have the inflation and interest rate target
log_Steady_state=zeros(NY,1);
log_Steady_state(ind_i_b,1)= log(var.i_bar);
log_Steady_state(ind_i_s,1)= log(var.i_bar);
log_Steady_state(ind_pi_,1)= log(var.Pi_bar);
log_Steady_state(ind_r_n,1)= log(1/var.beta);
log_Steady_State_new = log_Steady_state * ones(1,S+1);


New_Irf_d = (exp(Irf_d + log_Steady_State_new)-1)*400.*(abs((exp(Irf_d + log_Steady_State_new)-1)*400)>10.^(-10))...
    + 0.*(abs((exp(Irf_d + log_Steady_State_new)-1)*400)<10.^(-10)) ;

%% Definition
Irf(:,:,ii,jj,kk)= Irf_d(1:ind_l_s,:);
New_Irf(1:ind_r_n,:,ii,jj,kk)= New_Irf_d(1:ind_r_n,:);
price(:,:,ii,jj)= price_d;
New_Irf_lev(:,:,ii,jj,kk)= New_irf_lev_d(:,:);

%% For the natural real rate i apply Woodford definition chapt. 4 pg 248
% hat{r}_t^n = log(1 + r_t^n) + log(beta)

RN(:,ii,jj)=(exp(Irf_d(ind_r_n,:)- log(var.beta))-1)*400;  
 AA=min(New_Irf(ind_i_s,:,ii,jj,kk));
 

 if AA<0
     t1=t1+1;
 else
     epsi=0;
      t1
 end

end
ep=Irf(ind_y__,2)*100-OutputTar;
epsi= abs(ep);

   lambda_o= var.nu/var.phi;
   
       
    if strcmp('o',Sim_d)
        epsi=0;
    end
    
      if var.T<1
         epsi=0;
      end
    
      TT(ii,jj,kk)=t1;
      Y(ii,jj)=Irf(ind_y__,2,ii,jj);
      PI(ii,jj)=New_Irf(ind_pi_,2,ii,jj);
      RNl(ii,jj)=RN(2,ii,jj); 
      DEBTo(:,ii,jj,kk)= New_Irf_lev(1,:,ii,jj,kk);
      IB(:,ii,jj,kk)=New_Irf(ind_i_b,:,ii,jj,kk);
      load spread_debt
    
      
      epsio(ii,jj,kk)=sqrt(sum((DEBTo(2:size(debtm)+1,ii,jj,kk)-debtm).^2)./length(debtm));
      epsiu(ii,jj,kk)= sqrt(sum((IB(2:size(spread)+1,ii,jj,kk)-spread).^2)./length(spread));
      een(ii,jj,kk)=    epsio(ii,jj,kk)+ epsiu(ii,jj,kk);
   
end

end

end

ee=reshape(een,[length(lambdaha),length(phis)]);

[a1 b1] = min(epsio);
[a2 b2] = min(epsiu);
[a1 c1] = min(min(epsio));
[a2 c2] = min(min(epsiu));
[a1 d1] = min(min(min(epsio)));
[a2 d2] = min(min(min(epsiu)));
%[a3 b3] = min(ee);

[a3 c3] = min(ee);
[a3 d3] = min(min(ee));



display('\phi')
phis(d3)
display('\lambda')
lambdaha(c3(d3))