function [residual, g1, g2, g3] = Ramsey_dynamic(y, x, params, steady_state, it_)
%
% Status : Computes dynamic model for Dynare
%
% Inputs :
%   y         [#dynamic variables by 1] double    vector of endogenous variables in the order stored
%                                                 in M_.lead_lag_incidence; see the Manual
%   x         [nperiods by M_.exo_nbr] double     matrix of exogenous variables (in declaration order)
%                                                 for all simulation periods
%   steady_state  [M_.endo_nbr by 1] double       vector of steady state values
%   params    [M_.param_nbr by 1] double          vector of parameter values in declaration order
%   it_       scalar double                       time period for exogenous variables for which to evaluate the model
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the dynamic model equations in order of 
%                                          declaration of the equations.
%                                          Dynare may prepend auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by #dynamic variables] double    Jacobian matrix of the dynamic model equations;
%                                                           rows: equations in order of declaration
%                                                           columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g2        [M_.endo_nbr by (#dynamic variables)^2] double   Hessian matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g3        [M_.endo_nbr by (#dynamic variables)^3] double   Third order derivative matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

%
% Model equations
%

residual = zeros(45, 1);
T28 = params(2)*((1-y(20))/y(15)+y(20)/y(16));
T30 = 1/y(2);
T50 = y(17)/y(3);
T59 = params(7)/(1-params(7));
T60 = y(19)^T59;
T72 = 1/(1-params(7));
T73 = params(6)^T72;
T81 = y(63)^T59;
T97 = (1-(1-params(9))*y(4))^params(7);
T98 = (y(21)-(1-params(9))*y(4))/T97;
T117 = params(15)*(1+y(68))^params(14);
T124 = params(15)*(1+y(68))^(params(14)-1);
T146 = (1+y(28))^params(14);
T168 = y(32)/params(18);
T171 = y(33)/params(3);
T172 = T171^(-1);
T178 = params(3)^params(19);
T193 = params(20)/(1-params(4));
T216 = params(23)^(-1);
T226 = 1/y(15);
T235 = (-(T73*(-(1-params(10)))/params(8)));
T242 = params(2)*(-(1-y(20)))/(y(15)*y(15));
T244 = (-(T242/T30));
T255 = params(2)*((1-y(64))/y(59)+y(64)/y(60));
T256 = (-1)/(y(15)*y(15));
T259 = T226*T226;
T271 = 1/y(16);
T273 = (-((1-y(21))*T271));
T278 = params(2)*(-y(20))/(y(16)*y(16));
T280 = (-(T278/T30));
T287 = (-(T193*getPowerDeriv(y(17),1-params(4),1)));
T290 = 1/y(3);
T291 = getPowerDeriv(T50,(-params(4)),1);
T300 = (-y(61))/(y(17)*y(17));
T302 = getPowerDeriv(y(61)/y(17),(-params(4)),1);
T319 = params(15)*T146;
T327 = params(15)*(1+y(28))^(params(14)-1);
T335 = getPowerDeriv(y(19),T59,1);
T366 = params(2)*(T271+(-1)/y(15));
T381 = 1/T97;
T382 = getPowerDeriv(T98,T72,1);
T386 = (-(exp(y(34))/y(27)-y(15)));
T397 = (1-y(21)*(1-params(9)))^params(7);
T403 = (-(1-params(9)))*getPowerDeriv(1-y(21)*(1-params(9)),params(7),1);
T407 = (T397*(-(1-params(9)))-(y(65)-y(21)*(1-params(9)))*T403)/(T397*T397);
T408 = (y(65)-y(21)*(1-params(9)))/T397;
T409 = getPowerDeriv(T408,T72,1);
T428 = (-(T73*exp(y(34))*(1-params(10))/params(8)));
T429 = y(41)*T428;
T435 = (-((1-params(15))*getPowerDeriv(y(24),(-params(14)),1)));
T441 = (-((1-params(15))*getPowerDeriv(y(24),1-params(14),1)));
T447 = (-(params(14)*(1-params(16))/((params(14)-1)*y(26))));
T461 = (-((-(params(14)*(1-params(16))*y(25)*(params(14)-1)))/((params(14)-1)*y(26)*(params(14)-1)*y(26))));
T474 = (-(y(21)*(-exp(y(34)))/(y(27)*y(27))));
T475 = y(39)*T474;
T484 = getPowerDeriv(1+y(28),params(14),1);
T490 = (-(params(15)*getPowerDeriv(1+y(28),(-(1-params(14))),1)));
T506 = params(15)*getPowerDeriv(1+y(28),params(14)-1,1);
T545 = (-(T178*getPowerDeriv(y(33),1-params(19),1)));
T547 = 1/params(3);
T549 = T547*getPowerDeriv(T171,(-1),1);
T561 = (-(T73*(1-params(10))*exp(y(34))*y(23)/params(8)));
T564 = (-(y(21)*exp(y(34))/y(27)));
T567 = y(54)*(-(y(21)*exp(y(34))))+y(41)*T561+y(39)*T564;
residual(1) = y(37)*y(58)/(1+y(68));
residual(2) = y(38)+T216*y(8)*(1+y(1))/(1+y(28));
residual(3) = y(55)*(-(y(21)*T226))+y(53)+y(41)*T235+y(21)*y(39)+y(38)*T244+y(36)*(-params(1))+params(23)*y(70)*(-((-(T255*T256))/T259));
residual(4) = y(55)*T273+y(36)+y(38)*T280;
residual(5) = y(55)*T287+y(40)*(-(params(2)*T290*T291))+y(39)+params(23)*y(71)*(-(params(2)*T300*T302));
residual(6) = y(40)+T216*y(9)*(-(T60*(1-params(9))))+T216*y(10)*(-(y(25)*T319))+T216*y(11)*(-(y(26)*T327));
residual(7) = y(51)*(-(params(8)*T335/T73))+y(43)*(-(1-y(4)))+params(9)*y(42)+y(41)*T335+T216*y(9)*(-(T335*y(18)*(1-params(9))))+T216*y(12)*(-(y(31)*(-params(2))));
residual(8) = T216*y(12)*(-(y(31)*(-params(2))))+y(4)*y(43)+y(42)+y(38)*(-(T366/T30));
residual(9) = y(55)*(-(log(y(15))-log(y(16))))+y(54)*(-exp(y(34)))+y(44)*(-(T381*T382))+y(43)+y(39)*T386+params(23)*y(72)*(-(1-y(64)-y(63)))+params(23)*y(73)*(-(T407*T409));
residual(10) = y(44)+params(8)*y(39);
residual(11) = y(46)*(-y(29))+T429;
residual(12) = y(49)*T435+y(45)+y(48)*T441;
residual(13) = y(46)+y(45)*T447+T216*y(10)*(-(y(18)*T319));
residual(14) = y(47)+y(45)*T461+T216*y(11)*(-(y(18)*T327));
residual(15) = y(29)*y(54)+y(49)+T475+params(23)*y(74)*(-T117);
residual(16) = y(49)*(-(params(15)*y(5)*T484))+y(48)*T490+T216*y(8)*(-(y(14)*(1+y(1))))/((1+y(28))*(1+y(28)))+T216*y(10)*(-(y(25)*y(18)*params(15)*T484))+T216*y(11)*(-(y(26)*y(18)*T506));
residual(17) = y(27)*y(54)+(-y(47))+y(46)*(-y(23));
residual(18) = 1+y(55);
residual(19) = y(52)*1/params(17)+y(50)+T216*y(12)*(-(params(2)*(1-y(20)-y(19))));
residual(20) = y(51)+y(52)*(-(T172*1/params(18)));
residual(21) = y(53)*T545+y(52)*(-(T168*T549));
residual(22) = y(56)+T567+params(23)*y(75)*(-params(21));
residual(23) = y(57)+y(41)*T235+params(23)*y(76)*(-params(22));
residual(24) = y(16)-params(1)*y(15);
residual(25) = y(58)*(1+y(13))/(1+y(68))-1;
residual(26) = y(14)-T28/T30;
residual(27) = y(17)-(y(21)*(exp(y(34))/y(27)-y(15))-params(8)*y(22)+params(5));
residual(28) = y(18)-params(2)*T50^(-params(4));
residual(29) = T60-((1-params(10))*(exp(y(34))*y(23)-y(15)+params(11)-y(35))*T73/params(8)+(1-params(9))*y(62)*T81);
residual(30) = y(20)-params(9)*(1-y(19));
residual(31) = y(21)-((1-y(20))*y(4)+y(19)*(1-y(4)));
residual(32) = y(22)-T98^T72;
residual(33) = y(24)-params(14)*(1-params(16))*y(25)/((params(14)-1)*y(26));
residual(34) = y(25)-(y(23)*y(29)+y(62)*T117*y(66));
residual(35) = y(26)-(y(29)+y(62)*T124*y(67));
residual(36) = 1-((1-params(15))*y(24)^(1-params(14))+params(15)*(1+y(28))^(-(1-params(14))));
residual(37) = y(27)-((1-params(15))*y(24)^(-params(14))+params(15)*y(5)*T146);
residual(38) = y(31)-((-log(params(1)))+params(2)*(1-y(64)-y(63))*y(69));
residual(39) = y(32)-params(8)*T60/T73;
residual(40) = y(31)/params(17)-T168*T172;
residual(41) = y(15)-y(33)^(1-params(19))*T178;
residual(42) = y(27)*y(29)-y(21)*exp(y(34));
residual(43) = y(30)-(y(21)*log(y(15))+(1-y(21))*log(y(16))+T193*y(17)^(1-params(4)));
residual(44) = y(34)-(params(21)*y(6)-x(it_, 1));
residual(45) = y(35)-(params(22)*y(7)+x(it_, 2));
if nargout >= 2,
  g1 = zeros(45, 78);

  %
  % Jacobian matrix
  %

T642 = (-1)/(y(2)*y(2));
T647 = (-((-(T242*T642))/(T30*T30)));
T652 = (-((-(T278*T642))/(T30*T30)));
T657 = (-((-(T366*T642))/(T30*T30)));
T673 = (-(params(2)*(-((-(1-y(20)))*(y(15)+y(15))))/(y(15)*y(15)*y(15)*y(15))/T30));
T676 = (y(15)+y(15))/(y(15)*y(15)*y(15)*y(15));
T686 = (-((T259*(-(T255*T676))-(-(T255*T256))*(T226*T256+T226*T256))/(T259*T259)));
T694 = (-(params(2)*1/(y(15)*y(15))/T30));
T695 = y(38)*T694;
T707 = (-((-(T256*params(2)*(-(1-y(64)))/(y(59)*y(59))))/T259));
T712 = (-((1-y(21))*(-1)/(y(16)*y(16))));
T721 = (-(params(2)*(-((-y(20))*(y(16)+y(16))))/(y(16)*y(16)*y(16)*y(16))/T30));
T726 = (-(params(2)*(-1)/(y(16)*y(16))/T30));
T727 = y(38)*T726;
T737 = (-((-(T256*params(2)*(-y(64))/(y(60)*y(60))))/T259));
T741 = (-1)/(y(3)*y(3));
T743 = (-y(17))/(y(3)*y(3));
T744 = getPowerDeriv(T50,(-params(4)),2);
T757 = (-(T193*getPowerDeriv(y(17),1-params(4),2)));
T768 = (-((-y(61))*(y(17)+y(17))))/(y(17)*y(17)*y(17)*y(17));
T769 = getPowerDeriv(y(61)/y(17),(-params(4)),2);
T780 = (-1)/(y(17)*y(17));
T781 = 1/y(17);
T815 = getPowerDeriv(y(19),T59,2);
T831 = getPowerDeriv(y(63),T59,1);
T840 = params(2)*((-1)/y(59)+1/y(60));
T848 = (-(1-params(9)))*getPowerDeriv(1-(1-params(9))*y(4),params(7),1);
T851 = (-T848)/(T97*T97);
T855 = (T97*(-(1-params(9)))-(y(21)-(1-params(9))*y(4))*T848)/(T97*T97);
T856 = getPowerDeriv(T98,T72,2);
T857 = T855*T856;
T874 = (-(1-params(9)))*(-(1-params(9)))*getPowerDeriv(1-y(21)*(1-params(9)),params(7),2);
T877 = (-(1-params(9)))*T403-((-(1-params(9)))*T403+(y(65)-y(21)*(1-params(9)))*T874);
T884 = (T397*T397*T877-(T397*(-(1-params(9)))-(y(65)-y(21)*(1-params(9)))*T403)*(T397*T403+T397*T403))/(T397*T397*T397*T397);
T885 = getPowerDeriv(T408,T72,2);
T894 = (-((-exp(y(34)))/(y(27)*y(27))));
T895 = y(39)*T894;
T896 = (-(exp(y(34))/y(27)));
T898 = y(54)*(-exp(y(34)))+y(39)*T896;
T901 = (-T403)/(T397*T397);
T902 = 1/T397;
T914 = (-((1-params(15))*getPowerDeriv(y(24),(-params(14)),2)));
T918 = (-((1-params(15))*getPowerDeriv(y(24),1-params(14),2)));
T924 = (-((-(params(14)*(1-params(16))*(params(14)-1)))/((params(14)-1)*y(26)*(params(14)-1)*y(26))));
T925 = y(45)*T924;
T934 = (params(14)-1)*y(26)*(params(14)-1)*y(26)*(params(14)-1)*y(26)*(params(14)-1)*y(26);
T936 = (-((-((-(params(14)*(1-params(16))*y(25)*(params(14)-1)))*((params(14)-1)*(params(14)-1)*y(26)+(params(14)-1)*(params(14)-1)*y(26))))/T934));
T950 = (-(y(21)*(-((-exp(y(34)))*(y(27)+y(27))))/(y(27)*y(27)*y(27)*y(27))));
T951 = y(39)*T950;
T952 = getPowerDeriv(1+y(28),params(14),2);
T958 = (-(params(15)*getPowerDeriv(1+y(28),(-(1-params(14))),2)));
T963 = (1+y(28))*(1+y(28))*(1+y(28))*(1+y(28));
T975 = params(15)*getPowerDeriv(1+y(28),params(14)-1,2);
T986 = (-y(58))/((1+y(68))*(1+y(68)));
T989 = params(15)*getPowerDeriv(1+y(68),params(14),1);
T999 = params(15)*getPowerDeriv(1+y(68),params(14)-1,1);
T1005 = (-(1/params(18)*T549));
T1009 = (-(T178*getPowerDeriv(y(33),1-params(19),2)));
T1013 = T547*T547*getPowerDeriv(T171,(-1),2);
  g1(1,58)=y(37)*1/(1+y(68));
  g1(1,68)=y(37)*T986;
  g1(1,37)=y(58)/(1+y(68));
  g1(2,1)=T216*y(8)*1/(1+y(28));
  g1(2,28)=T216*y(8)*(-(1+y(1)))/((1+y(28))*(1+y(28)));
  g1(2,8)=T216*(1+y(1))/(1+y(28));
  g1(2,38)=1;
  g1(3,2)=y(38)*T647;
  g1(3,15)=y(55)*(-(y(21)*T256))+y(38)*T673+params(23)*y(70)*T686;
  g1(3,59)=params(23)*y(70)*T707;
  g1(3,60)=params(23)*y(70)*T737;
  g1(3,20)=T695;
  g1(3,64)=params(23)*y(70)*(-((-(T256*T840))/T259));
  g1(3,21)=y(39)+y(55)*(-T226);
  g1(3,36)=(-params(1));
  g1(3,38)=T244;
  g1(3,70)=params(23)*(-((-(T255*T256))/T259));
  g1(3,39)=y(21);
  g1(3,41)=T235;
  g1(3,53)=1;
  g1(3,55)=(-(y(21)*T226));
  g1(4,2)=y(38)*T652;
  g1(4,16)=y(55)*T712+y(38)*T721;
  g1(4,20)=T727;
  g1(4,21)=y(55)*T271;
  g1(4,36)=1;
  g1(4,38)=T280;
  g1(4,55)=T273;
  g1(5,3)=y(40)*(-(params(2)*(T291*T741+T290*T743*T744)));
  g1(5,17)=y(55)*T757+y(40)*(-(params(2)*T290*T290*T744))+params(23)*y(71)*(-(params(2)*(T302*T768+T300*T300*T769)));
  g1(5,61)=params(23)*y(71)*(-(params(2)*(T302*T780+T300*T769*T781)));
  g1(5,39)=1;
  g1(5,40)=(-(params(2)*T290*T291));
  g1(5,71)=params(23)*(-(params(2)*T300*T302));
  g1(5,55)=T287;
  g1(6,19)=T216*y(9)*(-((1-params(9))*T335));
  g1(6,25)=T216*y(10)*(-T319);
  g1(6,26)=T216*y(11)*(-T327);
  g1(6,28)=T216*y(10)*(-(y(25)*params(15)*T484))+T216*y(11)*(-(y(26)*T506));
  g1(6,40)=1;
  g1(6,9)=T216*(-(T60*(1-params(9))));
  g1(6,10)=T216*(-(y(25)*T319));
  g1(6,11)=T216*(-(y(26)*T327));
  g1(7,18)=T216*y(9)*(-((1-params(9))*T335));
  g1(7,19)=y(51)*(-(params(8)*T815/T73))+y(41)*T815+T216*y(9)*(-(y(18)*(1-params(9))*T815));
  g1(7,4)=y(43);
  g1(7,31)=T216*params(2)*y(12);
  g1(7,9)=T216*(-(T335*y(18)*(1-params(9))));
  g1(7,41)=T335;
  g1(7,42)=params(9);
  g1(7,43)=(-(1-y(4)));
  g1(7,12)=T216*(-(y(31)*(-params(2))));
  g1(7,51)=(-(params(8)*T335/T73));
  g1(8,2)=y(38)*T657;
  g1(8,15)=T695;
  g1(8,16)=T727;
  g1(8,4)=y(43);
  g1(8,31)=T216*params(2)*y(12);
  g1(8,38)=(-(T366/T30));
  g1(8,42)=1;
  g1(8,43)=y(4);
  g1(8,12)=T216*(-(y(31)*(-params(2))));
  g1(9,15)=y(39)+y(55)*(-T226);
  g1(9,16)=y(55)*T271;
  g1(9,63)=params(23)*y(72);
  g1(9,64)=params(23)*y(72);
  g1(9,4)=y(44)*(-(T382*T851+T381*T857));
  g1(9,21)=y(44)*(-(T381*T381*T856))+params(23)*y(73)*(-(T409*T884+T407*T407*T885));
  g1(9,65)=params(23)*y(73)*(-(T409*T901+T407*T885*T902));
  g1(9,27)=T895;
  g1(9,34)=T898;
  g1(9,39)=T386;
  g1(9,43)=1;
  g1(9,72)=params(23)*(-(1-y(64)-y(63)));
  g1(9,44)=(-(T381*T382));
  g1(9,73)=params(23)*(-(T407*T409));
  g1(9,54)=(-exp(y(34)));
  g1(9,55)=(-(log(y(15))-log(y(16))));
  g1(10,39)=params(8);
  g1(10,44)=1;
  g1(11,29)=(-y(46));
  g1(11,34)=T429;
  g1(11,41)=T428;
  g1(11,46)=(-y(29));
  g1(12,24)=y(49)*T914+y(48)*T918;
  g1(12,45)=1;
  g1(12,48)=T441;
  g1(12,49)=T435;
  g1(13,18)=T216*y(10)*(-T319);
  g1(13,26)=T925;
  g1(13,28)=T216*y(10)*(-(y(18)*params(15)*T484));
  g1(13,45)=T447;
  g1(13,10)=T216*(-(y(18)*T319));
  g1(13,46)=1;
  g1(14,18)=T216*y(11)*(-T327);
  g1(14,25)=T925;
  g1(14,26)=y(45)*T936;
  g1(14,28)=T216*y(11)*(-(y(18)*T506));
  g1(14,45)=T461;
  g1(14,11)=T216*(-(y(18)*T327));
  g1(14,47)=1;
  g1(15,21)=T895;
  g1(15,27)=T951;
  g1(15,68)=params(23)*y(74)*(-T989);
  g1(15,29)=y(54);
  g1(15,34)=T475;
  g1(15,39)=T474;
  g1(15,49)=1;
  g1(15,74)=params(23)*(-T117);
  g1(15,54)=y(29);
  g1(16,1)=T216*y(8)*(-y(14))/((1+y(28))*(1+y(28)));
  g1(16,14)=T216*y(8)*(-(1+y(1)))/((1+y(28))*(1+y(28)));
  g1(16,18)=T216*y(10)*(-(y(25)*params(15)*T484))+T216*y(11)*(-(y(26)*T506));
  g1(16,25)=T216*y(10)*(-(y(18)*params(15)*T484));
  g1(16,26)=T216*y(11)*(-(y(18)*T506));
  g1(16,5)=y(49)*(-(params(15)*T484));
  g1(16,28)=y(49)*(-(params(15)*y(5)*T952))+y(48)*T958+T216*y(8)*(-((-(y(14)*(1+y(1))))*(1+y(28)+1+y(28))))/T963+T216*y(10)*(-(y(25)*y(18)*params(15)*T952))+T216*y(11)*(-(y(26)*y(18)*T975));
  g1(16,8)=T216*(-(y(14)*(1+y(1))))/((1+y(28))*(1+y(28)));
  g1(16,10)=T216*(-(y(25)*y(18)*params(15)*T484));
  g1(16,11)=T216*(-(y(26)*y(18)*T506));
  g1(16,48)=T490;
  g1(16,49)=(-(params(15)*y(5)*T484));
  g1(17,23)=(-y(46));
  g1(17,27)=y(54);
  g1(17,46)=(-y(23));
  g1(17,47)=(-1);
  g1(17,54)=y(27);
  g1(18,55)=1;
  g1(19,19)=T216*params(2)*y(12);
  g1(19,20)=T216*params(2)*y(12);
  g1(19,12)=T216*(-(params(2)*(1-y(20)-y(19))));
  g1(19,50)=1;
  g1(19,52)=1/params(17);
  g1(20,33)=y(52)*T1005;
  g1(20,51)=1;
  g1(20,52)=(-(T172*1/params(18)));
  g1(21,32)=y(52)*T1005;
  g1(21,33)=y(53)*T1009+y(52)*(-(T168*T1013));
  g1(21,52)=(-(T168*T549));
  g1(21,53)=T545;
  g1(22,21)=T898;
  g1(22,23)=T429;
  g1(22,27)=T475;
  g1(22,34)=T567;
  g1(22,39)=T564;
  g1(22,41)=T561;
  g1(22,54)=(-(y(21)*exp(y(34))));
  g1(22,56)=1;
  g1(22,75)=params(23)*(-params(21));
  g1(23,41)=T235;
  g1(23,57)=1;
  g1(23,76)=params(23)*(-params(22));
  g1(24,15)=(-params(1));
  g1(24,16)=1;
  g1(25,13)=y(58)/(1+y(68));
  g1(25,58)=(1+y(13))/(1+y(68));
  g1(25,68)=(-(y(58)*(1+y(13))))/((1+y(68))*(1+y(68)));
  g1(26,14)=1;
  g1(26,2)=(-((-(T28*T642))/(T30*T30)));
  g1(26,15)=T244;
  g1(26,16)=T280;
  g1(26,20)=(-(T366/T30));
  g1(27,15)=y(21);
  g1(27,17)=1;
  g1(27,21)=T386;
  g1(27,22)=params(8);
  g1(27,27)=T474;
  g1(27,34)=T564;
  g1(28,3)=(-(params(2)*T291*T743));
  g1(28,17)=(-(params(2)*T290*T291));
  g1(28,18)=1;
  g1(29,15)=T235;
  g1(29,62)=(-((1-params(9))*T81));
  g1(29,19)=T335;
  g1(29,63)=(-((1-params(9))*y(62)*T831));
  g1(29,23)=T428;
  g1(29,34)=T561;
  g1(29,35)=T235;
  g1(30,19)=params(9);
  g1(30,20)=1;
  g1(31,19)=(-(1-y(4)));
  g1(31,20)=y(4);
  g1(31,4)=(-(1-y(20)-y(19)));
  g1(31,21)=1;
  g1(32,4)=(-(T382*T855));
  g1(32,21)=(-(T381*T382));
  g1(32,22)=1;
  g1(33,24)=1;
  g1(33,25)=T447;
  g1(33,26)=T461;
  g1(34,62)=(-(T117*y(66)));
  g1(34,23)=(-y(29));
  g1(34,25)=1;
  g1(34,66)=(-(y(62)*T117));
  g1(34,68)=(-(y(66)*y(62)*T989));
  g1(34,29)=(-y(23));
  g1(35,62)=(-(T124*y(67)));
  g1(35,26)=1;
  g1(35,67)=(-(y(62)*T124));
  g1(35,68)=(-(y(67)*y(62)*T999));
  g1(35,29)=(-1);
  g1(36,24)=T441;
  g1(36,28)=T490;
  g1(37,24)=T435;
  g1(37,5)=(-T319);
  g1(37,27)=1;
  g1(37,28)=(-(params(15)*y(5)*T484));
  g1(38,63)=(-(y(69)*(-params(2))));
  g1(38,64)=(-(y(69)*(-params(2))));
  g1(38,31)=1;
  g1(38,69)=(-(params(2)*(1-y(64)-y(63))));
  g1(39,19)=(-(params(8)*T335/T73));
  g1(39,32)=1;
  g1(40,31)=1/params(17);
  g1(40,32)=(-(T172*1/params(18)));
  g1(40,33)=(-(T168*T549));
  g1(41,15)=1;
  g1(41,33)=T545;
  g1(42,21)=(-exp(y(34)));
  g1(42,27)=y(29);
  g1(42,29)=y(27);
  g1(42,34)=(-(y(21)*exp(y(34))));
  g1(43,15)=(-(y(21)*T226));
  g1(43,16)=T273;
  g1(43,17)=T287;
  g1(43,21)=(-(log(y(15))-log(y(16))));
  g1(43,30)=1;
  g1(44,6)=(-params(21));
  g1(44,34)=1;
  g1(44,77)=1;
  g1(45,7)=(-params(22));
  g1(45,35)=1;
  g1(45,78)=(-1);

if nargout >= 3,
  %
  % Hessian matrix
  %

  v2 = zeros(413,3);
T1052 = T216*y(8)*(-((-(1+y(1)))*(1+y(28)+1+y(28))))/T963;
T1058 = (y(2)+y(2))/(y(2)*y(2)*y(2)*y(2));
T1097 = (-(T255*T676))*(T226*T256+T226*T256);
T1165 = y(38)*(-((-(T642*params(2)*1/(y(15)*y(15))))/(T30*T30)));
T1170 = y(38)*(-(params(2)*(-(y(15)+y(15)))/(y(15)*y(15)*y(15)*y(15))/T30));
T1238 = y(38)*(-((-(T642*params(2)*(-1)/(y(16)*y(16))))/(T30*T30)));
T1242 = y(38)*(-(params(2)*(y(16)+y(16))/(y(16)*y(16)*y(16)*y(16))/T30));
T1248 = T741*T743*T744;
T1254 = getPowerDeriv(T50,(-params(4)),3);
T1255 = T743*T1254;
T1296 = getPowerDeriv(y(61)/y(17),(-params(4)),3);
T1297 = T300*T1296;
T1361 = getPowerDeriv(y(19),T59,3);
T1385 = (-(1-params(9)))*(-(1-params(9)))*getPowerDeriv(1-(1-params(9))*y(4),params(7),2);
T1404 = (T97*T97*((-(1-params(9)))*T848-((-(1-params(9)))*T848+(y(21)-(1-params(9))*y(4))*T1385))-(T97*(-(1-params(9)))-(y(21)-(1-params(9))*y(4))*T848)*(T97*T848+T97*T848))/(T97*T97*T97*T97);
T1405 = getPowerDeriv(T98,T72,3);
T1406 = T855*T1405;
T1457 = getPowerDeriv(T408,T72,3);
T1458 = T407*T1457;
T1497 = y(39)*(-((-((-exp(y(34)))*(y(27)+y(27))))/(y(27)*y(27)*y(27)*y(27))));
T1513 = y(45)*(-((-((-(params(14)*(1-params(16))*(params(14)-1)))*((params(14)-1)*(params(14)-1)*y(26)+(params(14)-1)*(params(14)-1)*y(26))))/T934));
T1548 = params(15)*getPowerDeriv(1+y(68),params(14),2);
T1560 = getPowerDeriv(1+y(28),params(14),3);
  v2(1,1)=1;
  v2(1,2)=5284;
  v2(1,3)=y(37)*(-1)/((1+y(68))*(1+y(68)));
  v2(2,1)=1;
  v2(2,2)=4514;
  v2(2,3)=  v2(1,3);
  v2(3,1)=1;
  v2(3,2)=5294;
  v2(3,3)=y(37)*(-((-y(58))*(1+y(68)+1+y(68))))/((1+y(68))*(1+y(68))*(1+y(68))*(1+y(68)));
  v2(4,1)=1;
  v2(4,2)=2866;
  v2(4,3)=1/(1+y(68));
  v2(5,1)=1;
  v2(5,2)=4483;
  v2(5,3)=  v2(4,3);
  v2(6,1)=1;
  v2(6,2)=2876;
  v2(6,3)=T986;
  v2(7,1)=1;
  v2(7,2)=5263;
  v2(7,3)=  v2(6,3);
  v2(8,1)=2;
  v2(8,2)=2107;
  v2(8,3)=T216*y(8)*(-1)/((1+y(28))*(1+y(28)));
  v2(9,1)=2;
  v2(9,2)=28;
  v2(9,3)=  v2(8,3);
  v2(10,1)=2;
  v2(10,2)=2134;
  v2(10,3)=T1052;
  v2(11,1)=2;
  v2(11,2)=547;
  v2(11,3)=T216*1/(1+y(28));
  v2(12,1)=2;
  v2(12,2)=8;
  v2(12,3)=  v2(11,3);
  v2(13,1)=2;
  v2(13,2)=574;
  v2(13,3)=T216*(-(1+y(1)))/((1+y(28))*(1+y(28)));
  v2(14,1)=2;
  v2(14,2)=2114;
  v2(14,3)=  v2(13,3);
  v2(15,1)=3;
  v2(15,2)=80;
  v2(15,3)=y(38)*(-((T30*T30*(-(T242*T1058))-(-(T242*T642))*(T30*T642+T30*T642))/(T30*T30*T30*T30)));
  v2(16,1)=3;
  v2(16,2)=1094;
  v2(16,3)=y(38)*(-((-(T642*params(2)*(-((-(1-y(20)))*(y(15)+y(15))))/(y(15)*y(15)*y(15)*y(15))))/(T30*T30)));
  v2(17,1)=3;
  v2(17,2)=93;
  v2(17,3)=  v2(16,3);
  v2(18,1)=3;
  v2(18,2)=1107;
  v2(18,3)=y(55)*(-(y(21)*T676))+y(38)*(-(params(2)*(y(15)*y(15)*y(15)*y(15)*(-(2*(-(1-y(20)))))-(-((-(1-y(20)))*(y(15)+y(15))))*(y(15)*y(15)*(y(15)+y(15))+y(15)*y(15)*(y(15)+y(15))))/(y(15)*y(15)*y(15)*y(15)*y(15)*y(15)*y(15)*y(15))/T30))+params(23)*y(70)*(-((T259*T259*(T1097+T259*(-(T255*(2*y(15)*y(15)*y(15)*y(15)-(y(15)+y(15))*(y(15)*y(15)*(y(15)+y(15))+y(15)*y(15)*(y(15)+y(15))))/(y(15)*y(15)*y(15)*y(15)*y(15)*y(15)*y(15)*y(15))))-(T1097+(-(T255*T256))*(T256*T256+T226*T676+T256*T256+T226*T676)))-(T259*(-(T255*T676))-(-(T255*T256))*(T226*T256+T226*T256))*(T259*(T226*T256+T226*T256)+T259*(T226*T256+T226*T256)))/(T259*T259*T259*T259)));
  v2(19,1)=3;
  v2(19,2)=4539;
  v2(19,3)=params(23)*y(70)*(-((T259*(-(T676*params(2)*(-(1-y(64)))/(y(59)*y(59))))-(T226*T256+T226*T256)*(-(T256*params(2)*(-(1-y(64)))/(y(59)*y(59)))))/(T259*T259)));
  v2(20,1)=3;
  v2(20,2)=1151;
  v2(20,3)=  v2(19,3);
  v2(21,1)=3;
  v2(21,2)=4583;
  v2(21,3)=params(23)*y(70)*(-((-(T256*params(2)*(-((-(1-y(64)))*(y(59)+y(59))))/(y(59)*y(59)*y(59)*y(59))))/T259));
  v2(22,1)=3;
  v2(22,2)=4617;
  v2(22,3)=params(23)*y(70)*(-((T259*(-(T676*params(2)*(-y(64))/(y(60)*y(60))))-(T226*T256+T226*T256)*(-(T256*params(2)*(-y(64))/(y(60)*y(60)))))/(T259*T259)));
  v2(23,1)=3;
  v2(23,2)=1152;
  v2(23,3)=  v2(22,3);
  v2(24,1)=3;
  v2(24,2)=4662;
  v2(24,3)=params(23)*y(70)*(-((-(T256*params(2)*(-((-y(64))*(y(60)+y(60))))/(y(60)*y(60)*y(60)*y(60))))/T259));
  v2(25,1)=3;
  v2(25,2)=1484;
  v2(25,3)=T1165;
  v2(26,1)=3;
  v2(26,2)=98;
  v2(26,3)=  v2(25,3);
  v2(27,1)=3;
  v2(27,2)=1497;
  v2(27,3)=T1170;
  v2(28,1)=3;
  v2(28,2)=1112;
  v2(28,3)=  v2(27,3);
  v2(29,1)=3;
  v2(29,2)=4929;
  v2(29,3)=params(23)*y(70)*(-((T259*(-(T676*T840))-(T226*T256+T226*T256)*(-(T256*T840)))/(T259*T259)));
  v2(30,1)=3;
  v2(30,2)=1156;
  v2(30,3)=  v2(29,3);
  v2(31,1)=3;
  v2(31,2)=4973;
  v2(31,3)=params(23)*y(70)*(-((-(T256*params(2)*1/(y(59)*y(59))))/T259));
  v2(32,1)=3;
  v2(32,2)=4588;
  v2(32,3)=  v2(31,3);
  v2(33,1)=3;
  v2(33,2)=4974;
  v2(33,3)=params(23)*y(70)*(-((-(T256*params(2)*(-1)/(y(60)*y(60))))/T259));
  v2(34,1)=3;
  v2(34,2)=4666;
  v2(34,3)=  v2(33,3);
  v2(35,1)=3;
  v2(35,2)=1575;
  v2(35,3)=y(55)*(-T256);
  v2(36,1)=3;
  v2(36,2)=1113;
  v2(36,3)=  v2(35,3);
  v2(37,1)=3;
  v2(37,2)=2888;
  v2(37,3)=T647;
  v2(38,1)=3;
  v2(38,2)=116;
  v2(38,3)=  v2(37,3);
  v2(39,1)=3;
  v2(39,2)=2901;
  v2(39,3)=T673;
  v2(40,1)=3;
  v2(40,2)=1130;
  v2(40,3)=  v2(39,3);
  v2(41,1)=3;
  v2(41,2)=2906;
  v2(41,3)=T694;
  v2(42,1)=3;
  v2(42,2)=1520;
  v2(42,3)=  v2(41,3);
  v2(43,1)=3;
  v2(43,2)=5397;
  v2(43,3)=params(23)*T686;
  v2(44,1)=3;
  v2(44,2)=1162;
  v2(44,3)=  v2(43,3);
  v2(45,1)=3;
  v2(45,2)=5441;
  v2(45,3)=params(23)*T707;
  v2(46,1)=3;
  v2(46,2)=4594;
  v2(46,3)=  v2(45,3);
  v2(47,1)=3;
  v2(47,2)=5442;
  v2(47,3)=params(23)*T737;
  v2(48,1)=3;
  v2(48,2)=4672;
  v2(48,3)=  v2(47,3);
  v2(49,1)=3;
  v2(49,2)=5446;
  v2(49,3)=params(23)*(-((-(T256*T840))/T259));
  v2(50,1)=3;
  v2(50,2)=4984;
  v2(50,3)=  v2(49,3);
  v2(51,1)=3;
  v2(51,2)=2985;
  v2(51,3)=1;
  v2(52,1)=3;
  v2(52,2)=1599;
  v2(52,3)=  v2(51,3);
  v2(53,1)=3;
  v2(53,2)=4227;
  v2(53,3)=(-(y(21)*T256));
  v2(54,1)=3;
  v2(54,2)=1147;
  v2(54,3)=  v2(53,3);
  v2(55,1)=3;
  v2(55,2)=4233;
  v2(55,3)=(-T226);
  v2(56,1)=3;
  v2(56,2)=1615;
  v2(56,3)=  v2(55,3);
  v2(57,1)=4;
  v2(57,2)=80;
  v2(57,3)=y(38)*(-((T30*T30*(-(T278*T1058))-(-(T278*T642))*(T30*T642+T30*T642))/(T30*T30*T30*T30)));
  v2(58,1)=4;
  v2(58,2)=1172;
  v2(58,3)=y(38)*(-((-(T642*params(2)*(-((-y(20))*(y(16)+y(16))))/(y(16)*y(16)*y(16)*y(16))))/(T30*T30)));
  v2(59,1)=4;
  v2(59,2)=94;
  v2(59,3)=  v2(58,3);
  v2(60,1)=4;
  v2(60,2)=1186;
  v2(60,3)=y(55)*(-((1-y(21))*(y(16)+y(16))/(y(16)*y(16)*y(16)*y(16))))+y(38)*(-(params(2)*(y(16)*y(16)*y(16)*y(16)*(-(2*(-y(20))))-(-((-y(20))*(y(16)+y(16))))*(y(16)*y(16)*(y(16)+y(16))+y(16)*y(16)*(y(16)+y(16))))/(y(16)*y(16)*y(16)*y(16)*y(16)*y(16)*y(16)*y(16))/T30));
  v2(61,1)=4;
  v2(61,2)=1484;
  v2(61,3)=T1238;
  v2(62,1)=4;
  v2(62,2)=98;
  v2(62,3)=  v2(61,3);
  v2(63,1)=4;
  v2(63,2)=1498;
  v2(63,3)=T1242;
  v2(64,1)=4;
  v2(64,2)=1190;
  v2(64,3)=  v2(63,3);
  v2(65,1)=4;
  v2(65,2)=1576;
  v2(65,3)=y(55)*(-1)/(y(16)*y(16));
  v2(66,1)=4;
  v2(66,2)=1191;
  v2(66,3)=  v2(65,3);
  v2(67,1)=4;
  v2(67,2)=2888;
  v2(67,3)=T652;
  v2(68,1)=4;
  v2(68,2)=116;
  v2(68,3)=  v2(67,3);
  v2(69,1)=4;
  v2(69,2)=2902;
  v2(69,3)=T721;
  v2(70,1)=4;
  v2(70,2)=1208;
  v2(70,3)=  v2(69,3);
  v2(71,1)=4;
  v2(71,2)=2906;
  v2(71,3)=T726;
  v2(72,1)=4;
  v2(72,2)=1520;
  v2(72,3)=  v2(71,3);
  v2(73,1)=4;
  v2(73,2)=4228;
  v2(73,3)=T712;
  v2(74,1)=4;
  v2(74,2)=1225;
  v2(74,3)=  v2(73,3);
  v2(75,1)=4;
  v2(75,2)=4233;
  v2(75,3)=T271;
  v2(76,1)=4;
  v2(76,2)=1615;
  v2(76,3)=  v2(75,3);
  v2(77,1)=5;
  v2(77,2)=159;
  v2(77,3)=y(40)*(-(params(2)*(T1248+T291*(y(3)+y(3))/(y(3)*y(3)*y(3)*y(3))+T1248+T290*(T744*(-((-y(17))*(y(3)+y(3))))/(y(3)*y(3)*y(3)*y(3))+T743*T1255))));
  v2(78,1)=5;
  v2(78,2)=1251;
  v2(78,3)=y(40)*(-(params(2)*(T741*T290*T744+T290*(T741*T744+T290*T1255))));
  v2(79,1)=5;
  v2(79,2)=173;
  v2(79,3)=  v2(78,3);
  v2(80,1)=5;
  v2(80,2)=1265;
  v2(80,3)=y(55)*(-(T193*getPowerDeriv(y(17),1-params(4),3)))+y(40)*(-(params(2)*T290*T290*T290*T1254))+params(23)*y(71)*(-(params(2)*(T768*T300*T769+T302*(y(17)*y(17)*y(17)*y(17)*(-(2*(-y(61))))-(-((-y(61))*(y(17)+y(17))))*(y(17)*y(17)*(y(17)+y(17))+y(17)*y(17)*(y(17)+y(17))))/(y(17)*y(17)*y(17)*y(17)*y(17)*y(17)*y(17)*y(17))+T768*T300*T769+T300*(T768*T769+T300*T1297))));
  v2(81,1)=5;
  v2(81,2)=4697;
  v2(81,3)=params(23)*y(71)*(-(params(2)*(T300*T769*T780+T302*(y(17)+y(17))/(y(17)*y(17)*y(17)*y(17))+T768*T769*T781+T300*(T781*T1297+T769*T780))));
  v2(82,1)=5;
  v2(82,2)=1309;
  v2(82,3)=  v2(81,3);
  v2(83,1)=5;
  v2(83,2)=4741;
  v2(83,3)=params(23)*y(71)*(-(params(2)*(T780*T769*T781+T780*T769*T781+T300*T781*T781*T1296)));
  v2(84,1)=5;
  v2(84,2)=3045;
  v2(84,3)=(-(params(2)*(T291*T741+T290*T743*T744)));
  v2(85,1)=5;
  v2(85,2)=196;
  v2(85,3)=  v2(84,3);
  v2(86,1)=5;
  v2(86,2)=3059;
  v2(86,3)=(-(params(2)*T290*T290*T744));
  v2(87,1)=5;
  v2(87,2)=1288;
  v2(87,3)=  v2(86,3);
  v2(88,1)=5;
  v2(88,2)=5477;
  v2(88,3)=params(23)*(-(params(2)*(T302*T768+T300*T300*T769)));
  v2(89,1)=5;
  v2(89,2)=1319;
  v2(89,3)=  v2(88,3);
  v2(90,1)=5;
  v2(90,2)=5521;
  v2(90,3)=params(23)*(-(params(2)*(T302*T780+T300*T769*T781)));
  v2(91,1)=5;
  v2(91,2)=4751;
  v2(91,3)=  v2(90,3);
  v2(92,1)=5;
  v2(92,2)=4229;
  v2(92,3)=T757;
  v2(93,1)=5;
  v2(93,2)=1303;
  v2(93,3)=  v2(92,3);
  v2(94,1)=6;
  v2(94,2)=1423;
  v2(94,3)=T216*y(9)*(-((1-params(9))*T815));
  v2(95,1)=6;
  v2(95,2)=2131;
  v2(95,3)=T216*y(10)*(-(params(15)*T484));
  v2(96,1)=6;
  v2(96,2)=1900;
  v2(96,3)=  v2(95,3);
  v2(97,1)=6;
  v2(97,2)=2132;
  v2(97,3)=T216*y(11)*(-T506);
  v2(98,1)=6;
  v2(98,2)=1978;
  v2(98,3)=  v2(97,3);
  v2(99,1)=6;
  v2(99,2)=2134;
  v2(99,3)=T216*y(10)*(-(y(25)*params(15)*T952))+T216*y(11)*(-(y(26)*T975));
  v2(100,1)=6;
  v2(100,2)=643;
  v2(100,3)=T216*(-((1-params(9))*T335));
  v2(101,1)=6;
  v2(101,2)=1413;
  v2(101,3)=  v2(100,3);
  v2(102,1)=6;
  v2(102,2)=727;
  v2(102,3)=T216*(-T319);
  v2(103,1)=6;
  v2(103,2)=1882;
  v2(103,3)=  v2(102,3);
  v2(104,1)=6;
  v2(104,2)=730;
  v2(104,3)=T216*(-(y(25)*params(15)*T484));
  v2(105,1)=6;
  v2(105,2)=2116;
  v2(105,3)=  v2(104,3);
  v2(106,1)=6;
  v2(106,2)=806;
  v2(106,3)=T216*(-T327);
  v2(107,1)=6;
  v2(107,2)=1961;
  v2(107,3)=  v2(106,3);
  v2(108,1)=6;
  v2(108,2)=808;
  v2(108,3)=T216*(-(y(26)*T506));
  v2(109,1)=6;
  v2(109,2)=2117;
  v2(109,3)=  v2(108,3);
  v2(110,1)=7;
  v2(110,2)=1422;
  v2(110,3)=T216*y(9)*(-((1-params(9))*T815));
  v2(111,1)=7;
  v2(111,2)=1345;
  v2(111,3)=  v2(110,3);
  v2(112,1)=7;
  v2(112,2)=1423;
  v2(112,3)=y(51)*(-(params(8)*T1361/T73))+y(41)*T1361+T216*y(9)*(-(y(18)*(1-params(9))*T1361));
  v2(113,1)=7;
  v2(113,2)=642;
  v2(113,3)=T216*(-((1-params(9))*T335));
  v2(114,1)=7;
  v2(114,2)=1335;
  v2(114,3)=  v2(113,3);
  v2(115,1)=7;
  v2(115,2)=643;
  v2(115,3)=T216*(-(y(18)*(1-params(9))*T815));
  v2(116,1)=7;
  v2(116,2)=1413;
  v2(116,3)=  v2(115,3);
  v2(117,1)=7;
  v2(117,2)=3139;
  v2(117,3)=T815;
  v2(118,1)=7;
  v2(118,2)=1445;
  v2(118,3)=  v2(117,3);
  v2(119,1)=7;
  v2(119,2)=3280;
  v2(119,3)=1;
  v2(120,1)=7;
  v2(120,2)=277;
  v2(120,3)=  v2(119,3);
  v2(121,1)=7;
  v2(121,2)=889;
  v2(121,3)=params(2)*T216;
  v2(122,1)=7;
  v2(122,2)=2352;
  v2(122,3)=  v2(121,3);
  v2(123,1)=7;
  v2(123,2)=3919;
  v2(123,3)=(-(params(8)*T815/T73));
  v2(124,1)=7;
  v2(124,2)=1455;
  v2(124,3)=  v2(123,3);
  v2(125,1)=8;
  v2(125,2)=80;
  v2(125,3)=y(38)*(-((T30*T30*(-(T366*T1058))-(-(T366*T642))*(T30*T642+T30*T642))/(T30*T30*T30*T30)));
  v2(126,1)=8;
  v2(126,2)=1094;
  v2(126,3)=T1165;
  v2(127,1)=8;
  v2(127,2)=93;
  v2(127,3)=  v2(126,3);
  v2(128,1)=8;
  v2(128,2)=1107;
  v2(128,3)=T1170;
  v2(129,1)=8;
  v2(129,2)=1172;
  v2(129,3)=T1238;
  v2(130,1)=8;
  v2(130,2)=94;
  v2(130,3)=  v2(129,3);
  v2(131,1)=8;
  v2(131,2)=1186;
  v2(131,3)=T1242;
  v2(132,1)=8;
  v2(132,2)=2888;
  v2(132,3)=T657;
  v2(133,1)=8;
  v2(133,2)=116;
  v2(133,3)=  v2(132,3);
  v2(134,1)=8;
  v2(134,2)=2901;
  v2(134,3)=T694;
  v2(135,1)=8;
  v2(135,2)=1130;
  v2(135,3)=  v2(134,3);
  v2(136,1)=8;
  v2(136,2)=2902;
  v2(136,3)=T726;
  v2(137,1)=8;
  v2(137,2)=1208;
  v2(137,3)=  v2(136,3);
  v2(138,1)=8;
  v2(138,2)=3280;
  v2(138,3)=1;
  v2(139,1)=8;
  v2(139,2)=277;
  v2(139,3)=  v2(138,3);
  v2(140,1)=8;
  v2(140,2)=889;
  v2(140,3)=params(2)*T216;
  v2(141,1)=8;
  v2(141,2)=2352;
  v2(141,3)=  v2(140,3);
  v2(142,1)=9;
  v2(142,2)=1107;
  v2(142,3)=y(55)*(-T256);
  v2(143,1)=9;
  v2(143,2)=1186;
  v2(143,3)=y(55)*(-1)/(y(16)*y(16));
  v2(144,1)=9;
  v2(144,2)=238;
  v2(144,3)=y(44)*(-(T851*T857+T382*(T97*T97*(-T1385)-(-T848)*(T97*T848+T97*T848))/(T97*T97*T97*T97)+T851*T857+T381*(T856*T1404+T855*T1406)));
  v2(145,1)=9;
  v2(145,2)=1564;
  v2(145,3)=y(44)*(-(T851*T381*T856+T381*(T851*T856+T381*T1406)));
  v2(146,1)=9;
  v2(146,2)=255;
  v2(146,3)=  v2(145,3);
  v2(147,1)=9;
  v2(147,2)=1581;
  v2(147,3)=y(44)*(-(T381*T381*T381*T1405))+params(23)*y(73)*(-(T884*T407*T885+T409*(T397*T397*T397*T397*(T877*(T397*T403+T397*T403)+T397*T397*((-(1-params(9)))*T874-((-(1-params(9)))*T874+(-(1-params(9)))*T874+(y(65)-y(21)*(1-params(9)))*(-(1-params(9)))*(-(1-params(9)))*(-(1-params(9)))*getPowerDeriv(1-y(21)*(1-params(9)),params(7),3)))-(T877*(T397*T403+T397*T403)+(T397*(-(1-params(9)))-(y(65)-y(21)*(1-params(9)))*T403)*(T403*T403+T397*T874+T403*T403+T397*T874)))-(T397*T397*T877-(T397*(-(1-params(9)))-(y(65)-y(21)*(1-params(9)))*T403)*(T397*T403+T397*T403))*(T397*T397*(T397*T403+T397*T403)+T397*T397*(T397*T403+T397*T403)))/(T397*T397*T397*T397*T397*T397*T397*T397)+T884*T407*T885+T407*(T884*T885+T407*T1458)));
  v2(148,1)=9;
  v2(148,2)=5013;
  v2(148,3)=params(23)*y(73)*(-(T407*T885*T901+T409*(T397*T397*(-T874)-(T397*T403+T397*T403)*(-T403))/(T397*T397*T397*T397)+T884*T885*T902+T407*(T902*T1458+T885*T901)));
  v2(149,1)=9;
  v2(149,2)=1625;
  v2(149,3)=  v2(148,3);
  v2(150,1)=9;
  v2(150,2)=5057;
  v2(150,3)=params(23)*y(73)*(-(T901*T885*T902+T901*T885*T902+T407*T902*T902*T1457));
  v2(151,1)=9;
  v2(151,2)=2055;
  v2(151,3)=T1497;
  v2(152,1)=9;
  v2(152,2)=2601;
  v2(152,3)=T895;
  v2(153,1)=9;
  v2(153,2)=2062;
  v2(153,3)=  v2(152,3);
  v2(154,1)=9;
  v2(154,2)=2608;
  v2(154,3)=T898;
  v2(155,1)=9;
  v2(155,2)=2979;
  v2(155,3)=1;
  v2(156,1)=9;
  v2(156,2)=1131;
  v2(156,3)=  v2(155,3);
  v2(157,1)=9;
  v2(157,2)=2991;
  v2(157,3)=T894;
  v2(158,1)=9;
  v2(158,2)=2067;
  v2(158,3)=  v2(157,3);
  v2(159,1)=9;
  v2(159,2)=2998;
  v2(159,3)=T896;
  v2(160,1)=9;
  v2(160,2)=2613;
  v2(160,3)=  v2(159,3);
  v2(161,1)=9;
  v2(161,2)=5601;
  v2(161,3)=params(23);
  v2(162,1)=9;
  v2(162,2)=4908;
  v2(162,3)=  v2(161,3);
  v2(163,1)=9;
  v2(163,2)=5602;
  v2(163,3)=params(23);
  v2(164,1)=9;
  v2(164,2)=4986;
  v2(164,3)=  v2(163,3);
  v2(165,1)=9;
  v2(165,2)=3358;
  v2(165,3)=(-(T382*T851+T381*T857));
  v2(166,1)=9;
  v2(166,2)=278;
  v2(166,3)=  v2(165,3);
  v2(167,1)=9;
  v2(167,2)=3375;
  v2(167,3)=(-(T381*T381*T856));
  v2(168,1)=9;
  v2(168,2)=1604;
  v2(168,3)=  v2(167,3);
  v2(169,1)=9;
  v2(169,2)=5637;
  v2(169,3)=params(23)*(-(T409*T884+T407*T407*T885));
  v2(170,1)=9;
  v2(170,2)=1633;
  v2(170,3)=  v2(169,3);
  v2(171,1)=9;
  v2(171,2)=5681;
  v2(171,3)=params(23)*(-(T409*T901+T407*T885*T902));
  v2(172,1)=9;
  v2(172,2)=5065;
  v2(172,3)=  v2(171,3);
  v2(173,1)=9;
  v2(173,2)=4168;
  v2(173,3)=(-exp(y(34)));
  v2(174,1)=9;
  v2(174,2)=2628;
  v2(174,3)=  v2(173,3);
  v2(175,1)=9;
  v2(175,2)=4227;
  v2(175,3)=(-T226);
  v2(176,1)=9;
  v2(176,2)=1147;
  v2(176,3)=  v2(175,3);
  v2(177,1)=9;
  v2(177,2)=4228;
  v2(177,3)=T271;
  v2(178,1)=9;
  v2(178,2)=1225;
  v2(178,3)=  v2(177,3);
  v2(179,1)=11;
  v2(179,2)=2608;
  v2(179,3)=T429;
  v2(180,1)=11;
  v2(180,2)=3154;
  v2(180,3)=T428;
  v2(181,1)=11;
  v2(181,2)=2615;
  v2(181,3)=  v2(180,3);
  v2(182,1)=11;
  v2(182,2)=3539;
  v2(182,3)=(-1);
  v2(183,1)=11;
  v2(183,2)=2230;
  v2(183,3)=  v2(182,3);
  v2(184,1)=12;
  v2(184,2)=1818;
  v2(184,3)=y(49)*(-((1-params(15))*getPowerDeriv(y(24),(-params(14)),3)))+y(48)*(-((1-params(15))*getPowerDeriv(y(24),1-params(14),3)));
  v2(185,1)=12;
  v2(185,2)=3690;
  v2(185,3)=T918;
  v2(186,1)=12;
  v2(186,2)=1842;
  v2(186,3)=  v2(185,3);
  v2(187,1)=12;
  v2(187,2)=3768;
  v2(187,3)=T914;
  v2(188,1)=12;
  v2(188,2)=1843;
  v2(188,3)=  v2(187,3);
  v2(189,1)=13;
  v2(189,2)=1976;
  v2(189,3)=T1513;
  v2(190,1)=13;
  v2(190,2)=2124;
  v2(190,3)=T216*y(10)*(-(params(15)*T484));
  v2(191,1)=13;
  v2(191,2)=1354;
  v2(191,3)=  v2(190,3);
  v2(192,1)=13;
  v2(192,2)=2134;
  v2(192,3)=T216*y(10)*(-(y(18)*params(15)*T952));
  v2(193,1)=13;
  v2(193,2)=3458;
  v2(193,3)=T924;
  v2(194,1)=13;
  v2(194,2)=1995;
  v2(194,3)=  v2(193,3);
  v2(195,1)=13;
  v2(195,2)=720;
  v2(195,3)=T216*(-T319);
  v2(196,1)=13;
  v2(196,2)=1336;
  v2(196,3)=  v2(195,3);
  v2(197,1)=13;
  v2(197,2)=730;
  v2(197,3)=T216*(-(y(18)*params(15)*T484));
  v2(198,1)=13;
  v2(198,2)=2116;
  v2(198,3)=  v2(197,3);
  v2(199,1)=14;
  v2(199,2)=1975;
  v2(199,3)=T1513;
  v2(200,1)=14;
  v2(200,2)=1898;
  v2(200,3)=  v2(199,3);
  v2(201,1)=14;
  v2(201,2)=1976;
  v2(201,3)=y(45)*(-((T934*(-((-(params(14)*(1-params(16))*y(25)*(params(14)-1)))*((params(14)-1)*(params(14)-1)+(params(14)-1)*(params(14)-1))))-(-((-(params(14)*(1-params(16))*y(25)*(params(14)-1)))*((params(14)-1)*(params(14)-1)*y(26)+(params(14)-1)*(params(14)-1)*y(26))))*((params(14)-1)*y(26)*(params(14)-1)*y(26)*((params(14)-1)*(params(14)-1)*y(26)+(params(14)-1)*(params(14)-1)*y(26))+(params(14)-1)*y(26)*(params(14)-1)*y(26)*((params(14)-1)*(params(14)-1)*y(26)+(params(14)-1)*(params(14)-1)*y(26))))/(T934*T934)));
  v2(202,1)=14;
  v2(202,2)=2124;
  v2(202,3)=T216*y(11)*(-T506);
  v2(203,1)=14;
  v2(203,2)=1354;
  v2(203,3)=  v2(202,3);
  v2(204,1)=14;
  v2(204,2)=2134;
  v2(204,3)=T216*y(11)*(-(y(18)*T975));
  v2(205,1)=14;
  v2(205,2)=3457;
  v2(205,3)=T924;
  v2(206,1)=14;
  v2(206,2)=1917;
  v2(206,3)=  v2(205,3);
  v2(207,1)=14;
  v2(207,2)=3458;
  v2(207,3)=T936;
  v2(208,1)=14;
  v2(208,2)=1995;
  v2(208,3)=  v2(207,3);
  v2(209,1)=14;
  v2(209,2)=798;
  v2(209,3)=T216*(-T327);
  v2(210,1)=14;
  v2(210,2)=1337;
  v2(210,3)=  v2(209,3);
  v2(211,1)=14;
  v2(211,2)=808;
  v2(211,3)=T216*(-(y(18)*T506));
  v2(212,1)=14;
  v2(212,2)=2117;
  v2(212,3)=  v2(211,3);
  v2(213,1)=15;
  v2(213,2)=2049;
  v2(213,3)=T1497;
  v2(214,1)=15;
  v2(214,2)=1587;
  v2(214,3)=  v2(213,3);
  v2(215,1)=15;
  v2(215,2)=2055;
  v2(215,3)=y(39)*(-(y(21)*(y(27)*y(27)*y(27)*y(27)*(-(2*(-exp(y(34)))))-(-((-exp(y(34)))*(y(27)+y(27))))*(y(27)*y(27)*(y(27)+y(27))+y(27)*y(27)*(y(27)+y(27))))/(y(27)*y(27)*y(27)*y(27)*y(27)*y(27)*y(27)*y(27))));
  v2(216,1)=15;
  v2(216,2)=5294;
  v2(216,3)=params(23)*y(74)*(-T1548);
  v2(217,1)=15;
  v2(217,2)=2595;
  v2(217,3)=T895;
  v2(218,1)=15;
  v2(218,2)=1594;
  v2(218,3)=  v2(217,3);
  v2(219,1)=15;
  v2(219,2)=2601;
  v2(219,3)=T951;
  v2(220,1)=15;
  v2(220,2)=2062;
  v2(220,3)=  v2(219,3);
  v2(221,1)=15;
  v2(221,2)=2608;
  v2(221,3)=T475;
  v2(222,1)=15;
  v2(222,2)=2985;
  v2(222,3)=T894;
  v2(223,1)=15;
  v2(223,2)=1599;
  v2(223,3)=  v2(222,3);
  v2(224,1)=15;
  v2(224,2)=2991;
  v2(224,3)=T950;
  v2(225,1)=15;
  v2(225,2)=2067;
  v2(225,3)=  v2(224,3);
  v2(226,1)=15;
  v2(226,2)=2998;
  v2(226,3)=T474;
  v2(227,1)=15;
  v2(227,2)=2613;
  v2(227,3)=  v2(226,3);
  v2(228,1)=15;
  v2(228,2)=5762;
  v2(228,3)=params(23)*(-T989);
  v2(229,1)=15;
  v2(229,2)=5300;
  v2(229,3)=  v2(228,3);
  v2(230,1)=15;
  v2(230,2)=4163;
  v2(230,3)=1;
  v2(231,1)=15;
  v2(231,2)=2238;
  v2(231,3)=  v2(230,3);
  v2(232,1)=16;
  v2(232,2)=1015;
  v2(232,3)=T216*y(8)*(-1)/((1+y(28))*(1+y(28)));
  v2(233,1)=16;
  v2(233,2)=14;
  v2(233,3)=  v2(232,3);
  v2(234,1)=16;
  v2(234,2)=1890;
  v2(234,3)=T216*y(10)*(-(params(15)*T484));
  v2(235,1)=16;
  v2(235,2)=1351;
  v2(235,3)=  v2(234,3);
  v2(236,1)=16;
  v2(236,2)=1968;
  v2(236,3)=T216*y(11)*(-T506);
  v2(237,1)=16;
  v2(237,2)=1352;
  v2(237,3)=  v2(236,3);
  v2(238,1)=16;
  v2(238,2)=2107;
  v2(238,3)=T216*y(8)*(-((-y(14))*(1+y(28)+1+y(28))))/T963;
  v2(239,1)=16;
  v2(239,2)=28;
  v2(239,3)=  v2(238,3);
  v2(240,1)=16;
  v2(240,2)=2120;
  v2(240,3)=T1052;
  v2(241,1)=16;
  v2(241,2)=1042;
  v2(241,3)=  v2(240,3);
  v2(242,1)=16;
  v2(242,2)=2124;
  v2(242,3)=T216*y(10)*(-(y(25)*params(15)*T952))+T216*y(11)*(-(y(26)*T975));
  v2(243,1)=16;
  v2(243,2)=1354;
  v2(243,3)=  v2(242,3);
  v2(244,1)=16;
  v2(244,2)=2131;
  v2(244,3)=T216*y(10)*(-(y(18)*params(15)*T952));
  v2(245,1)=16;
  v2(245,2)=1900;
  v2(245,3)=  v2(244,3);
  v2(246,1)=16;
  v2(246,2)=2132;
  v2(246,3)=T216*y(11)*(-(y(18)*T975));
  v2(247,1)=16;
  v2(247,2)=1978;
  v2(247,3)=  v2(246,3);
  v2(248,1)=16;
  v2(248,2)=2111;
  v2(248,3)=y(49)*(-(params(15)*T952));
  v2(249,1)=16;
  v2(249,2)=340;
  v2(249,3)=  v2(248,3);
  v2(250,1)=16;
  v2(250,2)=2134;
  v2(250,3)=y(49)*(-(params(15)*y(5)*T1560))+y(48)*(-(params(15)*getPowerDeriv(1+y(28),(-(1-params(14))),3)))+T216*y(8)*(T963*(-(2*(-(y(14)*(1+y(1))))))-(-((-(y(14)*(1+y(1))))*(1+y(28)+1+y(28))))*((1+y(28))*(1+y(28))*(1+y(28)+1+y(28))+(1+y(28))*(1+y(28))*(1+y(28)+1+y(28))))/(T963*T963)+T216*y(10)*(-(y(25)*y(18)*params(15)*T1560))+T216*y(11)*(-(y(26)*y(18)*params(15)*getPowerDeriv(1+y(28),params(14)-1,3)));
  v2(251,1)=16;
  v2(251,2)=547;
  v2(251,3)=T216*(-y(14))/((1+y(28))*(1+y(28)));
  v2(252,1)=16;
  v2(252,2)=8;
  v2(252,3)=  v2(251,3);
  v2(253,1)=16;
  v2(253,2)=560;
  v2(253,3)=T216*(-(1+y(1)))/((1+y(28))*(1+y(28)));
  v2(254,1)=16;
  v2(254,2)=1022;
  v2(254,3)=  v2(253,3);
  v2(255,1)=16;
  v2(255,2)=574;
  v2(255,3)=T216*(-((-(y(14)*(1+y(1))))*(1+y(28)+1+y(28))))/T963;
  v2(256,1)=16;
  v2(256,2)=2114;
  v2(256,3)=  v2(255,3);
  v2(257,1)=16;
  v2(257,2)=720;
  v2(257,3)=T216*(-(y(25)*params(15)*T484));
  v2(258,1)=16;
  v2(258,2)=1336;
  v2(258,3)=  v2(257,3);
  v2(259,1)=16;
  v2(259,2)=727;
  v2(259,3)=T216*(-(y(18)*params(15)*T484));
  v2(260,1)=16;
  v2(260,2)=1882;
  v2(260,3)=  v2(259,3);
  v2(261,1)=16;
  v2(261,2)=730;
  v2(261,3)=T216*(-(y(25)*y(18)*params(15)*T952));
  v2(262,1)=16;
  v2(262,2)=2116;
  v2(262,3)=  v2(261,3);
  v2(263,1)=16;
  v2(263,2)=798;
  v2(263,3)=T216*(-(y(26)*T506));
  v2(264,1)=16;
  v2(264,2)=1337;
  v2(264,3)=  v2(263,3);
  v2(265,1)=16;
  v2(265,2)=806;
  v2(265,3)=T216*(-(y(18)*T506));
  v2(266,1)=16;
  v2(266,2)=1961;
  v2(266,3)=  v2(265,3);
  v2(267,1)=16;
  v2(267,2)=808;
  v2(267,3)=T216*(-(y(26)*y(18)*T975));
  v2(268,1)=16;
  v2(268,2)=2117;
  v2(268,3)=  v2(267,3);
  v2(269,1)=16;
  v2(269,2)=3694;
  v2(269,3)=T958;
  v2(270,1)=16;
  v2(270,2)=2154;
  v2(270,3)=  v2(269,3);
  v2(271,1)=16;
  v2(271,2)=3749;
  v2(271,3)=(-(params(15)*T484));
  v2(272,1)=16;
  v2(272,2)=361;
  v2(272,3)=  v2(271,3);
  v2(273,1)=16;
  v2(273,2)=3772;
  v2(273,3)=(-(params(15)*y(5)*T952));
  v2(274,1)=16;
  v2(274,2)=2155;
  v2(274,3)=  v2(273,3);
  v2(275,1)=17;
  v2(275,2)=3533;
  v2(275,3)=(-1);
  v2(276,1)=17;
  v2(276,2)=1762;
  v2(276,3)=  v2(275,3);
  v2(277,1)=17;
  v2(277,2)=4161;
  v2(277,3)=1;
  v2(278,1)=17;
  v2(278,2)=2082;
  v2(278,3)=  v2(277,3);
  v2(279,1)=19;
  v2(279,2)=877;
  v2(279,3)=params(2)*T216;
  v2(280,1)=19;
  v2(280,2)=1416;
  v2(280,3)=  v2(279,3);
  v2(281,1)=19;
  v2(281,2)=878;
  v2(281,3)=params(2)*T216;
  v2(282,1)=19;
  v2(282,2)=1494;
  v2(282,3)=  v2(281,3);
  v2(283,1)=20;
  v2(283,2)=2529;
  v2(283,3)=y(52)*(-(1/params(18)*T1013));
  v2(284,1)=20;
  v2(284,2)=4011;
  v2(284,3)=T1005;
  v2(285,1)=20;
  v2(285,2)=2548;
  v2(285,3)=  v2(284,3);
  v2(286,1)=21;
  v2(286,2)=2528;
  v2(286,3)=y(52)*(-(1/params(18)*T1013));
  v2(287,1)=21;
  v2(287,2)=2451;
  v2(287,3)=  v2(286,3);
  v2(288,1)=21;
  v2(288,2)=2529;
  v2(288,3)=y(53)*(-(T178*getPowerDeriv(y(33),1-params(19),3)))+y(52)*(-(T168*T547*T547*T547*getPowerDeriv(T171,(-1),3)));
  v2(289,1)=21;
  v2(289,2)=4010;
  v2(289,3)=T1005;
  v2(290,1)=21;
  v2(290,2)=2470;
  v2(290,3)=  v2(289,3);
  v2(291,1)=21;
  v2(291,2)=4011;
  v2(291,3)=(-(T168*T1013));
  v2(292,1)=21;
  v2(292,2)=2548;
  v2(292,3)=  v2(291,3);
  v2(293,1)=21;
  v2(293,2)=4089;
  v2(293,3)=T1009;
  v2(294,1)=21;
  v2(294,2)=2549;
  v2(294,3)=  v2(293,3);
  v2(295,1)=22;
  v2(295,2)=2049;
  v2(295,3)=T895;
  v2(296,1)=22;
  v2(296,2)=1587;
  v2(296,3)=  v2(295,3);
  v2(297,1)=22;
  v2(297,2)=2055;
  v2(297,3)=T951;
  v2(298,1)=22;
  v2(298,2)=2595;
  v2(298,3)=T898;
  v2(299,1)=22;
  v2(299,2)=1594;
  v2(299,3)=  v2(298,3);
  v2(300,1)=22;
  v2(300,2)=2597;
  v2(300,3)=T429;
  v2(301,1)=22;
  v2(301,2)=1750;
  v2(301,3)=  v2(300,3);
  v2(302,1)=22;
  v2(302,2)=2601;
  v2(302,3)=T475;
  v2(303,1)=22;
  v2(303,2)=2062;
  v2(303,3)=  v2(302,3);
  v2(304,1)=22;
  v2(304,2)=2608;
  v2(304,3)=T567;
  v2(305,1)=22;
  v2(305,2)=2985;
  v2(305,3)=T896;
  v2(306,1)=22;
  v2(306,2)=1599;
  v2(306,3)=  v2(305,3);
  v2(307,1)=22;
  v2(307,2)=2991;
  v2(307,3)=T474;
  v2(308,1)=22;
  v2(308,2)=2067;
  v2(308,3)=  v2(307,3);
  v2(309,1)=22;
  v2(309,2)=2998;
  v2(309,3)=T564;
  v2(310,1)=22;
  v2(310,2)=2613;
  v2(310,3)=  v2(309,3);
  v2(311,1)=22;
  v2(311,2)=3143;
  v2(311,3)=T428;
  v2(312,1)=22;
  v2(312,2)=1757;
  v2(312,3)=  v2(311,3);
  v2(313,1)=22;
  v2(313,2)=3154;
  v2(313,3)=T561;
  v2(314,1)=22;
  v2(314,2)=2615;
  v2(314,3)=  v2(313,3);
  v2(315,1)=22;
  v2(315,2)=4155;
  v2(315,3)=(-exp(y(34)));
  v2(316,1)=22;
  v2(316,2)=1614;
  v2(316,3)=  v2(315,3);
  v2(317,1)=22;
  v2(317,2)=4168;
  v2(317,3)=(-(y(21)*exp(y(34))));
  v2(318,1)=22;
  v2(318,2)=2628;
  v2(318,3)=  v2(317,3);
  v2(319,1)=25;
  v2(319,2)=4459;
  v2(319,3)=1/(1+y(68));
  v2(320,1)=25;
  v2(320,2)=994;
  v2(320,3)=  v2(319,3);
  v2(321,1)=25;
  v2(321,2)=5239;
  v2(321,3)=T986;
  v2(322,1)=25;
  v2(322,2)=1004;
  v2(322,3)=  v2(321,3);
  v2(323,1)=25;
  v2(323,2)=5284;
  v2(323,3)=(-(1+y(13)))/((1+y(68))*(1+y(68)));
  v2(324,1)=25;
  v2(324,2)=4514;
  v2(324,3)=  v2(323,3);
  v2(325,1)=25;
  v2(325,2)=5294;
  v2(325,3)=(-((-(y(58)*(1+y(13))))*(1+y(68)+1+y(68))))/((1+y(68))*(1+y(68))*(1+y(68))*(1+y(68)));
  v2(326,1)=26;
  v2(326,2)=80;
  v2(326,3)=(-((T30*T30*(-(T28*T1058))-(-(T28*T642))*(T30*T642+T30*T642))/(T30*T30*T30*T30)));
  v2(327,1)=26;
  v2(327,2)=1094;
  v2(327,3)=T647;
  v2(328,1)=26;
  v2(328,2)=93;
  v2(328,3)=  v2(327,3);
  v2(329,1)=26;
  v2(329,2)=1107;
  v2(329,3)=T673;
  v2(330,1)=26;
  v2(330,2)=1172;
  v2(330,3)=T652;
  v2(331,1)=26;
  v2(331,2)=94;
  v2(331,3)=  v2(330,3);
  v2(332,1)=26;
  v2(332,2)=1186;
  v2(332,3)=T721;
  v2(333,1)=26;
  v2(333,2)=1484;
  v2(333,3)=T657;
  v2(334,1)=26;
  v2(334,2)=98;
  v2(334,3)=  v2(333,3);
  v2(335,1)=26;
  v2(335,2)=1497;
  v2(335,3)=T694;
  v2(336,1)=26;
  v2(336,2)=1112;
  v2(336,3)=  v2(335,3);
  v2(337,1)=26;
  v2(337,2)=1498;
  v2(337,3)=T726;
  v2(338,1)=26;
  v2(338,2)=1190;
  v2(338,3)=  v2(337,3);
  v2(339,1)=27;
  v2(339,2)=1575;
  v2(339,3)=1;
  v2(340,1)=27;
  v2(340,2)=1113;
  v2(340,3)=  v2(339,3);
  v2(341,1)=27;
  v2(341,2)=2049;
  v2(341,3)=T894;
  v2(342,1)=27;
  v2(342,2)=1587;
  v2(342,3)=  v2(341,3);
  v2(343,1)=27;
  v2(343,2)=2055;
  v2(343,3)=T950;
  v2(344,1)=27;
  v2(344,2)=2595;
  v2(344,3)=T896;
  v2(345,1)=27;
  v2(345,2)=1594;
  v2(345,3)=  v2(344,3);
  v2(346,1)=27;
  v2(346,2)=2601;
  v2(346,3)=T474;
  v2(347,1)=27;
  v2(347,2)=2062;
  v2(347,3)=  v2(346,3);
  v2(348,1)=27;
  v2(348,2)=2608;
  v2(348,3)=T564;
  v2(349,1)=28;
  v2(349,2)=159;
  v2(349,3)=(-(params(2)*(T743*T743*T744+T291*(-((-y(17))*(y(3)+y(3))))/(y(3)*y(3)*y(3)*y(3)))));
  v2(350,1)=28;
  v2(350,2)=1251;
  v2(350,3)=(-(params(2)*(T291*T741+T290*T743*T744)));
  v2(351,1)=28;
  v2(351,2)=173;
  v2(351,3)=  v2(350,3);
  v2(352,1)=28;
  v2(352,2)=1265;
  v2(352,3)=(-(params(2)*T290*T290*T744));
  v2(353,1)=29;
  v2(353,2)=1423;
  v2(353,3)=T815;
  v2(354,1)=29;
  v2(354,2)=4898;
  v2(354,3)=(-((1-params(9))*T831));
  v2(355,1)=29;
  v2(355,2)=4821;
  v2(355,3)=  v2(354,3);
  v2(356,1)=29;
  v2(356,2)=4899;
  v2(356,3)=(-((1-params(9))*y(62)*getPowerDeriv(y(63),T59,2)));
  v2(357,1)=29;
  v2(357,2)=2597;
  v2(357,3)=T428;
  v2(358,1)=29;
  v2(358,2)=1750;
  v2(358,3)=  v2(357,3);
  v2(359,1)=29;
  v2(359,2)=2608;
  v2(359,3)=T561;
  v2(360,1)=31;
  v2(360,2)=253;
  v2(360,3)=1;
  v2(361,1)=31;
  v2(361,2)=1408;
  v2(361,3)=  v2(360,3);
  v2(362,1)=31;
  v2(362,2)=254;
  v2(362,3)=1;
  v2(363,1)=31;
  v2(363,2)=1486;
  v2(363,3)=  v2(362,3);
  v2(364,1)=32;
  v2(364,2)=238;
  v2(364,3)=(-(T855*T857+T382*T1404));
  v2(365,1)=32;
  v2(365,2)=1564;
  v2(365,3)=(-(T382*T851+T381*T857));
  v2(366,1)=32;
  v2(366,2)=255;
  v2(366,3)=  v2(365,3);
  v2(367,1)=32;
  v2(367,2)=1581;
  v2(367,3)=(-(T381*T381*T856));
  v2(368,1)=33;
  v2(368,2)=1975;
  v2(368,3)=T924;
  v2(369,1)=33;
  v2(369,2)=1898;
  v2(369,3)=  v2(368,3);
  v2(370,1)=33;
  v2(370,2)=1976;
  v2(370,3)=T936;
  v2(371,1)=34;
  v2(371,2)=5132;
  v2(371,3)=(-T117);
  v2(372,1)=34;
  v2(372,2)=4824;
  v2(372,3)=  v2(371,3);
  v2(373,1)=34;
  v2(373,2)=5288;
  v2(373,3)=(-(y(66)*T989));
  v2(374,1)=34;
  v2(374,2)=4826;
  v2(374,3)=  v2(373,3);
  v2(375,1)=34;
  v2(375,2)=5292;
  v2(375,3)=(-(y(62)*T989));
  v2(376,1)=34;
  v2(376,2)=5138;
  v2(376,3)=  v2(375,3);
  v2(377,1)=34;
  v2(377,2)=5294;
  v2(377,3)=(-(y(66)*y(62)*T1548));
  v2(378,1)=34;
  v2(378,2)=2207;
  v2(378,3)=(-1);
  v2(379,1)=34;
  v2(379,2)=1745;
  v2(379,3)=  v2(378,3);
  v2(380,1)=35;
  v2(380,2)=5210;
  v2(380,3)=(-T124);
  v2(381,1)=35;
  v2(381,2)=4825;
  v2(381,3)=  v2(380,3);
  v2(382,1)=35;
  v2(382,2)=5288;
  v2(382,3)=(-(y(67)*T999));
  v2(383,1)=35;
  v2(383,2)=4826;
  v2(383,3)=  v2(382,3);
  v2(384,1)=35;
  v2(384,2)=5293;
  v2(384,3)=(-(y(62)*T999));
  v2(385,1)=35;
  v2(385,2)=5216;
  v2(385,3)=  v2(384,3);
  v2(386,1)=35;
  v2(386,2)=5294;
  v2(386,3)=(-(y(67)*y(62)*params(15)*getPowerDeriv(1+y(68),params(14)-1,2)));
  v2(387,1)=36;
  v2(387,2)=1818;
  v2(387,3)=T918;
  v2(388,1)=36;
  v2(388,2)=2134;
  v2(388,3)=T958;
  v2(389,1)=37;
  v2(389,2)=1818;
  v2(389,3)=T914;
  v2(390,1)=37;
  v2(390,2)=2111;
  v2(390,3)=(-(params(15)*T484));
  v2(391,1)=37;
  v2(391,2)=340;
  v2(391,3)=  v2(390,3);
  v2(392,1)=37;
  v2(392,2)=2134;
  v2(392,3)=(-(params(15)*y(5)*T952));
  v2(393,1)=38;
  v2(393,2)=5367;
  v2(393,3)=params(2);
  v2(394,1)=38;
  v2(394,2)=4905;
  v2(394,3)=  v2(393,3);
  v2(395,1)=38;
  v2(395,2)=5368;
  v2(395,3)=params(2);
  v2(396,1)=38;
  v2(396,2)=4983;
  v2(396,3)=  v2(395,3);
  v2(397,1)=39;
  v2(397,2)=1423;
  v2(397,3)=(-(params(8)*T815/T73));
  v2(398,1)=40;
  v2(398,2)=2528;
  v2(398,3)=T1005;
  v2(399,1)=40;
  v2(399,2)=2451;
  v2(399,3)=  v2(398,3);
  v2(400,1)=40;
  v2(400,2)=2529;
  v2(400,3)=(-(T168*T1013));
  v2(401,1)=41;
  v2(401,2)=2529;
  v2(401,3)=T1009;
  v2(402,1)=42;
  v2(402,2)=2211;
  v2(402,3)=1;
  v2(403,1)=42;
  v2(403,2)=2057;
  v2(403,3)=  v2(402,3);
  v2(404,1)=42;
  v2(404,2)=2595;
  v2(404,3)=(-exp(y(34)));
  v2(405,1)=42;
  v2(405,2)=1594;
  v2(405,3)=  v2(404,3);
  v2(406,1)=42;
  v2(406,2)=2608;
  v2(406,3)=(-(y(21)*exp(y(34))));
  v2(407,1)=43;
  v2(407,2)=1107;
  v2(407,3)=(-(y(21)*T256));
  v2(408,1)=43;
  v2(408,2)=1186;
  v2(408,3)=T712;
  v2(409,1)=43;
  v2(409,2)=1265;
  v2(409,3)=T757;
  v2(410,1)=43;
  v2(410,2)=1575;
  v2(410,3)=(-T226);
  v2(411,1)=43;
  v2(411,2)=1113;
  v2(411,3)=  v2(410,3);
  v2(412,1)=43;
  v2(412,2)=1576;
  v2(412,3)=T271;
  v2(413,1)=43;
  v2(413,2)=1191;
  v2(413,3)=  v2(412,3);
  g2 = sparse(v2(:,1),v2(:,2),v2(:,3),45,6084);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],45,474552);
end
end
end
end
