function [residual, g1, g2, g3] = flexprice_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations.
%                                          Dynare may prepend or append auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g3        [M_.endo_nbr by (M_.endo_nbr)^3] double   Third derivatives matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 13, 1);

%
% Model equations
%

T31 = y(4)^(params(7)/(1-params(7)));
T41 = params(6)^(1/(1-params(7)));
T63 = (1-y(6)*(1-params(9)))^params(7);
T87 = (y(11)/params(3))^(-1);
T93 = params(3)^params(18);
lhs =y(2);
rhs =y(6)*(exp(y(12))-y(1))-params(8)*y(7)+params(5);
residual(1)= lhs-rhs;
lhs =y(3);
rhs =params(2);
residual(2)= lhs-rhs;
lhs =T31;
rhs =(1-params(10))*(exp(y(12))-y(1)+params(11)-y(13))*T41/params(8)+T31*y(3)*(1-params(9));
residual(3)= lhs-rhs;
lhs =y(5);
rhs =params(9)*(1-y(4));
residual(4)= lhs-rhs;
lhs =y(6);
rhs =y(6)*(1-y(5))+y(4)*(1-y(6));
residual(5)= lhs-rhs;
lhs =y(7);
rhs =((y(6)-y(6)*(1-params(9)))/T63)^(1/(1-params(7)));
residual(6)= lhs-rhs;
lhs =y(9);
rhs =(-log(params(1)))+y(9)*params(2)*(1-y(5)-y(4));
residual(7)= lhs-rhs;
lhs =y(10);
rhs =params(8)*T31/T41;
residual(8)= lhs-rhs;
lhs =y(9)/params(16);
rhs =y(10)/params(17)*T87;
residual(9)= lhs-rhs;
lhs =y(1);
rhs =y(11)^(1-params(18))*T93;
residual(10)= lhs-rhs;
lhs =y(8);
rhs =y(6)*exp(y(12));
residual(11)= lhs-rhs;
lhs =y(12);
rhs =y(12)*params(19)-x(1);
residual(12)= lhs-rhs;
lhs =y(13);
rhs =y(13)*params(20)+x(2);
residual(13)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(13, 13);

  %
  % Jacobian matrix
  %

T116 = getPowerDeriv(y(4),params(7)/(1-params(7)),1);
  g1(1,1)=y(6);
  g1(1,2)=1;
  g1(1,6)=(-(exp(y(12))-y(1)));
  g1(1,7)=params(8);
  g1(1,12)=(-(y(6)*exp(y(12))));
  g1(2,3)=1;
  g1(3,1)=(-(T41*(-(1-params(10)))/params(8)));
  g1(3,3)=(-(T31*(1-params(9))));
  g1(3,4)=T116-y(3)*(1-params(9))*T116;
  g1(3,12)=(-(T41*exp(y(12))*(1-params(10))/params(8)));
  g1(3,13)=(-(T41*(-(1-params(10)))/params(8)));
  g1(4,4)=params(9);
  g1(4,5)=1;
  g1(5,4)=(-(1-y(6)));
  g1(5,5)=y(6);
  g1(5,6)=1-(1-y(5)-y(4));
  g1(6,6)=(-((T63*(1-(1-params(9)))-(y(6)-y(6)*(1-params(9)))*(-(1-params(9)))*getPowerDeriv(1-y(6)*(1-params(9)),params(7),1))/(T63*T63)*getPowerDeriv((y(6)-y(6)*(1-params(9)))/T63,1/(1-params(7)),1)));
  g1(6,7)=1;
  g1(7,4)=(-(y(9)*(-params(2))));
  g1(7,5)=(-(y(9)*(-params(2))));
  g1(7,9)=1-params(2)*(1-y(5)-y(4));
  g1(8,4)=(-(params(8)*T116/T41));
  g1(8,10)=1;
  g1(9,9)=1/params(16);
  g1(9,10)=(-(T87*1/params(17)));
  g1(9,11)=(-(y(10)/params(17)*1/params(3)*getPowerDeriv(y(11)/params(3),(-1),1)));
  g1(10,1)=1;
  g1(10,11)=(-(T93*getPowerDeriv(y(11),1-params(18),1)));
  g1(11,6)=(-exp(y(12)));
  g1(11,8)=1;
  g1(11,12)=(-(y(6)*exp(y(12))));
  g1(12,12)=1-params(19);
  g1(13,13)=1-params(20);
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],13,169);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],13,2197);
end
end
end
end
