%--------------------------------------------------------------------------
% 1. Declare variables and parameters
%--------------------------------------------------------------------------

var                                       % (23) variables incl. 1 instrument, for 22 model equations)
    i Me w deltat                         % Employed workers
    CF MF                                 % Firm owners
    f s n v                               % Labor market flows
    g ps K F Delta pi                     % Wholesale firms
    Y W                                   % Output, welfare
    Sw J wN                               % Nash wage
    z zeta ;                              % Exogenous state variables
               
varexo 
    epsz ezeta;                           % Productivity, cost-push

parameters
    ratio beta wSS                        % Employed workers
    sigma_tilde varpi                     % Firm owners                    
    m gamma eta rho tauI T fSS sSS        % Labor market flows
    theta omega tauW                      % Wholesale firms
    SwSS JSS phi                          % Nash bargaining
    Lambda_tilde                          % Transformed welfare weight
    mu_z mu_zeta;                         % Auto-correlation of shocks
   

%----------------------------------------------------------------
% 2. Calibration
%----------------------------------------------------------------
                  
load param;
set_param_value('ratio',ratio);
set_param_value('beta',beta);
set_param_value('wSS',wSS);
set_param_value('SwSS',SwSS);
set_param_value('JSS',JSS);
set_param_value('gamma',gamma);
set_param_value('sigma_tilde',sigma_tilde);
set_param_value('eta',eta);
set_param_value('tauI',tauI);
set_param_value('T',T);
set_param_value('tauW',tauW);
set_param_value('Lambda_tilde',Lambda_tilde);
set_param_value('phi', phi);
set_param_value('mu_z', mu_z);
set_param_value('mu_zeta', mu_zeta);
set_param_value('omega', omega);
set_param_value('varpi', varpi);
fSS     = 0.8;
sSS     = 0.05;
m       = fSS^(gamma)*lambdaSS^(1-gamma);
rho     = sSS/(1-fSS);
theta   = 6;

%----------------------------------------------------------------
% 3. Model
%----------------------------------------------------------------

model;

%WORKERS
deltat = ratio*w;                                                      % (01) Home production
Me(+1)*(1+i)/(1+pi(+1)) = 1;                                           % (02) Bond Euler condition
Me = beta*((1-s)/w + s/deltat)/(1/w(-1));                              % (03) IRMS of employed workers

%FIRM OWNERS
CF = n*(exp(z)/Delta - w) - eta*v + varpi ;                            % (04) Total consumption of firm owners
MF = beta*(CF/CF(-1))^-sigma_tilde ;                                   % (05) IRMS of firm owners            

%LABOR MARKET FLOWS
f^(gamma/(1-gamma))=(1-tauI)*(exp(z)*g-w+T-zeta)*m^(1/(1-gamma))/eta        
  + (1-rho)*MF(+1)*f(+1)^(gamma/(1-gamma));                            % (06) Job finding rate
s = rho*(1-f);                                                         % (07) Period-to-period job-loss rate
n = (1-s)*n(-1)+(1-n(-1))*f;                                           % (08) Employment rate
v = ((n-(1-rho)*n(-1))/(1-(1-rho)*n(-1))^gamma)^(1/(1-gamma));         % (09) Vacancies

%WHOLESALE FIRM
ps    = theta*(1-tauW)*K/((theta-1)*F);                                % (10) Optimal reset price
K     = g*Y + omega*((1+pi(+1))^theta)*MF(+1)*K(+1);                   % (11) Numerator in (11)
F     = Y + omega*((1+pi(+1))^(theta-1))*MF(+1)*F(+1);                 % (12) Denominator in (11)
1     = (1-omega)*(ps)^(1-theta) + omega*(1+pi)^(-(1-theta));          % (13) Inflation dynamics
Delta = (1-omega)*(ps)^(-theta) + omega*Delta(-1)*(1+pi)^theta;        % (14) Price dispersion dynamics

%NASH WAGE
Sw = -log(ratio)+beta*(1-s(+1)-f(+1))*Sw(+1);                          % (15) Value of being employed (Ve-Vu)
J = eta*f^(gamma/(1-gamma))/m^(1/(1-gamma));                           % (16) Job value (from free-entry condition)
Sw/SwSS = (J/JSS)*(wN/wSS)^-1;                                         % (17) Nash wage  
w = (wN^(1-phi))*(wSS^phi);                                            % (18) Nash-bargained wage: (wN^0.06)*(wSS^0.94)

%MARKET CLEARING AND WELFARE
Delta*Y = exp(z)*n;                                                    % (19) Market clearing
W=n*log(w)+(1-n)*log(deltat)+(Lambda_tilde/(1-sigma_tilde))*CF^(1-sigma_tilde); 
                                                                       % (20) Welfare
%SHOCKS
z    = mu_z*z(-1)    - epsz  ;                                         % (21) Productivity
zeta = mu_zeta*zeta(-1) + ezeta ;                                      % (22) Cost-push

end;

%----------------------------------------------------------------
% 4. Computation
%----------------------------------------------------------------

%STEADY STATE
initval;
i   = iSS;
Me  = MeSS;
w   = wSS;
wN  = wSS;
deltat = ratio*wSS;                    
CF  = CFSS;
MF  = beta;
f   = fSS;
s   = sSS;
n   = nSS;
v   = vSS;
g   = gSS;
ps  = 1;
K   = KSS;
F   = FSS; 
Delta = 1;
pi  = 0.0;              
Y   = nSS;
W   =  nSS*log(wSS)+(1-nSS)*log(ratio*wSS)+(Lambda_tilde/(1-sigma_tilde))*CFSS^(1-sigma_tilde);
Sw  = SwSS;
J   = JSS;
z   = 0;
zeta= 0;
end;

%SHOCKS
shocks;
var epsz      =  stdepsz^2;
var ezeta     =  stdezeta^2;
end;

%COMPUTATION OF OPTIMAL POLICY
planner_objective(W);
ramsey_policy(planner_discount=beta,order=1,nograph,instruments=(i)) z zeta w n i pi Y J Sw CF MF;
