%--------------------------------------------------------------------------
% 1. Declare variables and parameters
%--------------------------------------------------------------------------

var                                       % (13 variables for 13 model equations)
    w                                     % Employed workers
    CF MF                                 % Firm owners
    f s n v                               % Labor market flows
    Y                                     % Output, welfare
    Sw J wN                               % Nash wage
    z zeta;                               % Exogenous state
            
varexo 
    epsz ezeta;                           % Productivity, cost-push

parameters
    ratio beta wSS                        % Employed workers
    sigma_tilde varpi                     % Firm owners                    
    m gamma eta rho tauI T fSS sSS        % Labor market flows
    theta tauW                            % Wholesale firms
    SwSS JSS phi                          % Nash bargaining
    mu_z mu_zeta;                         % Auto-correlation of shocks

%----------------------------------------------------------------
% 2. Calibration
%----------------------------------------------------------------

load param;
set_param_value('ratio',ratio);
set_param_value('beta',beta);
set_param_value('wSS',wSS);
set_param_value('SwSS',SwSS);
set_param_value('JSS',JSS);
set_param_value('gamma',gamma);
set_param_value('sigma_tilde',sigma_tilde);
set_param_value('eta',eta);
set_param_value('tauI',tauI);
set_param_value('T',T);
set_param_value('tauW',tauW);
set_param_value('phi', phi);
set_param_value('mu_z', mu_z);
set_param_value('mu_zeta', mu_zeta);
set_param_value('varpi', varpi);     
fSS     = 0.8;
sSS     = 0.05;
m       = fSS^(gamma)*lambdaSS^(1-gamma);
rho     = sSS/(1-fSS);
theta   = 6;

%----------------------------------------------------------------
% 3. Model
%----------------------------------------------------------------

model;

%FIRM OWNERS
CF = n*(exp(z) - w) - eta*v + varpi ;                              % (01) Total consumption of firm owners
MF = beta*(CF/CF(-1))^-sigma_tilde ;                               % (02) IRMS of firm owners

%LABOR MARKET FLOWS
f^(gamma/(1-gamma))=(1-tauI)*(exp(z)-w+T-zeta)*m^(1/(1-gamma))/eta        
  + (1-rho)*MF(+1)*f(+1)^(gamma/(1-gamma));                        % (03) Job finding rate
s = rho*(1-f);                                                     % (04) Period-to-period job-loss rate
n = (1-s)*n(-1)+(1-n(-1))*f;                                       % (05) Employment rate
v = ((n-(1-rho)*n(-1))/(1-(1-rho)*n(-1))^gamma)^(1/(1-gamma));     % (06) Vacancies

%NASH WAGE
Sw = -log(ratio)+beta*(1-s(+1)-f(+1))*Sw(+1);                      % (07) Value of being employed (Ve-Vu)
J = eta*f^(gamma/(1-gamma))/m^(1/(1-gamma));                       % (08) Job value (from free-entry condition)
Sw/SwSS = (J/JSS)*(wN/wSS)^-1;                                     % (09) Nash wage  
w = (wN^(1-phi))*(wSS^phi);                                        % (10) Nash-bargained wage

%MARKET CLEARING AND MONETARY POLICY
Y = exp(z)*n;                                                      % (11) Market clearing

%SHOCKS
z    = mu_z*z(-1)    - epsz  ;                                     % (12) Productivity shock
zeta = mu_zeta*zeta(-1) + ezeta ;                                  % (13) Cost-push shock

end;

%----------------------------------------------------------------
% 4. Computation
%----------------------------------------------------------------

%STEADY STATE
initval;
w   = wSS;
wN  = wSS;                
CF  = CFSS;
MF  = beta;
f   = fSS;
s   = sSS;
n   = nSS;
v   = vSS;       
Y   = nSS;
Sw  = SwSS;
J   = JSS;
z   = 0;
zeta= 0;
end;

%SHOCKS
shocks;
var epsz      =  stdepsz^2;
var ezeta     =  stdezeta^2;
end;

%STOCHASTIC SIMULATION
stoch_simul (order=1,nograph) z zeta w s n Y J MF;  
