clear all; 
close all; 
clc;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FIGURE 1                                                                %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Plot Figure Average Population Age (20-64 Years Old) 
% Year:  1950   1955   1960   1965   1970   1975   1980   1985   1990   1995   2000   2005   2010   2015
avg_age_pop_2064=[39.70776944	40.43602404	40.74754722	40.74729527	40.30277348	39.49764723	38.94311757	38.83121308	38.84415641	39.52502469	40.4407236	41.09700885	41.60355455	41.76760277];

f1=figure;  
subplot(1,2,1)
plot(1950:5:2015,avg_age_pop_2064,'-o','MarkerSize',4,'LineWidth',2,'Color',[0.0 0 0.5]);
xl=xlabel('year');
yl=ylabel('average age');
set(gca,'XTick',[1950 1960 1970 1980 1990 2000 2010]);
set(gca,'XTickLabel',['1950';'1960';'1970';'1980';'1990';'2000';'2010'])
ti=title('A. Average Age');
set([xl,yl], 'FontName', 'AvantGarde','FontSize',12);
set(ti, 'FontName', 'AvantGarde','FontSize',16);
axis([1950 2015 38.5 42])
grid on

% Plot Figure Age Composition Population (20-64 Years Old)
% Age group:       20-24           25-34        35-44      45-54       55-64  
pop_shares_by_age=[0.129617385	0.269206353	0.241927996	0.201682812	0.157565455;
    0.103173572	0.265445794	0.255154088	0.212851141	0.163375404;
    0.112010232	0.239846979	0.2555306	0.224604772	0.168007417;
    0.129400587	0.22275977	0.24787709	0.225984781	0.173977772;
    0.147953898	0.235954788	0.217175308	0.222680556	0.176235451;
    0.161404608	0.26654325	0.1955281	0.204282048	0.172241994;
    0.162668386	0.288183656	0.201628722	0.177873386	0.169645851;
    0.147017628	0.297500445	0.229536055	0.163989142	0.16195673;
    0.130003414	0.295582453	0.259412567	0.172499061	0.142502504;
    0.117048361	0.267312699	0.276846193	0.202935695	0.135857053;
    0.112199604	0.237161366	0.271525483	0.230644061	0.148469486;
    0.116118872	0.223713262	0.246288555	0.241136449	0.172742862;
    0.115502144	0.224465968	0.220008831	0.243095938	0.196927118;
    0.117166346	0.227805374	0.211577986	0.227293832	0.216156463];

pop_shares_by_age_3_groups=[pop_shares_by_age(:,1)+pop_shares_by_age(:,2)...
        pop_shares_by_age(:,3)+pop_shares_by_age(:,4) pop_shares_by_age(:,5)];
    
subplot(1,2,2)
[AX,H1,H3]=plotyy(1950:5:2015,pop_shares_by_age_3_groups(:,1)*100,1950:5:2015,pop_shares_by_age_3_groups(:,3)*100);
set(gca,'XTick',[1950 1960 1970 1980 1990 2000 2010]);
set(gca,'XTickLabel',['1950';'1960';'1970';'1980';'1990';'2000';'2010'])
set(AX,'XLim',[1950 2015])
set(AX(1),'ycolor',[0 0 0.5])
set(AX(2),'ycolor',[0.9 0 0])
set(AX(1),'YLim',[30 55])
set(AX(1),'YTick',[30 35 40 45 50 55]);
set(AX(2),'YLim',[5 25])
set(get(AX(1),'Ylabel'),'String','percent','FontName', 'AvantGarde','FontSize',12) 
set(get(AX(2),'Ylabel'),'String','percent','FontName', 'AvantGarde','FontSize',12) 
set(H1,'LineStyle','-','Marker','o','MarkerSize',4,'LineWidth',2,'Color',[0 0 0.5])
set(H3,'LineStyle','-.','Marker','d','MarkerSize',4,'LineWidth',2,'Color',[0.9 0 0.0])
xl=xlabel('year');
suptitle('Working-Age Population');
ti=title('B. Shares by Age');
set(xl,'FontName','AvantGarde','FontSize',12);
set(ti,'FontName','AvantGarde','FontSize',16);
grid on
axes(AX(1))
hold on
H2=plot(1950:5:2015,pop_shares_by_age_3_groups(:,2)*100,'--s','MarkerSize',4,'LineWidth',2,'Color',[0 0 0.5]);
hold off
axes(AX(2))
set(AX(2),'YTickMode', 'auto', 'YTickLabelMode', 'auto')
legend([H1;H2;H3],'20-34','35-54','55-64','Location','NorthWest')
legend boxoff
set(gcf,'Position',[50 50 800 600])
str=strcat('FF_figures/','AGING_Figure1');
saveas(gcf,str,'epsc');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FIGURE B1                                                               %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Plot Figure Average Labor Force Age (20-64 Years Old) 
% Year:  1950   1955   1960   1965   1970   1975   1980   1985   1990   1995   2000   2005   2010   2015
avg_age_lf_2064=[39.37  40.38  40.72  40.69  40.05  38.63  37.79  37.61  37.91  38.74  39.66  40.49  41.10   41.21];
 
f2=figure; 
subplot(1,2,1)
plot(1950:5:2015,avg_age_lf_2064,'-o','MarkerSize',7,'LineWidth',3,'Color',[0.0 0 0.5]);
xl=xlabel('year');
yl=ylabel('average age');
set(gca,'XTick',[1950 1960 1970 1980 1990 2000 2010]);
set(gca,'XTickLabel',['1950';'1960';'1970';'1980';'1990';'2000';'2010'])
ti=title('A. Average Age');
set([ti,xl,yl], 'FontName', 'AvantGarde','FontSize',10);
axis([1950 2015 37 42])
grid on

% Plot Figure Age Composition Labor Force (20-64 Years Old)
% Age group:       20-24           25-34        35-44      45-54       55-64  
lf_shares_by_age=[0.13295677	0.266021001	0.253905023	0.208228798	0.138888409;
    0.098294378	0.261307441	0.26724307	0.22544634	0.147708772;
    0.108826152	0.233521339	0.264155191	0.241119966	0.152377351;
    0.126191272	0.217493744	0.257357038	0.240794303	0.158163643;
    0.14654699	0.235611908	0.227364139	0.234417097	0.156059865;
    0.167789206	0.278984441	0.206282234	0.20847927	0.138464849;
    0.168470727	0.309249093	0.216524544	0.178933793	0.126821844;
    0.150195247	0.320571863	0.249120407	0.165524644	0.114587839;
    0.128272874	0.313541764	0.280492952	0.176687168	0.101005242;
    0.113389117	0.283285047	0.296149195	0.208930943	0.098245699;
    0.109615617	0.251968203	0.288977815	0.239007408	0.110430958;
    0.11051128	0.236272114	0.263231623	0.25133542	0.138649562;
    0.106382504	0.237950725	0.236192974	0.254559716	0.164914082;
    0.107224779	0.24274919	0.22931707	0.23966733	0.18104164];

lf_shares_by_age_3_groups=[lf_shares_by_age(:,1)+lf_shares_by_age(:,2)...
        lf_shares_by_age(:,3)+lf_shares_by_age(:,4) lf_shares_by_age(:,5)];
   
subplot(1,2,2)
[AX,H1,H3]=plotyy(1950:5:2015,lf_shares_by_age_3_groups(:,1)*100,1950:5:2015,lf_shares_by_age_3_groups(:,3)*100);
set(gca,'XTick',[1950 1960 1970 1980 1990 2000 2010]);
set(gca,'XTickLabel',['1950';'1960';'1970';'1980';'1990';'2000';'2010'])
set(AX,'XLim',[1950 2015])
set(AX(1),'ycolor',[0 0 0.5])
set(AX(2),'ycolor',[0.9 0 0])
set(AX(1),'YLim',[30 55])
set(AX(1),'YTick',[30 35 40 45 50 55]);
set(AX(2),'YLim',[5 25])
set(get(AX(1),'Ylabel'),'String','percent','FontName', 'AvantGarde','FontSize',10) 
set(get(AX(2),'Ylabel'),'String','percent','FontName', 'AvantGarde','FontSize',10) 
set(H1,'LineStyle','-','Marker','o','MarkerSize',7,'LineWidth',2,'Color',[0.0 0 0.5])
set(H3,'LineStyle','-.','Marker','d','MarkerSize',7,'LineWidth',2,'Color',[0.9 0 0])
xl=xlabel('year');
suptitle('Labor Force');
ti=title('B. Shares by Age');
set([ti,xl],'FontName','AvantGarde','FontSize',10);
grid on
axes(AX(1))
hold on
H2=plot(1950:5:2015,lf_shares_by_age_3_groups(:,2)*100,'--s','MarkerSize',7,'LineWidth',3,'Color',[0 0 0.5]);
hold off
axes(AX(2))
set(AX(2),'YTickMode', 'auto', 'YTickLabelMode', 'auto')
legend([H1;H2;H3],'20-34','35-54','55-64','Location','NorthWest')
legend boxoff
set(gcf,'Position',[50 50 800 600])
str=strcat('FF_figures/','AGING_FigureB1');
saveas(gcf,str,'epsc');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FIGURE B2                                                               %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Plot Figure Average Employed (20-64 Years Old) 
% Year:  1950   1955   1960   1965   1970   1975   1980   1985   1990   1995   2000   2005   2010   2015
avg_age_emp_2064=[39.45693222 40.43388382 40.84483044 40.80033953 40.2309506 38.96876591 38.09562019 37.84400941 38.07767868 38.90008559 39.78787898 40.65480282 41.36995262 41.36632061];

f4=figure; 
subplot(1,2,1)
plot(1950:5:2015,avg_age_emp_2064,'-o','MarkerSize',7,'LineWidth',3,'Color',[0.0 0 0.5]);
xl=xlabel('year');
yl=ylabel('average age');
set(gca,'XTick',[1950 1960 1970 1980 1990 2000 2010]);
set(gca,'XTickLabel',['1950';'1960';'1970';'1980';'1990';'2000';'2010'])
ti=title('A. Average Age');
set([ti,xl,yl], 'FontName', 'AvantGarde','FontSize',10);
axis([1950 2015 37 42])
grid on

% Plot Figure Age Composition Employed (20-64 Years Old)
% Age group:       20-24           25-34        35-44      45-54       55-64  
emp_shares_by_age=[0.128925974	0.266011039	0.256603646	0.209593966	0.138865375;
0.095179639	0.261693841	0.268865379	0.226875691	0.14738545;
0.10445978	0.232707633	0.266304012	0.243061859	0.153466716;
0.122138672	0.217347348	0.258451727	0.243000528	0.159061725;
0.140173129	0.235069936	0.229375274	0.237295352	0.158086309;
0.156487502	0.277640656	0.210079587	0.213214134	0.142578121;
0.158936558	0.306910366	0.220263848	0.183167095	0.130722133;
0.142794089	0.318758545	0.252604677	0.16863624	0.11720645;
0.123089534	0.311722451	0.283064947	0.179349133	0.102773935;
0.108387009	0.281817734	0.297883359	0.212320237	0.09959166;
0.105382541	0.251347396	0.290260454	0.241464477	0.111545132;
0.105550218	0.234813557	0.265054964	0.254155802	0.140425459;
0.098882443	0.235389621	0.238778708	0.258469297	0.168479931;
0.103462285	0.241358288	0.230415304	0.240861584	0.183902538];
                 
emp_shares_by_age_3_groups=[emp_shares_by_age(:,1)+emp_shares_by_age(:,2)...
        emp_shares_by_age(:,3)+emp_shares_by_age(:,4) emp_shares_by_age(:,5)];
    
subplot(1,2,2)
[AX,H1,H3]=plotyy(1950:5:2015,emp_shares_by_age_3_groups(:,1)*100,1950:5:2015,emp_shares_by_age_3_groups(:,3)*100);
set(gca,'XTick',[1950 1960 1970 1980 1990 2000 2010]);
set(gca,'XTickLabel',['1950';'1960';'1970';'1980';'1990';'2000';'2010'])
set(AX,'XLim',[1950 2015])
set(AX(1),'ycolor',[0 0 0.5])
set(AX(2),'ycolor',[0.9 0 0])
set(AX(1),'YLim',[30 55])
set(AX(1),'YTick',[30 35 40 45 50 55]);
set(AX(2),'YLim',[5 25])
set(get(AX(1),'Ylabel'),'String','percent','FontName', 'AvantGarde','FontSize',10) 
set(get(AX(2),'Ylabel'),'String','percent','FontName', 'AvantGarde','FontSize',10) 
set(H1,'LineStyle','-','Marker','o','MarkerSize',7,'LineWidth',2,'Color',[0.0 0 0.5])
set(H3,'LineStyle','-.','Marker','d','MarkerSize',7,'LineWidth',2,'Color',[0.9 0 0])
xl=xlabel('year');
suptitle('Employed Persons');
ti=title('B. Shares by Age');
set([ti,xl],'FontName','AvantGarde','FontSize',10);
grid on
axes(AX(1))
hold on
H2=plot(1950:5:2015,emp_shares_by_age_3_groups(:,2)*100,'--s','MarkerSize',7,'LineWidth',2,'Color',[0 0 0.5]);
hold off
axes(AX(2))
set(AX(2),'YTickMode', 'auto', 'YTickLabelMode', 'auto')
legend([H1;H2;H3],'20-34','35-54','55-64','Location','NorthWest')
legend boxoff
set(gcf, 'PaperPositionMode', 'manual');
set(gcf, 'PaperUnits', 'inches');
set(gcf,'Position',[50 50 800 600])
str=strcat('FF_figures/','AGING_FigureB2');
saveas(gcf,str,'epsc');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FIGURE B3                                                               %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Plot Figure Average Unemployed (20-64 Years Old) 
% Year:  1950   1955   1960   1965   1970   1975   1980   1985   1990   1995   2000   2005   2010   2015
avg_age_unemp_2064=[37.7485463 38.97237772 38.26944684 37.72708523 35.57608277 34.3209238 33.10376615 34.2576118 34.64484522 35.56411385 36.09632534 37.0244187	38.43180861	37.60705823];

f3=figure; 
subplot(1,2,1)
plot(1950:5:2015,avg_age_unemp_2064,'-o','MarkerSize',7,'LineWidth',2,'Color',[0.0 0 0.5]);
xl=xlabel('year');
yl=ylabel('average age');
set(gca,'XTick',[1950 1960 1970 1980 1990 2000 2010]);
set(gca,'XTickLabel',['1950';'1960';'1970';'1980';'1990';'2000';'2010'])
ti=title('A. Average Age');
set([ti,xl,yl], 'FontName', 'AvantGarde','FontSize',10);
axis([1950 2015 32 40])
grid on

% Plot Figure Age Composition Unemployed (20-64 Years Old) 
% Age group:       20-24           25-34        35-44      45-54       55-64  
unemp_shares_by_age=[0.210860492	0.265754594	0.202802468	0.181549808	0.139032639;
                     0.174929715	0.251049006	0.22587443	0.191879921	0.156266929;
                     0.193602067	0.249752227	0.222330855	0.203129175	0.131185677;
                     0.233722654	0.220299109	0.228675921	0.182582357	0.13471996;
                     0.299846913	0.248496111	0.178557145	0.165363176	0.107736655;
                     0.310746534	0.295856276	0.158169511	0.148700266	0.086527412;
                     0.31240235	    0.344337964	0.160020714	0.115059256	0.068179717;
                     0.257570253	0.34698429	0.198557408	0.120282685	0.076605364;
                     0.227362568	0.348068807	0.231461588	0.125776249	0.067330787;
                     0.210925634	0.311508622	0.262548586	0.142994451	0.072022707;
                     0.228161776	0.26963975	0.252848523	0.170144509	0.079205441;
                     0.214474614	0.267085578	0.224908081	0.19220543	0.101326296;
                     0.18146746	    0.263649075	0.20995713	0.215454678	0.129471657;
                     0.215513209	0.272234605	0.19217382	0.17877699	0.141301376];
                 
unemp_shares_by_age_3_groups=[unemp_shares_by_age(:,1)+unemp_shares_by_age(:,2)...
        unemp_shares_by_age(:,3)+unemp_shares_by_age(:,4) unemp_shares_by_age(:,5)];

subplot(1,2,2)
[AX,H1,H3]=plotyy(1950:5:2015,unemp_shares_by_age_3_groups(:,1)*100,1950:5:2015,unemp_shares_by_age_3_groups(:,3)*100);
set(gca,'XTick',[1950 1960 1970 1980 1990 2000 2010]);
set(gca,'XTickLabel',['1950';'1960';'1970';'1980';'1990';'2000';'2010'])
set(AX,'XLim',[1950 2015])
set(AX(1),'ycolor',[0 0 0.5])
set(AX(2),'ycolor',[0.9 0 0])
set(AX(1),'YLim',[20 70])
set(AX(1),'YTick',[20 25 30 35 40 45 50 55 60 65 70]);
set(AX(2),'YLim',[5 25])
set(get(AX(1),'Ylabel'),'String','percent','FontName', 'AvantGarde','FontSize',10) 
set(get(AX(2),'Ylabel'),'String','percent','FontName', 'AvantGarde','FontSize',10) 
set(H1,'LineStyle','-','Marker','o','MarkerSize',7,'LineWidth',2,'Color',[0.0 0 0.5])
set(H3,'LineStyle','-.','Marker','d','MarkerSize',7,'LineWidth',2,'Color',[0.9 0 0])
xl=xlabel('year');
suptitle('Unemployed Persons');
ti=title('B. Shares by Age');
set([ti,xl],'FontName','AvantGarde','FontSize',10);
grid on
axes(AX(1))
hold on
H2=plot(1950:5:2015,unemp_shares_by_age_3_groups(:,2)*100,'--s','MarkerSize',7,'LineWidth',2,'Color',[0 0 0.5]);
hold off
axes(AX(2))
set(AX(2),'YTickMode', 'auto', 'YTickLabelMode', 'auto')
legend([H1;H2;H3],'20-34','35-54','55-64','Location','NorthWest')
legend boxoff
set(gcf,'Position',[50 50 800 600])
str=strcat('FF_figures/','AGING_FigureB3');
saveas(gcf,str,'epsc');
