function D = EISTsysinit(X)

global RMsub manutrade trade t eta gamma alfa mu l aM aMs delta aA ksi1A ksi1M ksi1Ms  ksi2 Lbar kappatoll avTgr avMgr avAgr avTsgr avMsgr avAsgr fc aY aH ar tdum
global w rp rw p_E rr zeta Z_M Z_A zA zM Z_T Z_M_Mor Z_A_Mor c_M c_A p_M p_A M A L_T L_M L_Ms L_A L R_M R_Ms R_A phi_M phi_Ms phi_A theta Po_M Po_A ES_M Ubar RI AN AS phiMhat phiAhat LMMer LAAer LMmis LTsub TS kappa kappaq boldkappaq TTsub

p_A(:,t) = ones(length(l),1);

Ubar(t) = X(1);
p_M(1,t) = X(2);
RI(t) = X(3);

Z_M(:,t) = Z_M_Mor(:,t);
Z_A(:,t) = Z_A_Mor(:,t);

for i = 1:length(l)
    
    %Wages and consumption
    
    w(i,t) = (Ubar(t)*(((p_A(i,t)./p_M(i,t))*((1-eta)/eta))^(eta-1))+gamma)*(p_A(i,t)./eta)-p_A(i,t).*((1-eta)/eta)*gamma - RI(t);
    c_A(i,t) = (w(i,t)+RI(t)+p_A(i,t).*((1-eta)/eta)*gamma)*(eta./p_A(i,t));
    c_M(i,t) = (c_A(i,t)-gamma).*((p_A(i,t).*(1-eta))/(p_M(i,t).*eta));
    
    %Production and labor choices
    
    L_M(i,t) = ((w(i,t).*(aM-1))/(aM*mu.*p_M(i,t).*Z_M(i,t)))^(1/(mu-1));
    L_A(i,t) = ((w(i,t).*(aA-1))/(aA*alfa.*p_A(i,t).*Z_A(i,t)))^(1/(alfa-1));
    
    %Potential Outputs
    M(i,t) = (Z_M(i,t)).*L_M(i,t).^mu;
    A(i,t) = (Z_A(i,t)).*L_A(i,t).^alfa;
    
    %kappatoll
    
    %negflag = @(y) (sign(y-(TTsub*Z_T(t)*TS(i,t)))+1)/2;
    %kapp = @(x) negflag(x)*(LTsub*w(i,t)/(TTsub*Z_T(t)*zeta))*(((zeta*(1-zeta)*(((((x/(TTsub*Z_T(t)*TS(i,t))))^rr)-1)^-1))+zeta)^((rr-1)/rr));
    %got rid of anonymous functions in favour of direct equation below
    %(((sign(tdemand(i,t)-(TTsub*Z_T(t)*TS(i,t)))+1)/2)*((LTsub*w(i,t))/(TTsub*Z_T(t)*zeta))*(((zeta*(1-zeta)*(((((tdemand(i,t)/(TTsub*Z_T(t)*TS(i,t))))^rr)-1)^-1))+zeta)^((rr-1)/rr)))
    
    %Calculate tertiary labour
    
    L_TA = 0;
    L_TM = 0;
    
    
    
    if i > 1
        L_TA = (((((LTsub*w(i,t)/((((sign((abs(ES_M(i-1,t))+A(i,t))-(TTsub*Z_T(t)*TS(i,t)))+1)/2)*((LTsub*w(i,t))/(TTsub*Z_T(t)*zeta))*(((zeta*(1-zeta)*((((((abs(ES_M(i-1,t))+A(i,t))/(TTsub*Z_T(t)*TS(i,t))))^rr)-1)^-1))+zeta)^((rr-1)/rr)))*TTsub*Z_T(t)*zeta))^(rr/(1-rr)))-zeta)/(1-zeta))^(-1/rr))*TS(i,t);
        L_TM = (((((LTsub*w(i,t)/((((sign((abs(ES_M(i-1,t))+M(i,t))-(TTsub*Z_T(t)*TS(i,t)))+1)/2)*((LTsub*w(i,t))/(TTsub*Z_T(t)*zeta))*(((zeta*(1-zeta)*((((((abs(ES_M(i-1,t))+M(i,t))/(TTsub*Z_T(t)*TS(i,t))))^rr)-1)^-1))+zeta)^((rr-1)/rr)))*TTsub*Z_T(t)*zeta))^(rr/(1-rr)))-zeta)/(1-zeta))^(-1/rr))*TS(i,t);
    else
        L_TA = (((((LTsub*w(i,t)/((((sign((A(i,t))-(TTsub*Z_T(t)*TS(i,t)))+1)/2)*((LTsub*w(i,t))/(TTsub*Z_T(t)*zeta))*(((zeta*(1-zeta)*((((((A(i,t))/(TTsub*Z_T(t)*TS(i,t))))^rr)-1)^-1))+zeta)^((rr-1)/rr)))*TTsub*Z_T(t)*zeta))^(rr/(1-rr)))-zeta)/(1-zeta))^(-1/rr))*TS(i,t);
        L_TM = (((((LTsub*w(i,t)/((((sign((M(i,t))-(TTsub*Z_T(t)*TS(i,t)))+1)/2)*((LTsub*w(i,t))/(TTsub*Z_T(t)*zeta))*(((zeta*(1-zeta)*((((((M(i,t))/(TTsub*Z_T(t)*TS(i,t))))^rr)-1)^-1))+zeta)^((rr-1)/rr)))*TTsub*Z_T(t)*zeta))^(rr/(1-rr)))-zeta)/(1-zeta))^(-1/rr))*TS(i,t);    
    end
    
    
    R_M(i,t) = p_M(i,t).*Z_M(i,t).*(L_M(i,t).^mu)-w(i,t).*L_M(i,t);
    R_A(i,t) = p_A(i,t).*Z_A(i,t).*(L_A(i,t).^alfa)-w(i,t).*L_A(i,t);
    
    if tdum == 1
        if RMsub*R_M(i,t) > R_A(i,t)
            theta(i,t) = 1;
            L_T(i,t) = L_TM;
        else
            theta(i,t) = 0;
            L_T(i,t) = L_TA;
        end
    else
        if RMsub*(R_M(i,t))> R_A(i,t)
            theta(i,t) = 1;
            L_T(i,t) = 0;
        else
            theta(i,t) = 0;
            L_T(i,t) = 0;
        end
    end
    
    phi_M(i,t) = (theta(i,t)).*phi_M(i,t);
    phi_A(i,t) = (1-theta(i,t)).*phi_A(i,t);
    
    %Aggregate Labor
    L(i,t) = theta(i,t).*L_M(i,t)+(1-theta(i,t)).*L_A(i,t) + L_T(i,t);
    
    %Transport costs
    
    if theta(i,t) == 1
        if i > 1
            tdemand(i,t) = abs(ES_M(i-1,t))+M(i,t);
        else
            tdemand(i,t) = M(i,t);
        end
    else
        if i > 1
            tdemand(i,t) = abs(ES_M(i-1,t))+A(i,t);
        else
            tdemand(i,t) = A(i,t);
        end
    end

    kappatoll(i,t) = ((sign(tdemand(i,t)-(TTsub*Z_T(t)*TS(i,t)))+1)/2)*((LTsub*w(i,t))/(TTsub*Z_T(t)*zeta))*(((zeta*(1-zeta)*(((((tdemand(i,t)/(TTsub*Z_T(t)*TS(i,t))))^rr)-1)^-1))+zeta)^((rr-1)/rr));

    
    kappaq(i,t) = boldkappaq.*exp(-TS(i,t));
    kappa(i,t) = kappaq(i,t) + kappatoll(i,t);
    
    %Construct Excess Supply
    if i > 1
        ES_M(i,t) =  ES_M(i-1,t) + (theta(i,t)*M(i,t) - c_M(i,t).*L(i,t) - kappaq(i,t)*(abs(ES_M(i-1,t))))/(length(l))-trade*manutrade(i,t);
    else
        ES_M(i,t) = (theta(i,t)*M(i,t)-c_M(i,t).*L(i,t))/(length(l))-trade*manutrade(i,t);
    end
    
    %Construct prices for i+1
    if ES_M(i,t) > 0
        if i < length(l)
            p_M(i+1,t) = p_M(i,t)*exp(kappaq(i,t)/length(l));
        end
    else
        if i < length(l)
            p_M(i+1,t) = p_M(i,t)*exp(-kappaq(i,t)/length(l));
        end
    end
    
    %Generate Poisson draws
    Po_M(i,t) = rand;
    Po_A(i,t) = rand;
    
    %Generate Pareto and update productivity after innovation
    if Po_M(i,t) > phi_M(i,t);
        Z_M(i,t) = Z_M(i,t);
    else
        z = gprnd(1/aM,1/aM,1);
        Z_M(i,t) = z*Z_M(i,t);
    end
    if Po_A(i,t) > phi_A(i,t);
        Z_A(i,t) = Z_A(i,t);
    else
        z = gprnd(1/aA,1/aA,1);
        Z_A(i,t) = z*Z_A(i,t);
    end
    
    
    %Actual Outputs
    M(i,t) = theta(i,t).*(Z_M(i,t)).*L_M(i,t).^mu;
    A(i,t) = (1-theta(i,t)).*(Z_A(i,t)).*L_A(i,t).^alfa;
    
end


%Equilibrium in the goods market
if (Ubar(t) > 0 && sum((1-theta(:,t)).*L_A(:,t))/length(l) < 100);
    d1 = ES_M(length(l),t);
    if isreal(d1) == 0
        d1 = 2000000;
    end
else
    d1 = 1000000;
end


%Equilibrium condition in labor market

if (t > 1 && max(phi_A(:,t)) == 0)
    pp = p_M(1,t-1);
else
    pp = 100;
end

if (p_M(1,t)> 0 && p_M(1,t) < pp)
    d2 = sum(L(:,t))/length(l) - Lbar;
    if isreal(d2) == 0
        d2 = 2000000;
    end
else
    d2 = 1000000;
end

%Calculate Rental Income (RI)

if (RI(t) > 0 && min(w(:,t)) > 0)
    d3 = RI(t) - (sum(theta(:,t).*(R_M(:,t))) + sum((1-theta(:,t)).*R_A(:,t)))/(Lbar*length(l));
    if isreal(d3) == 0
        d3 = 2000000;
    end
else
    d3 = 1000000;
end

D = [d1,d2,d3];
