global alfa mu l Lbar kappa w rp rw c_M c_A p_M M A L_T L_M L_A L phi_M phi_Ms phi_A theta ES_M AN AS 

Pc = [.8 .1 .1];
Sc = [.22 .16 .78];
Tc = [.15 .7 .15];

L_Tp=L_T./L;

%average growth rates
avMgr = zeros(1,T);
avAgr = zeros(1,T);
avTgr = zeros(1,T);
avMsgr = zeros(1,T);
avAsgr = zeros(1,T);
avTsgr = zeros(1,T);

for t = 1:T
    if t == 1
        avMgr(t) = NaN;
        avAgr(t) = NaN;
        avTgr(t) = NaN;
        avMsgr(t) = NaN;
        avAsgr(t) = NaN;
        avTsgr(t) = NaN;
    else
        avMgr(t) = (sum(M(:,t))/length(l)-sum(M(:,t-1))/length(l))/(sum(M(:,t-1))/length(l));
        avAgr(t) = (sum(A(:,t))/length(l)-sum(A(:,t-1))/length(l))/(sum(A(:,t-1))/length(l));
        avTgr(t) = (sum(A(:,t))/length(l)+sum(M(:,t))/length(l)-sum(A(:,t-1))/length(l)-sum(M(:,t-1))/length(l))/(sum(M(:,t-1))/length(l)+sum(A(:,t-1))/length(l));
    end
end
n = 3;
for t=1:T
    if t>n & t<T-n
        avMsgr(t) = mean(avMgr(t-n:t+n));
        avAsgr(t) = mean(avAgr(t-n:t+n));
        avTsgr(t) = mean(avTgr(t-n:t+n));
    else
        avMsgr(t) = NaN;
        avAsgr(t) = NaN;
        avTsgr(t) = NaN;
    end
end

figure;

subplot(3,2,1)
hold on
plot([1:T],avMgr,'b',[1:T],avAgr,'r',[1:T],avTgr,'g')
plot([1:T],avMsgr,'b',[1:T],avAsgr,'r',[1:T],avTsgr,'g','linewidth',2)
xlabel('Time')
ylabel('growth rate of M (blue), A (red), and total (green)')
xlim([1 150])

hold off

subplot(3,2,3)
hold on
box
plot([1:T],log(sum(M)./sum((L_M.^mu).*(theta))),'b',[1:T],log(sum(A)./sum((L_A.^alfa).*(1-theta))),'r')
xlabel('Time')
ylabel('Log agg. Z_M (blue) and Z_A(red)')
xlim([1 150])

hold off


subplot(3,2,4)
plot(l,ES_M)
xlabel('Location')
ylabel('ES_M')
xlim([0 length(l)])

rp = (sum(c_A(:,:))./(sum(c_M(:,:))+sum(c_A(:,:))))+sum(c_M(:,:))./(sum(c_M(:,:))+sum(c_A(:,:))).*(sum(p_M)/length(l));
rw = (sum(c_A(:,:))./(sum(c_M(:,:))+sum(c_A(:,:)))).*(sum(w)/length(l))+sum(c_M(:,:))./(sum(c_M(:,:))+sum(c_A(:,:))).*((sum(w)/length(l))./(sum(p_M)/length(l)));


subplot(3,2,2)
hold on
imagesc(1-theta,[0 1.15])
colorbar('off')
title('Land Use (red = agriculture)')
xlabel('Time')
ylabel('Location')
xlim([1 T])
ylim([1 length(l)])


hold off

% %record averages by N and S
% 
% AN = zeros(1,T);
% AS = zeros(1,T);
% LN = zeros(1,T);
% LS = zeros(1,T);
% 
% 
% for t = 1:T
%     
%     AN(t) = 0;
%     AS(t) = 0;
%     LN(t) = 0;
%     LS(t) = 0;
%     
%     for i = 1:length(l)*.5
%         AS(t) = AS(t) + ((1-theta(i,t)).*L_A(i,t));
%         LS(t) = LS(t) + ((1-theta(i,t)).*L_A(i,t)) + (theta(i,t).*L_M(i,t));
%     end
%     
%     for i = (length(l)*.5+1):length(l)
%         AN(t) = AN(t) + ((1-theta(i,t)).*L_A(i,t));
%         LN(t) = LN(t) + ((1-theta(i,t)).*L_A(i,t)) + (theta(i,t).*L_M(i,t));
%     end
%     
%     AN(t) = AN(t)/LN(t);
%     AS(t) = AS(t)/LS(t);
%     LShareN(t) = LN(t)/(LN(t)+LS(t));
% end

subplot(3,2,5)

plot([1:T],sum(p_M)/length(l))
xlabel('Time')
ylabel('Avg. p_M')
xlim([1 T])

subplot(3,2,6)
hold off
plot([1:T],sum((1-theta(:,:)).*L_A(:,:))/(length(l)*Lbar),'r',[1:T],sum(c_M(:,:))./(sum(c_M(:,:))+sum(c_A(:,:))),'g')
xlabel('Time')
ylabel('L_A (red) share. C_M share (green)')
xlim([1 T])

figure;

subplot(1,3,1)
hold on
imagesc(phi_A,[0 1])
colorbar('off')
title('Agricultural Innovation, \phi_A')
xlabel('Time')
ylabel('Location')
xlim([1 T])
ylim([1 length(l)])
hold off

subplot(1,3,2)
hold on
imagesc(phi_M,[0 1])
colorbar('off')
title('Fast Manu Innov, \phi_M')
xlabel('Time')
ylabel('Location')
xlim([1 T])
ylim([1 length(l)])
hold off

subplot(1,3,3)
hold on
imagesc(phi_Ms,[0 1])
colorbar('off')
title('Slow Manu Innov, \phi_{Ms}')
xlabel('Time')
ylabel('Location')
xlim([1 T])
ylim([1 length(l)])
hold off



% figure;
%
% subplot(3,1,1)
% stairs(l,(1-theta(:,1:T)).*L_A(:,1:T))
% title('L_A')
%
% subplot(3,1,2)
% stairs(l,theta(:,1:T).*L_M(:,1:T))
% title('L_M')
%
% subplot(3,1,3)
% stairs(l,L_T(:,1:T))
% title('L_T')

figure;

hold on
ad = plot(indrev(156:327,1),indrev(156:327,13));
ad.Color = Pc;
ad.LineWidth = 2;

am = plot([1710:1710+T-1],sum((1-theta(:,:)).*L_A(:,:))/500);
am.Color = Pc;

bd = plot(indrev(156:327,1),indrev(156:327,14));
bd.Color = Sc;
bd.LineWidth = 2;

bm = plot([1710:1710+T-1],sum((theta(:,:)).*L_M(:,:))/500);
bm.Color = Sc;

cd = plot(indrev(156:327,1),indrev(156:327,15));
cd.Color = Tc;
cd.LineWidth = 2;

cm = plot([1710:1710+T-1],sum(L_T(:,:))/500);
cm.Color = Tc;

%ylim([0 65])

hold off

% figure;
%
% subplot(2,1,1)
% a = area(L_Tp(:,1));
% a.FaceColor = Tc;
%
% subplot(2,1,2)
% b = area(L_Tp(:,T));
% b.FaceColor = Tc;
%
figure;
subplot(2,1,1)
hold on
hm = patch([1 1:500 500],[0; L_Tp(:,1); 0],Tc);
alpha(0.5);
hd = plot([1:500],intprops1710a(:,3));
hd.Color = Tc;
hd.LineWidth = 2;
ylim([0 .7])
hold off

subplot(2,1,2)
hold on
hm = patch([1 1:500 500],[0; L_Tp(:,T); 0],Tc);
alpha(0.5);
hd = plot([1:500],intprops1881(:,3));
hd.Color = Tc;
hd.LineWidth = 2;
ylim([0 .7])
hold off


if idum == 1
    
    figure;
    
    hold on
    clims = [0 0.32];
    imagesc(kappa',clims);
    ylim([1 T])
    xlim([1 length(l)])
    ax = gca;
    ax.YTick = [20; 60; 100; 140];
    ax.YTickLabel = {'1730','1770','1810','1850'};
    title('Transport cost')
    ylabel('Time')
    xlabel('Location')
    colorbar
    %tightfig;
   minc = 0;
    maxc = 0.32;
    zlim([minc maxc])
colorbar('Ticks',[minc, maxc],...
         'TickLabels',{'Low','High'})
    hold off
    
    figure;
  
    hold on
    imagesc(TS')
    ylim([1 T])
    xlim([1 length(l)])
    ax = gca;
    ax.YTick = [20; 60; 100; 140];
    ax.YTickLabel = {'1730','1770','1810','1850'};
    %caxis([-.0 20]);
    title('Infrastructure level (model)')
    ylabel('Time')
    xlabel('Location')
    colorbar
    hold off
    
    TSn = TS-TS(:,1);
    
     figure;
  
    hold on
    imagesc(TSn')
    ylim([1 T])
    xlim([1 length(l)])
    ax = gca;
    ax.YTick = [20; 60; 100; 140];
    ax.YTickLabel = {'1730','1770','1810','1850'};
    %caxis([-.0 20]);
    title('Infrastructure level change (model)')
    ylabel('Time')
    xlabel('Location')
    colorbar
    hold off
    
    
    figure;
    
    hold on
    imagesc(infradum')
    ylim([1 T])
    xlim([1 length(l)])
    ax = gca;
    ax.YTick = [20; 60; 100; 140];
    ax.YTickLabel = {'1730','1770','1810','1850'};
    hold on
    imagesc(infradum')
    ylim([1 T])
    ax.YTick = [20; 60; 100; 140];
    hold off
    
    disp('average decline in t-cost')
(1-mean(kappa(:,171))/mean(kappa(:,1)))

disp('average decline in trade-weighted t-cost')
share1 = sum(kappa(:,1).*(theta(:,1).*M(:,1)+(1-theta(:,1)).*A(:,1))+abs(ES_M(:,1)))/sum(kappaq(:,1).*(theta(:,1).*M(:,1)+(1-theta(:,1)).*A(:,1))+abs(ES_M(:,1)))/sum((theta(:,1).*M(:,1)+(1-theta(:,1)).*A(:,1))+abs(ES_M(:,1)));
share2 = sum(kappa(:,171).*(theta(:,171).*M(:,171)+(1-theta(:,171)).*A(:,171))+abs(ES_M(:,171)))/sum(kappaq(:,171).*(theta(:,171).*M(:,171)+(1-theta(:,171)).*A(:,171))+abs(ES_M(:,171)))/sum((theta(:,171).*M(:,171)+(1-theta(:,171)).*A(:,171))+abs(ES_M(:,171)));
(1-share2/share1)

    
    
end


% figure;
%
% subplot(2,1,1)
% hold on
% stairs([1:500],nR_M(:,1))
% stairs([1:500],nR_Ms(:,1))
% stairs([1:500],nR_A(:,1))
% hold off
%
% subplot(2,1,2)
% hold on
% stairs([1:500],nR_M(:,T))
% stairs([1:500],nR_Ms(:,T))
% stairs([1:500],nR_A(:,T))
% hold off
%
% figure;
%
% subplot(2,1,1)
% hold on
% stairs([1:500],L_M(:,1))
% stairs([1:500],L_Ms(:,1))
% stairs([1:500],L_A(:,1))
% hold off
%
% subplot(2,1,2)
% hold on
% stairs([1:500],L_M(:,T))
% stairs([1:500],L_Ms(:,T))
% stairs([1:500],L_A(:,T))
% hold off
%
% figure;
%
% subplot(2,1,1)
% hold on
% stairs([1:500],Z_M(:,1))
% stairs([1:500],Z_A(:,1))
% hold off
%
% subplot(2,1,2)
% hold on
% stairs([1:500],Z_M(:,T))
% stairs([1:500],Z_A(:,T))
% hold off


