global Lbar w rw p_M L_M L_A theta RI
 

%%set year = T, load indrev, construct dataset and plot model

enT = 1880;   %sets T = year

stY = 1690; %sets plot start year >= 1555
enY = 1890; %sets plot end year

load('indrevst2r.mat')  %this holds the historical data
% 1 year
% 2 pc growth
% 3 p_M/p_A
% 4 real wage
% 5 p_M/w
% 6 agg. agriculture share (old)
% 7 northern agriculture share (old)
% 8 southern agriculture share (old)
% 9 land rent
%10 p_M
%11 net manu trade as a proportion of 1700 per capita
%12 linear trend of 11
%13 agg prim
%14 agg seco
%15 agg tert

modcfdata=NaN;

j=5;

mst = enT-T-stY+2;
men = enT-stY+1;
dmst = stY-1555+mst;
dmen = stY-1555+men;

for i = 1:enY-stY+1
    if stY-1555+i > length(indrev)
        modcfdata(i,1) = stY+i-1;  %year
        modcfdata(i,2:9) = NaN;
    else
        modcfdata(i,1) = stY+i-1;  %year
        modcfdata(i,2) = indrev(stY-1555+i,2);  %per capita growth
        modcfdata(i,18) = indrev(stY-1555+i,10);  %p_M
        modcfdata(i,3) = indrev(stY-1555+i,3);  %p_M/p_A
        modcfdata(i,4) = indrev(stY-1555+i,4);  %real w
        modcfdata(i,5) = indrev(stY-1555+i,5);  %p_M/w
        modcfdata(i,6) = indrev(stY-1555+i,6);  %aggregate agriculture share
        modcfdata(i,7) = indrev(stY-1555+i,7);  %northern agriculture share
        modcfdata(i,8) = indrev(stY-1555+i,8);  %southern agriculture share
        modcfdata(i,9) = indrev(stY-1555+i,9);  %land rent
        %indrev(:,11) is net manu trade as a proportion of 1700 per capita
    end
    if i < mst+5
        modcfdata(i,10:17)=NaN;
    else
        if i > men
            modcfdata(i,10:17)=NaN;
        else
            j=j+1;
            modcfdata(i,10) = 100*avTsgr(j);
            modcfdata(i,11) = sum(p_M(:,j))/length(l)*(nanmean(indrev(dmst:dmen,3))/mean((sum(p_M(:,:))/length(l))));
            modcfdata(i,12) = sum(rw(:,j))*(nanmean(indrev(dmst:dmen,4))/nanmean((rw(:,:))));
            modcfdata(i,13) = (sum(p_M(:,j))/length(l))./(sum(w(:,j))/length(l))*(nanmean(indrev(dmst:dmen,5))/mean((sum(p_M(:,:))/length(l))./(sum(w(:,:))/length(l))));
            modcfdata(i,14) = sum((1-theta(:,j)).*L_A(:,j))/(length(l)*Lbar);
            modcfdata(i,15) = NaN;%AN(j);
            modcfdata(i,16) = NaN;%AS(j);
            modcfdata(i,17) = RI(j)*Lbar*(nanmean(indrev(dmst:dmen,9)/nanmean(RI(:)*Lbar)));
        end
    end    
end

figure;

a = subplot(2,2,1);
hold on
plot([stY:enY],modcfdata(:,10), 'g','linewidth',2)
stairs([stY:enY],modcfdata(:,2),'k')
xlabel('Year')
ylabel('data (black), model (green)')
xlim([stY enY])
ylim([0 2.5])
title(a,'Annual Growth')
ax = gca;
ax.FontSize = 15;

text(1840,.5,'data','FontSize',15);
text(1785,.75,'model','FontSize',15,'Color','g','FontWeight','bold');

hold off

% b = subplot(2,3,2);
% hold on
% plot([stY:enY],modcfdata(:,14), 'g','linewidth',2)
% plot([stY:enY],modcfdata(:,6),'k')
% xlabel('Year')
% ylabel('data (black)')%
% xlim([stY enY])
% ylim([0 1])
% title(b,'Agg. Labour Share Agriculture')
% 
% hold off

c = subplot(2,2,2);
hold on
plot([stY:enY],modcfdata(:,11), 'g','linewidth',2)
plot([stY:enY],modcfdata(:,3),'k')
%plot([stY:enY],modcfdata(:,18),'k--')
xlabel('Year')
ylabel('data p_M/p_A (black), model (green)')
xlim([stY enY])
%ylim([0 1])
title(c,'Relative prices')
ax = gca;
ax.FontSize = 15;

hold off

d = subplot(2,2,3);
hold on
plot([stY:enY],modcfdata(:,12), 'g','linewidth',2)
plot([stY:enY],modcfdata(:,4),'k')
xlabel('Year')
ylabel('data (black), model (green)')
xlim([stY enY])
%ylim([0 1])
title(d,'Real wages')
ax = gca;
ax.FontSize = 15;

hold off

% e = subplot(2,3,5);
% hold on
% plot([stY:enY],modcfdata(:,13), 'g','linewidth',2)
% plot([stY:enY],modcfdata(:,5),'k')
% xlabel('Year')
% ylabel('data (black), model (green)')
% xlim([stY enY])
% %ylim([0 1])
% title(e,'pM/w')
% 
% hold off

f = subplot(2,2,4);
hold on
plot([stY:enY],modcfdata(:,17), 'g','linewidth',2)
plot([stY:enY],modcfdata(:,9),'k')
xlabel('Year')
ylabel('data (black), model (green)')
xlim([stY enY])
%ylim([0 1])
title(f,'Land rent')
ax = gca;
ax.FontSize = 15;

hold off

tightfig;


figure; 
subplot(1,3,1)
hold on
stairs(intnorm1710a(:,2),'k');stairs((theta(:,1)).*L_M(:,1),'Color',Sc,'linewidth',2)
ylim([0 1600])
xlim([0 500])
title('1710')
ax = gca;
ax.FontSize = 15;

text(320,120,'data','FontSize',15);
text(160,200,'model','FontSize',15,'Color',Sc,'FontWeight','bold');

hold off

subplot(1,3,2)
hold on
stairs(intnorm1817(:,2),'k');stairs((theta(:,107)).*L_M(:,107),'Color',Sc,'linewidth',2)
ylim([0 1600])
xlim([0 500])
title('1817')
ax = gca;
ax.FontSize = 15;

hold off

subplot(1,3,3)
hold on
stairs(intnorm1881(:,2),'k');stairs((theta(:,T)).*L_M(:,T),'Color',Sc,'linewidth',2)
ylim([0 1600])
xlim([0 500])
title('1881')
ax = gca;
ax.FontSize = 15;

hold off

tightfig;

figure; 
subplot(1,3,1)
hold on
stairs(intnorm1710a(:,1),'k');stairs(((1-theta(:,1))).*L_A(:,1),'Color',Pc,'linewidth',2)
ylim([0 250])
xlim([0 500])
title('1710')
ax = gca;
ax.FontSize = 15;

text(160,120,'data','FontSize',15);
text(280,75,'model','FontSize',15,'Color',Pc,'FontWeight','bold');

hold off

subplot(1,3,2)
hold on
stairs(intnorm1817(:,1),'k');stairs(((1-theta(:,107))).*L_A(:,107),'Color',Pc,'linewidth',2)
ylim([0 250])
xlim([0 500])
title('1817')
ax = gca;
ax.FontSize = 15;

hold off

subplot(1,3,3)
hold on
stairs(intnorm1881(:,1),'k');stairs(((1-theta(:,T))).*L_A(:,T),'Color',Pc,'linewidth',2)
ylim([0 250])
xlim([0 500])
title('1881')
ax = gca;
ax.FontSize = 15;

hold off

tightfig;

figure; 
subplot(1,3,1)
hold on
stairs((sum(intnorm1710a(:,2))/sum(intnorm1710a(:,5)))*intnorm1710a(:,5),'k');stairs((theta(:,1)).*L_M(:,1),'Color',Sc,'linewidth',2)
ylim([0 1200])
xlim([0 500])
title('1710')
ax = gca;
ax.FontSize = 15;

text(320,160,'data','FontSize',15);
text(160,200,'model','FontSize',15,'Color',Sc,'FontWeight','bold');

hold off

subplot(1,3,2)
hold on
stairs((sum(intnorm1817(:,2))/sum(intnorm1817(:,5)))*intnorm1817(:,5),'k');stairs((theta(:,107)).*L_M(:,107),'Color',Sc,'linewidth',2)
ylim([0 1200])
xlim([0 500])
title('1817')
ax = gca;
ax.FontSize = 15;

hold off

subplot(1,3,3)
hold on
stairs((sum(intnorm1881(:,2))/sum(intnorm1881(:,5)))*intnorm1881(:,5),'k');stairs((theta(:,T)).*L_M(:,T),'Color',Sc,'linewidth',2)
ylim([0 1200])
xlim([0 500])
title('1881')
ax = gca;
ax.FontSize = 15;

hold off

tightfig;


figure; 
subplot(1,3,1)
hold on
stairs(intnorm1710a(:,3),'k');stairs(L_T(:,1),'Color',Tc,'linewidth',2)
ylim([0 200])
xlim([0 500])
title('1710')
ax = gca;
ax.FontSize = 15;

text(240,30,'data','FontSize',15);
text(160,40,'model','FontSize',15,'Color',Tc,'FontWeight','bold');

hold off

subplot(1,3,2)
hold on
stairs(intnorm1817(:,3),'k');stairs(L_T(:,107),'Color',Tc,'linewidth',2)
ylim([0 200])
xlim([0 500])
title('1817')
ax = gca;
ax.FontSize = 15;

hold off

subplot(1,3,3)
hold on
stairs(intnorm1881(:,3),'k');stairs(L_T(:,T),'Color',Tc,'linewidth',2)
ylim([0 200])
xlim([0 500])
title('1881')
ax = gca;
ax.FontSize = 15;

hold off

tightfig;

