cap program drop permute_table2
program permute_table2, rclass
version 14

set more off
#delimit ;
cap log close;
set logtype text;
label drop _all;

/* The file returns one treatment effect of each of 2 outcomes */
/* management practtices. Permutation Tests for Table 2*/

args  treatment;


preserve;

gen treatment2011=treatment*year2011;
gen treatment2017=treatment*year2017;







/* Table 2 Unbalanced Panel  */

reg management treatment2011 treatment2017 year2017 bmanagement
if (year==2011|year==2017) & experimental==1,
vce(cluster fcode);

matrix beta_vector = e(b);
scalar b_temp=beta_vector[1,1];
scalar b_temp2=beta_vector[1,2];
scalar b_temp_yr = beta_vector[1,3];
scalar b_temp_bm = beta_vector[1,4];

return scalar b_t11_up = b_temp;
return scalar b_t17_up = b_temp2;
return scalar b_yr_up = b_temp_yr;
return scalar b_bm_up = b_temp_bm;

/*
* Table 2 Balanced Panel
*/
reg management treatment2011 treatment2017 year2017 bmanagement
if (year==2011|year==2017) & experimental==1 & min2017==1,
vce(cluster fcode);

matrix beta_vector = e(b);
scalar b_temp=beta_vector[1,1];
scalar b_temp2=beta_vector[1,2];
scalar b_temp_yr = beta_vector[1,3];
scalar b_temp_bm = beta_vector[1,4];

return scalar b_t11_bp = b_temp;
return scalar b_t17_bp = b_temp2;
return scalar b_yr_bp = b_temp_yr;
return scalar b_bm_bp = b_temp_bm;

restore;




end;
