* This creates the following .dta data sets (needed for the main tables and
*                                             figures)

* 1) table2.dta
* 2) table3.dta
* 3) table4.dta
* 4) table5_1.dta, table5_2.dta
* 5) figure1.dta, figures23.dta

* Needs: inputdata/india2017.dta; inputdata/question.dta
* Needs: inputdata/MCA_website_content.csv, inputdata/management2011.dta

**********
* Table 2
**********
clear
use inputdata/india2017

gen year2011=year==2011
gen year2017=year==2017
gen treatment2011=treatment*year2011
gen treatment2017=treatment*year2017

gen basemanagement=management if year==2008
egen bmanagement=mean(basemanagement), by(plant)

encode firm,gen(fcode)

gen in2017=1 if year==2017 & management~=.
egen min2017=max(in2017), by(plant)


#delimit ;

keep management bmanagement treatment treatment2011 treatment2017
year2017 year experimental fcode min2017 plant firm year2011 year2017;


saveold  table2/table2, replace;

#delimit cr

**********
* Table 3
**********

clear

u inputdata/question,clear
	replace reason="" if dman==0
	replace reason="A New Manager" if substr(reason,1,3)=="New"&dq==1
	replace reason="A Spillovers: firms" if substr(reason,1,3)=="Spi"
	replace reason="A Spillovers: plants" if substr(reason,1,3)=="Hor"
	replace reason="D Negative Perceived Benefit" if lower(substr(reason,1,3))=="inc"
	replace reason="D Reduced Directors Time" if substr(reason,1,3)=="Lac"|(substr(reason,1,3)=="Ext"&dq<0)
	replace reason="A New Manager" if substr(reason,1,3)=="Ext"&substr(remark,1,3)=="Dir"&dq>0
	replace reason="A Product, customer or production change" if substr(reason,1,3)=="Ext"&(substr(remark,1,3)=="Cus"|substr(remark,1,3)=="Exp"|substr(remark,1,3)=="New"|substr(remark,1,3)=="Ord")&dq>0
	replace reason="A Spillovers: firms" if substr(reason,1,3)=="Ext"&(substr(remark,1,3)=="Ind"|substr(remark,1,3)=="Lea")&dq>0
	replace reason="A Product, customer or production change" if substr(reason,1,3)=="Ext"&(substr(remark,1,3)=="Spa"|substr(remark,1,3)=="Yar")&dq>0
	replace reason="D New Manager" if newpm==1&lower(substr(reason,1,5))=="d neg"&dq==-1
	replace reason="no change" if dq==0
*RESULT: Of the 928 factor level practices, find that 14% dropped, 5% added and 81% stayed the same
tab dq if year==2017
keep if year==2017&dq~=.

keep reason treatment experimental plant year


saveold table3/table3, replace



**********
* Table 4
**********
u inputdata/india2017,clear
	so firm
	merge firm using inputdata/dtfp
	drop *category
	keep q* plant firm year management noj treatment experimental sq23 sq40 dltfp
	reshape long q@_reason q@ q@_remarks,i(plant  dltfp year) j(question)
	ren q adopt
	ren q_reason reason
	ren q_remark remark
	drop if management==.

	gen common=.
	gen uncommon=.
	gen freq=.
	forv i=1(1)38 {
	qui su adopt if year==2008&question==`i'
	qui replace freq=r(mean) if question==`i'
	qui replace common=(r(mean)>=0.5) if question==`i'
	qui replace uncommon=(r(mean)<0.05) if question==`i'
	}


save inputdata/temp,replace


keep question freq
so question
keep if question!=question[_n-1]
so question
save inputdata/common,replace
u inputdata/temp,clear

	egen group=group(plant question)
	tsset group year
	replace adopt=round(adopt)
	gen dq=adopt-l6.adopt
	gen dman=management-l6.management


keep adopt dq year firm experimental treatment sq40 plant noj freq management group

saveold table4/table4, replace



************
* TABLE 5
***********

clear all
use inputdata/india2017, clear
* ssc install ritest
* ssc install ftools
* ssc install reghdfe
* ssc install estout

keep year firm plant  sq41 sq31 sq18 sq35 sq36 sq64 sm3-sm9 treatment experimental management


egen time=group(year)
egen firmid=group(firm)
egen plantid=group(plant)
tsset plantid time

*Drop dead plant years
drop if sq41==.
destring sq31,force replace
drop if plant=="eden"&year>=2014
replace sq18=3 if year>=2014&firm=="veekayem"
destring sq35,replace force

gen emp=sq41
drop if emp==.|emp==0
egen tag=tag(firm year)
gen treat_year_2017=treatment*(year>=2017)
gen treat_year_2014=treatment*(year>=2014)
gen treat_year_2011=treatment*(year>=2011)
gen ytreat_year_2017=treatment*(year==2017)
gen ytreat_year_2014=treatment*(year==2014)
gen ytreat_year_2011=treatment*(year==2011)

gen nitreat_year_2017=(1-experimental)*treatment*(year>=2017)
gen nitreat_year_2011=(1-experimental)*treatment*(year>=2011)
gen itreat_year_2017=experimental*treatment*(year>=2017)
gen itreat_year_2014=experimental*treatment*(year>=2014)
gen itreat_year_2011=experimental*treatment*(year>=2011)

egen mitreat_year_2017=mean(itreat_year_2017),by(firm year)
egen mitreat_year_2014=mean(itreat_year_2014),by(firm year)
gen treat_tyear=treatment*year*(year>=2011)
gen plants=sq18
*replace sq35=substr(sq35,1,2)

gen looms=sq35
encode firm,gen(fcode)
encode plant,gen(pcode)
tsset pcode year
egen salesmarketingscore=rsum(sm3-sm9)


gen picks=sq36
foreach var in emp looms picks {
egen firm`var'=sum(`var'),by(firm year)
gen lfirm`var'=log(firm`var')
gen l`var'=log(`var')
}
gen picks_emp=log(picks/emp)
gen looms_emp=looms/emp
gen llooms_emp=log(looms/emp)


destring sq64,force replace
replace sq64=0 if sq64==.
gen lconsultants=log(1+sq64)
gen anyconsult = (sq64>0)
gen texport=looms*sq31
*collapse (mean) texport sq31 treat_year_2011 [aw=emp], by(fcode year)
gen ltexport=log(1+texport)
gen l_texport=log(texport)
replace sq31=100*sq31
gen export=(sq31>0)
keep if management~=.

#delimit ;
keep export treat_year* pcode year fcode l_texport treatment  firm
year firmlooms firmemp firmpicks anyconsult salesmarketingscore fcode ;
#delimit cr


saveold table5/table5_1,replace
clear all
insheet using inputdata/MCA_website_content.csv,c
compress
keep total treatment new fcode
saveold table5/table5_2,replace


**********
* FIGURES
**********
use inputdata/management2011, clear
drop if timing>24
keep timing m_management*

saveold figures/figure1, replace


use inputdata/india2017, clear
drop *remarks *reason *category
keep q* treatment experimental year
saveold figures/figures23, replace
