cap program drop permute_table5_cols4_8
program permute_table5_cols4_8, rclass
version 14

* Edited June 2019. Permutation Test for Columns 4 through 8 for
* New Table 5

set more off
#delimit ;
cap log close;
set logtype text;
label drop _all;

/* The file returns one treatment effect of each of 4 outcomes */
/* (llooms,llooms_exp,anyconsult, marketing) for Table 5*/


args  treatment;


preserve;

gen treat_year_2011=treatment*(year>=2011);


foreach var in logflooms logemp logflooms_emp anyconsult salesmarketingscore {;
     reghdfe `var' treat_year_2011,ab(fcode year);
     matrix beta_vector = e(b);
     scalar b_temp=beta_vector[1,1];
     return scalar b_`var' = b_temp;

};

restore;

end;
