/* Phase in analysis

Mitchells Plain
FOR TUFTS SERVER - current cleaning from workingdata_v12



set more off
clear all

cap cd /cluster/tufts/jack_collab01/
* Set macros

cap log close
log using logfiles/sim.txt, text replace name(sim)
global resdir "tablesfigures/"

use "workingdata/workingdata.dta", clear

*/

use "$IN/Data/admin_data/workingdata_analysis.dta", clear

global IN  "SA Utilities/Phase in/Mitchell's Plain/Data and analysis"

global resdir "SA Utilities/Paper/Tables-Figures"

local r = 100

*********************************
  ** CE and NPV CALCULATIONS **
*********************************

** Bootstrap standard errors for the NPV estimate 

// program to calculate NPV //


xtset, clear

capture program drop myboot0
program define myboot0, rclass
preserve

	bsample, cluster(id) idcluster(newid)
	xtset newid monthyear
 
	xtivreg revenue (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post

	gen rev_0 = _b[1._at]
	gen rev_1 = _b[2._at]
	
	xtivreg cost (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen cost_0 = _b[1._at]
	gen cost_1 = _b[2._at]
	
	xtivreg timing (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen timing_0 = _b[1._at]
	gen timing_1 = _b[2._at]
	
** Calculate mean NPV 
	
	keep if _n == 1
	sum rev_* cost_* timing_*


	gen NPV_0 = 0 // start with meter cost deficit
	gen NPV_1 = 0
	gen NPV_diff = .
	
	gen i = 1+.00643 // monthly rate
	
	

		forval m = 0/1 {
	
		replace NPV_`m' = NPV_`m' + (rev_`m' / (i^(1+timing_`m'))) - ((cost_`m') / (i ^ 1)) 
		
		}
		replace NPV_diff = (NPV_1) / abs(NPV_0)	
	
	sum NPV_0
    return scalar NPV = r(mean)
	* run with different outcomes to estimate for pre and post NPV
   restore
   
end // myboot0

xtset, clear
capture program drop myboot1
program define myboot1, rclass
preserve

	bsample, cluster(id) idcluster(newid)
	xtset newid monthyear
 
	xtivreg revenue (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post

	gen rev_0 = _b[1._at]
	gen rev_1 = _b[2._at]
	
	xtivreg cost (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen cost_0 = _b[1._at]
	gen cost_1 = _b[2._at]
	
	xtivreg timing (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen timing_0 = _b[1._at]
	gen timing_1 = _b[2._at]
	
** Calculate mean NPV 
	
	keep if _n == 1
	sum rev_* cost_* timing_*

	gen NPV_0 = 0 // start with meter cost deficit
	gen NPV_1 = 0
	gen NPV_diff = .
	
	gen i = 1+.00643 // monthly rate
	
	

		forval m = 0/1 {
	
		replace NPV_`m' = NPV_`m' + (rev_`m' / (i^(1+timing_`m'))) - ((cost_`m') / (i ^ 1)) 
		
		}
		replace NPV_diff = (NPV_1) / abs(NPV_0)	
	
	sum NPV_1
    return scalar NPV = r(mean)
	* run with different outcomes to estimate for pre and post NPV
   restore
   
end // myboot1


cap file close NPV_diff
file open NPV_diff using "$IN/Data/admin_data/NPV_diff.txt", write text replace
file write NPV_diff "Characteristic" _tab "decile" _tab "observed" _tab "bootstrap" ///
	_tab "se" _tab "ci normal lb" _tab "ci normal ub" _tab "ci bias lb" _tab "ci bias ub" _n
file close NPV_diff

xtset id monthyear 

foreach i in 0 1 {

tempfile all_v
save `all_v', replace

drop if switchmonth == monthyear
keep if shortrun == 1
cap drop rev_* cost_* timing_* NPV* i

// first, get the observed statistic

	xtivreg revenue (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen rev_0 = _b[1._at]
	gen rev_1 = _b[2._at]
	
	xtivreg cost (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen cost_0 = _b[1._at]
	gen cost_1 = _b[2._at]
	
	xtivreg timing (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen timing_0 = _b[1._at]
	gen timing_1 = _b[2._at]
	
** Calculate mean NPV 

	sum rev_* cost_* timing_*

	gen NPV_0 = 0 // start with meter cost deficit
	gen NPV_1 = 0
	gen NPV_diff = .
	
	gen i = 1+.00643 // monthly rate

		forval m = 0/1 {
	
		replace NPV_`m' = NPV_`m' + (rev_`m' / (i^(1+timing_`m'))) - ((cost_`m') / (i ^ 1)) 
		
		}
		replace NPV_diff = (NPV_1) / abs(NPV_0)	
	
	sum NPV_`i'
	
	local observed = r(mean)
	local n = r(N)

drop NPV_* i rev_* cost_* timing_*

** Average
 
simulate mean=r(NPV), seed(5925169) reps(`r') : myboot`i'

bstat, stat(`observed') n(`n')

local b 	: display %-4.3f _b[mean]
local se 	: display %-4.3f _se[mean]
matrix bs = e(b_bs)
local bs 	= bs[1,1]
matrix ci_n = e(ci_normal)
local ci_n_lb = ci_n[1,1]
local ci_n_ub = ci_n[2,1]
matrix ci_b = e(ci_bc)
local ci_b_lb = ci_b[1,1]
local ci_b_ub = ci_b[2,1]

// post observed mean, bootstrapped mean, bootstrapped se, normal CI, bias corrected CI

cap file close NPV_diff
file open NPV_diff using "$IN/Data/admin_data/NPV_diff.txt", write text append

file write NPV_diff "NPV_`i'" _tab "" _tab "`b'" _tab "`bs'" _tab ///
	"`se'" _tab "`ci_n_lb'" _tab "`ci_n_ub'" _tab "`ci_b_lb'" _tab "`ci_b_ub'" _n
	
file close NPV_diff

use `all_v', replace
}

