#delimit ;
set more 1;

capture log close;
set logtype text;
/* log using tabwithinoccchanges-7791-centiles-gen-8497_table6,replace;

;

   Look at info on changes in occupational task content from dot77 to 
   dot91 related to computerization ;
   
   Make independent and dependent variables into 10 * annualized measures 5/25/01, 
   D. Autor.

   To weight, we use start of period occupation weights.
   This allows us to do the between- within- decomp consistently.

   D. Autor, 5/27/01.
   
   1/14/03: 
   
   Quantilize: This 'gen' version uses gender by occupation cells to form initial quantiles. 
   
   2/18/03: 
   
   Calculate occupational education demands as a function of occupational task input.
   Dependent variable is 'college equivalent' employment share.
   
   
*/;   

clear;
set mem 5m;

* Put the dot77 and dot91 data together by occ8090 by gender and overall;
use dot77-8090-gen;
gen year=77;
append using dot91-8090-gen;
replace year=91 if year==.;
sort occ8090;
quietly by occ8090: assert _N==4;
gen byte sex =1 + female;
drop female;
append using dot77-8090;
replace year=77 if year==.;
replace sex=0 if sex==.;
append using dot91-8090;
replace year=91 if year==.;
replace sex=0 if sex==.;

* Apply 1984 and 1997 weights from OCT CPS;
sort occ8090 sex;
merge occ8090 sex using oct8497means-gen;
drop if _merge!=3;
drop _merge;

*************************************************************************************;
** Calculate percentiles of distribution in each year                              **;
** Smooth percentiles for combined distribution - does not work on end points      **;
** Calcuate medians and assign percentiles to each occ in each year                **;
*************************************************************************************;

gen byte useobs=(year==77 & sex!=0);

pctile pmath = math [aw=wt84] if useobs, n(100) genp(pnmath);
pctile pdcp = dcp [aw=wt84] if useobs, n(100) genp(pndcp);
pctile psts = sts [aw=wt84] if useobs, n(100) genp(pnsts);
pctile pfinger = finger [aw=wt84] if useobs, n(100) genp(pnfinger);
pctile pehf = ehf [aw=wt84] if useobs, n(100) genp(pnehf);

* Smooth;
for any math dcp sts finger ehf:
   sort pnX \ 
   gen repX = (pX==pX[_n+1] & pX!=. & pX[_n+1]!=.) \ 
   gen qX=0 \ 
   replace qX = qX[_n-1] + 1 if repX & qX[_n-1]!=. \ 
   gsort - pnX \
   gen sX = pX \ replace sX = sX[_n-1] - (sX[_n-1] - sX[_n+qX])/(qX+1) if qX>0 & qX!=. \
   drop qX;

* Smoothing points affected;
sort useobs;
for any math dcp sts finger ehf: gen diffX = pX  !=sX;
for any math dcp sts finger ehf: count if diffX ;

* Apply to all years of data;
for any math dcp sts ehf finger: xtile qX=X, cutpoints(sX);

** Aggregate to means by occupation;
for any math dcp sts finger ehf: gen mqX=.;
for any math dcp sts finger ehf: 
   egen tqX=sum(qX*wt84*(sex!=0)), by(occ8090 year) \ 
   egen twX=sum(wt84*(sex!=0)), by(occ8090 year) \ 
   replace tqX=tqX/twX \
   replace mqX=tqX if sex==0;
drop tw* tq*;

* Fill in the detailed cells that already exist;
for any math dcp sts finger ehf: replace mqX = qX if sex!=0;
for any math dcp sts finger ehf: assert mqX!=.;

for any math dcp sts finger ehf: label var qX "Centile position in the 1980 occupation task distribution.";
for any math dcp sts finger ehf: label var mqX "Weighted mean centile position in the 1980 distribution averaging over sex-ed centiles.";

********************************************;
** Prep for run regs                      **;
********************************************;

* Gen Changes ;
sort occ8090 sex year;
for any math dcp sts finger ehf: quietly by occ8090 sex: gen dqX=mqX-mqX[_n-1];
for any math dcp sts finger ehf: replace dqX=10*dqX/14;

* Generate occ means of gender, education and computer use using 84/97 wts that apply ;
* to the matched sample;

gen wt84orig=wt84;
gen wt97orig=wt97;

egen wt84gen=sum(wt84*(sex!=0)), by(occ8090);
egen wt97gen=sum(wt97*(sex!=0)), by(occ8090);
replace wt84gen=wt84 if sex!=0;
replace wt97gen=wt97 if sex!=0;

for any fem clp smc hsg hsd ed use: 
   egen X84gen=sum(X84*wt84*(sex!=0)), by(occ8090) \
   replace X84gen=X84 if sex!=0 \
   replace X84gen=X84gen/wt84gen if sex==0;

for any fem clp smc hsg hsd ed use: 
   egen X97gen=sum(X97*wt97*(sex!=0)), by(occ8090) \
   replace X97gen=X97 if sex!=0 \
   replace X97gen=X97gen/wt97gen if sex==0;

* Normalize all weights by year; 
for var wt84 wt97 wt84gen wt97gen: 
    egen tX=sum(X), by(sex year) \ 
    replace X=X/tX \ 
    drop tX ;

gen wt8497=(wt84+wt97)/2;
gen wt8497gen=(wt84gen+wt97gen)/2;

gen duse8497=(use97-use84)*10/13;
gen duse8497gen=(use97gen-use84gen)*10/13;

foreach v in clp smc hsg hsd fem {;
   gen d`v'=(`v'97-`v'84) * 10/13;
   };
foreach v in clp smc hsg hsd fem {;
   gen d`v'gen=(`v'97gen-`v'84gen) * 10/13;
   };

** Education demand as a function of tasks;
gen equiv = clp84 + .5 * smc84;
gen lnequiv = ln(equiv/(1-equiv));
gen lnclp   = ln(clp84/(1-clp84));

* Predicting equations: levels;
drop equiv lnequiv lnclp;


****************************************************************;
* Regs using 1984/1997 CPS weights: Gender specific variables **;
* AVERAGE EMPLOYMENT WEIGHTS                                  **;
****************************************************************;

***********************;
**A. Nonroutine analytic;
*1;
reg dqmath duse8497gen [aw=wt8497gen] if sex==0;
*2;
reg dqmath duse8497gen dclpgen dhsggen [aw=wt8497gen] if sex==0;
*3;
reg dqmath duse8497gen dclpgen dhsggen dfemgen [aw=wt8497gen] if sex==0;

***********************;
**B. Nonroutine interactive;
*1;
reg dqdcp duse8497gen [aw=wt8497gen] if sex==0;
*2;
reg dqdcp duse8497gen dclpgen dhsggen [aw=wt8497gen] if sex==0;
*3;
reg dqdcp duse8497gen dclpgen dhsggen dfemgen [aw=wt8497gen] if sex==0;


***********************;
**C. Routine cognitive;
*1;
reg dqsts duse8497gen [aw=wt8497gen] if sex==0;
*2;
reg dqsts duse8497gen dclpgen dhsggen [aw=wt8497gen] if sex==0;
*3;
reg dqsts duse8497gen dclpgen dhsggen dfemgen [aw=wt8497gen] if sex==0;


***********************;
**D. Routine manual;
*1;
reg dqfin duse8497gen [aw=wt8497gen] if sex==0;
*2;
reg dqfin duse8497gen dclpgen dhsggen [aw=wt8497gen] if sex==0;
*3;
reg dqfin duse8497gen dclpgen dhsggen dfemgen [aw=wt8497gen] if sex==0;

keep if sex==0;

