
**************************************************************************************************
*       PLOT OUTPUTS   
**************************************************************************************************  
set scheme plotplainblind
graph set eps fontface  "Times New Roman"
graph set eps fontfacesans  "Times New Roman"
graph set eps fontfaceserif  "Times New Roman"
graph set eps fontfacemono "Times New Roman"

* set aspect ratio to make graphs look less square (i think this looks better when we put them in panels)
local aspectratio 0.5 


 /* --------------------------------------------------------------------------  
	Fig 1a. (+ various robusness checks) 
 ----------------------------------------------------------------------------- */  

 foreach graph in "" _origFindex  _3yrband _parentsonly{

 clear 
    set obs 21
    gen MomsAge = _n + 19       
    * native-born:     
    estimates restore fig1a_nb`graph'
    
    gen coef_native = 100 * _b[_cons] in 1 
	gen se_native = 100 * _se[_cons] in 1 
    forval i = 21(1)40{
        replace coef_native = 100 * (_b[`i'.mom_aged_birth] + _b[_cons]) if MomsAge == `i'
		replace se_native = 100 * (_se[`i'.mom_aged_birth] + _se[_cons]) if MomsAge == `i'
    }
      
    * foreign-born: 
    estimates restore fig1a_fb`graph'
    gen coef_foreign = 100 * _b[_cons] in 1 
    gen se_foreign = 100 * _se[_cons] in 1 

    forvalues i = 21(1)40{
     replace coef_foreign = 100 * ( _b[`i'.mom_aged_birth] + _b[_cons]) if MomsAge==`i'
     replace se_foreign = 100 * ( _se[`i'.mom_aged_birth] + _se[_cons]) if MomsAge==`i'
}
	gen upper_foreign = coef_foreign + se_foreign 
	gen lower_foreign = coef_foreign - se_foreign 
	
	gen upper_native = coef_native + se_native 
	gen lower_native = coef_native - se_native 	
	
	
    * Save graph
    twoway rcap upper_foreign lower_foreign MomsAge, lc(black) mc(black) m(o) || rcap upper_native lower_native MomsAge, lc(gray) mc(gray) m(o) xla(, nogrid)  || connected coef_foreign MomsAge,  mc(black) lc(black) ls(solid) m(o) || connected coef_native MomsAge,  mc(gray) lc(gray) ls(solid) m(o) xtitle("Mother's Age at Birth of Child") xlab(20(1)40) ylab(20(10)60) ytitle("Foreignness Index") legend(on order(3 4) label( 3 "Foreign-born mother") label(4 "US-born mother") position(6) rows(1)) 
  
  *twoway connected coef_foreign MomsAge,  mc(black) lc(black) ls(solid) m(o) || connected coef_native MomsAge,  mc(gray) lc(gray) ls(solid) m(o) xla(, nogrid)   xtitle("Mother's Age at Birth of Child") xlab(20(1)40) ylab(20(10)60) ytitle("Foreignness Index") legend(on order(1 2) label( 1 "Foreign-born mother") label(2 "US-born mother") position(6) rows(1)) 
  
  graph export $writeup/fig1a`graph'.eps, replace

  
}

 /* --------------------------------------------------------------------------  
	Fig 1a."old" version - in relative change not levels (i.e. don't at constant)
 ----------------------------------------------------------------------------- */ 
 
 clear 
    set obs 21
    gen MomsAge = _n + 19       
    * native-born:     
    estimates restore fig1a_nb 
    
    gen coef_native = 0 in 1 
	gen se_native = 0 in 1 
    forval i = 21(1)40{
        replace coef_native = 100 * (_b[`i'.mom_aged_birth] ) if MomsAge == `i'
		replace se_native = 100 * (_se[`i'.mom_aged_birth] ) if MomsAge == `i'
    }
      
    * foreign-born: 
    estimates restore fig1a_fb 
    gen coef_foreign =0 in 1 
    gen se_foreign = 0 in 1 

    forvalues i = 21(1)40{
     replace coef_foreign = 100 * ( _b[`i'.mom_aged_birth] ) if MomsAge==`i'
     replace se_foreign = 100 * ( _se[`i'.mom_aged_birth] ) if MomsAge==`i'
}
	gen upper_foreign = coef_foreign + se_foreign 
	gen lower_foreign = coef_foreign - se_foreign 
	
	gen upper_native = coef_native + se_native 
	gen lower_native = coef_native - se_native 	
	
	
    * Save graph
    twoway rcap upper_foreign lower_foreign MomsAge, lc(black) mc(black) m(o) || rcap upper_native lower_native MomsAge, lc(gray) mc(gray) m(o) xla(, nogrid)  || connected coef_foreign MomsAge,  mc(black) lc(black) ls(solid) m(o) || connected coef_native MomsAge,  mc(gray) lc(gray) ls(solid) m(o) xtitle("Mother's Age at Birth of Child") xlab(20(1)40) ylab(5(5)-15)ytitle("Foreignness Index") legend(on order(3 4) label( 3 "Foreign-born mother") label(4 "US-born mother") position(6) rows(1)) 
  
 graph export $writeup/fig1a_relative.eps, replace
 
 
 
 /* --------------------------------------------------------------------------  
	Fig 1a. alt specifications for foreign line 
 ----------------------------------------------------------------------------- */  
 
 
 foreach graph in FE_grouped FE  fig1csamp  {

 clear 
    set obs 21
    gen MomsAge = _n + 19  
    
    * native-born:     
    estimates restore fig1a_nb 
    
    gen coef_native = 100 * _b[_cons] in 1 
	gen se_native = 100 * _se[_cons] in 1 
    forval i = 21(1)40{
        replace coef_native = 100 * (_b[`i'.mom_aged_birth] + _b[_cons]) if MomsAge == `i'
		replace se_native = 100 * (_se[`i'.mom_aged_birth] + _se[_cons]) if MomsAge == `i'
    }

 * foreign-born: 
    estimates restore fig1a_fb_`graph'
    gen coef_foreign = 100 * _b[_cons] in 1 
    gen se_foreign = 100 * _se[_cons] in 1 

    forvalues i = 21(1)40{
     replace coef_foreign = 100 * ( _b[`i'.mom_aged_birth] + _b[_cons]) if MomsAge==`i'
     replace se_foreign = 100 * ( _se[`i'.mom_aged_birth] + _se[_cons]) if MomsAge==`i'

	 }
	gen upper_foreign = coef_foreign + se_foreign 
	gen lower_foreign = coef_foreign - se_foreign 
	
	gen upper_native = coef_native + se_native 
	gen lower_native = coef_native - se_native 	
	
	
    * Save graph
    twoway rcap upper_foreign lower_foreign MomsAge, lc(black) mc(black) m(o) || 	rcap upper_native lower_native MomsAge, lc(gray) mc(gray) m(o) xla(, nogrid)  || connected coef_foreign MomsAge,  mc(black) lc(black) ls(solid) m(o) || connected coef_native MomsAge,  mc(gray) lc(gray) ls(solid) m(o) xtitle("Mother's Age at Birth of Child") xlab(20(1)40) ylab(20(10)60)	ytitle("Foreignness Index") legend(on order(3 4) label( 3 "Foreign-born mother") label(4 "US-born mother") position(6) rows(1)) 
    graph export $writeup/fig1a_`graph'.eps, replace
	 
}
 
 
 
 
 /* --------------------------------------------------------------------------  
	Fig 1c. Moms Yrs in US 
 ----------------------------------------------------------------------------- */  	
	
      estimates restore fig1c
      clear
      set obs 21 
      gen YrsUS = _n -1 
      gen coef = 100 * _b[_cons] in 1 
	  gen se = 100 * _se[_cons] in 1 
      forval i = 1(1)20{
      replace coef = 100 * (_b[`i'.mom_years_in_us_birth] + _b[_cons]) if YrsUS == `i'
	 
	  replace se = 100 * (_se[`i'.mom_years_in_us_birth] + _se[_cons]) if YrsUS == `i'

      }
	  
	  
	  gen upper = coef - se 
	  gen lower = coef + se 
	  
	  
     twoway rcap upper lower YrsUS, lc(black) mc(black) || ///
	 connected coef YrsUS, xtitle("Mother's Years in US at Time of Birth") ///
	 ytitle("Foreignness Index") xlab(0(1)20) ylab(20(10)60) m(o) lc(black) ///
	 mc(black) xla(, nogrid) legend(off) 
	 
   	 graph export $writeup/fig1c.eps, replace
  
	 * w/out error bars:  twoway connected coef YrsUS, xtitle("Mother's Years in US at Time of Birth") ytitle("Foreignness Index") xlab(0(1)20) ylab(20(10)60) m(o) lc(black) mc(black) xla(, nogrid) legend(off) 
     
      local N : display %10.0fc e(N)
      file open N using "$writeup/fig1c_N.tex", write replace
      file write N "`N'"
      file close N 

	  ** relative - not levels 
	estimates restore fig1c
      clear
      set obs 21 
      gen YrsUS = _n -1 
      gen coef = 0 in 1 
	  gen se = 0  in 1 
      forval i = 1(1)20{
      replace coef = 100 * (_b[`i'.mom_years_in_us_birth]) if YrsUS == `i'
	 
	  replace se = 100 * (_se[`i'.mom_years_in_us_birth]) if YrsUS == `i'

      }
	  
	  
	  gen upper = coef - se 
	  gen lower = coef + se 
	  
	  
     twoway rcap upper lower YrsUS, lc(black) mc(black) || ///
	 connected coef YrsUS, xtitle("Mother's Years in US at Time of Birth") ///
	 ytitle("Foreignness Index") xlab(0(1)20) m(o) lc(black) ///
	 mc(black) xla(, nogrid) legend(off) 
	 
   	 graph export $writeup/fig1c_relative.eps, replace
  	   
 /* --------------------------------------------------------------------------  
	Fig 2. Country specific bar graph
 ----------------------------------------------------------------------------- */  	
	
  local bpls "404 405 410 414 434 450 453 465 426 421 400 412 411 401 436 420"

  local name_404 Norway
  local name_405 Sweden
  local name_410 England
  local name_414 Ireland
  local name_434 Italy
  local name_450 Austria 
  local name_453 Germany
  local name_465 Russia
  local name_426 Switzerland
  local name_421 France
  local name_400 Denmark
  local name_412 Wales
  local name_411 Scotland
  local name_401 Finland
  local name_436 Portugal
  local name_420 Belgium  
    
 clear
 set obs 16
 gen bpl = . 
 gen country = ""
 gen stars = ""
 gen coef = . 
 gen se = . 
 gen meanFB = . 

  local i = 0 
  foreach bpl in `bpls'{
  local ++i 
  replace bpl = `bpl' in `i'
  }


  foreach c in `bpls' {
  
  estimates restore  fig2_`c' 
  
  * store coefficients 
  replace coef = (100 * _b[mom_aged_birth]) * 20  if bpl == `c'
  replace se = (100 * _se[mom_aged_birth]) * 20  if bpl == `c'
   
 * stars: 
		local p = 2*(1-normal(abs(_b[mom_aged_birth]/_se[mom_aged_birth])))
		if `p' <=.05 {	
			replace stars = "*"  if bpl == `c'
		}
		
  * store  F-index from aux reg
  estimates restore Findex20_`c'
  local mean : display %3.0fc 100* (_b[ 1.foreign_mo] + _b[_cons])
  replace meanFB = `mean' if bpl == `c'
  
  replace country = "`name_`c''" if bpl == `c' 
  }
  
  
  
  tostring meanFB, replace force
  gen FB = substr(meanFB, 1, 5)
  gen label = country +  " (F = " + FB + ")" + stars
  
  sort coef 
  gen N = _n 
  
  labmask N, values(label)

  *twoway bar coef1 coef2 N, barw(0.5) || rcap top bottom N, legend(off) xlabel(1(1)16, valuelabel angle(45)) xtitle("") ylab(0.4(0.2)-1)  ytitle("Estimated effect of one additional year of"  "mother's age at birth on Foreignness Index")
 *  graph bar (asis) coef1 coef2, over(N, label(valuelabel angle(45))) bar(1,bcolor(black)) bar(2,bcolor(gray)) legend(label(1 "20-22 years at birth") label(2 "28-30 years at birth") position(6) rows(1)) ytitle( "Foreignness Index") 
  graph bar (asis) coef, over(N,  label(valuelabel angle(45))) ytitle( "Estimated effect of 20 additional years of" "mother's age at birth on Foreignness Index ") graphregion(color(white))
  graph export $writeup/fig2.eps, replace

	   
 /* --------------------------------------------------------------------------  
	Fig 2 - Pooled version
 ----------------------------------------------------------------------------- */  	
	
  local bpls "404 405 410 414 434 450 453 465 426 421 400 412 411 401 436 420"

  local name_404 Norway
  local name_405 Sweden
  local name_410 England
  local name_414 Ireland
  local name_434 Italy
  local name_450 Austria 
  local name_453 Germany
  local name_465 Russia
  local name_426 Switzerland
  local name_421 France
  local name_400 Denmark
  local name_412 Wales
  local name_411 Scotland
  local name_401 Finland
  local name_436 Portugal
  local name_420 Belgium  
  
  
 clear
 estimates restore fig2_pooled
 set obs 16
 gen bpl = . 
 gen country = ""
 gen stars = ""
 gen coef = . 
 gen se = . 
 gen meanFB = . 

  local i = 0 
  foreach bpl in `bpls'{
	  local ++i 
	  replace bpl = `bpl' in `i'
	  }
	  
	  
	    foreach bpl in `bpls'{

	  * coef: 
	  replace coef = 100 * _b[mom_age_x_`bpl'] * 20  if bpl == `bpl'

	 * stars: 
	 local p = 2*(1-normal(abs(_b[mom_age_x_`bpl']/_se[mom_age_x_`bpl'])))
			if `p' <=.05 {	
				replace stars = "*"  if bpl == `bpl'
			}
	* country name:
	  replace country = "`name_`bpl''" if bpl == `bpl'  		
			
  }
  
  foreach bpl in `bpls'{
	  * store  F-index from aux reg
	  estimates restore Findex20_`bpl'
	  local mean : display %3.0fc 100* (_b[ 1.foreign_mo] + _b[_cons])
	  replace meanFB = `mean' if bpl == `bpl'
}
  
  tostring meanFB, replace force
  gen FB = substr(meanFB, 1, 5)
  gen label = country +  " (F = " + FB + ")" + stars
  
  sort coef 
  gen N = _n 
  
  labmask N, values(label)
  
   graph bar (asis) coef, over(N,  label(valuelabel angle(45))) ytitle( "Estimated effect of 20 additional years of" "mother's age at birth on Foreignness Index ") graphregion(color(white))
  graph export $writeup/fig2_pooled.eps, replace


  	   
 /* --------------------------------------------------------------------------  
	 Table 1 
 ----------------------------------------------------------------------------- */  	
 
   local name_404 Norway
  local name_405 Sweden
  local name_410 England
  local name_414 Ireland
  local name_434 Italy
  local name_450 Austria 
  local name_453 Germany
  local name_465 Russia
  local name_426 Switzerland
  local name_421 France
  local name_400 Denmark
  local name_412 Wales
  local name_411 Scotland
  local name_401 Finland
  local name_436 Portugal
  local name_420 Belgium  
  
* check which countries are both a) significant and b) have more than 1,000 moms in eaach group: 
  local bpls "404 405 410 414 434 450 453 465 426 421 400 412 411 401 436 420"

foreach group in lit nonlit{
	 
 foreach c in `bpls' {
	 
qui estimates restore table1_`c'_`group'
if `e(N)' < 2000 {
di "bpl `c', `group' <2000"
}

}

}

* elimiated (<2,000):  404 405 410 414 426 421 400 412 411 420
* eliminated (not significant): 412

	 * both over 1,000: 436, 465, 401, 450, 453, 414, 434, 405,   
	 
  
foreach group in lit nonlit{
foreach c in    434 450 453 465 401 436  {
   di "`c'"
estimates restore table1_`c'_`group'
	 
  


local `group'_`c' : display %4.3fc _b[mom_aged_birth] *100 
local se_`group'_`c': display %4.3fc _se[mom_aged_birth] *100  
local N_`group'_`c': display %10.0fc e(N) 

		* stars: 
		local p = 2*(1-normal(abs(_b[mom_aged_birth]/_se[mom_aged_birth])))
		if `p' >.05 & `p' <=.10 { 	
			local `group'_`c'_stars  "$^{*}$"
		}
		if `p' >.01 & `p' <=.05 { 	
			local `group'_`c'_stars   "$^{**}$"
		}
		if `p' <=.01 {	
			local `group'_`c'_stars  "$^{***}$" 
		}
}
}


  file open table1 using "$writeup/table1.tex", write replace
  file write table1 "\begin{tabularx}{.75\textwidth}{l@{\extracolsep{\fill}}l|cc}"_n
  file write table1 "\toprule"_n
  file write table1 "\multicolumn{4}{c}{Dependent Variable = Foreignness Index}\\"_n
  file write table1 "\hline "_n
  file write table1 " & & \multicolumn{2}{c}{Mother is...}\\"_n
  file write table1 " & & Literate & Not literate \\"_n
  file write table1 "\hline "_n

foreach bpl in    434 450 453 465 401 436  {
  file write table1 "`name_`bpl'' & Mom age at birth & `lit_`bpl''`lit_`bpl'_stars' & `nonlit_`bpl''`nonlit_`bpl'_stars' \\"_n 
  file write table1 " &  & (`se_lit_`bpl'') & (`se_nonlit_`bpl'') \\"_n
  file write table1 " & \textit{N} & `N_lit_`bpl'' & `N_nonlit_`bpl'' \\[1ex]"_n

  }
  file write table1 "\bottomrule"_n
  file write table1 "\end{tabularx}" _n 
  file close table1 

  
 /* --------------------------------------------------------------------------  
	Appendix tables A3 & A4: 
 ----------------------------------------------------------------------------- */  	
** table A3 (baseline, country-specific, nysiis) 
foreach v in _baseline _countryspecific _nysiis{
estimates restore tableA4`v'
  local coef`v' : display %4.3fc _b[mom_aged_birth] *100 
  local se`v'  : display %4.3fc _se[mom_aged_birth] *100 
  local N`v' : display %10.0fc e(N) 
  local p`v' = 2*(1-normal(abs(_b[mom_aged_birth]/_se[mom_aged_birth])))
		if `p`v'' >.05 & `p`v'' <=.10 { 	
			local stars`v'  "$^{*}$"
		}
		if `p`v'' >.01 & `p`v'' <=.05 { 	
			local stars`v'   "$^{**}$"
		}
		if `p`v'' <=.01 {	
			local stars`v' "$^{***}$" 
		}

}

 file open A3 using "$writeup/tableA3.tex", write replace
  file write A3 "\begin{tabularx}{.5\textwidth}{l@{\extracolsep{\fill}}c}\\"_n
  file write A3 "\toprule"_n
  file write A3 "\multicolumn{2}{c}{Dependent Variable = Foreignness Index}\\"_n
  file write A3 "\midrule" _n
  file write A3 "Baseline & `coef_baseline'`stars_baseline' \\"_n
  file write A3 " & (`se_baseline') \\"_n
  file write A3 "\textit{N} & `N_baseline' \\[2ex]"_n
  
  file write A3 " Country-Specific F-index & `coef_countryspecific'`stars_countryspecific'\\"_n
  file write A3 " & (`se_countryspecific')\\"_n
  file write A3 "\textit{N} & `N_countryspecific' \\"_n
  
   file write A3 "Adjust with NYSIIS & `coef_nysiis'`stars_nysiis'\\"_n
  file write A3 " & (`se_nysiis')\\"_n
  file write A3 "\textit{N} & `N_nysiis' \\"_n
  
  
  file write A3 "\bottomrule"_n
  file write A3 "\end{tabularx}"_n
  file close A3


 
 ** table A4 (CA & kids only) 
 estimates restore tableA4_baseline
   local baseline_coef : display %4.3fc _b[mom_aged_birth] *100 
  local baseline_se  : display %4.3fc _se[mom_aged_birth] *100 
  local baseline_N : display %10.0fc e(N) 
  local p = 2*(1-normal(abs(_b[mom_aged_birth]/_se[mom_aged_birth])))
		if `p' >.05 & `p' <=.10 { 	
			local CA_stars  "$^{*}$"
		}
		if `p' >.01 & `p' <=.05 { 	
			local CA_stars   "$^{**}$"
		}
		if `p' <=.01 {	
			local CA_stars  "$^{***}$" 
		}

 
 estimates restore tableA4_CA
  local CA_coef : display %4.3fc _b[mom_aged_birth] *100 
  local CA_se  : display %4.3fc _se[mom_aged_birth] *100 
  local CA_N : display %10.0fc e(N) 
  local p = 2*(1-normal(abs(_b[mom_aged_birth]/_se[mom_aged_birth])))
		if `p' >.05 & `p' <=.10 { 	
			local CA_stars  "$^{*}$"
		}
		if `p' >.01 & `p' <=.05 { 	
			local CA_stars   "$^{**}$"
		}
		if `p' <=.01 {	
			local CA_stars  "$^{***}$" 
		}

		
  estimates restore tableA4_06
  local 06_coef : display %4.3fc _b[mom_aged_birth] *100 
  local 06_se  : display %4.3fc _se[mom_aged_birth] *100 
  local 06_N : display %10.0fc e(N) 
  local p = 2*(1-normal(abs(_b[mom_aged_birth]/_se[mom_aged_birth])))
		if `p' >.05 & `p' <=.10 { 	
			local 06_stars  "$^{*}$"
		}
		if `p' >.01 & `p' <=.05 { 	
			local 06_stars   "$^{**}$"
		}
		if `p' <=.01 {	
			local 06_stars  "$^{***}$" 
		}

		


  
 file open A6 using "$writeup/tableA4.tex", write replace
  file write A6 "\begin{tabularx}{.5\textwidth}{l@{\extracolsep{\fill}}c}\\"_n
  file write A6 "\toprule"_n
  file write A6 "\multicolumn{2}{c}{Dependent Variable = Foreignness Index}\\"_n
  file write A6 "\midrule" _n
  
  
  file write A6 "Baseline & `baseline_coef'`baseline_stars' \\"_n
  file write A6 " & (`baseline_se') \\"_n
  file write A6 "\textit{N} & `baseline_N' \\[2ex]"_n 
  
  file write A6 "Born in California & `CA_coef'`CA_stars' \\"_n
  file write A6 " & (`CA_se') \\"_n
  file write A6 "\textit{N} & `CA_N' \\[2ex]"_n
  file write A6 "Children $\leq$ 6 years old & `06_coef'`06_stars'\\"_n
  file write A6 " & (`06_se')\\"_n
  file write A6 "\textit{N} & `06_N' \\"_n
  file write A6 "\bottomrule"_n
  file write A6 "\end{tabularx}"_n
  file close A6
  
  
  * ----- Fig A1 -----


  estimates restore figA1
  clear
  set obs 21 
  gen MomsAge = 20 in 1 
  gen coef = 100 * _b[_cons] in 1 
  gen se = 100 * _se[_cons] in 1
  local i = 1 
  forval age = 21(1)40{
  local ++ i
  replace MomsAge = `age' in `i'
  }

  forval i = 21(1)40{
  replace coef = 100 * (_b[`i'.mom_aged_birth] + _b[_cons])  if MomsAge == `i'
  replace se = 100 * (_se[`i'.mom_aged_birth] + _se[_cons])  if MomsAge == `i'
  }
  * Save graph - with erro bars 
  gen low = coef - se 
  gen upper = coef + se 
  
  
  twoway rcap low upper MomsAge, lc(black) || connected coef MomsAge,  mc(black) lc(black) m(o)   xtitle("Mother's Age at Birth of Child") xlab(20(1)40) ylab(20(10)60) ytitle("Foreignness Index")  legend(off) xla(, nogrid)
  graph export $writeup/figA1.eps, replace

  * Save sample size for table notes 
  local N : display %10.0fc e(N)
  file open N using "$writeup/figA1_N.tex", write replace
  file write N "`N'"
  file close N 

 /* --------------------------------------------------------------------------  
	Fig 1a - estimated seperately for sons & daughters
 ----------------------------------------------------------------------------- */  	
foreach graph in "" _mbpl{
 
 estimates restore fig1a_fb_sons`graph'
 local sons_20 = 100 * (_b[_cons]) 
 local sons_20_se = 100 * (_se[_cons]) 
 forval i = 21(1)40{
 local sons_`i' = 100 * ( _b[`i'.mom_aged_birth] + _b[_cons] ) 
 local sons_`i'_se = 100 * ( _se[`i'.mom_aged_birth] + _se[_cons] ) 

 }
 estimates restore fig1a_fb_daughters`graph'
 local daughters_20 = 100 * (_b[_cons]) 
 local daughters_20_se = 100 * (_se[_cons]) 

 forval i = 21(1)40{
 local daughters_`i' = 100 * ( _b[`i'.mom_aged_birth] + _b[_cons] )
 local daughters_`i'_se = 100 * ( _se[`i'.mom_aged_birth] + _se[_cons] )

 }
 estimates restore fig1a_nb`graph'
 local native_20 = 100 * _b[_cons]
 local native_20_se = 100 * _se[_cons]

 forval i = 21(1)40{
 local native_`i' = 100 * ( _b[`i'.mom_aged_birth]  + _b[_cons]) 
 local native_`i'_se = 100 * ( _se[`i'.mom_aged_birth]  + _se[_cons]) 

 }

 clear
 set obs 21 
 gen MomsAge = .
 gen foreign_sons = .
 gen foreign_daughters =.
 gen native = .
 gen foreign_sons_se = .
 gen foreign_daughters_se = .
 gen native_se = . 
 local i = 0 
 forval age = 20(1)40{
 local ++ i
 replace MomsAge = `age' in `i'
 }
 forval i = 20(1)40{
 replace foreign_sons = `sons_`i'' if MomsAge == `i'
 replace foreign_daughters = `daughters_`i'' if MomsAge == `i'
 replace native = `native_`i'' if MomsAge == `i'
 replace foreign_sons_se = `sons_`i'_se' if MomsAge == `i'
 replace foreign_daughters_se = `daughters_`i'_se' if MomsAge == `i'
 replace native_se = `native_`i'_se' if MomsAge == `i'
 }
 gen upper_foreign_sons = foreign_sons - foreign_sons_se
 gen lower_foreign_sons = foreign_sons + foreign_sons_se
 
 gen upper_foreign_daughters = foreign_daughters - foreign_daughters_se
 gen lower_foreign_daughters = foreign_daughters + foreign_daughters_se
 
 gen upper_native = native + native_se
 gen lower_native = native - native_se 
 
 
 * Save graph
twoway rcap upper_foreign_sons lower_foreign_sons MomsAge, lc(black) || rcap upper_foreign_daughters lower_foreign_daughters MomsAge, lc(gs12) || rcap upper_native lower_native MomsAge, lc(gray)  ||  connected foreign_sons MomsAge,  mc(black) lc(black) m(o) lpattern(solid) || connected foreign_daughters MomsAge,  mc(gs12) lc(gs12) m(o) lpattern(solid) || connected native MomsAge,  mc(gray) lc(gray) m(o) lpattern(dash) xtitle("Mother's Age at Birth of Child") xlab(20(1)40) ylab(20(10)60) ytitle("Foreignness Index")  legend(on order(4 5 6)  label(4 "Foreign-born mother, sons") label(5 "Foreign-born mother, daughters") label( 6 "US-born mother, all children") position(6) rows(1)) xla(, nogrid)

* twoway connected native MomsAge,  mc(gs10) lc(gs10) m(o) || connected foreign_sons MomsAge,  mc(black) lc(black) m(o) || connected foreign_daughters MomsAge,  mc(gs5) lc(gs5) m(o) lpattern(dash)  xtitle("Mother's Age at Birth of Child") xlab(20(1)40) ylab(20(10)60) ytitle("Foreignness Index")  legend( label( 1 "US-born") label(2 "Foreign Sons") label(3 "Foreign Daughters") position(6) rows(1)) xla(, nogrid)

 graph export $writeup/fig1a_bysex`graph'.eps, replace
 
 twoway rcap upper_foreign_sons lower_foreign_sons MomsAge, lc(black) || rcap upper_foreign_daughters lower_foreign_daughters MomsAge, lc(gs12) || rcap upper_native lower_native MomsAge, lc(gray)  ||  connected foreign_sons MomsAge,  mc(black) lc(black) m(o) lpattern(solid) || connected foreign_daughters MomsAge,  mc(gs12) lc(gs12) m(o) lpattern(solid) || connected native MomsAge,  mc(gray) lc(gray) m(o) lpattern(dash) xtitle("Mother's Age at Birth of Child") xlab(20(1)40) ylab(20(10)70) ytitle("Foreignness Index")  legend(on order(4 5 6)  label(4 "Foreign Sons") label(5 "Foreign Daughters") label( 6 "US-born") position(6) rows(1)) xla(, nogrid)
 graph export $writeup/fig1a_bysex`graph'_alt.eps, replace

 
 
 
}
