* ssc install hamiltonfilter

clear
freduse LNS17100000 JTS1000QUR UNEMPLOY
 
gen JTSQUR  = JTS1000QUR

gen quarter=quarter(daten)
gen month=month(daten)
gen year=year(daten)

keep if year>2000
gen mdate=ym(year,month)
gen qdate=yq(year,quarter)

gen ueRate = 100*LNS17100000/UNEMPLOY
tsset mdate, m


foreach var of varlist ueRate JTSQUR{
	gen ln`var'=ln(`var')
	tsfilter hp c_`var'=`var',smooth(129600)
	tsfilter hp c_ln`var'=ln`var',smooth(129600)
	gen dln`var'=D.ln`var'
}


outsheet mdate c_lnueRate c_lnJTSQUR ueRate JTSQUR  using "../Data/CPSf_JOLTSq.csv", replace comma noquote


* detrending according to Hamilton prescription: 24 leads for monthly data
regress lnueRate l(24/27).lnueRate
predict c_lnueRate_hamilton, residuals
predict t_lnueRate_hamilton

regress lnJTSQUR l(24/27).lnJTSQUR
predict c_lnJTSQUR_hamilton, residuals
predict t_lnJTSQUR_hamilton

outsheet mdate c_lnueRate_hamilton c_lnJTSQUR_hamilton using "../Data/CPSf_JOLTSq_hamilton.csv", replace comma noquote


collapse (mean) ueRate JTSQUR, by(qdate)
tsset qdate,q

foreach var of varlist ueRate JTSQUR{
	gen ln`var'=ln(`var')
	tsfilter hp c_`var'=`var',smooth(1600)
	tsfilter hp c_ln`var'=ln`var',smooth(1600)
	gen dln`var'=D.ln`var'
}

outsheet qdate c_lnueRate c_lnJTSQUR ueRate JTSQUR using "../Data/CPSf_JOLTSq_qrt.csv", replace comma noquote

* detrending according to Hamilton prescription: 8 leads for quarterly data
regress lnueRate l(8/11).lnueRate
predict c_lnueRate_hamilton, residuals
predict t_lnueRate_hamilton

regress lnJTSQUR l(8/11).lnJTSQUR
predict c_lnJTSQUR_hamilton, residuals
predict t_lnJTSQUR_hamilton

hamiltonfilter lnueRate , frequency(quarterly) stub(lnueRate_ham)
hamiltonfilter lnJTSQUR , frequency(quarterly) stub(lnJTSQUR_ham)


tsline c_lnueRate_hamilton lnueRate_ham_cycle c_lnueRate
tsline c_lnJTSQUR_hamilton lnJTSQUR_ham_cycle c_lnJTSQUR

drop if c_lnueRate_hamilton == . | c_lnJTSQUR_hamilton == .
outsheet qdate c_lnueRate_hamilton c_lnJTSQUR_hamilton using "../Data/CPSf_JOLTSq_qrt_hamilton.csv", replace comma  noquote
   
