
clear
set max_memory 7g
cap log close
adopath + \$prog
set more off,perm









** get kreis (municipality) and industry from individual-level administrative spell data 
** (in turn drawing from administrative BHP establishment data)
 
 use   arb_kr betnr begepi wz93 wz03 wz73  using $orig\LIAB_LM2_2007_v2_pers.dta, clear
  
* year (German: "Jahr") of spell observation
gen jahr=year(begepi)

* set to missing invalid industry codes
replace wz93=. if wz93<0
replace wz03=. if wz03<0
replace wz73=. if wz73<0

keep betnr wz73 wz93 wz03 arb_kr jahr   
collapse wz73 wz93 wz03 arb_kr,by(betnr jahr)

save $data/indbased_w935_kreis_betnr.dta,replace
 
  
 
 *** construct unemployment count data (provided by IAB upon request)

 use orig/199301-201207_alo_bzg.dta,clear
rename krsnr arb_kr
gen syear=substr(yearmon,1,4)
destring syear,gen(jahr)
drop syear
collapse  alo,by(jahr arb_kr)
xtset arb_kr jahr
** generate year-location-specific log count of the unemployed (will be used with location FEs in panel setting, so will reflect % changes)
gen lnalo=ln(alo)
save data/unemploymentcounts.dta,replace
 
 
 
** load IAB Establishment Survey panel (appended survey waves of LIAB establishments)
use $data\04_survey_panel.dta,clear
  
 
 
 *** merge unemployment  count data (provided by IAB)
 merge m:1 jahr arb_kr  using $data/unemploymentcounts.dta
 drop if _merge==2
 rename _merge merge_kr_unrate
 
 
 
 
	  
	  
*** merge Kreis and industry data by establishment (from admin data)

drop if betnr==.
merge 1:1 jahr betnr  using $data/indbased_w935_kreis_betnr.dta
drop if _merge==2
drop _merge

 
 ** coarsen industry to 2 digit.
replace wz73=floor(wz73/10)
replace wz93=floor(wz93/1000)
replace wz03=floor(wz03/1000)
 

 
 ** set to missing survey variable invalid/error codes (negative values) for worker flow variables 
  xtset  idnum jahr
  foreach var of varlist gesamt offen einstell entlass akuend bkuend{
  replace `var'=. if `var'<0
  }
  
 ** generate worker flow growth variables (vacancies, hiring, firing, quits, layoffs, employment)
  foreach var of varlist offen einstell entlass akuend bkuend gesamt{
 * rates of worker flows normalizedby lagged employment
 gen r_`var'=`var'/L.gesamt*100
* changes and growth
  gen  ln`var'=ln(`var')
  gen dln`var'=D.ln`var'
  gen l`var'=L.`var'
  gen lr_`var'=L.r_`var'
 }
  
  
 *** AGGREGATES (sums) to generate ratios of worker flows normalized by employment counts (sums)
 xtset idnum jahr
 bysort jahr: egen tot_lgesamt=total(lgesamt)
 	    foreach var of varlist offen einstell entlass akuend bkuend gesamt{
 bysort jahr: egen tot_`var'=total(`var') 
 gen R_`var'=tot_`var'/tot_lgesamt*100
 }
  
  
xtile q10_dlngesamt=dlngesamt,nq(10)
  
xtile q100_r_akuend = r_akuend,nq(100)
  
tab jahr, gen(i_jahr)
xtset  idnum jahr
save $data/estsurvey_prepared.dta,replace
	   
