function [errObj] = calibrationObjective2(endopar,targetMom,par,func,glob,comp)

par.delta  = endopar(1);
par.s      = endopar(2);
par.kappa  = endopar(3);
par.mu     = endopar(4);
par.lambda = endopar(5);
par.pBad   = endopar(6);
par.pGood  = endopar(7);

ss = solveSS(par, func, glob, comp);

par.k2 = 1;
[tr] = solveTransition(ss, 250, 0.015/par.sigmaZ,  par, func, glob, comp , 0, 'c(n)'); 

b = regress(log(tr.jjRate)',[ones(length(tr.ueRate),1) log(tr.ueRate')]);
elast = b(2);

dev = 100*([ss.u ; ss.repVacShare; ss.vfr ; ss.ueRate; ss.jjRate; ss.xiBadShare; elast] - targetMom) ./ targetMom;
errObj = sqrt(dev' * dev)/sqrt(length(endopar));

end