
*** Generate output for Figure 1 Panel (b) + Figure A1 Panels (b)-(f) + Tables A1-2
**** LIAB establishment survey, 1993-2008

 
 adopath ++ $prog

  
 
** KEY VARIABLE NAMES: 
	** r_ein: hiring rate per 100 employees
	** r_offen: job opening rate per 100 employees
	** einsteller: industry (one digit) 
	** jahr: year
	** r_aku: quit rate per 100 employees
	** dlnges: growth of employment (annual) this compared to last year
	** gesamt: employment
	** idnum and benr: establishment IDs (from survey and admin BHP data set)
	** lnalo / alo: (log) unemployment location-year-level 

****  Load data set of LIAB establishments, using data only from the 
***** Establishment Survey

use $data/estsurvey_prepared.dta,clear

xtset idnum jahr
 
 ** generate  1-digit version of the industry variable
  gen einsteller=floor(w93/100)
 
 ** generate consistent Kreis (municipality) variable
 gen fff=floor(arb_kr)
 gen kreis=arb_kr if arb_kr>0 & fff==arb_kr
 
	** avoid hitting file line length limitation (shorten variable names used as labels)
	rename r_aku r_aku
	rename r_bku r_bku  


	
  *** Appendix Figure A1 Panel (b)+(c): binned scatter plots of establishment level relationship b/w quits ("aku") & worker flows 
	
 *** for confidentiality/disclosure review reasons, the code reports observation counts and generates the bins as a table



**  sample restriction 1: West Germany "bula<10" (Bundesland (state) codes) and  establishments with employment growth below -40% and below 40%
**  sample restriction 2: West Germany "bula<10" (Bundesland (state) codes) and  establishments with employment growth below -40% and below 40% and establishments larger than 50 employees
	  foreach  sample_restriction in   " if  bula<10 & dlnges>-.4 & dlnges<0.4"  "  if  gesamt>50 & dlnges>-.4 & dlnges<0.4 & bula<10"     {
* variants: positive quit rate, below 20% quit rate, and positive and below 20% quit rate  (r_aku)
	  foreach sr_aku  in "if gesamt>=0"  "if r_aku>0" "if r_aku<20" "if r_aku>0 & r_aku<20" {
* employment-weighted or unweighted variants
	 foreach weight  in "" "[w=gesamt]" {
 foreach indvar of varlist r_aku {
foreach depvar of varlist   r_einst  r_offen   {
	preserve
disp "weight: `weight'"
	disp "BEGIN SAMPLE RESTRICTION: `sample_restriction'"
 	disp "AND ALSO: `sr_aku'"
   keep `sample_restriction'
	keep `sr_aku'
	disp "next line is COUNT of observation:"
	nois count  `sample_restriction'
	disp "dep var: `depvar' -- indvar:`indvar'"
	
	quietly areg `depvar' i.jahr    if `indvar'!=. `weight',absorb(idnum)
	 predict e_`depvar', resid
	quietly areg `indvar' i.jahr     if `depvar'!=. `weight',absorb(idnum)
	 predict e_`indvar',resid
****** }
*** create 20 equally sized bins of the residuals
quiet xtile q20_e_`indvar'=e_`indvar',nq(20)
quiet tab  q20_e_`indvar', gen(i_q20_e_`indvar')
   
    *** main regression
  nois areg `depvar' i.jahr     `indvar'  `weight',absorb(idnum)  cluster(idnum)
  ***   regression based on residuals
 nois reg e_`depvar' e_`indvar' `weight',  cluster(idnum)
  gen b1_e_`depvar'_e_`indvar'=_b[e_`indvar']
  gen b0_e_`depvar'_e_`indvar'=_cons
   gen yhat=  e_`indvar'*b1_e_`depvar'_e_`indvar'
 
  *** binned averages
  nois reg e_`indvar'  i_q20_e_`indvar'*,nocons
 nois reg e_`depvar' i_q20_e_`indvar'*,nocons
 nois  reg yhat  i_q20_e_`indvar'*,nocons
 
 	restore
 }
	}
	}
	}
 	}
 
 
 
 		
	 *** Appendix Figure A1 Panel (d): average annual hiring, vacancy, quit, layoff rates 
	 *** reports variable-specific year fixed effects underlying the time series
 
**  sample restriction 1: West Germany "bula<10" (Bundesland (state) codes)  
**  sample restriction 2: West Germany "bula<10" (Bundesland (state) codes) and  establishments with employment growth below -40% and below 40%

	foreach  sample_restriction in " if bula<10" " if  bula<10 & dlng>-.4 & dlnges<0.4"  {
  preserve
  	 keep `sample_restriction'
foreach var of varlist  r_offen r_einstell r_entlass r_aku r_bku r_gesamt{
		 disp "`sample_restriction'"
**** generate yearly averages via regression
		 reg  `var'   i_jahr*, nocons
}
	 restore
 	 }
 
 
 
 
 
 *** Appendix Figure A1 Panel (e)+(f): binned scatter plots of worker flows against local unemployment (lnalo)
 
 *** for confidentiality/disclosure review reasons, the code reports observation counts and generates the bins as a table
 
**  sample restriction 1: West Germany "bula<10" (Bundesland (state) codes) and  establishments with employment growth below -40% and below 40%
**  sample restriction 2: West Germany "bula<10" (Bundesland (state) codes) and  establishments with employment growth below -40% and below 40% and establishments larger than 50 employees


**  Figure A1 Panel (e): generate QUIT (r_aku) and HIRING  (r_einst) binned scatter plots 
 foreach  sample_restriction in  " if  bula<10 & dlnges>-.4 & dlnges<0.4"  "  if  gesamt>50 & dlnges>-.4 & dlnges<0.4 & bula<10"    {
foreach indvar of varlist lnalo {
foreach depvar of varlist r_aku   r_einst  {
	preserve
	disp "BEGIN SAMPLE RESTRICTION: `sample_restriction'"
    keep `sample_restriction'
	disp "next line is COUNT of observation:"
	nois count  `sample_restriction'
	disp "dep var: `depvar' -- indvar:`indvar'"
	*** prepare binned scatter plot: get residuals
	quietly areg `depvar' i.jahr if `indvar'!=. ,absorb(idnum)
	 predict e_`depvar', resid
	quietly areg `indvar' i.jahr if `depvar'!=. ,absorb(idnum)
	 predict e_`indvar',resid
*** create 20 equally sized bins of the residuals
 xtile q20_e_`indvar'=e_`indvar',nq(20)
 
 *** main regression
  nois areg `depvar' i.jahr `indvar',absorb(idnum)
  nois reg e_`depvar' e_`indvar', cluster(kreis)
  
  quiet tab  q20_e_`indvar', gen(i_q20_e_`indvar')
  ** predicted values
  gen b1_e_`depvar'_e_`indvar'=_b[e_`indvar']
  gen b0_e_`depvar'_e_`indvar'=_cons
  gen yhat=  e_`indvar'*b1_e_`depvar'_e_`indvar'

  *** binned averages
 nois reg e_`indvar'  i_q20_e_`indvar'*,nocons
 nois reg e_`depvar' i_q20_e_`indvar'*,nocons
 nois  reg yhat  i_q20_e_`indvar'*,nocons

 
  	restore
 }
	}
	}
 
**  Figure A1 Panel (f): generate   JOB OPENING  (r_offen) binned scatter plots (and use quit data points from above anlaysis)
**  see above notes to   Figure A1 Panel (e)
	
foreach  sample_restriction in  " if  bula<10 & dlng>-.4 & dlnges<0.4"  "  if  gesamt>50 & dlng>-.4 & dlnges<0.4 & bula<10"    {
foreach indvar of varlist lnalo {
foreach depvar of varlist   r_offen   {
	preserve
	disp "BEGIN SAMPLE RESTRICTION: `sample_restriction'"
    keep `sample_restriction'
	disp "next line is COUNT of observation:"
	nois count  `sample_restriction'
	disp "dep var: `depvar' -- indvar:`indvar'"
	*** prepare binned scatter plot: get residuals
	quietly areg `depvar' i.jahr if `indvar'!=. ,absorb(idnum)
	 predict e_`depvar', resid
	quietly areg `indvar' i.jahr if `depvar'!=. ,absorb(idnum)
	 predict e_`indvar',resid
*** create 20 equally sized bins of the residuals
 xtile q20_e_`indvar'=e_`indvar',nq(20)
 
 *** main regression
  nois areg `depvar' i.jahr `indvar',absorb(idnum)
  nois reg e_`depvar' e_`indvar', cluster(kreis)
  
  quiet tab  q20_e_`indvar', gen(i_q20_e_`indvar')
  ** predicted values
  gen b1_e_`depvar'_e_`indvar'=_b[e_`indvar']
  gen b0_e_`depvar'_e_`indvar'=_cons
  gen yhat=  e_`indvar'*b1_e_`depvar'_e_`indvar'

  *** binned averages
 nois reg e_`indvar'  i_q20_e_`indvar'*,nocons
 nois reg e_`depvar' i_q20_e_`indvar'*,nocons
 nois  reg yhat  i_q20_e_`indvar'*,nocons

 
  	restore
 }
	}
	}
 
 
 
 
 
	*** Appendix Table A1: Establishment-level Regressions of Hiring/Job Openings vs. Quits (Rates per 100 Employees)

	*** LEFT PANEL: incl zero quits
	
	**  column (1):  establishment and year FEs
	nois areg r_ein  i.jahr r_aku if gesamt>50 & dlnges>-.4 & dlnges<0.4 & bula<10 & r_aku<20  ,absorb(idnum)  cluster(idnum)
  	nois areg r_offen  i.jahr r_aku  if gesamt>50 & dlnges>-.4 & dlnges<0.4 & bula<10 & r_aku<20  ,absorb(idnum)  cluster(idnum)

	**  column (2):  establishment  and industryXyear FEs
	
	nois areg r_ein i.einsteller##i.jahr r_aku if gesamt>50 & dlnges>-.4 & dlnges<0.4 & bula<10 & r_aku<20  ,absorb(idnum)  cluster(idnum)
  	nois areg r_offen i.einsteller##i.jahr r_aku  if gesamt>50 & dlnges>-.4 & dlnges<0.4 & bula<10 & r_aku<20  ,absorb(idnum)  cluster(idnum)
       
	**  column (3):  establishment   and stateXyear FEs

	nois areg r_ein i.bula##i.jahr r_aku  if gesamt>50 & dlnges>-.4 & dlnges<0.4 & bula<10 & r_aku<20 ,absorb(idnum)  cluster(idnum)
  	nois areg r_offen i.bula##i.jahr r_aku  if gesamt>50 & dlnges>-.4 & dlnges<0.4 & bula<10 & r_aku<20 ,absorb(idnum)  cluster(idnum)
 	
	
	*** RIGHT PANEL: POSITIVE quit rates
	
	**  column (1):  establishment and year FEs
	nois areg r_ein  i.jahr r_aku if gesamt>50 & dlnges>-.4 & dlnges<0.4 & bula<10 & r_aku<20 & r_aku>0 ,absorb(idnum)  cluster(idnum)
  	nois areg r_offen  i.jahr r_aku  if gesamt>50 & dlnges>-.4 & dlnges<0.4 & bula<10 & r_aku<20 & r_aku>0 ,absorb(idnum)  cluster(idnum)

	**  column (2):  establishment  and industryXyear FEs
	
	nois areg r_ein i.einsteller##i.jahr r_aku if gesamt>50 & dlnges>-.4 & dlnges<0.4 & bula<10 & r_aku<20 & r_aku>0 ,absorb(idnum)  cluster(idnum)
  	nois areg r_offen i.einsteller##i.jahr r_aku  if gesamt>50 & dlnges>-.4 & dlnges<0.4 & bula<10 & r_aku<20  & r_aku>0,absorb(idnum)  cluster(idnum)
       
	**  column (3):  establishment   and stateXyear FEs

	nois areg r_ein i.bula##i.jahr r_aku  if gesamt>50 & dlnges>-.4 & dlnges<0.4 & bula<10 & r_aku<20 & r_aku>0,absorb(idnum)  cluster(idnum)
  	nois areg r_offen i.bula##i.jahr r_aku  if gesamt>50 & dlnges>-.4 & dlnges<0.4 & bula<10 & r_aku<20 & r_aku>0,absorb(idnum)  cluster(idnum)
 	
	
	
	
*** TABLE A2 and coefficients underlying Figure 1 Panel (b) 

* LEFT PANEL: including zero quits
** 4 columns with incremental bandwidths in leads/lags around event (quit) year
nois areg r_ein  i.jahr r_aku if gesamt>50 & dlnges>-.4 & dlnges<0.4 & bula<10 & r_aku<20 ,absorb(idnum)  cluster(idnum)
nois areg r_ein  i.jahr L(-1/1).r_aku if gesamt>50 & dlnges>-.4 & dlnges<0.4 & bula<10 & r_aku<20,absorb(idnum)  cluster(idnum)
nois areg r_ein  i.jahr L(-2/2).r_aku if gesamt>50 & dlnges>-.4 & dlnges<0.4 & bula<10 & r_aku<20 ,absorb(idnum)  cluster(idnum)
nois areg r_ein  i.jahr L(-3/3).r_aku if gesamt>50 & dlnges>-.4 & dlnges<0.4 & bula<10 & r_aku<20 ,absorb(idnum)  cluster(idnum)
	
	
* RIGHT PANEL (and coefficients presented in main paper  Figure 1 Panel (b) ): positive quits only
** 4 columns with incremental bandwidths in leads/lags around event (quit) year
nois areg r_ein  i.jahr r_aku if gesamt>50 & dlnges>-.4 & dlnges<0.4 & bula<10 & r_aku<20 & r_aku>0 ,absorb(idnum)  cluster(idnum)
nois areg r_ein  i.jahr L(-1/1).r_aku if gesamt>50 & dlnges>-.4 & dlnges<0.4 & bula<10 & r_aku<20 & r_aku>0 ,absorb(idnum)  cluster(idnum)
nois areg r_ein  i.jahr L(-2/2).r_aku if gesamt>50 & dlnges>-.4 & dlnges<0.4 & bula<10 & r_aku<20 & r_aku>0 ,absorb(idnum)  cluster(idnum)
 nois areg r_ein  i.jahr L(-3/3).r_aku if gesamt>50 & dlnges>-.4 & dlnges<0.4 & bula<10 & r_aku<20 & r_aku>0 ,absorb(idnum)  cluster(idnum)
	
	
	
 
