function [] = plotCrowdout(ss,T,par,func,glob,comp,ls)
close all
nk2 = 100;
k2Grid = linspace(0,5,nk2);
Tz = 250; % transition duration
nSigma = 0.015/par.sigmaZ; % size of shock in terms of standard deviations: 1.5% shock

%% Construct comparative statics for k2
dn_v = zeros(nk2,1);
dv_v = zeros(nk2,1);

min_u_rep = zeros(nk2,1);
min_u_norep = zeros(nk2,1);

parfor ik2 = 1:nk2
    disp(ik2)
    parLoop = par;
    parLoop.k2 = k2Grid(ik2);
    
    % Crowdout graph
    [tr_21_vac_k2] = solveTransition(ss, T, -2,  parLoop, func, glob, comp, 0 ,'c(n)');
    dn_v(ik2) = (tr_21_vac_k2.n(1)-ss.n)/(0.01*ss.v);
    dv_v(ik2) = (tr_21_vac_k2.v(1)-ss.v)/(0.01*ss.v);
    
    % Relative amplification graph
    [tr_z_rep]   = solveTransition(ss, Tz, nSigma ,  parLoop , func , glob , comp , 0 , 'c(n)');
    [tr_z_norep] = solveTransition(ss, Tz, nSigma ,  parLoop , func , glob , comp , 1 , 'c(n)');
    [min_u_rep(ik2), index_min_u_repost] = min(tr_z_rep.u);
    min_u_norep(ik2) = tr_z_norep.u(index_min_u_repost);
    
end


%%

relAmp = 100 * abs( ((min_u_rep - ss.u) - (min_u_norep - ss.u)) ./ (min_u_norep - ss.u));


figure(1)

yyaxis left
set(gca,'YColor',rgb('black'))

p1 = plot(k2Grid,dn_v,ls.lineSpec1{:});
hold on
p2 = plot(k2Grid,dv_v,ls.lineSpec2{:});
line([1 1], [-1 1],ls.lineSpec4{:},'HandleVisibility','off');
a = annotation('textarrow',[0.35 0.30],[0.65 0.65],'String','Our calibration');
a.Color = rgb('Black');
a.FontSize = 15;
%line([0 0], [-1 1],lineSpec4{:});
b = annotation('textarrow',[0.35 0.145],[0.4 0.11],'String','Standard DMP');
annotation('textarrow',[0.35 0.145],[0.4 0.51]);
b.Color = rgb('Black');
b.FontSize = 15;
hline = refline([0 0]);
hline.Color = 'k';
hold off
xlabel('$k_2$')
grid on
xlim([-0.1 5])
set(gca,ls.gridLineSpec{:})
set(gca,ls.fontSpec{:} )
ylim([-1 1])

yyaxis right
set(gca,'YColor',rgb('maroon'))
p3 = plot(k2Grid,relAmp,ls.lineSpec3{:});
hold off
ylabel('Percent (\%)')
legend([p1 p2 p3],{'$dn/\varepsilon_1^{\tilde{v}}$','$dv/\varepsilon_1^{\tilde{v}}$','Relative amplification'},'Location','southeast')
export_fig(figure(1),[ls.graphPath 'elasticity_v_new'],'-pdf','-transparent');

end