clear
freduse JTSQUR JTS1000QUR JTSQUL JTS1000QUL JTSJOL JTS1000JOL UNRATE JTS1000HIR JTS1000HIL

gen year=year(daten)
gen month=month(daten)
gen quarter=quarter(daten)

gen mdate=ym(year,month)
gen qrt_date=yq(year,quarter)
gen qdate=qrt_date

gen monthlydate_1 = mdate

merge 1:1 monthlydate_1 using  "../Data/MasterCPSflows.dta"
drop _merge
merge m:1 qrt_date using  "../Data/HWI.dta"
rename HWI hwi

ipolate u_e monthlydate_1, gen(u_eInt)


collapse (mean) UNRATE JTSJOL JTS1000JOL JTSQUR JTSQUL JTS1000QUR JTS1000QUL JTS1000HIL u_eInt hwi, by(qdate)
tsset qdate, q

keep if qdate>=yq(1948,1) & qdate<=yq(2018,4)

foreach var of varlist UNRATE JTSJOL JTS1000JOL JTSQUR JTSQUL JTS1000QUR JTS1000QUL JTS1000HIL u_eInt{
	
	gen ln`var'=ln(`var')

	* HP filter
	tsfilter hp c_ln`var' = ln`var', smooth(1600) trend(t_ln`var') // hp filter log of variables
	tsfilter hp c_`var'   = `var'  , smooth(1600) trend(t_`var')       // hp filter level of variables
	
	* Hamilton filter: 8 leads for quarterly data
	* logs
	regress ln`var' l(8/11).ln`var'
	predict c_ln`var'_hamilton, residuals
	predict t_ln`var'_hamilton
	* levels
	regress `var' l(8/11).`var'
	predict c_`var'_hamilton, residuals
	predict t_`var'_hamilton	
}

save "../Data/CF_Master.dta", replace

use "../Data/CF_Master.dta", clear

local repshare = 0.56 // set to 0.56 for Germany, 0.927 for the US
local filesuffix = "Germany"

* local repshare = 0.927 
* local filesuffix = "USA"


 
gen rep_vac = `repshare' * t_JTS1000JOL * (c_lnJTS1000QUL+1)
gen rep_vac_hamilton = `repshare' * t_JTS1000JOL_hamilton * (c_lnJTS1000QUL_hamilton+1) 
 
gen cf_vac = JTS1000JOL - `repshare'*t_JTS1000JOL*c_lnJTS1000QUL
gen cf_hil = JTS1000HIL - `repshare'*t_JTS1000HIL*c_lnJTS1000QUL

gen cf_vac_hamilton = JTS1000JOL - `repshare' * t_JTS1000JOL_hamilton * c_lnJTS1000QUL_hamilton
gen cf_hil_hamilton = JTS1000HIL - `repshare' * t_JTS1000HIL_hamilton * c_lnJTS1000QUL_hamilton


foreach var of varlist cf_vac cf_hil rep_vac{
	
	gen ln`var'=ln(`var')
	tsfilter hp cyc_ln`var' = ln`var', smooth(1600) trend(tre_ln`var')
	tsfilter hp cyc_`var' = `var', smooth(1600) trend(tre_`var')
			
}

foreach var of varlist cf_vac_hamilton cf_hil_hamilton rep_vac_hamilton{
	
	gen ln`var'=ln(`var')
	
	regress ln`var' l(8/11).ln`var'
	predict cyc_ln`var', residuals
	predict tre_ln`var'
	
	regress `var' l(8/11).`var'
	predict cyc_`var', residuals
	predict tre_`var'
			
}


** Okun's law: 0.0841 semi-elasticity of quits to UNRATE 
*binscatter c_lnJTS1000QUL c_UNRATE


reg c_lnJTS1000QUL c_UNRATE
local ok_monthly = _b[c_UNRATE]
gen cyc_synth_lnquit = `ok_monthly' * c_UNRATE

reg c_lnJTS1000QUL_hamilton c_UNRATE_hamilton
local ok_monthly_hamilton=_b[c_UNRATE_hamilton]
gen cyc_synth_lnquit_hamilton = `ok_monthly_hamilton'* c_UNRATE_hamilton
  
foreach var of varlist hwi{
	gen ln`var'=ln(`var')
	
	tsfilter hp c_ln`var'=ln`var',smooth(1600) trend(t_ln`var')
	tsfilter hp c_`var'=`var',smooth(1600) trend(t_`var')
	
	regress ln`var' l(8/11).ln`var'
	predict c_ln`var'_hamilton, residuals
	predict t_ln`var'_hamilton	
	
	regress `var' l(8/11).`var'
	predict c_`var'_hamilton, residuals
	predict t_`var'_hamilton	
	
}
 
gen rep_hwi = `repshare'*t_hwi * (cyc_synth_lnquit+1)
gen cf_hwi = hwi - `repshare'*t_hwi*cyc_synth_lnquit

gen rep_hwi_hamilton = `repshare'*t_hwi_hamilton * (cyc_synth_lnquit_hamilton+1)
gen cf_hwi_hamilton = hwi - `repshare'*t_hwi_hamilton * cyc_synth_lnquit_hamilton

foreach var of varlist cf_hwi rep_hwi{
	gen ln`var'=ln(`var')
 
	tsfilter hp cyc_ln`var'=ln`var', smooth(1600) trend(tre_ln`var')
	tsfilter hp cyc_`var'=`var', smooth(1600) trend(tre_`var')
}

foreach var of varlist cf_hwi_hamilton rep_hwi_hamilton{
	gen ln`var'=ln(`var')
	
	regress ln`var' l(8/11).ln`var'
	predict cyc_ln`var', residuals
	predict tre_ln`var'	
	
	regress `var' l(8/11).`var'
	predict cyc_`var', residuals
	predict tre_`var'
 
}



outsheet qdate c_lnhwi cyc_lncf_hwi cyc_lncf_vac c_lnJTS1000JOL cyc_lncf_hil c_lnJTS1000HIL ///
	using "../Data/CounterFactualTimeSeries`filesuffix'.csv" , comma  replace
	
	
outsheet qdate ///
	c_lnhwi cyc_lncf_hwi cyc_lncf_vac c_lnJTS1000JOL cyc_lncf_hil c_lnJTS1000HIL ///
	c_lnhwi_hamilton cyc_lncf_hwi_hamilton cyc_lncf_vac_hamilton c_lnJTS1000JOL_hamilton cyc_lncf_hil_hamilton c_lnJTS1000HIL_hamilton ///
	using "../Data/CounterFactualTimeSeries`filesuffix'_hamilton.csv" , comma  replace	


 
