*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><
*																				
*		epp_est.ado
*		see AEJPol_2017_0709_data_read_me.pdf
*
*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><

*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><
*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><

cap program drop epp_est
program define epp_est , rclass

syntax , y( string ) t( string ) [ x( string ) wt( string ) ]

preserve

*-------------------------------------------------------------------------------
*	Preliminaries
*-------------------------------------------------------------------------------

if "`wt'" == "" gen wtvar = 1
if "`wt'" != "" gen wtvar = `wt'

*-------------------------------------------------------------------------------
*	Point estimates (with hete-cluster-robust errors)
*-------------------------------------------------------------------------------

qui reg `y' `t' `x' i.rblock [ aw = wtvar ] , cluster( schoolid )

foreach v in `t' {
	loc delta_`v' = _b[`v'] 
}	

*-------------------------------------------------------------------------------
*	Wild cluster bootstrap-t p-values             			       
*-------------------------------------------------------------------------------

set seed 42

epp_wcbt , yvar( `y' ) tvars( `t' ) clustervar( schoolid ) ///
	orhs( `x' i.rblock [ aw = wtvar ] ) breps( 500 ) 

foreach v in `t' {
	loc wcbtp_`v' = r(wcbtp_`v') 
}	
		
*-------------------------------------------------------------------------------
*	Fisher randomization test p-values             		       	
*-------------------------------------------------------------------------------

set seed 42

epp_frt , yvar( `y' ) tvars( `t' ) orhs( `x' i.rblock [ aw = wtvar ] ) 

foreach v in `t' {
	loc frtp_`v' = r(frtp_`v') 
}	

*-------------------------------------------------------------------------------
*	Display results
*-------------------------------------------------------------------------------

di in yellow "-----------------------------------"
di in yellow " Point estimate, [WCBt p], (FRT p) "
di in yellow "-----------------------------------"

foreach v in `t' {

	di in green "`v'"
	di in green " " %4.3f `delta_`v'' 
	di in green "[" %4.3f `wcbtp_`v'' "]"
	di in green "(" %4.3f `frtp_`v''  ")"
	di in green ""
	
}	

restore
	
end

*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><
*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><
	
cap program drop epp_wcbt
program define epp_wcbt , rclass

syntax , yvar( varname ) tvars( varlist ) clustervar( varname ) ///
	[ orhs( string ) breps( integer 1000 ) ]

*-------------------------------------------------------------------------------
*		misc. setup
*-------------------------------------------------------------------------------

set output error

preserve

tempname pfh	
tempfile pff
postfile `pfh' str32( xvar ) brep wildt using `pff' , replace	

*-------------------------------------------------------------------------------
*		ols estimate with crve
*-------------------------------------------------------------------------------

reg `yvar' `tvars' `orhs' , cluster( `clustervar' )
foreach v in `tvars' {
	loc beta_`v' = _b[`v']
	loc t_`v' = _b[`v'] / _se[`v'] // assumes a null hupothesis of 0, thus ( _b[`v'] - 0 ) = _b[`v']
}
predict ehat , resid
predict yhat , xb 

*-------------------------------------------------------------------------------
*		bootstrap reps
*-------------------------------------------------------------------------------

loc breps_m1 = `breps' - 1
	
forv b = 1/`breps_m1' { 

	bysort `clustervar' : gen rand = uniform() 

	bysort `clustervar' : gen birand = rand[1] < [(1+sqrt(5))/(2*sqrt(5))] // mammen weights
		gen wr = ehat * [  (1-sqrt(5))/2] if birand == 1
	replace wr = ehat * [1-(1-sqrt(5))/2] if birand == 0
	gen wy = yhat + wr
	

	reg wy `tvars' `orhs' , cluster( `clustervar' )
	foreach v in `tvars' {
		post `pfh' ( "`v'" ) ( `b' ) ( ( _b[`v'] - `beta_`v'' ) / _se[`v'] )		
	}	
	
	drop rand birand wr wy
	
} 

*-------------------------------------------------------------------------------
* 		finish up, save results
*-------------------------------------------------------------------------------

postclose `pfh'

restore
		
foreach v in `tvars' {
		
	preserve 	
	
	use `pff' , clear		
	keep if xvar == "`v'"

	set obs `breps'
	replace brep = 0 in `breps'
	replace wildt = `t_`v'' in `breps'
	
	sort wildt
	gen n = _n

	sum n if brep == 0
	return scalar wcbtp_`v' = 2 * min( r(mean) / `breps' , 1 - r(mean) / `breps' )
	
	restore
	
}

set output proc

end

*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><
*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><

cap program drop epp_frt
program define epp_frt , rclass

syntax , yvar( varname ) tvars( varlist ) [ orhs( string ) override ]

set output error

*-------------------------------------------------------------------------------
*		add on "case" variables : case0 (real), case1 ... case127
*-------------------------------------------------------------------------------

preserve

mat A = [   6 , 0 , 101 \ ///
		   16 , 1 , 101 \ ///
		  146 , 0 , 102 \ ///
		   56 , 1 , 102 \ ///		   
		   38 , 0 , 103 \ ///
		  144 , 1 , 103 \ ///
		  140 , 0 , 104 \ ///		   
		   66 , 1 , 104 \ ///
		   14 , 0 , 105 \ ///
		  100 , 1 , 105 \ ///		   
		   86 , 0 , 106 \ ///
		  111 , 1 , 106 \ ///		   
		   97 , 0 , 107 \ ///
		  142 , 1 , 107 ]
clear		  
svmat A 
gen A0 = "570-"
egen schoolid = concat( A0 A1 )
rename A2 treat
rename A3 rblock		   
drop A*		   
sort rblock treat

tuples 101 102 103 104 105 106 107
forv i = 0/127 {
	gen case`i' = treat
	foreach j in `tuple`i'' {
		replace case`i' = abs( case`i' - 1 ) if rblock == `j'
	}
}

tempfile 128cases
save `128cases' , replace

restore

preserve

if "`override'" == "" {
	merge m:1 schoolid using `128cases' , assert( match ) nogen
}
	
if "`override'" == "override" {
	merge m:1 schoolid using `128cases' , assert( match using ) 
	noi di in red "Missing Cases"
	noi tab _merge
	drop _merge
}	

*-------------------------------------------------------------------------------
*		estimate for each case
*-------------------------------------------------------------------------------

tempname rireg_pfh	
tempfile rireg_pff
postfile `rireg_pfh' case str32( covar ) beta sterr using `rireg_pff' , replace	

forv i = 0/127 {

	if "`tvars'" == "treat" {

		* regression
		qui reg `yvar' case`i' `orhs' , cluster( schoolid )
		
		* save coeff
		post `rireg_pfh' ( `i' ) ( "treat" ) ( _b[case`i'] ) ( _se[case`i'] ) 
				
	}	

	if "`tvars'" != "treat" {

		* role * treatment interactions
		foreach v in targ ment norole {
			replace `v'Xt = t_`v' * case`i'
		}
		
		* var * t_targ * treat
		foreach v in `tvars' {
			if regexm( "`v'" , "targXtX" ) {
				loc w : subinstr loc v "targXtX" ""
				replace `v' = t_targ * case`i' * `w'
			}
		}
	
		* regression
		qui reg `yvar' `tvars' `orhs' , cluster( schoolid )
		
		* save coeff
		foreach v in `tvars' {
			post `rireg_pfh' ( `i' ) ( "`v'" ) ( _b[`v'] ) ( _se[`v'] )
		}
	
	}
		
}
	
postclose `rireg_pfh'

*-------------------------------------------------------------------------------
*		get p-value(s), save results
*-------------------------------------------------------------------------------

use `rireg_pff' , clear

gen stat = abs( beta )

  sort covar   stat case
bysort covar ( stat case ) : gen order = _n 

foreach v in `tvars' { 
	sum order if case == 0 & covar == "`v'"
	return scalar frtp_`v' = 1 - ( ( r(mean) - 1 ) / 128 )
}

restore

set output proc

end

*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><
*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><
