*******************************************
* AMADEUS OWNERSHP PANEL: EU-PARENT FIRMS *
*******************************************

***** INSHEET DATA AND RENAMING OF THE VARIABLES *****

*******Read in Original Amadeus Dataset: Part 1*******

qui insheet using "S:\Li Liu\Amadeus Downloads\ETPF\Financial\Disk Download\Amadeus_ETPF_1.csv", clear

qui drop mark
qui rename bvdidnumber bvd_id 
qui rename conscode cons_code 
qui rename nacerev2primarycode ind_nace

ren  operatingrevenueturnovertheur201 turnover2011
ren  v62 turnover2010
ren  operatingrevenueturnovertheur200 turnover2009
ren  v64 turnover2008
ren  v65 turnover2007
ren  v66 turnover2006
ren  v67 turnover2005
ren  noofrecordedshareholders no_shrhld
ren  noofrecordedsubsidiaries no_sub
ren  guocountryisocode uo_ctry
ren  guooperatingrevenueturnovermileu uo_turnover
ren  guototalassetsmileur uo_asset
ren  guonumberofemployees uo_wkrs
ren  guodirect uo_direct
ren  guototal uo_total

forv year=2005/2011 {
	rename fixedassetstheur`year' asset_fixed`year'
	rename intangiblefixedassetstheur`year' asset_intang`year'
	rename tangiblefixedassetstheur`year' asset_tang`year'
	rename currentassetstheur`year' asset_current`year'
	rename totalassetstheur`year' asset_total`year'
	rename longtermdebttheur`year' debt_lt`year'
	rename currentliabilitiestheur`year' lib_current`year'
	rename numberofemployees`year' wkrs`year'
	rename operatingplebittheur`year' ebit`year'
	rename  plbeforetaxtheur`year' ebt`year'
	rename  taxationtheur`year' tax`year'
	rename  costsofemployeestheur`year' wage`year'
	rename  depreciationtheur`year' depr`year'
	rename  interestpaidtheur`year' int_paid`year'
	rename  cashflowtheur`year' cashflow`year'
	rename  ebitdatheur`year' ebitda`year'
	rename  addedvaluetheur`year' vadd`year'
	}


tab cons_code
drop if cons_code!="U1"

bysort bvd_id: gen n=_n
drop if n>1
qui drop n

*reshape long*
local varlist asset_fixed asset_intang asset_tang asset_current asset_total debt_lt lib_current wkrs ///
ebit ebt tax wage depr int_paid cashflow ebitda vadd turnover

reshape long `varlist', i(bvd_id) j(year)

*destring variables*
local varlist ind_nace asset_fixed asset_intang asset_tang asset_current asset_total debt_lt lib_current wkrs ///
ebit ebt tax wage depr int_paid cashflow ebitda vadd turnover  no_shrhld  no_sub  uo_turnover uo_asset uo_wkrs ///
uo_direct uo_total

foreach var of varlist `varlist' {
	destring `var', force replace
	}
	
compress

qui save "S:\Li Liu\Amadeus Downloads\ETPF\Financial\Disk Download\Amadeus_ETPF_1", replace

********Read in Original Amadeus Dataset: Part 2******************

qui insheet using "S:\Li Liu\Amadeus Downloads\ETPF\Financial\Disk Download\Amadeus_ETPF_2.csv", name clear

qui drop v1
qui rename bvdidnumber bvd_id 
qui rename conscode cons_code 
qui rename nacerev2primarycode ind_nace

ren  operatingrevenueturnovertheur201 turnover2011
ren  v62 turnover2010
ren  operatingrevenueturnovertheur200 turnover2009
ren  v64 turnover2008
ren  v65 turnover2007
ren  v66 turnover2006
ren  v67 turnover2005
ren  noofrecordedshareholders no_shrhld
ren  noofrecordedsubsidiaries no_sub
ren  guocountryisocode uo_ctry
ren  guooperatingrevenueturnovermileu uo_turnover
ren  guototalassetsmileur uo_asset
ren  guonumberofemployees uo_wkrs
ren  guodirect uo_direct
ren  guototal uo_total

forv year=2005/2011 {
	rename fixedassetstheur`year' asset_fixed`year'
	rename intangiblefixedassetstheur`year' asset_intang`year'
	rename tangiblefixedassetstheur`year' asset_tang`year'
	rename currentassetstheur`year' asset_current`year'
	rename totalassetstheur`year' asset_total`year'
	rename longtermdebttheur`year' debt_lt`year'
	rename currentliabilitiestheur`year' lib_current`year'
	rename numberofemployees`year' wkrs`year'
	rename operatingplebittheur`year' ebit`year'
	rename  plbeforetaxtheur`year' ebt`year'
	rename  taxationtheur`year' tax`year'
	rename  costsofemployeestheur`year' wage`year'
	rename  depreciationtheur`year' depr`year'
	rename  interestpaidtheur`year' int_paid`year'
	rename  cashflowtheur`year' cashflow`year'
	rename  ebitdatheur`year' ebitda`year'
	rename  addedvaluetheur`year' vadd`year'
	}


tab cons_code
drop if cons_code!="U1"

bysort bvd_id: gen n=_n
drop if n>1
qui drop n

*reshape long*
local varlist asset_fixed asset_intang asset_tang asset_current asset_total debt_lt lib_current wkrs ///
ebit ebt tax wage depr int_paid cashflow ebitda vadd turnover

reshape long `varlist', i(bvd_id) j(year)

*destring variables*
local varlist ind_nace asset_fixed asset_intang asset_tang asset_current asset_total debt_lt lib_current wkrs ///
ebit ebt tax wage depr int_paid cashflow ebitda vadd turnover  no_shrhld  no_sub  uo_turnover uo_asset uo_wkrs ///
uo_direct uo_total

foreach var of varlist `varlist' {
	destring `var', force replace
	}
	
compress

qui save "S:\Li Liu\Amadeus Downloads\ETPF\Financial\Disk Download\Amadeus_ETPF_2", replace


********Read in Original Amadeus Dataset: Part 3******************

qui insheet using "S:\Li Liu\Amadeus Downloads\ETPF\Financial\Disk Download\Amadeus_ETPF_3.csv", name clear

qui drop mark
qui rename bvdidnumber bvd_id 
qui rename conscode cons_code 
qui rename nacerev2primarycode ind_nace

ren  operatingrevenueturnovertheur201 turnover2011
ren  v62 turnover2010
ren  operatingrevenueturnovertheur200 turnover2009
ren  v64 turnover2008
ren  v65 turnover2007
ren  v66 turnover2006
ren  v67 turnover2005
ren  noofrecordedshareholders no_shrhld
ren  noofrecordedsubsidiaries no_sub
ren  guocountryisocode uo_ctry
ren  guooperatingrevenueturnovermileu uo_turnover
ren  guototalassetsmileur uo_asset
ren  guonumberofemployees uo_wkrs
ren  guodirect uo_direct
ren  guototal uo_total

forv year=2005/2011 {
	rename fixedassetstheur`year' asset_fixed`year'
	rename intangiblefixedassetstheur`year' asset_intang`year'
	rename tangiblefixedassetstheur`year' asset_tang`year'
	rename currentassetstheur`year' asset_current`year'
	rename totalassetstheur`year' asset_total`year'
	rename longtermdebttheur`year' debt_lt`year'
	rename currentliabilitiestheur`year' lib_current`year'
	rename numberofemployees`year' wkrs`year'
	rename operatingplebittheur`year' ebit`year'
	rename  plbeforetaxtheur`year' ebt`year'
	rename  taxationtheur`year' tax`year'
	rename  costsofemployeestheur`year' wage`year'
	rename  depreciationtheur`year' depr`year'
	rename  interestpaidtheur`year' int_paid`year'
	rename  cashflowtheur`year' cashflow`year'
	rename  ebitdatheur`year' ebitda`year'
	rename  addedvaluetheur`year' vadd`year'
	}


tab cons_code
drop if cons_code!="U1"

bysort bvd_id: gen n=_n
drop if n>1
qui drop n

*reshape long*
local varlist asset_fixed asset_intang asset_tang asset_current asset_total debt_lt lib_current wkrs ///
ebit ebt tax wage depr int_paid cashflow ebitda vadd turnover

reshape long `varlist', i(bvd_id) j(year)

*destring variables*
local varlist ind_nace asset_fixed asset_intang asset_tang asset_current asset_total debt_lt lib_current wkrs ///
ebit ebt tax wage depr int_paid cashflow ebitda vadd turnover  no_shrhld  no_sub  uo_turnover uo_asset uo_wkrs ///
uo_direct uo_total

foreach var of varlist `varlist' {
	destring `var', force replace
	}
	
compress

qui save "S:\Li Liu\Amadeus Downloads\ETPF\Financial\Disk Download\Amadeus_ETPF_3", replace

********Read in Original Amadeus Dataset: Part 4******************

qui insheet using "S:\Li Liu\Amadeus Downloads\ETPF\Financial\Disk Download\Amadeus_ETPF_4.csv", name clear

qui drop mark
qui rename bvdidnumber bvd_id 
qui rename conscode cons_code 
qui rename nacerev2primarycode ind_nace

ren  operatingrevenueturnovertheur201 turnover2011
ren  v62 turnover2010
ren  operatingrevenueturnovertheur200 turnover2009
ren  v64 turnover2008
ren  v65 turnover2007
ren  v66 turnover2006
ren  v67 turnover2005
ren  noofrecordedshareholders no_shrhld
ren  noofrecordedsubsidiaries no_sub
ren  guocountryisocode uo_ctry
ren  guooperatingrevenueturnovermileu uo_turnover
ren  guototalassetsmileur uo_asset
ren  guonumberofemployees uo_wkrs
ren  guodirect uo_direct
ren  guototal uo_total

forv year=2005/2011 {
	rename fixedassetstheur`year' asset_fixed`year'
	rename intangiblefixedassetstheur`year' asset_intang`year'
	rename tangiblefixedassetstheur`year' asset_tang`year'
	rename currentassetstheur`year' asset_current`year'
	rename totalassetstheur`year' asset_total`year'
	rename longtermdebttheur`year' debt_lt`year'
	rename currentliabilitiestheur`year' lib_current`year'
	rename numberofemployees`year' wkrs`year'
	rename operatingplebittheur`year' ebit`year'
	rename  plbeforetaxtheur`year' ebt`year'
	rename  taxationtheur`year' tax`year'
	rename  costsofemployeestheur`year' wage`year'
	rename  depreciationtheur`year' depr`year'
	rename  interestpaidtheur`year' int_paid`year'
	rename  cashflowtheur`year' cashflow`year'
	rename  ebitdatheur`year' ebitda`year'
	rename  addedvaluetheur`year' vadd`year'
	}


tab cons_code
drop if cons_code!="U1"

bysort bvd_id: gen n=_n
drop if n>1
qui drop n

*reshape long*
local varlist asset_fixed asset_intang asset_tang asset_current asset_total debt_lt lib_current wkrs ///
ebit ebt tax wage depr int_paid cashflow ebitda vadd turnover

reshape long `varlist', i(bvd_id) j(year)

*destring variables*
local varlist ind_nace asset_fixed asset_intang asset_tang asset_current asset_total debt_lt lib_current wkrs ///
ebit ebt tax wage depr int_paid cashflow ebitda vadd turnover  no_shrhld  no_sub  uo_turnover uo_asset uo_wkrs ///
uo_direct uo_total

foreach var of varlist `varlist' {
	destring `var', force replace
	}
	
compress

qui save "S:\Li Liu\Amadeus Downloads\ETPF\Financial\Disk Download\Amadeus_ETPF_4", replace


****Combining All Parts***

qui use "S:\Li Liu\Amadeus Downloads\ETPF\Financial\Disk Download\Amadeus_ETPF_1", replace

forv i=2/4 {

	qui append using "S:\Li Liu\Amadeus Downloads\ETPF\Financial\Disk Download\Amadeus_ETPF_`i'"
	
	}

qui save "S:\Li Liu\Amadeus Downloads\ETPF\Financial\Disk Download\Amadeus_ETPF", replace

*Addtional Time Invariant Variables*

qui insheet using "S:\Li Liu\Amadeus Downloads\ETPF\Financial\Disk Download\Amadeus_Export_morvar1.csv", name clear

qui drop mark
qui rename bvdidnumber bvd_id 
qui rename dateofincorporation date_incorp
qui rename  researchdevelopmentexpensestheur rd_exp2011
qui rename v5 rd_exp2010
qui rename v6 rd_exp2009
qui rename v7 rd_exp2008
qui rename v8 rd_exp2007
qui rename v9 rd_exp2006
qui rename v10 rd_exp2005

bysort bvd_id: gen n=_n
drop if n>1
qui drop n

*reshape long*
local varlist rd_exp
reshape long `varlist', i(bvd_id) j(year)

*destring variables*
local varlist rd_exp
foreach var of varlist `varlist' {
	destring `var', force replace
	}

*date of incorporation*

gen incorp_year=substr(date_incorp,-4,4)
destring incorp_year, force replace
drop date_incorp

save "S:\Li Liu\Amadeus Downloads\ETPF\Financial\Disk Download\Amadeus_Export_morvar1", replace

qui insheet using "S:\Li Liu\Amadeus Downloads\ETPF\Financial\Disk Download\Amadeus_Export_morvar2.csv", name clear

qui drop mark
qui rename bvdidnumber bvd_id 
qui rename dateofincorporation date_incorp
qui rename  researchdevelopmentexpensestheur rd_exp2011
qui rename v5 rd_exp2010
qui rename v6 rd_exp2009
qui rename v7 rd_exp2008
qui rename v8 rd_exp2007
qui rename v9 rd_exp2006
qui rename v10 rd_exp2005

bysort bvd_id: gen n=_n
drop if n>1
qui drop n

*reshape long*
local varlist rd_exp
reshape long `varlist', i(bvd_id) j(year)

*destring variables*
local varlist rd_exp
foreach var of varlist `varlist' {
	destring `var', force replace
	}

*date of incorporation*

gen incorp_year=substr(date_incorp,-4,4)
destring incorp_year, force replace
drop date_incorp

save "S:\Li Liu\Amadeus Downloads\ETPF\Financial\Disk Download\Amadeus_Export_morvar2", replace

append using "S:\Li Liu\Amadeus Downloads\ETPF\Financial\Disk Download\Amadeus_Export_morvar1"

bysort bvd_id year: gen n=_n
drop if n>1
drop n

save "S:\Li Liu\Amadeus Downloads\ETPF\Financial\Disk Download\Amadeus_Export_morvar", replace


****Merge with the Main Dataset****

use "S:\Li Liu\Amadeus Downloads\ETPF\Financial\Disk Download\Amadeus_ETPF", clear
bysort bvd_id year: gen n=_n
drop if n>1
drop n

merge 1:1 bvd_id year using "S:\Li Liu\Amadeus Downloads\ETPF\Financial\Disk Download\Amadeus_Export_morvar"

drop if _merge==2
drop _merge

save "S:\Li Liu\Amadeus Downloads\ETPF\Financial\Disk Download\Amadeus_ETPF_full", replace
