
clear all
set more off 
cap log close 
set mem 12g 
set matsize 11000
set maxvar 32000
global dir "/home/research/cavoced/cred" 
global build "$dir/build"
global analy "$dir/analysis"

global prodir "${analy}/prog"
global logdir "${analy}/prog" 
global rawdir "${analy}/raw" 
global temdir "${analy}/temp" /*unclean data, but not raw*/
global anadir "${analy}/data"
global outdir "${analy}/output"

global texdir "$outdir/tex"
global txtdir "$outdir/txt"
global xlsdir "$outdir/xls"
global londir "$outdir/xls/long"
global figdir "$outdir/figs"
local standard="noobs nonumbers nomtitles nogaps nolines"
set scheme s1color
local figbacks "plotregion(fcolor(white)) graphregion(fcolor(white) lwidth(large)) bgcolor(white)"

*********************************************************************************
*For this analysis need to plot Central College AND California sample on same graph. So append data on top of each other, need to clean both first (long process)
****************************************************************************

use $temdir/aca_CENCOL_withwages, clear
rename awa_123010_CENCOL awa
rename enrol_123010 enr
rename work_health hemp
drop if mlot1_term==.
egen tag=tag(ssn yearqtr)
keep if tag
gen ysince_e=yearqtr-classof
keep if ysince_e>=-3.65 & ysince_e<9
qui tab ysince, gen(qsfe)
rename qsfe15 omit

	reg logwages agfe* yfe* qfe* qsfe*, cluster(ssn)
	mat a1=15,0,0
	forvalues y=1/14{
		mat b=`y', _b[qsfe`y'],_se[qsfe`y']
		mat a1=a1\b
		}
	forvalues y=16/49{
		mat b=`y', _b[qsfe`y'],_se[qsfe`y']
		mat a1=a1\b
		}
	areg logwages agfe* yfe* qfe* qsfe*, cluster(ssn) absorb(ssn)
	mat a2=15,0,0
	forvalues y=1/14{
		mat b=`y', _b[qsfe`y'],_se[qsfe`y']
		mat a2=a2\b
		}
	forvalues y=16/49{
		mat b=`y', _b[qsfe`y'],_se[qsfe`y']
		mat a2=a2\b
		}

	

*Now for eventual winners and losers

use $temdir/aca_CENCOL_withwages_rr, clear
rename awa_123010_CENCOL awa
rename enrol_123010 enr
rename work_health hemp
drop if mlot1_term==.
keep if mlot1_term>2004 & mlot1_term<2009.3
drop if lotnum>4
	gen ysince_lot=yearqtr-lot_term
		replace ysince_lot=. if ysince_lot>100
		keep if ysince_lo>-5.1 & ysince_lo<5.3
	qui tab ysince_lot, gen(qsfe)
	rename qsfe1 om
	gen enrolled8=unitsatt_term>=8 & unitsatt_term!=.
	
	reg logwages i.lotnum  agfe* yfe* qfe* qsfe* if lot_adm==1, cluster(ssn) 
	mat a3=1,0,0
	forvalues y=2/42{
		mat b=`y', _b[qsfe`y'],_se[qsfe`y']
		mat a3=a3\b
		}
		
	reg logwages i.lotnum   agfe* yfe* qfe* qsfe* if lot_adm==0, cluster(ssn)
	mat a4=1,0,0
	forvalues y=2/42{
		mat b=`y', _b[qsfe`y'],_se[qsfe`y']
		mat a4=a4\b
		}

	reg logwages    agfe* yfe* qfe* qsfe* if lot_adm==1 & lotnum==1, cluster(ssn) 
	mat a5=1,0,0
	forvalues y=2/42{
		mat b=`y', _b[qsfe`y'],_se[qsfe`y']
		mat a5=a5\b
		}			
	reg logwages   agfe* yfe* qfe* qsfe* if lot_adm==0 & lotnum==1, cluster(ssn)
	mat a6=1,0,0
	forvalues y=2/42{
		mat b=`y', _b[qsfe`y'],_se[qsfe`y']
		mat a6=a6\b
		}
			
	mat c=a3, a4, a5 , a6
	
	preserve
	clear
	svmat c
	replace c1=c1-21
	sort c1
	rename(c2 c5 c8 c11)(b1 b2 b3 b4)
	gen u1=b1+1.96*c3
	gen l1=b1-1.96*c3
	gen u2=b2+1.96*c6
	gen l2=b2-1.96*c6

	gen u3=b3+1.96*c9
	gen l3=b3-1.96*c9
	gen u4=b4+1.96*c12
	gen l4=b4-1.96*c12

	twoway scatter b3 u3 l3 b4 u4 l4 c1 if c1<=0  ,connect(l l l l l l) msymbol(O none none Oh none none) lcolor(black black black gray gray gray) mcolor(black black black gray gray gray) `figbacks' ytitle("Log Earnings") xtitle("Quarters Since  Lottery") legend(order(1 "Win" 4 "Lose"))
		graph export "$figdir/condacc/pretrends_winlose1_p0.eps", replace
		
		*Save some graphs for later	
		clear
		mat a=a1,a2
		svmat a
		save $temdir/mata_fortrends, replace
		restore, preserve



*Now enrollment rates (any units>0)
gen enro=unitsatt_term!=. & unitsatt_term>0		
drop enro
gen enro=unitsatt_term
	replace enro=0 if unitsatt_term==.
	reg enro i.lotnum  agfe* yfe* qfe* qsfe* if lot_adm==1, cluster(ssn) 
	mat a3=1,0,0
	forvalues y=2/42{
		mat b=`y', _b[qsfe`y'],_se[qsfe`y']
		mat a3=a3\b
		}
		
	reg enro i.lotnum   agfe* yfe* qfe* qsfe* if lot_adm==0, cluster(ssn)
	mat a4=1,0,0
	forvalues y=2/42{
		mat b=`y', _b[qsfe`y'],_se[qsfe`y']
		mat a4=a4\b
		}

	reg enro    agfe* yfe* qfe* qsfe* if lot_adm==1 & lotnum==1, cluster(ssn) 
	mat a5=1,0,0
	forvalues y=2/42{
		mat b=`y', _b[qsfe`y'],_se[qsfe`y']
		mat a5=a5\b
		}			
	reg enro   agfe* yfe* qfe* qsfe* if lot_adm==0 & lotnum==1, cluster(ssn)
	mat a6=1,0,0
	forvalues y=2/42{
		mat b=`y', _b[qsfe`y'],_se[qsfe`y']
		mat a6=a6\b
		}
			
	mat c=a3, a4, a5 , a6
	
	preserve
	clear
	svmat c
	replace c1=c1-21
	sort c1
	rename(c2 c5 c8 c11)(b1 b2 b3 b4)
	gen u1=b1+1.96*c3
	gen l1=b1-1.96*c3
	gen u2=b2+1.96*c6
	gen l2=b2-1.96*c6

	gen u3=b3+1.96*c9
	gen l3=b3-1.96*c9
	gen u4=b4+1.96*c12
	gen l4=b4-1.96*c12

	twoway scatter b1 u1 l1 b2 u2 l2 c1 if c1<22  , xscale(r(-20(4)21)) xlabel(-20(4)21)  connect(l l l l l l) msymbol(O none none Oh none none) lcolor(black black black gray gray gray) mcolor(black black black gray gray gray) `figbacks' ytitle("Enrolled Credits") xtitle("Quarters Since  Lottery") legend(order(1 "Win" 4 "Lose"))
		graph export "$figdir/condacc/pretrendsenr_winlose_all.eps", replace
		