
clear all
set more off 
cap log close 
set mem 12g 
set matsize 11000

global dir "/home/research/cavoced/cred" 
global build "$dir/build"
global analy "$dir/analysis"

global prodir "${analy}/prog"
global logdir "${analy}/prog" 
global rawdir "${analy}/raw" 
global temdir "${analy}/temp" /*unclean data, but not raw*/
global anadir "${analy}/data"
global outdir "${analy}/output"

global texdir "$outdir/tex"
global txtdir "$outdir/txt"
global xlsdir "$outdir/xls"
global londir "$outdir/xls/long"
global figdir "$outdir/figs"





*************************************************************
*Control for Industry
*************************************************************
use $anadir/CENCOL_earnings_naics_rr,clear
	destring WAGES, replace
	destring YEAR, replace
	destring Q, replace
	gen yearqtr=YEAR+(Q-1)/4
	rename WAGES wages
		*More NAICS2 stuff
			gen t_workhealth=substr(NAICS,1,2)=="62"
				gen t_workhealth_hosp=substr(NAICS,1,3)=="622"
				gen t_workhealth_amb=substr(NAICS,1,3)=="621"
				gen t_workhealth_nursres=substr(NAICS,1,3)=="623"
			gen t_workretail=substr(NAICS,1,2)=="44" | substr(NAICS,1,2)=="45"
				gen t_workretail_groc=substr(NAICS,1,4)=="4451"
				gen t_workretail_heal=substr(NAICS,1,4)=="4461"
				gen t_workretail_cloth=substr(NAICS,1,4)=="4481"|substr(NAICS,1,4)=="4521"|substr(NAICS,1,4)=="4529"
			gen t_workadmin=substr(NAICS,1,2)=="56" 
				gen t_workadmin_plac=substr(NAICS,1,4)=="5613"
			gen t_workeduc=substr(NAICS,1,2)=="61"
			gen t_workacfo=substr(NAICS,1,2)=="72"
				gen t_workacfo_hotel=substr(NAICS,1,3)=="721"
				gen t_workacfo_food=substr(NAICS,1,3)=="722"
			collapse(sum) t_*, by(yearqtr STU)
				foreach g of varlist t_*{
					replace `g'=`g'>0
					}
					tempfile tempnaics
					save `tempnaics'
**************************************************************
*Merge Transfer to CENCOL Data
***************************************************************		
use $temdir/aca_CENCOL_withwages_rr, clear
			keep ssn mlot1_term
			gen SID=reverse(substr(reverse(ssn),3,.))
			duplicates drop
			tempfile tempsp
			save `tempsp'
use /home/research/cavoced/cte/data/trans_ALL
		keep SID trans_*
		duplicates drop
		joinby SID using `tempsp', unmatched(both)
		keep if _merge==3
		gen transyear=floor(trans_term/10000)
		gen trans_flag=transyear>mlot1_term & transyear<(mlot1_term+6)
		keep if trans_flag
		keep ssn trans_flag trans_seg
		tempfile temptrn
		save `temptrn'
		clear
******************************		
use $temdir/aca_CENCOL_withwages_rr, clear



merge m:1 ssn using `temptrn', gen(mergetran)
	replace trans_flag=trans_flag==1
	gen trans_UCCSU=trans_seg=="UC"|trans_seg=="CSU"

*Employment outcome variables: any employment, number of quarters employed, >0.5quarters employed
		gen aaa=rys==5
			bysort ssn lotnum: egen numq=total(aaa)
			drop aaa
		gen zzz=(logwages!=.) if rys==5
			bysort ssn lotnum: egen numempq=total(zzz)
			drop zzz
			drop emp_numq
			gen emp_any=numempq>0
			gen emp_numq=numempq
			gen emp_empha=numempq/numq>0.5
			gen emp_all=numempq/numq==1
		gen zzz=hemp==1 if rys==5
			bysort ssn lotnum: egen numhq=total(zzz)
			drop zzz
			gen emp_hea=numhq>0
			gen emp_chea=numhq>0 if emp_any==1		


qui tab lot_term, gen(loofe)
		label var lot_adm "Win Lottery"
		label var awa "Finish Program"
		label var awa2 "Finish any ADN"
		label var enr "Start Program"
gen doof=.	


		
	gen lot1pers=mlot1_adm==1 | (mlot1_adm==0 & numlots==1)
	gen lot5pers=numlots==5
			
	********************
	*Regressions
	**********************
	
	global racevar "age_at  race_H race_A race_OBX"
	global acadvar "gpa_prelot1   "
	global empvar "hemp_anypre emp_pre "	
	global finvar "sfa_bog sfa_pel  sfa_cal "	

	
*Create a consistent sample for the 1st stage regressions
	reg numlots  lot_adm $racevar $acadvar $empvar $finvar loof* if lotnum==1 & appflag==1
	gen ESAMPLEall=e(sample)
	reg logwage0 win14   zc0* if lotnum<5   & ysince_lot1==5.25 , cluster(ssn)  
	gen ESAMPLE57=e(sample)
	foreach g of varlist E*{
		bysort ssn: egen a=total(`g')
		replace `g'=a>0
		drop a
		}	

	
	keep if ESAMPLE57==1
	
	

*merge on NAICS
gen STUDENT_SSN=substr(ssn,1,strpos(ssn,"_")-1)
merge m:1 STUDENT_SSN yearqtr using `tempnaics', gen(naicsmerge)
	
	foreach g of varlist t_*{
		replace `g'=`g'==1
		}
		gen t_workoth=(emp==1 & t_workhealth==0 & t_workretail==0 & t_workadmin==0 & t_workeduc==0)
	*******************************************************************************
	*Control for Industry
	*******************************************************************************
	global indlist t_workhealth t_workretail t_workadmin t_workeduc t_workoth
	foreach endo in enrn enr{
	eststo clear

		eststo ie1157: ivreg2 logwage0 (`endo'=lot_adm) enrolled $indlist	yfe* qfe* flot loofe* gap if lotnum==1 & rys==5 , cluster(ssn)  
			estadd scalar Ftous=e(widstat)
			sum wages0 if e(sample)
			estadd scalar meanwag=r(mean)	
			estimates save "$temdir/i`endo'lot1indcon57" , replace
		
			}
		
	
	
	
	
	*******************************************************************************
	*Exclude 0's
	*******************************************************************************
		foreach endo in enrn enr{
	eststo clear

		eststo ie1157: ivreg2 logwages (`endo'=lot_adm)  enrolled	yfe* qfe* flot loofe* gap if lotnum==1 & rys==5 , cluster(ssn)  
			estadd scalar Ftous=e(widstat)
			sum wages0 if e(sample)
			estadd scalar meanwag=r(mean)	
			estimates save "$temdir/i`endo'lot1exczer57" , replace
			
			}
			
	*******************************************************************************
	*Drop Transfer Students
	*******************************************************************************
	foreach endo in enrn enr{
	eststo clear
	preserve
		drop if trans_UCCSU==1
		eststo ie1157: ivreg2 logwage0 (`endo'=lot_adm)  enrolled	yfe* qfe* flot loofe* gap if lotnum==1 & rys==5 , cluster(ssn)  
			estadd scalar Ftous=e(widstat)
			sum wages0 if e(sample)
			estadd scalar meanwag=r(mean)	
			estimates save "$temdir/i`endo'lot1exctran57" , replace
			
			restore
			}
		
	*******************************************************************************
	*Keep only pre-earners
	*******************************************************************************
		foreach endo in enrn enr {
	eststo clear
	preserve
		gen zzz=wages!=. & wages!=0 & yearqtr<mlot1_term
		bysort ssn: egen aaaa=total(zzz)
		keep if aaaa>0
			
		eststo ie1157: ivreg2 logwage0 (`endo'=lot_adm)  enrolled	yfe* qfe* flot loofe* gap if lotnum==1 & rys==5 , cluster(ssn)  
			estadd scalar Ftous=e(widstat)
			sum wages0 if e(sample)
			estadd scalar meanwag=r(mean)	
			estimates save "$temdir/i`endo'lot1excnea57" , replace
			
			restore
			}
			

	*******************************************************************************
	*Exclude in other way people
	*******************************************************************************
		
		foreach endo in enrn enr{
		preserve
		drop if everoth2==1|everoth1==1
			
		eststo ie1157: ivreg2 logwage0 (`endo'=lot_adm)  enrolled	yfe* qfe* flot loofe* gap if lotnum==1 & rys==5 , cluster(ssn)  
			estadd scalar Ftous=e(widstat)
			sum wages0 if e(sample)
			estadd scalar meanwag=r(mean)	
			estimates save "$temdir/i`endo'lot1excoth57" , replace
			
			restore
			}
			
	
	
	
	
	*******************************************************************************
	*Exclude 5th lottery and nonpersisters
	*******************************************************************************
	foreach endo in enrn enr{
		eststo clear
		preserve
		*Lot 1 without persisters
		eststo ie1157: ivreg2 logwage0 (`endo'=lot_adm)  enrolled	yfe* qfe* flot loofe* gap if lotnum==1 & rys==5 & lot1per==1, cluster(ssn)  
			estadd scalar Ftous=e(widstat)
			sum wages0 if e(sample)
			estadd scalar meanwag=r(mean)	
			estimates save "$temdir/i`endo'lot1excper57" , replace

		
		drop if numlots==5
			
		eststo ie1157: ivreg2 logwage0 (`endo'=lot_adm)  enrolled	yfe* qfe* flot loofe* gap if lotnum==1 & rys==5 , cluster(ssn)  
			estadd scalar Ftous=e(widstat)
			sum wages0 if e(sample)
			estadd scalar meanwag=r(mean)	
			estimates save "$temdir/i`endo'lot1exc557" , replace
			
			restore
			}
			
	
	*******************************************************************************
	*Exclude men
	*******************************************************************************
		foreach endo in enrn enr{
	eststo clear
	preserve

		drop if sex_M==1
			
		eststo ie1157: ivreg2 logwage0 (`endo'=lot_adm)  enrolled	yfe* qfe* flot loofe* gap if lotnum==1 & rys==5 , cluster(ssn)  
			estadd scalar Ftous=e(widstat)
			sum wages0 if e(sample)
			estadd scalar meanwag=r(mean)	
			estimates save "$temdir/i`endo'lot1excM57" , replace
			
			

			restore
			}
			
	
	
	*******************************************************************************
	*Exclude alternates
	*******************************************************************************
		foreach endo in enrn enr{
	eststo clear
	preserve

		drop if everalt==1
			
		eststo ie1157: ivreg2 logwage0 (`endo'=lot_adm)  enrolled	yfe* qfe* flot loofe* gap if lotnum==1 & rys==5 , cluster(ssn)  
			estadd scalar Ftous=e(widstat)
			sum wages0 if e(sample)
			estadd scalar meanwag=r(mean)	
			estimates save "$temdir/i`endo'lot1excalt57" , replace
			
			restore
		}				
						

	
	

		
	
	
		
	
	