

***-----------------------------------------------------------------------------------------------------------------------------***	
***   				Barrage, Chyn, Hastings (2019, AEJ:Policy)		     				        ***
***						FIGURE 2									***	
***-----------------------------------------------------------------------------------------------------------------------------***	
	
/* This do-file replicates Figure 2.
Inputs:   BCH_Replication_Figure2.dta
Outputs:  Figure2_Google_Search_Prices.eps
	  Figure2_Google_Search_Qty.eps
*/
	
clear all
set more off

*Set directory:
include 1_SET_DIRECTORY.do

*Open data:
use BCH_Replication_Figure2.dta, clear


*********************
**   Figure 2(a)   **           
*********************
 sort date

graph twoway (line google_oilspill date, lcol(blue) yaxis(1)) (connected betas_p date, yaxis(2) mcolor(red) msize(small)), ///
              xtitle("") xlabel(#5) ///
              ytitle("Net Price ($)", axis(2)) ///
	      ylab(-50(25)50, axis(1)) ///
              ytitle("Google Search Intensity", axis(1)) ///
              ylab(-0.05(0.025)0.05, axis(2)) ///
              legend(row(2)) ///
              yscale(titlegap(2) axis(1)) yscale(titlegap(2) axis(2)) ///
              graphregion(color(white) fcolor(white) icolor(white) ifcolor(white) lcolor(white) ilcolor(white)) plotregion(color(white) fcolor(white) icolor(white) ifcolor(white) lcolor(white) ilcolor(white))

graph export Figure2_Google_Search_Prices.eps, replace

*********************
**   Figure 2(b)   **           
*********************
 sort date

graph twoway (line google_oilspill date, lcol(blue) yaxis(1)) (connected betas_q date, yaxis(2) mcolor(red) msize(small)), ///
              xtitle("") xlabel(#5) ///
              ytitle("Volume (Log)", axis(2)) ///
	      ylab(-50(25)50, axis(1)) ///
              ytitle("Google Search Intensity", axis(1)) ///
              ylab(-0.1(0.05)0.15, axis(2)) ///
              legend(row(2)) ///
              yscale(titlegap(2) axis(1)) yscale(titlegap(2) axis(2)) ///
	      graphregion(color(white) fcolor(white) icolor(white) ifcolor(white) lcolor(white) ilcolor(white)) plotregion(color(white) fcolor(white) icolor(white) ifcolor(white) lcolor(white) ilcolor(white))


graph export Figure2_Google_Search_Qty.eps, replace	
